/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;

public class SSCCompilerParameter {
    private DatasetVector m_networkDataset = null;
    private String m_nodeIDField = "SmNodeID";
    private String m_edgeIDField = "SmEdgeID";
    private String m_fNodeIDField = "SmFNode";
    private String m_tNodeIDField = "SmTNode";
    private DatasetVector m_turnDataset = null;
    private String m_turnNodeIDField = "";
    private String m_turnFEdgeIDField = "";
    private String m_turnTEdgeIDField = "";
    private String m_edgeNameField = "SmEdgeID";
    private String m_turnWeightField = "";
    private String m_ruleField = "";
    private String[] m_FTSingleWayRuleValues = null;
    private String[] m_TFSingleWayRuleValues = null;
    private String[] m_prohibitedWayRuleValues = null;
    private String[] m_twoWayRuleValues = null;
    private String m_ftWeightField = "SmLength";
    private String m_tfWeightField = "SmLength";
    private String m_filePath = "";
    private String m_levelField = "";
    private String m_speedField = "";

    public SSCCompilerParameter() {
    }

    public SSCCompilerParameter(SSCCompilerParameter parameter) {
        if (parameter == null) {
            String string = InternalResource.loadString("networkAnalystSetting", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        this.copyFrom(parameter);
    }

    public DatasetVector getNetworkDataset() {
        return this.m_networkDataset;
    }

    public void setNetworkDataset(DatasetVector value) {
        if (value != null && value.getType() != DatasetType.NETWORK) {
            String string = InternalResource.loadString("value", "DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_networkDataset = value;
    }

    public String getNodeIDField() {
        return this.m_nodeIDField;
    }

    public void setNodeIDField(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nodeIDField = value;
    }

    public String getEdgeIDField() {
        return this.m_edgeIDField;
    }

    public void setEdgeIDField(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_edgeIDField = value;
    }

    public String getFNodeIDField() {
        return this.m_fNodeIDField;
    }

    public void setFNodeIDField(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_fNodeIDField = value;
    }

    public String getTNodeIDField() {
        return this.m_tNodeIDField;
    }

    public void setTNodeIDField(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_tNodeIDField = value;
    }

    public DatasetVector getTurnDataset() {
        return this.m_turnDataset;
    }

    public void setTurnDataset(DatasetVector value) {
        if (value != null && value.getType() != DatasetType.TABULAR) {
            String string = InternalResource.loadString("value", "DatasetTypeMustBeTabular", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_turnDataset = value;
    }

    public String getTurnNodeIDField() {
        return this.m_turnNodeIDField;
    }

    public void setTurnNodeIDField(String value) {
        this.m_turnNodeIDField = value;
    }

    public String getTurnFEdgeIDField() {
        return this.m_turnFEdgeIDField;
    }

    public void setTurnFEdgeIDField(String value) {
        this.m_turnFEdgeIDField = value;
    }

    public String getTurnTEdgeIDField() {
        return this.m_turnTEdgeIDField;
    }

    public void setTurnTEdgeIDField(String value) {
        this.m_turnTEdgeIDField = value;
    }

    public String getEdgeNameField() {
        return this.m_edgeNameField;
    }

    public void setEdgeNameField(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_edgeNameField = value;
    }

    public String getRuleField() {
        return this.m_ruleField;
    }

    public void setRuleField(String value) {
        this.m_ruleField = value;
    }

    public String[] getFTSingleWayRuleValues() {
        String[] stringArray = null;
        if (this.m_FTSingleWayRuleValues != null) {
            stringArray = (String[])this.m_FTSingleWayRuleValues.clone();
        }
        return stringArray;
    }

    public void setFTSingleWayRuleValues(String[] values) {
        if (values == null) {
            this.m_FTSingleWayRuleValues = null;
        } else {
            int n = values.length;
            this.m_FTSingleWayRuleValues = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_FTSingleWayRuleValues[i] = values[i];
            }
        }
    }

    public String[] getTFSingleWayRuleValues() {
        String[] stringArray = null;
        if (this.m_TFSingleWayRuleValues != null) {
            stringArray = (String[])this.m_TFSingleWayRuleValues.clone();
        }
        return stringArray;
    }

    public void setTFSingleWayRuleValues(String[] values) {
        if (values == null) {
            this.m_TFSingleWayRuleValues = null;
        } else {
            int n = values.length;
            this.m_TFSingleWayRuleValues = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_TFSingleWayRuleValues[i] = values[i];
            }
        }
    }

    public String[] getProhibitedWayRuleValues() {
        String[] stringArray = null;
        if (this.m_prohibitedWayRuleValues != null) {
            stringArray = (String[])this.m_prohibitedWayRuleValues.clone();
        }
        return stringArray;
    }

    public void setProhibitedWayRuleValues(String[] values) {
        if (values == null) {
            this.m_prohibitedWayRuleValues = null;
        } else {
            int n = values.length;
            this.m_prohibitedWayRuleValues = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_prohibitedWayRuleValues[i] = values[i];
            }
        }
    }

    public String[] getTwoWayRuleValues() {
        String[] stringArray = null;
        if (this.m_twoWayRuleValues != null) {
            stringArray = (String[])this.m_twoWayRuleValues.clone();
        }
        return stringArray;
    }

    public void setTwoWayRuleValues(String[] values) {
        if (values == null) {
            this.m_twoWayRuleValues = null;
        } else {
            int n = values.length;
            this.m_twoWayRuleValues = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_twoWayRuleValues[i] = values[i];
            }
        }
    }

    public String getWeightField() {
        return this.m_ftWeightField;
    }

    public void setWeightField(String value) {
        this.m_ftWeightField = value;
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public void setFilePath(String value) {
        this.m_filePath = value;
    }

    public String getLevelField() {
        return this.m_levelField;
    }

    public void setLevelField(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_levelField = value;
    }

    public String getSpeedField() {
        return this.m_speedField;
    }

    public void setSpeedField(String value) {
        this.m_speedField = value;
    }

    void copyFrom(SSCCompilerParameter value) {
        if (value != null && !this.equals(value)) {
            this.setNetworkDataset(value.getNetworkDataset());
            this.setNodeIDField(value.getNodeIDField());
            this.setEdgeIDField(value.getEdgeIDField());
            this.setEdgeNameField(value.getEdgeNameField());
            this.setFNodeIDField(value.getFNodeIDField());
            this.setTNodeIDField(value.getTNodeIDField());
            this.setTurnDataset(value.getTurnDataset());
            this.setTurnNodeIDField(value.getTurnNodeIDField());
            this.setTurnFEdgeIDField(value.getTurnFEdgeIDField());
            this.setTurnTEdgeIDField(value.getTurnTEdgeIDField());
            this.setRuleField(value.getRuleField());
            this.setFTSingleWayRuleValues(value.getFTSingleWayRuleValues());
            this.setTFSingleWayRuleValues(value.getTFSingleWayRuleValues());
            this.setProhibitedWayRuleValues(value.getProhibitedWayRuleValues());
            this.setTwoWayRuleValues(value.getTwoWayRuleValues());
            this.setWeightField(value.getWeightField());
            this.setFilePath(value.getFilePath());
            this.setLevelField(value.getLevelField());
            this.setSpeedField(value.getSpeedField());
        }
    }
}

