/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.PathGuideItem;
import com.supermap.analyst.networkanalyst.PathGuideNative;

public class PathGuide
extends InternalHandle {
    PathGuideItem[] m_items = null;
    int m_count = 0;

    PathGuide(long handle) {
        this.setHandle(handle);
        this.m_count = PathGuideNative.jni_GetItemCount(handle);
        this.m_items = new PathGuideItem[this.m_count];
    }

    public PathGuideItem get(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "networkanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        PathGuideItem pathGuideItem = this.m_items[index];
        if (pathGuideItem == null) {
            long l = PathGuideNative.jni_GetItemHandle(this.getHandle(), index);
            pathGuideItem = new PathGuideItem(l);
        }
        return pathGuideItem;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_count;
    }
}

