/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.networkanalyst.FacilityAnalyst;
import com.supermap.analyst.networkanalyst.FacilityAnalystSetting;
import com.supermap.analyst.networkanalyst.InternalDatasetVector;
import com.supermap.analyst.networkanalyst.InternalDatasets;
import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.InternalToolkitNetworkAnalyst;
import com.supermap.analyst.networkanalyst.NetworkBuilderNative;
import com.supermap.analyst.networkanalyst.NetworkSplitMode;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldSign;
import com.supermap.data.FieldType;
import com.supermap.data.QueryParameter;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class NetworkBuilder {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private NetworkBuilder() {
    }

    @Deprecated
    public static DatasetVector buildNetwork(DatasetVector lineDataset, Datasource outputDatasource, String networkDatasetName) {
        NetworkBuilder.verifyLicense();
        DatasetVector[] datasetVectorArray = new DatasetVector[]{lineDataset};
        DatasetVector[] datasetVectorArray2 = null;
        return NetworkBuilder.buildNetwork(datasetVectorArray, datasetVectorArray2, outputDatasource, networkDatasetName, NetworkSplitMode.LINE_SPLIT_BY_POINT_AND_LINE, lineDataset.getTolerance().getNodeSnap());
    }

    @Deprecated
    public static DatasetVector buildNetwork(DatasetVector[] lineDatasets, DatasetVector[] pointDatasets, Datasource outputDatasource, String networkDatasetName, NetworkSplitMode networkSplitMode, double tolerance) {
        NetworkBuilder.verifyLicense();
        if (lineDatasets == null) {
            String string = InternalResource.loadString("lineDatasets", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (lineDatasets.length == 0) {
            String string = InternalResource.loadString("lineDatasets", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = lineDatasets.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (lineDatasets[i] == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)lineDatasets[i]) == 0L) {
                String string = InternalResource.loadString("lineDataset[" + i + "]", "Global_ArgumentNull", "networkanalyst_resources");
                throw new NullPointerException(string);
            }
            if (lineDatasets[i].getType() != DatasetType.LINE) {
                String string = InternalResource.loadString("lineDataset[" + i + "]", "NetworkBuilder_DatasetTypeMustBeLine", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)lineDatasets[i]);
        }
        long[] lArray2 = null;
        if (pointDatasets != null) {
            int n2 = pointDatasets.length;
            lArray2 = new long[n2];
            for (int i = 0; i < n2; ++i) {
                if (pointDatasets[i] == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)pointDatasets[i]) == 0L) {
                    String string = InternalResource.loadString("pointDataset[" + i + "]", "Global_ArgumentNull", "networkanalyst_resources");
                    throw new NullPointerException(string);
                }
                if (pointDatasets[i].getType() != DatasetType.POINT) {
                    String string = InternalResource.loadString("pointDataset[" + i + "]", "NetworkBuilder_DatasetTypeMustBePoint", "networkanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)pointDatasets[i]);
            }
        } else {
            lArray2 = new long[]{};
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string = networkDatasetName;
        String string2 = string + "_Node";
        if (!outputDatasource.getDatasets().isAvailableDatasetName(string2)) {
            String string3 = InternalResource.loadString("networkDatasetName", "NetworkBuilder_DatasetNameNameLengthMoreThanThirty", "networkanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (networkDatasetName == null || networkDatasetName.trim().length() == 0 || !outputDatasource.getDatasets().isAvailableDatasetName(networkDatasetName)) {
            String string4 = InternalResource.loadString("networkDatasetName", "NetworkBuilder_DatasetNameIsNotAvailabe", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (networkSplitMode == null) {
            String string5 = InternalResource.loadString("networkSplitMode", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (tolerance < 0.0) {
            String string6 = InternalResource.loadString("tolerance", "NetworkBuilder_ToleranceShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        int n3 = networkSplitMode.value();
        long l2 = NetworkBuilderNative.jni_BuildNetwork3(lArray, lArray2, stringArray, stringArray2, l, networkDatasetName, n3, tolerance);
        DatasetVector datasetVector = null;
        if (l2 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l2, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector buildNetwork(DatasetVector line, DatasetVector point, String edgeIDField, String fromNodeField, String toNodeField, String nodeIDField, Datasource outputDatasource, String networkDatasetName) {
        NetworkBuilder.verifyLicense();
        if (line == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (line.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("lineDataset", "NetworkBuilder_DatasetTypeMustBeLine", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("pointDataset", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (point.getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("pointDataset", "NetworkBuilder_DatasetTypeMustBePoint", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (point.getPrjCoordSys().getType() != line.getPrjCoordSys().getType()) {
            String string = InternalResource.loadString("pointDataset & lineDataset", "ProjectionNotSame", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (networkDatasetName == null) {
            String string = InternalResource.loadString("networkDatasetName", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = networkDatasetName;
        String string2 = string + "_Node";
        if (!outputDatasource.getDatasets().isAvailableDatasetName(string2)) {
            String string3 = InternalResource.loadString("networkDatasetName", "NetworkBuilder_DatasetNameIsNotAvailabe", "networkanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (fromNodeField == null) {
            String string4 = InternalResource.loadString("fromNodeField", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        FieldInfo fieldInfo = line.getFieldInfos().get(fromNodeField);
        if (fieldInfo == null) {
            String string5 = InternalResource.loadString("fromNodeField", "DatasetFieldNameIsInvalid", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (fieldInfo.getType() != FieldType.INT16 && fieldInfo.getType() != FieldType.INT32 && fieldInfo.getType() != FieldType.INT64) {
            String string6 = InternalResource.loadString("fromNodeField", "FieldType_UnSupport", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (toNodeField == null) {
            String string7 = InternalResource.loadString("toNodeField", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        fieldInfo = line.getFieldInfos().get(toNodeField);
        if (fieldInfo == null) {
            String string8 = InternalResource.loadString("toNodeField", "DatasetFieldNameIsInvalid", "networkanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        if (fieldInfo.getType() != FieldType.INT16 && fieldInfo.getType() != FieldType.INT32 && fieldInfo.getType() != FieldType.INT64) {
            String string9 = InternalResource.loadString("toNodeField", "FieldType_UnSupport", "networkanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        if (nodeIDField == null) {
            String string10 = InternalResource.loadString("nodeIDField", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string10);
        }
        fieldInfo = point.getFieldInfos().get(nodeIDField);
        if (fieldInfo == null) {
            String string11 = InternalResource.loadString("nodeIDField", "DatasetFieldNameIsInvalid", "networkanalyst_resources");
            throw new IllegalArgumentException(string11);
        }
        if (fieldInfo.getType() != FieldType.INT16 && fieldInfo.getType() != FieldType.INT32 && fieldInfo.getType() != FieldType.INT64) {
            String string12 = InternalResource.loadString("nodeIDField", "FieldType_UnSupport", "networkanalyst_resources");
            throw new IllegalArgumentException(string12);
        }
        String string13 = edgeIDField;
        if (edgeIDField == null) {
            string13 = "SMID";
        } else {
            fieldInfo = line.getFieldInfos().get(edgeIDField);
            if (fieldInfo == null) {
                String string14 = InternalResource.loadString("edgeIDField", "DatasetFieldNameIsInvalid", "networkanalyst_resources");
                throw new IllegalArgumentException(string14);
            }
            if (fieldInfo.getType() != FieldType.INT16 && fieldInfo.getType() != FieldType.INT32 && fieldInfo.getType() != FieldType.INT64) {
                String string15 = InternalResource.loadString("edgeIDField", "FieldType_UnSupport", "networkanalyst_resources");
                throw new IllegalArgumentException(string15);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)line);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)point);
        long l4 = NetworkBuilderNative.jni_BuildNetwork2(l2, l3, string13, fromNodeField, toNodeField, nodeIDField, l, networkDatasetName);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static boolean buildFacilityNetworkDirections(FacilityAnalystSetting facilityAnalystSetting, int[] sourceIDs, int[] sinkIDs, String weightName, String nodeTypeField) {
        int n;
        Object object;
        NetworkBuilder.verifyLicense();
        if (facilityAnalystSetting == null) {
            String string = InternalResource.loadString("facilityAnalystSetting", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = facilityAnalystSetting.getDirectionField();
        DatasetVector datasetVector = facilityAnalystSetting.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string2 = InternalResource.loadString("network", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasetVector.isAvailableFieldName(string)) {
            object = new FieldInfo();
            object.setName(string);
            object.setType(FieldType.INT32);
            object.setCaption(string);
            object.setMaxLength(4);
            datasetVector.getFieldInfos().add((FieldInfo)object);
        }
        if (datasetVector.getChildDataset().isAvailableFieldName(nodeTypeField)) {
            object = new FieldInfo();
            object.setName(nodeTypeField);
            object.setType(FieldType.INT32);
            object.setCaption(nodeTypeField);
            object.setMaxLength(4);
            datasetVector.getChildDataset().getFieldInfos().add((FieldInfo)object);
        }
        object = new FacilityAnalyst();
        ((FacilityAnalyst)((Object)object)).setAnalystSetting(facilityAnalystSetting);
        ((FacilityAnalyst)((Object)object)).load();
        if (sourceIDs == null && sinkIDs == null) {
            String string3 = InternalResource.loadString("sourceIDs and sinkIDs", "NetworkBuilder_BuildFacilityNetworkDirectionsBothSourceIDsAndSinkIDsAreNull", "networkanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (sourceIDs != null) {
            for (n = 0; n < sourceIDs.length; ++n) {
                if (sourceIDs[n] > 0) continue;
                String string4 = InternalResource.loadString("sourceIDs[" + n + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
        }
        if (sinkIDs != null) {
            for (n = 0; n < sinkIDs.length; ++n) {
                if (sinkIDs[n] > 0) continue;
                String string5 = InternalResource.loadString("sinkIDs[" + n + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = facilityAnalystSetting.getWeightFieldInfos().get(0).getName();
        } else if (facilityAnalystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string6 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
        boolean bl = false;
        bl = NetworkBuilderNative.jni_BuildFacilityNetworkDirections(l, weightName, sourceIDs, sinkIDs, string, nodeTypeField);
        ((FacilityAnalyst)((Object)object)).clearHandle();
        return bl;
    }

    public static boolean buildFacilityNetworkHierarchies(FacilityAnalystSetting facilityAnalystSetting, int[] sourceIDs, int[] sinkIDs, String weightName, String hierarchyField, boolean isLoopValid) {
        int n;
        Object object;
        if (facilityAnalystSetting == null) {
            String string = InternalResource.loadString("facilityAnalystSetting", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetVector datasetVector = facilityAnalystSetting.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("network", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasetVector.isAvailableFieldName(hierarchyField)) {
            object = new FieldInfo();
            object.setName(hierarchyField);
            object.setType(FieldType.INT32);
            object.setCaption(hierarchyField);
            object.setMaxLength(4);
            datasetVector.getFieldInfos().add((FieldInfo)object);
        }
        object = new FacilityAnalyst();
        ((FacilityAnalyst)((Object)object)).setAnalystSetting(facilityAnalystSetting);
        ((FacilityAnalyst)((Object)object)).load();
        if (sourceIDs == null && sinkIDs == null) {
            String string = InternalResource.loadString("sourceIDs and sinkIDs", "NetworkBuilder_BuildFacilityNetworkHierarchiesBothSourceIDsAndSinkIDsAreNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceIDs != null) {
            for (n = 0; n < sourceIDs.length; ++n) {
                if (sourceIDs[n] > 0) continue;
                String string = InternalResource.loadString("sourceIDs[" + n + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (sinkIDs != null) {
            for (n = 0; n < sinkIDs.length; ++n) {
                if (sinkIDs[n] > 0) continue;
                String string = InternalResource.loadString("sinkIDs[" + n + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = facilityAnalystSetting.getWeightFieldInfos().get(0).getName();
        } else if (facilityAnalystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (hierarchyField == null || hierarchyField.trim().length() == 0) {
            String string = InternalResource.loadString("hierarchyField", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
        boolean bl = false;
        bl = NetworkBuilderNative.jni_BuildFacilityNetworkHierarchies(l, weightName, sourceIDs, sinkIDs, hierarchyField, isLoopValid);
        ((FacilityAnalyst)((Object)object)).clearHandle();
        return bl;
    }

    public static DatasetVector createTurnTable(DatasetVector networkDataset, QueryParameter queryParameter, Datasource outputDatasource, String outputDatasetName) {
        NetworkBuilder.verifyLicense();
        if (networkDataset == null) {
            String string = InternalResource.loadString("networkDataset", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!networkDataset.getType().equals((Object)DatasetType.NETWORK)) {
            String string = InternalResource.loadString("networkDataset", "NetworkBuilder_CreateTurnTableDatasetTypeMustBeNetwor", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("networkDataset", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)queryParameter);
        if (l2 == 0L) {
            String string = InternalResource.loadString("queryParameter", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l3 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource.getDatasets().contains(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasource", "Datasource_DatasetNameIsInvalid", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l4 = NetworkBuilderNative.jni_CreateTurnTable(l, l2, l3, outputDatasetName);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)queryParameter);
        return datasetVector;
    }

    private static boolean isLongName(String name) {
        String string = "sm_seq_" + name + "_node";
        return string.length() > 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static DatasetVector buildNetwork(DatasetVector lineDataset, String[] lineFieldNames, Datasource outputDatasource, String networkDatasetName) {
        NetworkBuilder.verifyLicense();
        DatasetVector[] datasetVectorArray = new DatasetVector[]{lineDataset};
        DatasetVector[] datasetVectorArray2 = null;
        String[] stringArray = null;
        return NetworkBuilder.buildNetwork(datasetVectorArray, datasetVectorArray2, lineFieldNames, stringArray, outputDatasource, networkDatasetName, NetworkSplitMode.LINE_SPLIT_BY_POINT_AND_LINE, lineDataset.getTolerance().getNodeSnap());
    }

    public static DatasetVector buildNetwork(DatasetVector[] lineDatasets, DatasetVector[] pointDatasets, String[] lineFieldNames, String[] pointFieldNames, Datasource outputDatasource, String networkDatasetName, NetworkSplitMode networkSplitMode, double tolerance) {
        NetworkBuilder.verifyLicense();
        if (lineDatasets == null) {
            String string = InternalResource.loadString("lineDatasets", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (lineDatasets.length == 0) {
            String string = InternalResource.loadString("lineDatasets", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = lineDatasets.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (lineDatasets[i] == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)lineDatasets[i]) == 0L) {
                String string = InternalResource.loadString("lineDataset[" + i + "]", "Global_ArgumentNull", "networkanalyst_resources");
                throw new NullPointerException(string);
            }
            if (lineDatasets[i].getType() != DatasetType.LINE) {
                String string = InternalResource.loadString("lineDataset[" + i + "]", "NetworkBuilder_DatasetTypeMustBeLine", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)lineDatasets[i]);
        }
        long[] lArray2 = null;
        if (pointDatasets != null) {
            int n2 = pointDatasets.length;
            lArray2 = new long[n2];
            for (int i = 0; i < n2; ++i) {
                if (pointDatasets[i] == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)pointDatasets[i]) == 0L) {
                    String string = InternalResource.loadString("pointDataset[" + i + "]", "Global_ArgumentNull", "networkanalyst_resources");
                    throw new NullPointerException(string);
                }
                if (pointDatasets[i].getType() != DatasetType.POINT) {
                    String string = InternalResource.loadString("pointDataset[" + i + "]", "NetworkBuilder_DatasetTypeMustBePoint", "networkanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)pointDatasets[i]);
            }
        } else {
            lArray2 = new long[]{};
        }
        String string = networkDatasetName;
        String string2 = string + "_Node";
        if (!outputDatasource.getDatasets().isAvailableDatasetName(string2)) {
            String string3 = InternalResource.loadString("networkDatasetName", "NetworkBuilder_DatasetNameNameLengthMoreThanThirty", "networkanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (networkDatasetName == null || networkDatasetName.trim().length() == 0 || !outputDatasource.getDatasets().isAvailableDatasetName(networkDatasetName)) {
            String string4 = InternalResource.loadString("networkDatasetName", "NetworkBuilder_DatasetNameIsNotAvailabe", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (networkSplitMode == null) {
            String string5 = InternalResource.loadString("networkSplitMode", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (tolerance < 0.0) {
            String string6 = InternalResource.loadString("tolerance", "NetworkBuilder_ToleranceShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        int n3 = networkSplitMode.value();
        long l2 = NetworkBuilderNative.jni_BuildNetwork3(lArray, lArray2, lineFieldNames, pointFieldNames, l, networkDatasetName, n3, tolerance);
        DatasetVector datasetVector = null;
        if (l2 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l2, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static boolean appendToNetwork(DatasetVector networkDataset, DatasetVector[] datasets) {
        NetworkBuilder.verifyLicense();
        if (networkDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset) == 0L) {
            String string = InternalResource.loadString("networkDataset", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (networkDataset.getType() != DatasetType.NETWORK) {
            String string = InternalResource.loadString("networkDataset.getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (networkDataset.getChildDataset().getType() == DatasetType.POINT3D) {
            String string = InternalResource.loadString("networkDataset", "NotSupport3DNetworkDataset", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasets == null) {
            String string = InternalResource.loadString("datasets", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasets.length == 0) {
            String string = InternalResource.loadString("datasets", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset);
        Vector<Long> vector = new Vector<Long>();
        for (int i = 0; i < datasets.length; ++i) {
            if (datasets[i] == null || datasets[i].getPrjCoordSys() == networkDataset.getPrjCoordSys() || datasets[i].getType() != DatasetType.POINT && datasets[i].getType() != DatasetType.LINE && datasets[i].getType() != DatasetType.NETWORK || datasets[i].getType() == DatasetType.NETWORK && datasets[i].getChildDataset().getType() != DatasetType.POINT) continue;
            vector.add(InternalHandle.getHandle((com.supermap.data.InternalHandle)datasets[i]));
        }
        if (vector.size() == 0) {
            String string = InternalResource.loadString("datasets", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long[] lArray = new long[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            lArray[i] = (Long)vector.get(i);
        }
        return NetworkBuilderNative.jni_AppendToNetwork(l, lArray);
    }

    public static boolean fixRingEdgeErrors(DatasetVector networkDataset, Collection<Integer> errorIDs) {
        if (networkDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset) == 0L) {
            String string = InternalResource.loadString("networkDataset", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (networkDataset.getType() != DatasetType.NETWORK) {
            String string = InternalResource.loadString("networkDataset.getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (errorIDs == null) {
            String string = InternalResource.loadString("errorIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        return NetworkBuilder.fixRingEdgeErrors(networkDataset, errorIDs, networkDataset.getFieldNameBySign(FieldSign.EDGEID), networkDataset.getFieldNameBySign(FieldSign.FNODE), networkDataset.getFieldNameBySign(FieldSign.TNODE), networkDataset.getChildDataset().getFieldNameBySign(FieldSign.NODEID));
    }

    public static boolean fixRingEdgeErrors(DatasetVector networkDataset, Collection<Integer> errorIDs, String edgeIDField, String fromNodeIDField, String toNodeIDField, String nodeIDField) {
        if (networkDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset) == 0L) {
            String string = InternalResource.loadString("networkDataset", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (networkDataset.getType() != DatasetType.NETWORK) {
            String string = InternalResource.loadString("networkDataset.getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        FieldInfos fieldInfos = networkDataset.getFieldInfos();
        if (edgeIDField == null) {
            String string = InternalResource.loadString("edgeIDField", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (fieldInfos.indexOf(edgeIDField) == -1) {
            String string = InternalResource.loadString("edgeIDField", "FieldNotInDatasetVector", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (fromNodeIDField == null) {
            String string = InternalResource.loadString("fromNodeIDField", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (fieldInfos.indexOf(fromNodeIDField) == -1) {
            String string = InternalResource.loadString("fromNodeIDField", "FieldNotInDatasetVector", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (toNodeIDField == null) {
            String string = InternalResource.loadString("toNodeIDField", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (fieldInfos.indexOf(toNodeIDField) == -1) {
            String string = InternalResource.loadString("toNodeIDField", "FieldNotInDatasetVector", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        FieldInfos fieldInfos2 = networkDataset.getChildDataset().getFieldInfos();
        if (nodeIDField == null) {
            String string = InternalResource.loadString("nodeIDField", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (fieldInfos2.indexOf(nodeIDField) == -1) {
            String string = InternalResource.loadString("nodeIDField", "FieldNotInDatasetVector", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (errorIDs == null) {
            String string = InternalResource.loadString("errorIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (errorIDs.size() == 0) {
            return true;
        }
        int[] nArray = new int[errorIDs.size()];
        int n = 0;
        for (Integer n2 : errorIDs) {
            nArray[n++] = n2;
        }
        return NetworkBuilderNative.jni_FixEdgeStartEndEqualErrors(InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset), nArray, edgeIDField, fromNodeIDField, toNodeIDField, nodeIDField);
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "NetworkBuilder";
        boolean bl = InternalToolkitNetworkAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        NetworkBuilder.fireStepped(steppedEvent);
        InternalToolkitNetworkAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitNetworkAnalyst.managerProducts(InternalToolkitNetworkAnalyst.getNetworkAnalystProducts());
        m_license = InternalToolkitNetworkAnalyst.verifyLicense(arrayList);
    }
}

