/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing.cache;

import com.supermap.data.processing.CompactFile;
import com.supermap.data.processing.CompactFileOpenMode;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.imageio.ImageIO;

public class MergeCompactRunner
implements Runnable {
    private File des;
    private File src;

    public MergeCompactRunner(File srcCf, File desCf) {
        this.src = srcCf;
        this.des = desCf;
    }

    @Override
    public void run() {
        long l = System.currentTimeMillis();
        CompactFile compactFile = new CompactFile();
        CompactFile compactFile2 = new CompactFile();
        compactFile.Open(this.src.getAbsolutePath(), "");
        compactFile2.Open(this.des.getAbsolutePath(), "", CompactFileOpenMode.ReadWrite);
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                byte[] byArray = compactFile2.getAt(i, j);
                byte[] byArray2 = compactFile.getAt(i, j);
                if (byArray == null && byArray2 != null) {
                    compactFile2.SetAt(i, j, byArray2);
                    continue;
                }
                if (byArray != null && byArray.length > 16 && byArray2 != null && byArray2.length > 16) {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2, 12, byArray2.length - 12);
                        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray, 12, byArray.length - 12);
                        BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
                        BufferedImage bufferedImage2 = ImageIO.read(byteArrayInputStream2);
                        Graphics2D graphics2D = bufferedImage2.createGraphics();
                        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                        graphics2D.dispose();
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)bufferedImage2, "png", byteArrayOutputStream);
                        byte[] byArray3 = byteArrayOutputStream.toByteArray();
                        byte[] byArray4 = new byte[12 + byArray3.length];
                        for (int k = 0; k < 12; ++k) {
                            byArray4[k] = byArray[k];
                        }
                        System.arraycopy(byArray3, 0, byArray4, 12, byArray3.length);
                        compactFile2.SetAt(i, j, byArray4);
                        byteArrayOutputStream.close();
                        byteArrayInputStream.close();
                        byteArrayInputStream2.close();
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                    }
                    continue;
                }
                if (byArray != null && byArray.length == 16 && byArray2 != null && byArray2.length > 16) {
                    compactFile2.SetAt(i, j, byArray2);
                    continue;
                }
                if (byArray == null || byArray.length <= 16 || byArray2 == null || byArray2.length != 16) continue;
                compactFile2.SetAt(i, j, byArray);
            }
        }
        compactFile.Close();
        compactFile2.Close();
        long l2 = System.currentTimeMillis();
        System.out.println(String.format("thread id %d, merger %s to %s cost %d", Thread.currentThread().getId(), this.src.getAbsolutePath(), this.des.getAbsolutePath(), l2 - l));
    }
}

