/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Point3D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.DataRGBMode;
import com.supermap.data.processing.DataSeparator;
import com.supermap.data.processing.DataUnit;
import com.supermap.data.processing.ImageTilingMode;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.PointCloudCacheBuilderNative;
import com.supermap.data.processing.PointCloudCategoryField;
import com.supermap.data.processing.PointCloudFileInfo;
import com.supermap.data.processing.PointCloudInfoType;
import com.supermap.data.processing.ProcessFileType;
import com.supermap.data.processing.PyramidSplitType;
import com.supermap.realspace.CacheFileType;
import com.supermap.tilestorage.TileStorageConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class PointCloudCacheBuilder
extends InternalHandleDisposable {
    private static transient Vector m_steppedListeners;
    private static String m_senderMethodName;
    private long m_selfEventHandle;
    private static long removeEventHandle;
    private long m_pPointCloudSpatialIndex;
    private PointCloudFileInfo m_pointCloudFileInfo;

    public PointCloudCacheBuilder() {
        long l = PointCloudCacheBuilderNative.jni_New();
        this.m_pPointCloudSpatialIndex = PointCloudCacheBuilderNative.jni_NewIndex();
        this.m_pointCloudFileInfo = null;
        this.setHandle(l, true);
        this.m_selfEventHandle = PointCloudCacheBuilderNative.jni_NewSelfEventHandle(this);
        removeEventHandle = PointCloudCacheBuilderNative.jni_NewSelfEventHandle(this);
    }

    public PointCloudCacheBuilder(String pointCloudName, String outputFolder, String cacheName) {
        long l = PointCloudCacheBuilderNative.jni_New1(pointCloudName, outputFolder, cacheName);
        this.m_pointCloudFileInfo = null;
        this.m_pPointCloudSpatialIndex = PointCloudCacheBuilderNative.jni_NewIndex();
        this.setHandle(l, true);
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getProcessType() == ProcessFileType.NORMAL) {
            return PointCloudCacheBuilderNative.jni_Build(this.getHandle(), this.m_selfEventHandle);
        }
        return PointCloudCacheBuilderNative.jni_Build2(this.m_pPointCloudSpatialIndex, this.getHandle(), this.m_selfEventHandle);
    }

    public void setCacheName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheName(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.length() == 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetCacheName(this.getHandle(), value);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return PointCloudCacheBuilderNative.jni_GetCacheName(this.getHandle());
    }

    public boolean generatePointCloudList(String listFileName, ArrayList<String> fileNames, Point3D ptPos, PrjCoordSys srcPrjCoordSys, PointCloudInfoType infoType, DataSeparator dataSeparator, DataRGBMode RGBMode, DataUnit dataUnit) {
        String[] stringArray = new String[fileNames.size()];
        for (int i = 0; i < fileNames.size(); ++i) {
            stringArray[i] = fileNames.get(i);
        }
        double d = ptPos.getX();
        double d2 = ptPos.getY();
        double d3 = ptPos.getZ();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)srcPrjCoordSys);
        return PointCloudCacheBuilderNative.jni_GeneratePointCloudList(listFileName, stringArray, d, d2, d3, l, infoType.value(), dataSeparator.value(), RGBMode.value(), dataUnit.value());
    }

    public void setOutputFolder(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.length() == 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetOutputFolder(this.getHandle(), value);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return PointCloudCacheBuilderNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setDatabaseConnection(TileStorageConnection connInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (connInfo == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = null;
        if (connInfo != null) {
            stringArray = new String[]{connInfo.getServer(), connInfo.getDatabase(), connInfo.getName(), connInfo.getUser(), connInfo.getPassword()};
        }
        PointCloudCacheBuilderNative.jni_SetTileStorageConnection(this.getHandle(), stringArray);
    }

    public void setPointCloudListName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPointCloudListName(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.length() == 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetPointCloudListName(this.getHandle(), value);
    }

    public String getPointCloudListName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointCloudListName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return PointCloudCacheBuilderNative.jni_GetPointCloudListName(this.getHandle());
    }

    public void setGenerateNormal(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGenerateNormal(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetGenerateNormal(this.getHandle(), value);
    }

    public void setTilePyramidSplitType(PyramidSplitType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTilePyramidSplitType(PyramidSplitType value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetTilePyramidSplitType(this.getHandle(), value.value());
    }

    public PyramidSplitType getTilePyramidSplitType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTilePyramidSplitType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = PointCloudCacheBuilderNative.jni_GetTilePyramidSplitType(this.getHandle());
        return (PyramidSplitType)InternalEnum.parseUGCValue(PyramidSplitType.class, n);
    }

    public PointCloudCategoryField getCategoryField() {
        if (this.getHandle() == 0L || this.m_pPointCloudSpatialIndex == 0L) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getProcessType() == ProcessFileType.NORMAL && this.getPointCloudListName().isEmpty()) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getProcessType() == ProcessFileType.NORMAL ? PointCloudCacheBuilderNative.jni_GetCategoryField(this.getHandle()) : PointCloudCacheBuilderNative.jni_GetCategoryField_Index(this.m_pPointCloudSpatialIndex);
        return (PointCloudCategoryField)InternalEnum.parseUGCValue(PointCloudCategoryField.class, n);
    }

    public void setCategoryField(PointCloudCategoryField value) {
        if (this.getHandle() == 0L || this.m_pPointCloudSpatialIndex == 0L) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getProcessType() == ProcessFileType.NORMAL && this.getPointCloudListName().isEmpty()) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = this.getProcessType() == ProcessFileType.NORMAL ? PointCloudCacheBuilderNative.jni_SetCategoryField(this.getHandle(), value.value()) : PointCloudCacheBuilderNative.jni_SetCategoryField_Index(this.m_pPointCloudSpatialIndex, value.value());
        if (!bl) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
    }

    public CacheFileType getFileType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = PointCloudCacheBuilderNative.jni_GetFileType(this.getHandle());
        switch (n) {
            case 505: {
                n = 0;
                break;
            }
            case 511: {
                n = 1;
                break;
            }
            case 515: {
                n = 2;
                break;
            }
            default: {
                String string = InternalResource.loadString("fileType", "CacheFileTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
        }
        return (CacheFileType)InternalEnum.parseUGCValue(CacheFileType.class, n);
    }

    public void setFileType(CacheFileType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = 0;
        if (value == CacheFileType.OSGB) {
            n = 505;
        } else if (value == CacheFileType.S3M) {
            n = 511;
        } else if (value == CacheFileType.S3MB) {
            n = 515;
        } else {
            String string = InternalResource.loadString("value", "CacheFileTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetFileType(this.getHandle(), n);
    }

    public ProcessFileType getProcessType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = PointCloudCacheBuilderNative.jni_GetProcessFileType(this.getHandle());
        return (ProcessFileType)InternalEnum.parseUGCValue(ProcessFileType.class, n);
    }

    public void setProcessType(ProcessFileType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetProcessFileType(this.getHandle(), value.value());
    }

    public static boolean generatePointCloudList(ArrayList<String> fileNames, PointCloudFileInfo pointCloudFileInfo) {
        String[] stringArray = new String[fileNames.size()];
        for (int i = 0; i < fileNames.size(); ++i) {
            stringArray[i] = fileNames.get(i);
        }
        double d = pointCloudFileInfo.getPosition().getX();
        double d2 = pointCloudFileInfo.getPosition().getY();
        double d3 = pointCloudFileInfo.getPosition().getZ();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)pointCloudFileInfo.getSrcPrjCoordSys());
        if (pointCloudFileInfo.isTransEnable()) {
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)pointCloudFileInfo.getDesPrjCoordSys());
            long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)pointCloudFileInfo.getCoordSystemTransParameter());
            return PointCloudCacheBuilderNative.jni_GeneratePointCloudList2(pointCloudFileInfo.getListFileName(), stringArray, d, d2, d3, l, true, l2, l3, pointCloudFileInfo.getCoordSystemTransMethod().value(), pointCloudFileInfo.getPointInfoType().value(), pointCloudFileInfo.getPointDataSeparator().value(), pointCloudFileInfo.getPointDataRGBMode().value(), pointCloudFileInfo.getPointDataUnit().value());
        }
        return PointCloudCacheBuilderNative.jni_GeneratePointCloudList(pointCloudFileInfo.getListFileName(), stringArray, d, d2, d3, l, pointCloudFileInfo.getPointInfoType().value(), pointCloudFileInfo.getPointDataSeparator().value(), pointCloudFileInfo.getPointDataRGBMode().value(), pointCloudFileInfo.getPointDataUnit().value());
    }

    public PointCloudFileInfo getPointCloudInfos() {
        if (this.m_pPointCloudSpatialIndex == 0L) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_pointCloudFileInfo;
    }

    public void setPointCloudInfos(PointCloudFileInfo pointCloudInfoValue) {
        HashMap<String, ArrayList<String>> hashMap;
        if (this.m_pPointCloudSpatialIndex == 0L) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_pointCloudFileInfo = pointCloudInfoValue;
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        if (pointCloudInfoValue.isTransEnable()) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)pointCloudInfoValue.getDesPrjCoordSys());
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)pointCloudInfoValue.getCoordSystemTransParameter());
            n = pointCloudInfoValue.getCoordSystemTransMethod().value();
        }
        ArrayList<String> arrayList = pointCloudInfoValue.getPointCloudFileNamesArray();
        String[] stringArray = null;
        if (arrayList != null) {
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = arrayList.get(i);
            }
        }
        if ((hashMap = pointCloudInfoValue.getGroupFileNames()) == null) {
            return;
        }
        String[] stringArray2 = new String[hashMap.size()];
        Object[] objectArray = new Object[hashMap.size()];
        Iterator<String> iterator = hashMap.keySet().iterator();
        Iterator<ArrayList<String>> iterator2 = hashMap.values().iterator();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String[]> arrayList3 = new ArrayList<String[]>();
        while (iterator.hasNext()) {
            arrayList2.add(iterator.next());
            ArrayList<String> arrayList4 = iterator2.next();
            String[] stringArray3 = arrayList4.toArray(new String[arrayList4.size()]);
            arrayList3.add(stringArray3);
        }
        stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
        objectArray = arrayList3.toArray(new Object[arrayList3.size()]);
        PointCloudCacheBuilderNative.jni_SetPointCloudInfos(this.m_pPointCloudSpatialIndex, InternalHandle.getHandle((com.supermap.data.InternalHandle)pointCloudInfoValue.getSrcPrjCoordSys()), pointCloudInfoValue.isTransEnable(), l, l2, n, pointCloudInfoValue.getPointInfoType().value(), pointCloudInfoValue.getPointDataRGBMode().value(), pointCloudInfoValue.getPointDataSeparator().value(), pointCloudInfoValue.getPointDataUnit().value(), pointCloudInfoValue.getPosition().getX(), pointCloudInfoValue.getPosition().getY(), pointCloudInfoValue.getPosition().getZ(), pointCloudInfoValue.getBBoxMerged().getLower().getX(), pointCloudInfoValue.getBBoxMerged().getLower().getY(), pointCloudInfoValue.getBBoxMerged().getLower().getZ(), pointCloudInfoValue.getBBoxMerged().getUpper().getX(), pointCloudInfoValue.getBBoxMerged().getUpper().getY(), pointCloudInfoValue.getBBoxMerged().getUpper().getZ(), stringArray, pointCloudInfoValue.getPointDensity(), pointCloudInfoValue.getArrClassify(), stringArray2, objectArray);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            PointCloudCacheBuilderNative.jni_Delete(this.getHandle());
            if (this.m_pPointCloudSpatialIndex != 0L) {
                PointCloudCacheBuilderNative.jni_DeleteIndex(this.m_pPointCloudSpatialIndex);
            }
            this.clearHandle();
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    static void steppedCallBack(PointCloudCacheBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            PointCloudCacheBuilder.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    public ArrayList<PointCloudCategoryField> getValidCategoryFields() {
        if (this.getHandle() == 0L || this.m_pPointCloudSpatialIndex == 0L) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getProcessType() == ProcessFileType.NORMAL && this.getPointCloudListName().isEmpty()) {
            String string = InternalResource.loadString("PointCloudCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<PointCloudCategoryField> arrayList = new ArrayList<PointCloudCategoryField>();
        int[] nArray = this.getProcessType() == ProcessFileType.NORMAL ? PointCloudCacheBuilderNative.jni_GetAllValidCategory(this.getHandle()) : PointCloudCacheBuilderNative.jni_GetAllValidCategory_Index(this.m_pPointCloudSpatialIndex);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((PointCloudCategoryField)InternalEnum.parseUGCValue(PointCloudCategoryField.class, nArray[i]));
        }
        return arrayList;
    }

    static void parsePointCloud(String filePath, String attStoreDir, double averResolution) {
        PointCloudCacheBuilderNative.jni_ParsePointCloud(filePath, attStoreDir, averResolution);
    }

    static int[] caculateRowRangeAndColRange(double[] insertPoint, String xmlDir, int nRecommendedValue) {
        int[] nArray = new int[4];
        PointCloudCacheBuilderNative.jni_CaculateRowRangeAndColRange(nArray, insertPoint, xmlDir, nRecommendedValue);
        return nArray;
    }

    static String[] caculateRelatedLasFileList(int row, int col, String attStoreDir) {
        String string = PointCloudCacheBuilderNative.jni_CaculateRelatedLasFileListBasedColAndRow(row, col, attStoreDir);
        if (string.compareToIgnoreCase("") == 0) {
            return null;
        }
        return InternalToolkitProcessing.splitString(string, ";");
    }

    static void buildTile(String outputDir, int row, int col, String[] relatedFileList, TileStorageConnection mongoConn, String attStoreDir, double[] insertPoint, CacheFileType type, PointCloudCategoryField field) {
        String[] stringArray = null;
        if (mongoConn != null) {
            stringArray = new String[]{mongoConn.getServer(), mongoConn.getDatabase(), mongoConn.getName(), mongoConn.getUser(), mongoConn.getPassword()};
        }
        int n = 0;
        if (type == CacheFileType.OSGB) {
            n = 505;
        } else if (type == CacheFileType.S3M) {
            n = 511;
        } else if (type == CacheFileType.S3MB) {
            n = 515;
        } else {
            String string = InternalResource.loadString("value", "CacheFileTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_BuildTile2(outputDir, row, col, relatedFileList, stringArray, attStoreDir, insertPoint, n, field.value());
    }

    static void generatePointCloudScp(String scpPath, String attStoreDir, TileStorageConnection mongoConn) {
        String[] stringArray = null;
        if (mongoConn != null) {
            stringArray = new String[]{mongoConn.getServer(), mongoConn.getDatabase(), mongoConn.getName(), mongoConn.getUser(), mongoConn.getPassword()};
        }
        PointCloudCacheBuilderNative.jni_GeneratePointCloudScp(scpPath, attStoreDir, stringArray);
    }

    static boolean createMongoTileset(TileStorageConnection mongoConn) {
        String[] stringArray = null;
        if (mongoConn != null) {
            stringArray = new String[]{mongoConn.getServer(), mongoConn.getDatabase(), mongoConn.getName(), mongoConn.getUser(), mongoConn.getPassword()};
        }
        return PointCloudCacheBuilderNative.jni_CreateMongoTileset(stringArray);
    }

    @Deprecated
    public ImageTilingMode getImageTilingMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageTilingMode", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = PointCloudCacheBuilderNative.jni_GetImageTilingMode(this.getHandle());
        if (n == 0) {
            return ImageTilingMode.GLOBAL;
        }
        return ImageTilingMode.LOCAL;
    }

    @Deprecated
    public void setImageTilingMode(ImageTilingMode imageTilingModelValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageTilingMode", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetImageTilingMode(this.getHandle(), imageTilingModelValue.value());
    }

    public ImageTilingMode getTileSplitType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileSplitType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = PointCloudCacheBuilderNative.jni_GetPointCloudTileSplitType(this.m_pPointCloudSpatialIndex);
        if (n == 0) {
            return ImageTilingMode.GLOBAL;
        }
        return ImageTilingMode.LOCAL;
    }

    public void setTileSplitType(ImageTilingMode imageTilingModelValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileSplitType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetPointCloudTileSplitType(this.m_pPointCloudSpatialIndex, imageTilingModelValue.value());
    }

    public int getBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBeginLevel", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return PointCloudCacheBuilderNative.jni_GetBeginLevel(this.m_pPointCloudSpatialIndex);
    }

    public void setBeginLevel(int beginLevel) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBeginLevel", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetBeginLevel(this.m_pPointCloudSpatialIndex, beginLevel);
    }

    public int getEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndLevel", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return PointCloudCacheBuilderNative.jni_GetEndLevel(this.m_pPointCloudSpatialIndex);
    }

    public void setEndLevel(int endLevel) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndLevel", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetEndLevel(this.m_pPointCloudSpatialIndex, endLevel);
    }

    public static int[] getValidClassifyInfos(String fileName) {
        return PointCloudCacheBuilderNative.jni_GetValidClassifyInfos(fileName);
    }

    public void setSourceConfigFilePath(String pathValue) {
        if (this.m_pPointCloudSpatialIndex == 0L) {
            String string = InternalResource.loadString("setSourceConfigFilePath", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        PointCloudCacheBuilderNative.jni_SetSourceConfigFilePath(this.m_pPointCloudSpatialIndex, pathValue);
    }

    public static boolean deleteGroupData(String configFileName, String[] groupNames) {
        return PointCloudCacheBuilderNative.jni_DeleteGroupData(configFileName, groupNames, removeEventHandle);
    }
}

