/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.data.Point2D;
import com.supermap.jsuperpy.serializer.DataSerializer;
import com.supermap.jsuperpy.serializer.DataSerializers;
import com.supermap.jsuperpy.serializer.SerializerUtil;
import com.supermap.jsuperpy.serializer.impl.BooleanArraySerializer;
import com.supermap.jsuperpy.serializer.impl.DoubleArraySerializer;
import com.supermap.jsuperpy.serializer.impl.FloatArraySerializer;
import com.supermap.jsuperpy.serializer.impl.IntegerArraySerializer;
import com.supermap.jsuperpy.serializer.impl.LongArraySerializer;
import com.supermap.jsuperpy.serializer.impl.Point2DArraySerializer;
import com.supermap.jsuperpy.serializer.impl.ShortArraySerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ObjectArraySerializer
extends DataSerializer {
    private Map<String, Class> listSerializers = new HashMap<String, Class>();

    public ObjectArraySerializer() {
        this.listSerializers.put("b", BooleanArraySerializer.class);
        this.listSerializers.put("d", DoubleArraySerializer.class);
        this.listSerializers.put("f", FloatArraySerializer.class);
        this.listSerializers.put("i", IntegerArraySerializer.class);
        this.listSerializers.put("l", LongArraySerializer.class);
        this.listSerializers.put("s", ShortArraySerializer.class);
        this.listSerializers.put("P2", Point2DArraySerializer.class);
    }

    @Override
    public Class getValueClass() {
        return Object[].class;
    }

    @Override
    public String getTypeName() {
        return "OL";
    }

    private static int getMaxSubSameType(Object[] values, int start, ArrayList<Object> subs) {
        Object value = values[start];
        int i = start + 1;
        subs.add(value);
        Class<?> classValue = null;
        classValue = value != null ? value.getClass() : null;
        while (i < values.length) {
            if (values[i] != null) {
                if (values[i].getClass() != classValue) break;
                subs.add(values[i]);
                ++i;
                continue;
            }
            if (classValue != null) break;
            subs.add(null);
            ++i;
        }
        return i;
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ArrayList<Object> subs = new ArrayList<Object>();
            int start = 0;
            while (start < values.length) {
                subs.clear();
                start = ObjectArraySerializer.getMaxSubSameType(values, start, subs);
                if (subs.size() <= 0) continue;
                ByteArrayOutputStream subStream = new ByteArrayOutputStream();
                try {
                    subStream.write(SerializerUtil.encodeInt(subs.size()));
                    if (subs.get(0) == null) {
                        subStream.write(SerializerUtil.encodeString("!n;"));
                    } else {
                        byte[] valueBytes;
                        DataSerializer serializer = DataSerializers.find(subs.get(0).getClass());
                        String typeName = serializer.getTypeName();
                        subStream.write(SerializerUtil.encodeString("!" + typeName + ";"));
                        if (this.listSerializers.keySet().contains(typeName)) {
                            try {
                                Comparable<Boolean>[] subValues;
                                DataSerializer arraySerializer = (DataSerializer)this.listSerializers.get(typeName).newInstance();
                                Comparable<Boolean>[] itemValues = null;
                                if (arraySerializer instanceof BooleanArraySerializer) {
                                    subValues = new Boolean[subs.size()];
                                    subs.toArray(subValues);
                                    itemValues = subValues;
                                } else if (arraySerializer instanceof DoubleArraySerializer) {
                                    subValues = new Double[subs.size()];
                                    subs.toArray(subValues);
                                    itemValues = subValues;
                                } else if (arraySerializer instanceof IntegerArraySerializer) {
                                    subValues = new Integer[subs.size()];
                                    subs.toArray(subValues);
                                    itemValues = subValues;
                                } else if (arraySerializer instanceof ShortArraySerializer) {
                                    subValues = new Short[subs.size()];
                                    subs.toArray(subValues);
                                    itemValues = subValues;
                                } else if (arraySerializer instanceof FloatArraySerializer) {
                                    subValues = new Float[subs.size()];
                                    subs.toArray(subValues);
                                    itemValues = subValues;
                                } else if (arraySerializer instanceof LongArraySerializer) {
                                    subValues = new Long[subs.size()];
                                    subs.toArray(subValues);
                                    itemValues = subValues;
                                } else if (arraySerializer instanceof Point2DArraySerializer) {
                                    subValues = new Point2D[subs.size()];
                                    subs.toArray(subValues);
                                    itemValues = subValues;
                                } else {
                                    throw new IllegalArgumentException("invalid dataserializer");
                                }
                                valueBytes = arraySerializer.encode(itemValues);
                                subStream.write(SerializerUtil.encodeInt(valueBytes.length));
                                subStream.write(valueBytes);
                            }
                            catch (IllegalAccessException ex) {
                                ex.printStackTrace();
                                subStream.reset();
                            }
                            catch (InstantiationException ex) {
                                ex.printStackTrace();
                                subStream.reset();
                            }
                        } else {
                            for (Object item : subs) {
                                valueBytes = serializer.encode(item);
                                subStream.write(SerializerUtil.encodeInt(valueBytes.length));
                                subStream.write(valueBytes);
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    subStream.reset();
                    ex.printStackTrace();
                }
                try {
                    stream.write(subStream.toByteArray());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return stream.toByteArray();
        }
        return new byte[0];
    }

    public Object[] decode(byte[] bys) {
        if (bys == null || bys.length == 0) {
            return new Object[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bys);
        int itemCount = byteBuffer.getInt();
        ArrayList<Object> results = new ArrayList<Object>(10);
        while (itemCount > 0) {
            block29: {
                byte tempByte = byteBuffer.get();
                ArrayList<Byte> aryBytesTypeName = new ArrayList<Byte>();
                if (tempByte == 33) {
                    while ((tempByte = byteBuffer.get()) != 59) {
                        aryBytesTypeName.add(tempByte);
                    }
                    byte[] typeNameBys = new byte[aryBytesTypeName.size()];
                    for (int i = 0; i < aryBytesTypeName.size(); ++i) {
                        typeNameBys[i] = (Byte)aryBytesTypeName.get(i);
                    }
                    String typeName = SerializerUtil.decodeString(typeNameBys);
                    if (typeName.compareTo("n") == 0) {
                        for (int i = 0; i < itemCount; ++i) {
                            results.add(null);
                        }
                    } else if (this.listSerializers.keySet().contains(typeName)) {
                        int bytesLen = byteBuffer.getInt();
                        byte[] valueBytes = new byte[bytesLen];
                        byteBuffer.get(valueBytes);
                        try {
                            Object[] tempRes;
                            DataSerializer ser;
                            DataSerializer arraySerializer = (DataSerializer)this.listSerializers.get(typeName).newInstance();
                            if (arraySerializer instanceof BooleanArraySerializer) {
                                ser = (BooleanArraySerializer)arraySerializer;
                                for (boolean bl : tempRes = ((BooleanArraySerializer)ser).decode(valueBytes)) {
                                    results.add(bl);
                                }
                                break block29;
                            }
                            if (arraySerializer instanceof DoubleArraySerializer) {
                                ser = (DoubleArraySerializer)arraySerializer;
                                for (boolean bl : tempRes = (Object[])((DoubleArraySerializer)ser).decode(valueBytes)) {
                                    results.add((double)bl);
                                }
                                break block29;
                            }
                            if (arraySerializer instanceof IntegerArraySerializer) {
                                ser = (IntegerArraySerializer)arraySerializer;
                                for (int n : tempRes = (Object[])((IntegerArraySerializer)ser).decode(valueBytes)) {
                                    results.add(n);
                                }
                                break block29;
                            }
                            if (arraySerializer instanceof ShortArraySerializer) {
                                ser = (ShortArraySerializer)arraySerializer;
                                for (short s : tempRes = (Object[])((ShortArraySerializer)ser).decode(valueBytes)) {
                                    results.add(s);
                                }
                                break block29;
                            }
                            if (arraySerializer instanceof FloatArraySerializer) {
                                ser = (FloatArraySerializer)arraySerializer;
                                for (boolean bl : tempRes = (Object[])((FloatArraySerializer)ser).decode(valueBytes)) {
                                    results.add(Float.valueOf((float)bl));
                                }
                                break block29;
                            }
                            if (arraySerializer instanceof LongArraySerializer) {
                                ser = (LongArraySerializer)arraySerializer;
                                for (int n : tempRes = (Object[])((LongArraySerializer)ser).decode(valueBytes)) {
                                    results.add(Long.valueOf(n));
                                }
                                break block29;
                            }
                            if (arraySerializer instanceof Point2DArraySerializer) {
                                ser = (Point2DArraySerializer)arraySerializer;
                                for (boolean bl : tempRes = (Object[])((Point2DArraySerializer)ser).decode(valueBytes)) {
                                    results.add(bl);
                                }
                                break block29;
                            }
                            throw new IllegalArgumentException("invalid dataserializer");
                        }
                        catch (IllegalAccessException ex) {
                            ex.printStackTrace();
                        }
                        catch (InstantiationException ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        DataSerializer ser = DataSerializers.find(typeName);
                        for (int i = 0; i < itemCount; ++i) {
                            int bytesLen = byteBuffer.getInt();
                            byte[] valueBytes = new byte[bytesLen];
                            byteBuffer.get(valueBytes);
                            results.add(ser.decode(valueBytes));
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Invalid input bytes");
                }
            }
            if (byteBuffer.position() == byteBuffer.limit()) break;
            itemCount = byteBuffer.getInt();
        }
        Object[] resultValues = new Object[results.size()];
        results.toArray(resultValues);
        return resultValues;
    }
}

