/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.data.Enum;
import com.supermap.jsuperpy.serializer.DataSerializer;
import com.supermap.jsuperpy.serializer.SerializerUtil;

public class EnumSerializer
extends DataSerializer {
    private Class enumClass;

    public EnumSerializer() {
        this.enumClass = null;
    }

    public EnumSerializer(Class enumClass) {
        this.enumClass = enumClass;
    }

    public void setEnumClass(Class enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public Class getValueClass() {
        return this.enumClass;
    }

    @Override
    public String getTypeName() {
        return this.enumClass.getName();
    }

    @Override
    public byte[] encode(Object value) {
        if (this.enumClass.isInstance(value)) {
            return SerializerUtil.encodeInt(((Enum)value).value());
        }
        return new byte[0];
    }

    @Override
    public Object decode(byte[] bys) {
        return Enum.parse((Class)this.enumClass, (int)SerializerUtil.decodeInt(bys));
    }
}

