/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Dataset;
import com.supermap.data.conversion.ExportSetting;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.VCTVersion;
import java.util.ArrayList;

public class ExportSettingVCT
extends ExportSetting {
    private ArrayList<Object> m_sourceDatas;
    private String m_strVCTConfigFile;
    private VCTVersion m_version;

    public ExportSettingVCT() {
        this.m_sourceDatas = new ArrayList();
        this.setTargetFileType(FileType.VCT);
        this.m_strVCTConfigFile = "";
        this.m_version = VCTVersion.LANDUSE_VCT;
    }

    public ExportSettingVCT(ExportSettingVCT exportSettingVCT) {
        super(exportSettingVCT);
        this.m_sourceDatas = exportSettingVCT.m_sourceDatas;
        this.setConfigFilePath(exportSettingVCT.getConfigFilePath());
        this.setVersion(exportSettingVCT.getVersion());
    }

    public ExportSettingVCT(Object sourceData, String targetFilePath) {
        super(sourceData, targetFilePath, FileType.VCT);
        this.m_sourceDatas = new ArrayList();
        this.setSourceData(sourceData);
        this.m_strVCTConfigFile = "";
        this.m_version = VCTVersion.LANDUSE_VCT;
    }

    public ExportSettingVCT(Object[] sourceDatas, String targetFilePath) {
        super(sourceDatas[0], targetFilePath, FileType.VCT);
        this.m_sourceDatas = new ArrayList();
        this.setSourceDatas(sourceDatas);
        this.m_strVCTConfigFile = "";
        this.m_version = VCTVersion.LANDUSE_VCT;
    }

    @Override
    public Object getSourceData() {
        if (this.m_sourceDatas.size() <= 0) {
            return null;
        }
        return this.m_sourceDatas.get(0);
    }

    @Override
    public void setSourceData(Object value) {
        if (!(value instanceof Dataset)) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_sourceDatas != null) {
            this.m_sourceDatas.clear();
            this.m_sourceDatas.add(value);
        }
        this.m_sourceData = value;
    }

    public Object[] getSourceDatas() {
        return this.m_sourceDatas.toArray();
    }

    public void setSourceDatas(Object[] sourceDatas) {
        if (sourceDatas == null || sourceDatas.length == 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        for (Object object : sourceDatas) {
            if (object instanceof Dataset) continue;
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_sourceDatas.clear();
        for (int i = 0; i < sourceDatas.length; ++i) {
            this.m_sourceDatas.add(sourceDatas[i]);
        }
        if (this.m_sourceDatas.size() > 0) {
            this.m_sourceData = this.m_sourceDatas.get(0);
        }
    }

    @Override
    public void setTargetFileType(FileType type) {
        if (type != FileType.VCT) {
            String string = InternalResource.loadString("setTargetFileType(FileType type)", "SetTargetFileTypeIsNotAllowed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        super.setTargetFileType(type);
    }

    public String getConfigFilePath() {
        return this.m_strVCTConfigFile;
    }

    public void setConfigFilePath(String path) {
        this.m_strVCTConfigFile = path;
    }

    public VCTVersion getVersion() {
        return this.m_version;
    }

    public void setVersion(VCTVersion value) {
        this.m_version = value;
    }
}

