/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.addressmatching.AddressMatchNative;
import com.supermap.analyst.addressmatching.AddressMatchResults;
import com.supermap.analyst.addressmatching.AddressSearchResult;
import com.supermap.analyst.addressmatching.AddressSearchSetting;
import com.supermap.analyst.addressmatching.InternalHandleDisposable;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.analyst.addressmatching.InternalToolkitAddressMatching;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.PrjCoordSys;
import java.util.ArrayList;

public class AddressSearch
extends InternalHandleDisposable {
    private AddressSearchSetting m_setting;
    private License m_license;

    public AddressSearch() {
        this.checkLicense();
        this.m_setting = new AddressSearchSetting();
    }

    public AddressSearchSetting getSetting() {
        return this.m_setting;
    }

    public void setSetting(AddressSearchSetting value) {
        if (value == null) {
            String string = InternalResource.loadString("setAnalystSetting(NetworkAnalystSetting value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (this.getHandle() == 0L) {
            long l = AddressMatchNative.jni_New(value.getSearchDirectory());
            if (l == 0L) {
                String string = InternalResource.loadString("indexDirectory", "Global_ArgumentNull", "addressmatching_resources");
                throw new IllegalArgumentException(string);
            }
            this.setHandle(l, true);
        }
        this.m_setting.setMaxResultCount(value.getMaxResultCount());
        this.m_setting.setSearchDirectory(value.getSearchDirectory());
        this.m_setting.setTopGroupName(value.getTopGroupName());
        this.m_setting.setSecondaryGroupName(value.getSecondaryGroupName());
        this.m_setting.setLowestGroupName(value.getLowestGroupName());
        this.m_setting.setAddressSegmented(value.isAddressSegmented());
        this.m_setting.setLocationReturn(value.isLocationReturn());
    }

    @Deprecated
    public AddressSearch(String indexDirectory) {
        this.checkLicense();
        long l = AddressMatchNative.jni_New1(indexDirectory);
        if (l == 0L) {
            String string = InternalResource.loadString("indexDirectory", "Global_ArgumentNull", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, true);
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitAddressMatching.managerProducts(InternalToolkitAddressMatching.getAddressMatchingProducts());
        this.m_license = InternalToolkitAddressMatching.verifyLicense(arrayList);
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    private void verifyLicense() {
        int n = this.m_license.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public void dispose() {
        this.unLoadLicense();
        if (this.getHandle() != 0L) {
            AddressMatchNative.jni_Delete1(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Deprecated
    public AddressMatchResults match(String searchCity, String searchAddress, int resultCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match(String searchCity, String searchAddress, int resultCount)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (searchAddress == null || searchAddress.trim().length() == 0) {
            String string = InternalResource.loadString("searchAddress", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultCount <= 0) {
            String string = InternalResource.loadString("resultCount", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        long l = AddressMatchNative.jni_Match1(this.getHandle(), searchAddress, searchCity, resultCount);
        AddressMatchResults addressMatchResults = null;
        if (l != 0L) {
            addressMatchResults = new AddressMatchResults(l, null);
        }
        return addressMatchResults;
    }

    public boolean isValidTopGroupName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTopGroupNameSetValid(String value)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("isTopGroupNameSetValid(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        return AddressMatchNative.jni_IsValidTopGroupName(this.getHandle(), value);
    }

    public boolean isValidSecondaryGroupName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSecondaryGroupNameSetValid(String value)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("isSecondaryGroupNameSetValid(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        return AddressMatchNative.jni_IsValidSecondaryGroupName(this.getHandle(), value);
    }

    public boolean isValidLowestGroupName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLowestGroupNameSetValid(String value)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("isLowestGroupNameSetValid(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        return AddressMatchNative.jni_IsValidLowestGroupName(this.getHandle(), value);
    }

    public int match(String searchAddress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match(String searchAddress)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (searchAddress == null || searchAddress.trim().length() == 0) {
            String string = InternalResource.loadString("searchAddress", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        return AddressMatchNative.jni_Match2(this.getHandle(), searchAddress, this.m_setting.getMaxResultCount(), this.m_setting.getTopGroupName(), this.m_setting.getSecondaryGroupName(), this.m_setting.getLowestGroupName(), this.m_setting.isLocationReturn(), this.m_setting.isAddressSegmented());
    }

    public int match(Geometry geometry, double dDistance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match(String searchAddress)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (dDistance < 0.0) {
            String string = InternalResource.loadString("dDistance", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        return AddressMatchNative.jni_Match3(this.getHandle(), this.m_setting.getMaxResultCount(), l, dDistance);
    }

    public AddressMatchResults get(int resultCount, int startPosition) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match(String searchAddress)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (resultCount <= 0) {
            String string = InternalResource.loadString("resultCount", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (startPosition < 0) {
            String string = InternalResource.loadString("startPosition", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        long l = AddressMatchNative.jni_GetMatchResults(this.getHandle(), resultCount, startPosition);
        AddressMatchResults addressMatchResults = null;
        if (l != 0L) {
            addressMatchResults = new AddressMatchResults(l, null);
        }
        return addressMatchResults;
    }

    public PrjCoordSys getPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        PrjCoordSys prjCoordSys = new PrjCoordSys();
        long l = InternalHandle.getHandle((InternalHandle)prjCoordSys);
        boolean bl = AddressMatchNative.jni_GetPrjCoordSys(this.getHandle(), l);
        if (!bl) {
            return null;
        }
        return prjCoordSys;
    }

    public AddressSearchResult match(String searchAddress, AddressSearchSetting addressSearchSetting) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match(String searchAddress)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (searchAddress == null || searchAddress.trim().length() == 0) {
            String string = InternalResource.loadString("searchAddress", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (addressSearchSetting == null) {
            String string = InternalResource.loadString("addressSearchSetting", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        long l = AddressMatchNative.jni_Match4(this.getHandle(), searchAddress, addressSearchSetting.getMaxResultCount(), addressSearchSetting.getTopGroupName(), addressSearchSetting.getSecondaryGroupName(), addressSearchSetting.getLowestGroupName(), addressSearchSetting.isLocationReturn(), addressSearchSetting.isAddressSegmented());
        AddressSearchResult addressSearchResult = null;
        if (l != 0L) {
            addressSearchResult = new AddressSearchResult(l);
        }
        return addressSearchResult;
    }

    public AddressSearchResult match(Geometry geometry, double dDistance, AddressSearchSetting addressSearchSetting) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match(String searchAddress)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (dDistance < 0.0) {
            String string = InternalResource.loadString("dDistance", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (addressSearchSetting == null) {
            String string = InternalResource.loadString("addressSearchSetting", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        long l2 = AddressMatchNative.jni_Match5(this.getHandle(), addressSearchSetting.getMaxResultCount(), l, dDistance);
        AddressSearchResult addressSearchResult = null;
        if (l2 != 0L) {
            addressSearchResult = new AddressSearchResult(l2);
        }
        return addressSearchResult;
    }
}

