/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Environment;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.realspace.threeddesigner.DataImport3DNative;
import com.supermap.realspace.threeddesigner.FileType;
import com.supermap.realspace.threeddesigner.ImportResult3D;
import com.supermap.realspace.threeddesigner.ImportSetting3D;
import com.supermap.realspace.threeddesigner.ImportSetting3Ds;
import com.supermap.realspace.threeddesigner.InternalDatasetVector;
import com.supermap.realspace.threeddesigner.InternalDatasets;
import com.supermap.realspace.threeddesigner.InternalHandle;
import com.supermap.realspace.threeddesigner.InternalResource;
import com.supermap.realspace.threeddesigner.InternalToolkitThreeDDesigner;
import java.util.ArrayList;

public class DataImport3D
extends InternalHandleDisposable {
    private ImportSetting3Ds m_importSetting3ds;
    private FileType currentType = FileType.Model3DXML;
    private long m_selfEventHandle;
    private static License m_license;

    public DataImport3D() {
        this.m_importSetting3ds = new ImportSetting3Ds();
        this.setHandle(DataImport3DNative.jni_New(), true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "ThreeDDesigner_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            DataImport3DNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public ImportSetting3Ds getImportSettings() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportSettings()", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        return this.m_importSetting3ds;
    }

    private String[] getSucImportDtNames(ImportSetting3D ImportSetting3d) {
        return ImportResult3D.GetSucceedDatasetNames(ImportSetting3d);
    }

    public void setImportSettings(ImportSetting3Ds settings) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportSettings(ImportSettings settings)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        this.m_importSetting3ds = settings;
    }

    private String[] getSucImportMapNames(ImportSetting3D ImportSetting3d) {
        return ImportResult3D.GetSucceedMapNames(ImportSetting3d);
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DataImport3DNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public FileType getCurrentType() {
        return this.currentType;
    }

    public void setCurrentType(FileType currentType) {
        this.currentType = currentType;
    }

    public ImportResult3D Run() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Run()", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        int n = this.m_importSetting3ds.getCount();
        String[] stringArray = null;
        ImportResult3D importResult3D = new ImportResult3D();
        for (int i = 0; i < n; ++i) {
            String[] stringArray2;
            boolean bl;
            Datasource datasource = this.m_importSetting3ds.get(i).getTargetDatasource();
            ArrayList<Boolean> arrayList = this.m_importSetting3ds.get(i).getStates();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            int[] nArray = new int[arrayList.size()];
            for (bl = false; bl < nArray.length; bl += 1) {
                nArray[bl] = arrayList.get(bl ? 1 : 0) != false ? 1 : 0;
            }
            bl = false;
            String[] stringArray3 = null;
            String[] stringArray4 = null;
            FileType fileType = this.m_importSetting3ds.get(i).getFileType();
            if (fileType == FileType.CityGML) {
                stringArray4 = stringArray3 = this.m_importSetting3ds.get(i).run();
                bl = stringArray3.length > 0;
            } else {
                stringArray2 = null;
                stringArray3 = new String[]{stringArray2};
                stringArray4 = new String[]{stringArray2};
                if (this.m_importSetting3ds.get(i).getTargetDatasourceConnectionInfo() != null) {
                    bl = DataImport3DNative.jni_ImportData(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_importSetting3ds.get(i)), fileType.value(), nArray, InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_importSetting3ds.get(i).getTargetDatasourceConnectionInfo()));
                } else if (this.m_importSetting3ds.get(i).getTargetDatasource() != null) {
                    stringArray = new String[datasource.getDatasets().getCount()];
                    for (int j = 0; j < stringArray.length; ++j) {
                        stringArray[j] = datasource.getDatasets().get(j).getName();
                    }
                    bl = DataImport3DNative.jni_ImportData4(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_importSetting3ds.get(i)), fileType.value(), nArray, InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_importSetting3ds.get(i).getTargetDatasource()));
                }
            }
            importResult3D.AddSetting(this.m_importSetting3ds.get(i), stringArray3, stringArray4, bl);
            if (!bl) continue;
            stringArray2 = stringArray3;
            if (fileType == FileType.CityGML) continue;
            long[] lArray = new long[1];
            int[] nArray2 = new int[1];
            DataImport3DNative.jni_GetSucImportDatasets(this.getHandle(), lArray, nArray2);
            try {
                DatasetVector datasetVector = InternalDatasetVector.createInstance(lArray[0], datasource);
                if (datasetVector == null) continue;
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.clearSelfEventHandle();
        return importResult3D;
    }

    static {
        Environment.LoadWrapJ();
        ArrayList<ProductType> arrayList = InternalToolkitThreeDDesigner.managerProducts(InternalToolkitThreeDDesigner.getThreeDDesignerProducts());
        m_license = InternalToolkitThreeDDesigner.verifyLicense(arrayList);
    }
}

