/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.DatasetGroup;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerAddedEvent;
import com.supermap.mapping.LayerAddedListener;
import com.supermap.mapping.LayerChart;
import com.supermap.mapping.LayerChartNative;
import com.supermap.mapping.LayerGroup;
import com.supermap.mapping.LayerGroupNative;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerRemovedEvent;
import com.supermap.mapping.LayerRemovedListener;
import com.supermap.mapping.LayerSnapshotAddedEvent;
import com.supermap.mapping.LayerSnapshotNative;
import com.supermap.mapping.LayerSnapshotRemovedEvent;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import java.util.ArrayList;
import java.util.Vector;

public class LayerSnapshot
extends LayerGroup {
    protected LayerSnapshot(long handle, Layers layers, Map map) {
        super(handle, null, layers, map);
    }

    @Override
    protected void fillUGOItem() {
        int n = LayerSnapshotNative.jni_GetCount(this.getHandle());
        for (int i = 0; i < n; ++i) {
            long l = LayerSnapshotNative.jni_GetItemByIndex(this.getHandle(), i);
            if (l == 0L) continue;
            boolean bl = LayerNative.jni_IsChartLayer(l);
            boolean bl2 = LayerGroupNative.jni_IsLayerGroup(l);
            if (bl) {
                long l2 = LayerChartNative.jni_GetDatasetGroup(l);
                DatasetGroup datasetGroup = InternalToolkitMapping.toMangedDatasetGroup(this.m_map.getWorkspace(), l2);
                LayerChart layerChart = new LayerChart(l, this.m_layers, this.m_map, datasetGroup);
                layerChart.setParentGroup(null);
                layerChart.setParentSnapshot(this);
                this.m_layersList.add(layerChart);
                continue;
            }
            if (bl2) {
                LayerGroup layerGroup = new LayerGroup(l, this.m_layers, this.m_map, this);
                this.m_layersList.add(layerGroup);
                layerGroup.setParentSnapshot(this);
                layerGroup.setParentGroup(null);
                continue;
            }
            Layer layer = new Layer(l, this.m_layers, this.m_map);
            layer.setParentGroup(null);
            layer.setParentSnapshot(this);
            this.m_layersList.add(layer);
            layer.getDataset();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    @Override
    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_layersList.size();
    }

    @Override
    public Layer get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (Layer)((Object)this.m_layersList.get(index));
    }

    @Override
    void getContainedLayers(ArrayList<Layer> allLayers, boolean isVisibleOnly) {
        if (!isVisibleOnly || this.isVisible()) {
            for (Layer layer : this.m_layersList) {
                layer.getContainedLayers(allLayers, isVisibleOnly);
            }
        }
    }

    @Override
    public int indexOf(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_layersList.indexOf((Object)layer);
    }

    @Override
    public void add(Layer layer) {
        if (layer == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.insertInternal(-1, layer, l);
    }

    @Override
    public void insert(int index, Layer layer) {
        if (layer == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.insertInternal(index, layer, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertInternal(int index, Layer layer, long layerHandle) {
        try {
            this.m_lock.lock();
            if (layer instanceof LayerSnapshot) {
                String string = InternalResource.loadString("index", "LayerSnapshotInsertLayerSnapshotIsIllegal", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (layer.getParentGroup() != null) {
                layer.getParentGroup().removeLayer(layer, false);
            } else if (layer.getParentSnapshot() != null) {
                layer.getParentSnapshot().removeLayer(layer, false);
            } else {
                this.m_layers.removeLayer(layer, false);
            }
            boolean bl = LayerSnapshotNative.jni_Insert(this.getHandle(), layerHandle, index);
            if (bl) {
                layer.setParentSnapshot(this);
                if (layer instanceof LayerGroup) {
                    int n = this.m_layersList.size();
                    if (index < 0 || index >= this.m_layersList.size()) {
                        this.m_layersList.add(layer);
                        index = n;
                    } else {
                        this.m_layersList.add(index, layer);
                    }
                    LayerSnapshotAddedEvent layerSnapshotAddedEvent = new LayerSnapshotAddedEvent((Object)this.m_layers, (LayerGroup)layer, this, index);
                    this.m_layers.fireLayerSnapshotAdded(layerSnapshotAddedEvent);
                } else {
                    LayerAddedEvent layerAddedEvent = null;
                    if (index < 0 || index >= this.m_layersList.size()) {
                        this.m_layersList.add(layer);
                        layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                    } else {
                        this.m_layersList.add(index, layer);
                        layerAddedEvent = new LayerAddedEvent((Object)this, layer, index);
                    }
                    this.fireLayerAdded(layerAddedEvent);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    @Override
    public boolean remove(Layer layer) {
        return this.removeLayer(layer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean removeLayer(Layer layer, boolean deletelayer) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            if (layer == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle(layer);
            if (l == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = this.m_layersList.indexOf((Object)layer);
            String string = layer.getName();
            bl = LayerSnapshotNative.jni_Remove(this.getHandle(), l, deletelayer);
            if (bl) {
                this.m_layersList.remove((Object)layer);
                layer.setParentSnapshot(null);
                if (layer instanceof LayerGroup) {
                    LayerSnapshotRemovedEvent layerSnapshotRemovedEvent = new LayerSnapshotRemovedEvent((Object)this.m_layers, (LayerGroup)layer, this, n);
                    this.m_layers.fireLayerSnapshotRemoved(layerSnapshotRemovedEvent);
                } else {
                    LayerRemovedEvent layerRemovedEvent = new LayerRemovedEvent((Object)this, layer, string, n);
                    this.fireLayerRemoved(layerRemovedEvent);
                }
                if (deletelayer) {
                    layer.clearHandle();
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    @Override
    public LayerGroup addGroup(String groupName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addGroup(String groupName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (groupName == null) {
            groupName = "";
        }
        return this.insertGroupInternal(-1, groupName);
    }

    @Override
    public LayerGroup insertGroup(int index, String groupName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertGroup(int index, String groupName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (groupName == null) {
            groupName = "";
        }
        return this.insertGroupInternal(index, groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayerGroup insertGroupInternal(int index, String groupName) {
        LayerGroup layerGroup = null;
        try {
            this.m_lock.lock();
            long l = LayerSnapshotNative.jni_InsertGroup(this.getHandle(), groupName, index);
            layerGroup = new LayerGroup(l, this.m_layers, this.m_map, this);
            layerGroup.setMap(this.m_map);
            if (index < 0 || index >= this.m_layersList.size()) {
                this.m_layersList.add(layerGroup);
                index = this.m_layersList.size();
            } else {
                this.m_layersList.add(index, layerGroup);
            }
            LayerSnapshotAddedEvent layerSnapshotAddedEvent = new LayerSnapshotAddedEvent((Object)this, layerGroup, this, index);
            this.m_layers.fireLayerSnapshotAdded(layerSnapshotAddedEvent);
        }
        finally {
            this.m_lock.unlock();
        }
        return layerGroup;
    }

    @Override
    public boolean removeGroup(LayerGroup group) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.m_layersList.indexOf((Object)group);
        if (n < 0) {
            return false;
        }
        boolean bl = LayerSnapshotNative.jni_Remove(this.getHandle(), InternalHandle.getHandle(group), true);
        if (bl) {
            this.m_layersList.remove((Object)group);
            LayerSnapshotRemovedEvent layerSnapshotRemovedEvent = new LayerSnapshotRemovedEvent((Object)this, group, this, n);
            this.m_layers.fireLayerSnapshotRemoved(layerSnapshotRemovedEvent);
            group.clearHandle();
        }
        return bl;
    }

    @Override
    public boolean ungroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ungroup()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parentGroup != null) {
            int n = this.m_parentGroup.indexOf(this);
            int n2 = this.getCount();
            Layer layer = null;
            for (int i = n2 - 1; i >= 0; --i) {
                layer = this.get(i);
                this.m_parentGroup.insert(n, layer);
            }
            this.m_parentGroup.remove(this);
        } else {
            int n = this.m_layers.indexOf(this.getName());
            Layer layer = null;
            for (int i = this.m_layersList.size() - 1; i >= 0; --i) {
                layer = (Layer)((Object)this.m_layersList.get(i));
                this.m_layers.addLayer(n, layer);
            }
            this.m_layers.remove(this);
        }
        return true;
    }

    @Override
    public synchronized void addLayerAddedListener(LayerAddedListener l) {
        if (this.m_layerAddedListeners == null) {
            this.m_layerAddedListeners = new Vector();
        }
        if (!this.m_layerAddedListeners.contains(l)) {
            this.m_layerAddedListeners.insertElementAt(l, 0);
        }
    }

    @Override
    public synchronized void removeLayerAddedListener(LayerAddedListener l) {
        if (this.m_layerAddedListeners != null && this.m_layerAddedListeners.contains(l)) {
            this.m_layerAddedListeners.remove(l);
        }
    }

    @Override
    protected void fireLayerAdded(LayerAddedEvent event) {
        if (this.m_layerAddedListeners != null) {
            Vector vector = this.m_layerAddedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerAddedListener)vector.elementAt(i)).layerAdded(event);
            }
        }
    }

    @Override
    public synchronized void addLayerRemovedListener(LayerRemovedListener l) {
        if (this.m_layerRemovedListeners == null) {
            this.m_layerRemovedListeners = new Vector();
        }
        if (!this.m_layerRemovedListeners.contains(l)) {
            this.m_layerRemovedListeners.insertElementAt(l, 0);
        }
    }

    @Override
    public synchronized void removeLayerRemovedListener(LayerRemovedListener l) {
        if (this.m_layerRemovedListeners != null && this.m_layerRemovedListeners.contains(l)) {
            this.m_layerRemovedListeners.remove(l);
        }
    }

    @Override
    protected void fireLayerRemoved(LayerRemovedEvent event) {
        if (this.m_layerRemovedListeners != null) {
            Vector vector = this.m_layerRemovedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerRemovedListener)vector.elementAt(i)).layerRemoved(event);
            }
        }
    }

    @Override
    public String getAvailableCaption(String layerCaption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAvailableCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layerCaption == null || layerCaption.trim().isEmpty()) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LayerSnapshotNative.jni_FindAvailableCaption(this.getHandle(), layerCaption);
    }

    @Override
    public Layer findLayer(String layerName) {
        Layer layer = super.findLayer(layerName);
        if (layer != null) {
            return layer;
        }
        for (int i = 0; i < this.m_layersList.size(); ++i) {
            Layer layer2 = (Layer)((Object)this.m_layersList.get(i));
            layer = layer2.findLayer(layerName);
            if (layer == null) continue;
            return layer;
        }
        return null;
    }

    @Override
    Layer findLayer(long handle) {
        Layer layer = super.findLayer(handle);
        if (layer != null) {
            return layer;
        }
        for (int i = 0; i < this.m_layersList.size(); ++i) {
            Layer layer2 = (Layer)((Object)this.m_layersList.get(i));
            layer = layer2.findLayer(handle);
            if (layer == null) continue;
            return layer;
        }
        return null;
    }
}

