/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.DatasetGroup;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerAddedEvent;
import com.supermap.mapping.LayerAddedListener;
import com.supermap.mapping.LayerChart;
import com.supermap.mapping.LayerChartNative;
import com.supermap.mapping.LayerGroupAddedEvent;
import com.supermap.mapping.LayerGroupNative;
import com.supermap.mapping.LayerGroupRemovedEvent;
import com.supermap.mapping.LayerMosaicGroup;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerRemovedEvent;
import com.supermap.mapping.LayerRemovedListener;
import com.supermap.mapping.LayerSnapshot;
import com.supermap.mapping.LayerSnapshotNative;
import com.supermap.mapping.LayerType;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import java.util.ArrayList;
import java.util.Vector;

public class LayerGroup
extends Layer {
    protected ArrayList<Layer> m_layersList;
    transient Vector<LayerAddedListener> m_layerAddedListeners;
    transient Vector<LayerRemovedListener> m_layerRemovedListeners;

    protected LayerGroup(long handle, LayerGroup parentGroup, Layers layers, Map map) {
        super(handle, layers, map);
        this.m_parentSnapshot = null;
        this.m_layersList = new ArrayList();
        this.m_parentGroup = parentGroup;
        this.fillUGOItem();
    }

    protected LayerGroup(long handle, Layers layers, Map map, LayerSnapshot layerSnapshot) {
        super(handle, layers, map);
        this.m_layersList = new ArrayList();
        this.m_parentGroup = null;
        this.m_parentSnapshot = layerSnapshot;
        this.fillUGOItem();
    }

    protected void fillUGOItem() {
        int n = LayerGroupNative.jni_GetCount(this.getHandle());
        for (int i = 0; i < n; ++i) {
            long l = LayerGroupNative.jni_GetItemByIndex(this.getHandle(), i);
            if (l == 0L) continue;
            boolean bl = LayerNative.jni_IsChartLayer(l);
            boolean bl2 = LayerGroupNative.jni_IsLayerGroup(l);
            if (bl) {
                long l2 = LayerChartNative.jni_GetDatasetGroup(l);
                DatasetGroup datasetGroup = InternalToolkitMapping.toMangedDatasetGroup(this.m_map.getWorkspace(), l2);
                LayerChart layerChart = new LayerChart(l, this.m_layers, this.m_map, datasetGroup);
                layerChart.setParentGroup(this);
                this.m_layersList.add(layerChart);
                continue;
            }
            if (bl2) {
                LayerGroup layerGroup = new LayerGroup(l, this, this.m_layers, this.m_map);
                this.m_layersList.add(layerGroup);
                continue;
            }
            Layer layer = new Layer(l, this.m_layers, this.m_map);
            layer.setParentGroup(this);
            this.m_layersList.add(layer);
            layer.getDataset();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        try {
            this.m_lock.lock();
            if (this.m_layersList != null && this.m_layersList.size() > 0) {
                Layer layer = null;
                for (int i = 0; i < this.m_layersList.size(); ++i) {
                    layer = this.m_layersList.get(i);
                    layer.clearHandle();
                    layer = null;
                }
                this.m_layersList.clear();
                this.m_layersList = null;
            }
            this.m_parentGroup = null;
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_layersList.size();
    }

    public Layer get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_layersList.get(index);
    }

    @Override
    void getContainedLayers(ArrayList<Layer> allLayers, boolean isVisibleOnly) {
        if (!isVisibleOnly || this.isVisible()) {
            for (Layer layer : this.m_layersList) {
                layer.getContainedLayers(allLayers, isVisibleOnly);
            }
        }
    }

    public int indexOf(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_layersList.indexOf((Object)layer);
    }

    public void add(Layer layer) {
        if (layer == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.internalInsert(-1, layer, l);
    }

    public void insert(int index, Layer layer) {
        if (layer == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.internalInsert(index, layer, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer insertLayer(int index, String layerXml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertLayer(int index, String layerXml)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layerXml == null) {
            String string = InternalResource.loadString("layerXml", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Layer layer = null;
        try {
            this.m_lock.lock();
            long l = LayerGroupNative.jni_InsertLayer(this.getHandle(), layerXml, index);
            if (l == 0L) {
                Layer layer2 = null;
                return layer2;
            }
            if (LayerGroupNative.jni_IsLayerGroup(l) && Layer.getSubType(l) == LayerType.SUBLAYER_MOSAIC) {
                layer = new LayerMosaicGroup(l, this.m_layers, this.m_map);
            }
            layer = LayerSnapshotNative.jni_IsLayerSnapshot(l) ? new LayerSnapshot(l, this.m_layers, this.m_map) : (LayerGroupNative.jni_IsLayerGroup(l) ? new LayerGroup(l, null, this.m_layers, this.m_map) : new Layer(l, this.m_layers, this.m_map));
            layer.setParentGroup(this);
            layer.setMap(this.m_map);
            if (layer instanceof LayerGroup) {
                int n = this.m_layersList.size();
                if (index < 0 || index >= this.m_layersList.size()) {
                    this.m_layersList.add(layer);
                    index = n;
                } else {
                    this.m_layersList.add(index, layer);
                }
                LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this.m_layers, (LayerGroup)layer, this, index);
                this.m_layers.fireLayerGroupAdded(layerGroupAddedEvent);
            } else if (layer instanceof LayerSnapshot) {
                int n = this.m_layersList.size();
                if (index < 0 || index >= this.m_layersList.size()) {
                    this.m_layersList.add(layer);
                    index = n;
                } else {
                    this.m_layersList.add(index, layer);
                }
                LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this.m_layers, (LayerSnapshot)layer, this, index);
                this.m_layers.fireLayerGroupAdded(layerGroupAddedEvent);
            } else {
                LayerAddedEvent layerAddedEvent = null;
                if (index < 0 || index >= this.m_layersList.size()) {
                    this.m_layersList.add(layer);
                    layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                } else {
                    this.m_layersList.add(index, layer);
                    layerAddedEvent = new LayerAddedEvent((Object)this, layer, index);
                }
                this.fireLayerAdded(layerAddedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalInsert(int index, Layer layer, long layerHandle) {
        try {
            this.m_lock.lock();
            if (layer instanceof LayerSnapshot) {
                String string = InternalResource.loadString("index", "LayerGroupInsertLayerSnapshotIsIllegal", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (layer.getParentGroup() != null) {
                layer.getParentGroup().removeLayer(layer, false);
            } else if (layer.getParentSnapshot() != null) {
                layer.getParentSnapshot().removeLayer(layer, false);
            } else {
                this.m_layers.removeLayer(layer, false);
            }
            boolean bl = LayerGroupNative.jni_Insert(this.getHandle(), layerHandle, index);
            if (bl) {
                layer.setParentGroup(this);
                if (layer instanceof LayerGroup) {
                    int n = this.m_layersList.size();
                    if (index < 0 || index >= this.m_layersList.size()) {
                        this.m_layersList.add(layer);
                        index = n;
                    } else {
                        this.m_layersList.add(index, layer);
                    }
                    LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this.m_layers, (LayerGroup)layer, this, index);
                    this.m_layers.fireLayerGroupAdded(layerGroupAddedEvent);
                } else if (layer instanceof LayerSnapshot) {
                    int n = this.m_layersList.size();
                    if (index < 0 || index >= this.m_layersList.size()) {
                        this.m_layersList.add(layer);
                        index = n;
                    } else {
                        this.m_layersList.add(index, layer);
                    }
                    LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this.m_layers, (LayerSnapshot)layer, this, index);
                    this.m_layers.fireLayerGroupAdded(layerGroupAddedEvent);
                } else {
                    LayerAddedEvent layerAddedEvent = null;
                    if (index < 0 || index >= this.m_layersList.size()) {
                        this.m_layersList.add(layer);
                        layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                    } else {
                        this.m_layersList.add(index, layer);
                        layerAddedEvent = new LayerAddedEvent((Object)this, layer, index);
                    }
                    this.fireLayerAdded(layerAddedEvent);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public boolean remove(Layer layer) {
        return this.removeLayer(layer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeLayer(Layer layer, boolean deletelayer) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            if (layer == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle(layer);
            if (l == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = this.m_layersList.indexOf((Object)layer);
            String string = layer.getName();
            bl = LayerGroupNative.jni_Remove(this.getHandle(), l, deletelayer);
            if (bl) {
                this.m_layersList.remove((Object)layer);
                layer.setParentGroup(null);
                if (layer instanceof LayerGroup) {
                    LayerGroupRemovedEvent layerGroupRemovedEvent = new LayerGroupRemovedEvent((Object)this.m_layers, (LayerGroup)layer, this, n);
                    this.m_layers.fireLayerGroupRemoved(layerGroupRemovedEvent);
                } else if (layer instanceof LayerSnapshot) {
                    LayerGroupRemovedEvent layerGroupRemovedEvent = new LayerGroupRemovedEvent((Object)this.m_layers, (LayerGroup)layer, this, n);
                    this.m_layers.fireLayerGroupRemoved(layerGroupRemovedEvent);
                } else {
                    LayerRemovedEvent layerRemovedEvent = new LayerRemovedEvent((Object)this, layer, string, n);
                    this.fireLayerRemoved(layerRemovedEvent);
                }
                if (deletelayer) {
                    layer.clearHandle();
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public LayerGroup addGroup(String groupName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addGroup(String groupName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (groupName == null) {
            groupName = "";
        }
        return this.internalInsertGroup(-1, groupName);
    }

    public LayerGroup insertGroup(int index, String groupName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertGroup(int index, String groupName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (groupName == null) {
            groupName = "";
        }
        return this.internalInsertGroup(index, groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayerGroup internalInsertGroup(int index, String groupName) {
        LayerGroup layerGroup = null;
        try {
            this.m_lock.lock();
            long l = LayerGroupNative.jni_InsertGroup(this.getHandle(), groupName, index);
            layerGroup = new LayerGroup(l, this, this.m_layers, this.m_map);
            layerGroup.setMap(this.m_map);
            if (index < 0 || index >= this.m_layersList.size()) {
                this.m_layersList.add(layerGroup);
                index = this.m_layersList.size();
            } else {
                this.m_layersList.add(index, layerGroup);
            }
            LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this, layerGroup, this, index);
            this.m_layers.fireLayerGroupAdded(layerGroupAddedEvent);
        }
        finally {
            this.m_lock.unlock();
        }
        return layerGroup;
    }

    public boolean removeGroup(LayerGroup group) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.m_layersList.indexOf((Object)group);
        if (n < 0) {
            return false;
        }
        boolean bl = LayerGroupNative.jni_Remove(this.getHandle(), group.getHandle(), true);
        if (bl) {
            this.m_layersList.remove((Object)group);
            LayerGroupRemovedEvent layerGroupRemovedEvent = new LayerGroupRemovedEvent((Object)this, group, this, n);
            this.m_layers.fireLayerGroupRemoved(layerGroupRemovedEvent);
            group.clearHandle();
        }
        return bl;
    }

    public boolean ungroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parentGroup != null) {
            int n = this.m_parentGroup.indexOf(this);
            int n2 = this.getCount();
            Layer layer = null;
            for (int i = n2 - 1; i >= 0; --i) {
                layer = this.get(i);
                this.m_parentGroup.insert(n, layer);
            }
            this.m_parentGroup.remove(this);
        } else {
            int n = this.m_layers.indexOf(this.getName());
            Layer layer = null;
            for (int i = this.m_layersList.size() - 1; i >= 0; --i) {
                layer = this.m_layersList.get(i);
                this.m_layers.addLayer(n, layer);
            }
            this.m_layers.remove(this);
        }
        return true;
    }

    public synchronized void addLayerAddedListener(LayerAddedListener l) {
        if (this.m_layerAddedListeners == null) {
            this.m_layerAddedListeners = new Vector();
        }
        if (!this.m_layerAddedListeners.contains(l)) {
            this.m_layerAddedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerAddedListener(LayerAddedListener l) {
        if (this.m_layerAddedListeners != null && this.m_layerAddedListeners.contains(l)) {
            this.m_layerAddedListeners.remove(l);
        }
    }

    protected void fireLayerAdded(LayerAddedEvent event) {
        if (this.m_layerAddedListeners != null) {
            Vector<LayerAddedListener> vector = this.m_layerAddedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).layerAdded(event);
            }
        }
    }

    public synchronized void addLayerRemovedListener(LayerRemovedListener l) {
        if (this.m_layerRemovedListeners == null) {
            this.m_layerRemovedListeners = new Vector();
        }
        if (!this.m_layerRemovedListeners.contains(l)) {
            this.m_layerRemovedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerRemovedListener(LayerRemovedListener l) {
        if (this.m_layerRemovedListeners != null && this.m_layerRemovedListeners.contains(l)) {
            this.m_layerRemovedListeners.remove(l);
        }
    }

    protected void fireLayerRemoved(LayerRemovedEvent event) {
        if (this.m_layerRemovedListeners != null) {
            Vector<LayerRemovedListener> vector = this.m_layerRemovedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).layerRemoved(event);
            }
        }
    }

    protected static LayerGroup createInstance(long handle, LayerGroup parentGroup, Layers layers, Map map) {
        return new LayerGroup(handle, parentGroup, layers, map);
    }

    public String getAvailableCaption(String layerCaption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAvailableCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layerCaption == null || layerCaption.trim().isEmpty()) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LayerGroupNative.jni_FindAvailableCaption(this.getHandle(), layerCaption);
    }

    @Override
    public Layer findLayer(String layerName) {
        Layer layer = super.findLayer(layerName);
        if (layer != null) {
            return layer;
        }
        for (int i = 0; i < this.m_layersList.size(); ++i) {
            Layer layer2 = this.m_layersList.get(i);
            layer = layer2.findLayer(layerName);
            if (layer == null) continue;
            return layer;
        }
        return null;
    }

    @Override
    Layer findLayer(long handle) {
        Layer layer = super.findLayer(handle);
        if (layer != null) {
            return layer;
        }
        for (int i = 0; i < this.m_layersList.size(); ++i) {
            Layer layer2 = this.m_layersList.get(i);
            layer = layer2.findLayer(handle);
            if (layer == null) continue;
            return layer;
        }
        return null;
    }
}

