/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Dataset;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.Rectangle2D;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Scene;
import com.supermap.realspace.SceneNative;
import com.supermap.realspace.TerrainLayerCaptionChangedEvent;
import com.supermap.realspace.TerrainLayerNative;
import com.supermap.realspace.TerrainLayerVisibleChangedEvent;
import com.supermap.realspace.TerrainType;

public class TerrainLayer
extends InternalHandle {
    private Scene m_scene;

    TerrainLayer(Scene scene, long handle) {
        this.setHandle(handle);
        this.m_scene = scene;
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_getName(this.getHandle());
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_getCaption(this.getHandle());
    }

    public void setCaption(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCaption(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        String string = this.getCaption();
        if (!value.trim().equals(string)) {
            TerrainLayerNative.jni_setCaption(this.getHandle(), value);
            TerrainLayerCaptionChangedEvent terrainLayerCaptionChangedEvent = new TerrainLayerCaptionChangedEvent((Object)this, this, string, value);
            this.m_scene.getTerrainLayers().fireCaptionChanged(terrainLayerCaptionChangedEvent);
        }
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_getDescription(this.getHandle());
    }

    public void setDescription(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDescription(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        TerrainLayerNative.jni_setDescription(this.getHandle(), value);
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_isVisible(this.getHandle());
    }

    public void setVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = this.isVisible();
        if (value != bl) {
            TerrainLayerNative.jni_setVisible(this.getHandle(), value);
            TerrainLayerVisibleChangedEvent terrainLayerVisibleChangedEvent = new TerrainLayerVisibleChangedEvent((Object)this, this, value);
            this.m_scene.getTerrainLayers().fireVisibleChanged(terrainLayerVisibleChangedEvent);
            if (this.m_scene != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this.m_scene));
            }
        }
    }

    public String getDataName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSCTFile()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_getSCTFile(this.getHandle());
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        TerrainLayerNative.jni_getBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static TerrainLayer createInstance(Scene scene, long handle) {
        return new TerrainLayer(scene, handle);
    }

    void setName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TerrainLayerNative.jni_SetName(this.getHandle(), name);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_GetPassword(this.getHandle());
    }

    public Dataset getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = TerrainLayerNative.jni_GetDatasetName(this.getHandle());
        String string2 = TerrainLayerNative.jni_GetDataSourceName(this.getHandle());
        Datasource datasource = this.m_scene.getWorkspace().getDatasources().get(string2);
        if (datasource == null) {
            return null;
        }
        Dataset dataset = datasource.getDatasets().get(string);
        return dataset;
    }

    public TerrainType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TerrainLayer", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = TerrainLayerNative.jni_GetType(this.getHandle(), InternalHandle.getHandle((InternalHandle)this.m_scene.getTerrainLayers()));
        return (TerrainType)InternalEnum.parse(TerrainType.class, (int)n);
    }

    public int getBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TerrainLayer", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_GetBeginLevel(this.getHandle());
    }

    public int getEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TerrainLayer", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_GetEndLevel(this.getHandle());
    }

    public boolean getIsShowGlobe() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TerrainLayer", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_GetIsShowGlobe(this.getHandle());
    }

    public void setIsShowGlobe(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TerrainLayer", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TerrainLayerNative.jni_SetIsShowGlobe(this.getHandle(), value);
    }

    public double getLODRangeScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TerrainLayer", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_GetLODRangeScale(this.getHandle());
    }

    public void setLODRangeScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TerrainLayer", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TerrainLayerNative.jni_SetLODRangeScale(this.getHandle(), value);
    }

    public double getMaxHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TerrainLayer", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_GetMaxHeight(this.getHandle());
    }

    public double getMinHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TerrainLayer", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TerrainLayerNative.jni_GetMinHeight(this.getHandle());
    }
}

