/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DNative;
import com.supermap.realspace.Layer3DSetting;
import com.supermap.realspace.Layer3DSettingType;
import com.supermap.realspace.Layer3Ds;
import java.awt.Color;

public class Layer3DSettingImage
extends Layer3DSetting {
    private Layer3D m_layer3D;
    private Layer3Ds m_layer3Ds;
    private boolean isOwnerLayer;
    private boolean m_transparent;
    private Color m_transparentColor;
    private int m_transparentColorTolerance;

    public Layer3DSettingImage() {
        this.isOwnerLayer = false;
        this.setTransparent(false);
        this.setTransparentColor(new Color(255, 255, 255));
        this.setTransparentColorTolerance(24);
    }

    public Layer3DSettingImage(Layer3DSettingImage settingImage) {
        if (settingImage == null) {
            String string = InternalResource.loadString("settingImage", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (settingImage.isOwnerLayer) {
            if (settingImage.m_layer3D == null) {
                String string = InternalResource.loadString("settingImage", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle(settingImage.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("settingImage", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            int n = settingImage.m_layer3Ds.getLayersList().indexOf((Object)settingImage.m_layer3D);
            if (n == -1) {
                String string = InternalResource.loadString("settingImage", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        this.isOwnerLayer = false;
        this.setTransparent(settingImage.isTransparent());
        this.setTransparentColor(settingImage.getTransparentColor());
        this.setTransparentColorTolerance(settingImage.getTransparentColorTolerance());
    }

    Layer3DSettingImage(Layer3D layer3D, Layer3Ds layer3Ds) {
        this.m_layer3D = layer3D;
        this.m_layer3Ds = layer3Ds;
        this.isOwnerLayer = true;
        this.m_transparent = false;
        this.m_transparentColor = new Color(255, 255, 255);
        this.m_transparentColorTolerance = 24;
    }

    public int getOpaqueRate() {
        long l = InternalHandle.getHandle(this.m_layer3D);
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getOpaqueRate()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            if (l == 0L) {
                String string = InternalResource.loadString("getOpaqueRate()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return Layer3DNative.jni_GetOpaqueRate(l);
    }

    public void setOpaqueRate(int value) {
        long l = InternalHandle.getHandle(this.m_layer3D);
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setOpaqueRate()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            if (l == 0L) {
                String string = InternalResource.loadString("setOpaqueRate()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        Layer3DNative.jni_SetOpaqueRate(l, value);
    }

    public boolean isTransparent() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("isTransparent()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("isTransparent()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_transparent = Layer3DNative.jni_IsTransparent(l);
        }
        return this.m_transparent;
    }

    public void setTransparent(boolean transparent) {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setTransparent(boolean transparent)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean transparent)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Layer3DNative.jni_SetTransparent(l, transparent);
        }
        this.m_transparent = transparent;
    }

    public Color getTransparentColor() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getTransparentColor()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getTransparentColor()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_transparentColor = new Color(Layer3DNative.jni_GetTransparentColor(l));
        }
        return this.m_transparentColor;
    }

    public void setTransparentColor(Color color) {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setTransparent(boolean transparent)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean transparent)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Layer3DNative.jni_SetTransparentColor(l, color.getRGB());
        }
        this.m_transparentColor = color;
    }

    public int getTransparentColorTolerance() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getTransparentColorTolerance()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getTransparentColorTolerance()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_transparentColorTolerance = Layer3DNative.jni_GetTransparentColorTolerance(l);
        }
        return this.m_transparentColorTolerance;
    }

    public void setTransparentColorTolerance(int colorTolerance) {
        if (colorTolerance < 0 || colorTolerance > 255) {
            String string = InternalResource.loadString("setTransparentColorTolerance(int colorTolerance)", "TransparentColorTolerance_ShouldBetween0And255", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setTransparentColorTolerance(int colorTolerance)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparentColorTolerance(int colorTolerance)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Layer3DNative.jni_SetTransparentColorTolerance(l, colorTolerance);
        }
        this.m_transparentColorTolerance = colorTolerance;
    }

    @Override
    void clearHandle() {
        this.m_layer3D = null;
        this.m_layer3Ds = null;
    }

    @Override
    public Layer3DSettingType getType() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return Layer3DSettingType.IMAGE;
    }

    @Override
    void reset(Layer3DSetting value) {
        this.setTransparent(((Layer3DSettingImage)value).isTransparent());
        this.setTransparentColor(((Layer3DSettingImage)value).getTransparentColor());
        this.setTransparentColorTolerance(((Layer3DSettingImage)value).getTransparentColorTolerance());
    }
}

