/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.SupplyCenter;
import java.util.ArrayList;

public class SupplyCenters {
    private ArrayList<SupplyCenter> m_supplyCenters = new ArrayList();

    public SupplyCenters() {
    }

    public SupplyCenters(SupplyCenters supplyCenters) {
        int n = supplyCenters.getCount();
        for (int i = 0; i < n; ++i) {
            this.m_supplyCenters.add(supplyCenters.get(i));
        }
    }

    public int getCount() {
        return this.m_supplyCenters.size();
    }

    public SupplyCenter get(int index) {
        return this.m_supplyCenters.get(index);
    }

    public void set(int index, SupplyCenter supplyCenter) {
        if (supplyCenter == null) {
            String string = InternalResource.loadString("supplyCenter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_supplyCenters.set(index, new SupplyCenter(supplyCenter));
    }

    public int add(SupplyCenter supplyCenter) {
        if (supplyCenter == null) {
            String string = InternalResource.loadString("supplyCenter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SupplyCenter supplyCenter2 = new SupplyCenter(supplyCenter);
        this.m_supplyCenters.add(supplyCenter2);
        return this.m_supplyCenters.size() - 1;
    }

    public int addRange(SupplyCenter[] supplyCenters) {
        int n;
        if (supplyCenters == null) {
            String string = InternalResource.loadString("supplyCenter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < supplyCenters.length; ++n) {
            if (supplyCenters[n] == null) continue;
            String string = InternalResource.loadString("supplyCenters[" + n + "]", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < supplyCenters.length; ++n) {
            this.add(supplyCenters[n]);
        }
        return supplyCenters.length;
    }

    public boolean remove(int index) {
        this.m_supplyCenters.remove(index);
        return true;
    }

    public int removeRange(int index, int count) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "SupplyCenters_IndexOutOfBounds", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (count <= 0 || count > this.getCount() - index) {
            String string = InternalResource.loadString("count", "SupplyCenters_IndexOutOfBounds", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        for (int i = index + count - 1; i > 0; --i) {
            this.m_supplyCenters.remove(i);
        }
        return count;
    }

    public void clear() {
        this.m_supplyCenters.clear();
    }

    public SupplyCenter[] toArray() {
        SupplyCenter[] supplyCenterArray = new SupplyCenter[this.getCount()];
        for (int i = 0; i < supplyCenterArray.length; ++i) {
            supplyCenterArray[i] = this.m_supplyCenters.get(i);
        }
        return supplyCenterArray;
    }
}

