/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.RouteType;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;

public class SSCPathAnalystParameter {
    protected RouteType m_routeType = RouteType.RECOMMEND;
    protected Point2D m_pntStart;
    protected Point2D m_pntEnd;
    protected Point2Ds m_arrPoints = null;
    protected boolean m_bAlternative = false;
    protected double m_dRatio1 = 0.15;
    protected double m_dRatio2 = 0.8;
    protected double m_dRatio3 = 0.4;
    protected boolean m_bSetStartPoint;
    protected boolean m_bSetEndPoint;

    public SSCPathAnalystParameter setStartPoint(Point2D pnt) {
        if (pnt == null) {
            String string = InternalResource.loadString("StartPoint", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_pntStart = pnt;
        this.m_bSetStartPoint = true;
        return this;
    }

    public Point2D getStartPoint() {
        return this.m_pntStart;
    }

    public SSCPathAnalystParameter setEndPoint(Point2D pnt) {
        if (pnt == null) {
            String string = InternalResource.loadString("EndPoint", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_pntEnd = pnt;
        this.m_bSetEndPoint = true;
        return this;
    }

    public Point2D getEndPoint() {
        return this.m_pntEnd;
    }

    public SSCPathAnalystParameter setMidpoints(Point2Ds pnts) {
        if (pnts == null) {
            this.m_arrPoints = null;
        } else {
            if (this.m_arrPoints != null) {
                this.m_arrPoints.clear();
            }
            this.m_arrPoints = pnts.clone();
        }
        return this;
    }

    public Point2Ds getMidpoints() {
        if (this.m_arrPoints != null) {
            return this.m_arrPoints.clone();
        }
        return null;
    }

    public SSCPathAnalystParameter setRouteType(RouteType mode) {
        this.m_routeType = mode;
        return this;
    }

    public RouteType getRouteType() {
        return this.m_routeType;
    }

    boolean isSetStartPoint() {
        return this.m_bSetStartPoint;
    }

    boolean isSetEndPoint() {
        return this.m_bSetEndPoint;
    }

    public boolean isAlternative() {
        return this.m_bAlternative;
    }

    public SSCPathAnalystParameter setAlternative(boolean value) {
        this.m_bAlternative = value;
        return this;
    }

    void setRatio1(double value) {
        this.m_dRatio1 = value;
    }

    double getRatio1() {
        return this.m_dRatio1;
    }

    void setRatio2(double value) {
        this.m_dRatio2 = value;
    }

    double getRatio2() {
        return this.m_dRatio2;
    }

    void setRatio3(double value) {
        this.m_dRatio3 = value;
    }

    double getRatio3() {
        return this.m_dRatio3;
    }
}

