/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.networkanalyst.DataCompilerNative;
import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.InternalToolkitNetworkAnalyst;
import com.supermap.analyst.networkanalyst.SSCCompilerParameter;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfos;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class DataCompiler {
    private static License m_license;
    transient Vector m_steppedListeners;
    protected long m_selfEventHandle;

    public boolean compileSSCData(SSCCompilerParameter parameter) {
        String[] stringArray;
        DatasetVector datasetVector = parameter.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("setting.getNetworkDataset()", "Global_OwnerHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.NETWORK) {
            String string = InternalResource.loadString("setting.getNetworkDataset().getType()", "DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        String string = parameter.getFilePath();
        if (string.trim().equals("")) {
            String string2 = InternalResource.loadString("setting.getFilePath()", "FilePathNotExist", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        String[] stringArray2 = new String[]{parameter.getNodeIDField(), parameter.getEdgeIDField(), parameter.getFNodeIDField(), parameter.getTNodeIDField(), parameter.getTurnNodeIDField(), parameter.getTurnFEdgeIDField(), parameter.getTurnTEdgeIDField(), parameter.getEdgeNameField(), parameter.getRuleField()};
        DatasetVector datasetVector2 = parameter.getTurnDataset();
        if (datasetVector2 != null && !datasetVector2.isOpen()) {
            datasetVector2.open();
        }
        String[] stringArray3 = parameter.getFTSingleWayRuleValues();
        String[] stringArray4 = parameter.getTFSingleWayRuleValues();
        String[] stringArray5 = parameter.getProhibitedWayRuleValues();
        String[] stringArray6 = parameter.getTwoWayRuleValues();
        String string3 = parameter.getWeightField();
        String[] stringArray7 = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3], string3, stringArray2[7]};
        if (!DataCompiler.isNetworkFieldsAllRight(stringArray7, datasetVector)) {
            String string4 = InternalResource.loadString("fields", "FieldNotInDatasetVector", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        String[] stringArray8 = new String[]{stringArray2[0], parameter.getLevelField()};
        if (!DataCompiler.isNetworkFieldsAllRight(stringArray8, datasetVector)) {
            String string5 = InternalResource.loadString("LevelField", "FieldNotInDatasetVector", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!parameter.getSpeedField().trim().equals("") && !DataCompiler.isNetworkFieldsAllRight(stringArray = new String[]{stringArray2[0], parameter.getSpeedField()}, datasetVector)) {
            String string6 = InternalResource.loadString("SpeedField", "FieldNotInDatasetVector", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l2 = 0L;
        if (datasetVector2 != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2);
            DatasetType datasetType2 = datasetVector2.getType();
            if (datasetType2 != DatasetType.TABULAR) {
                String string7 = InternalResource.loadString("m_analystSetting.getTurnDataset().getType()", "DatasetTypeMustBeTabular", "networkanalyst_resources");
                throw new IllegalStateException(string7);
            }
            if (stringArray2[4] == null || stringArray2[4].trim().length() == 0) {
                String string8 = InternalResource.loadString("m_analystSetting.getTurnNodeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string8);
            }
            if (stringArray2[5] == null || stringArray2[5].trim().length() == 0) {
                String string9 = InternalResource.loadString("m_analystSetting.getTurnFEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string9);
            }
            if (stringArray2[6] == null || stringArray2[6].trim().length() == 0) {
                String string10 = InternalResource.loadString("m_analystSetting.getTurnTEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string10);
            }
            String[] stringArray9 = new String[]{stringArray2[4], stringArray2[5], stringArray2[6]};
            if (!DataCompiler.isTurnFieldsAllRight(stringArray9, datasetVector2)) {
                String string11 = InternalResource.loadString("fields", "FieldNotInDatasetVector", "networkanalyst_resources");
                throw new IllegalArgumentException(string11);
            }
        }
        this.m_selfEventHandle = DataCompilerNative.jni_NewSelfEventHandle(this);
        boolean bl = DataCompilerNative.jni_CompileSSCData(l, l2, stringArray2, string3, stringArray3, stringArray4, stringArray5, stringArray6, string, parameter.getLevelField(), parameter.getSpeedField(), this.m_selfEventHandle);
        return bl;
    }

    private static boolean isNetworkFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        int n;
        boolean bl = true;
        if (!networkDataset.open()) {
            networkDataset.open();
        }
        FieldInfos fieldInfos = networkDataset.getChildDataset().getFieldInfos();
        boolean bl2 = false;
        for (n = 0; n < fieldInfos.getCount(); ++n) {
            if (fieldInfos.get(n).getName().compareToIgnoreCase(fields[0]) != 0) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return bl2;
        }
        bl2 = false;
        fieldInfos = networkDataset.getFieldInfos();
        n = fields.length;
        for (int i = 1; i < n; ++i) {
            bl2 = false;
            for (int j = 0; j < fieldInfos.getCount(); ++j) {
                if (fieldInfos.get(j).getName().compareToIgnoreCase(fields[i]) != 0) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return bl2;
        }
        return bl;
    }

    private static boolean isTurnFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        boolean bl = false;
        FieldInfos fieldInfos = networkDataset.getFieldInfos();
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < fieldInfos.getCount(); ++j) {
                if (fieldInfos.get(j).getName().compareToIgnoreCase(fields[i]) != 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return bl;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(DataCompiler source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            boolean bl = InternalToolkitNetworkAnalyst.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, null, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitNetworkAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)source);
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DataCompilerNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitNetworkAnalyst.managerProducts(InternalToolkitNetworkAnalyst.getNetworkAnalystProducts());
        m_license = InternalToolkitNetworkAnalyst.verifyLicense(arrayList);
    }
}

