/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalHandle;
import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.StopSettingNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasets;
import com.supermap.data.Datasource;
import com.supermap.data.FieldType;

public class StopSetting {
    private DatasetVector m_dataset;
    private String m_nameField;
    private String m_aliasField;
    private String m_stopIDField;

    public StopSetting() {
        this.m_dataset = null;
        this.m_nameField = "";
        this.m_aliasField = "";
        this.m_stopIDField = "";
    }

    public StopSetting(StopSetting stopSetting) {
        this.setDataset(stopSetting.getDataset());
        this.setNameField(stopSetting.getNameField());
        if (stopSetting.getAliasField() != null && stopSetting.getAliasField().trim().length() != 0) {
            this.setAliasField(stopSetting.getAliasField());
        }
        this.setStopIDField(stopSetting.getStopIDField());
    }

    public DatasetVector getDataset() {
        return this.m_dataset;
    }

    public void setDataset(DatasetVector datasetVector) {
        this.m_dataset = datasetVector;
    }

    public String getNameField() {
        return this.m_nameField;
    }

    public void setNameField(String value) {
        this.m_nameField = value;
    }

    public String getAliasField() {
        return this.m_aliasField;
    }

    public void setAliasField(String value) {
        this.m_aliasField = value;
    }

    public String getStopIDField() {
        return this.m_stopIDField;
    }

    public void setStopIDField(String value) {
        this.m_stopIDField = value;
    }

    void setToUGC(long handle) {
        this.check();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_dataset);
        StopSettingNative.jni_SetAllToUGC(handle, l, this.m_stopIDField, this.m_nameField, this.m_aliasField);
    }

    void getFromUGC(Datasource ds, long handle) {
        String string = StopSettingNative.jni_GetAllFromUGC(handle);
        int n = -1;
        int n2 = string.indexOf(",", 0);
        this.m_stopIDField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_nameField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        this.m_aliasField = string.substring(n + 1);
        long l = StopSettingNative.jni_GetDataset(handle);
        Datasets datasets = ds.getDatasets();
        for (int i = 0; i < datasets.getCount(); ++i) {
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasets.get(i));
            if (l2 != l) continue;
            this.m_dataset = (DatasetVector)datasets.get(i);
            break;
        }
    }

    void check() {
        if (this.m_dataset == null) {
            String string = InternalResource.loadString("m_dataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("datasetVector", "NetworkBuilder_DatasetTypeMustBePoint", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_stopIDField == null || this.m_stopIDField.trim().length() == 0) {
            String string = InternalResource.loadString("m_stopIDField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getFieldInfos().indexOf(this.m_stopIDField) == -1) {
            String string = InternalResource.loadString("m_stopIDField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getFieldInfos().get(this.m_stopIDField).getType() != FieldType.INT32 && this.m_dataset.getFieldInfos().get(this.m_stopIDField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_stopIDField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_nameField == null || this.m_nameField.trim().length() == 0) {
            String string = InternalResource.loadString("m_nameField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getFieldInfos().indexOf(this.m_nameField) == -1) {
            String string = InternalResource.loadString("m_nameField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_aliasField != null && this.m_aliasField.length() != 0 && this.m_dataset.getFieldInfos().indexOf(this.m_aliasField) == -1) {
            String string = InternalResource.loadString("m_aliasField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }
}

