/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.BandWidthType;
import com.supermap.analyst.spatialstatistics.GWRParameterNative;
import com.supermap.analyst.spatialstatistics.InternalEnum;
import com.supermap.analyst.spatialstatistics.InternalHandle;
import com.supermap.analyst.spatialstatistics.InternalHandleDisposable;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.KernelFunction;
import com.supermap.analyst.spatialstatistics.KernelType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import java.util.ArrayList;
import java.util.Map;

public class GWRParameter
extends InternalHandleDisposable {
    private String m_strModelField;
    private ArrayList m_arrExplanatory;
    private KernelType m_kernelType = KernelType.FIXED;
    private BandWidthType m_bandWidthType = BandWidthType.AICC;
    private KernelFunction m_kernelFunction = KernelFunction.GAUSSIAN;
    private double m_dDistTolerance = 0.0;
    private int m_nNeighbors = 2;
    private DatasetVector m_PredictDataset;
    private Datasource m_targetPredictDatasource;
    private String m_targetPredictDatasetName;
    private Map<String, String> m_ExplanatoryFieldsMatching;

    public GWRParameter() {
        long l = GWRParameterNative.jni_New();
        this.setHandle(l, true);
        this.Reset();
    }

    void Reset() {
        long l = super.getHandle();
        if (l != 0L) {
            GWRParameterNative.jni_Reset(l);
        }
    }

    public GWRParameter(GWRParameter gwrParameter) {
        if (gwrParameter == null) {
            String string = InternalResource.loadString("gwrParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        long l = GWRParameterNative.jni_New();
        this.setHandle(l, true);
        this.Reset();
        this.m_strModelField = gwrParameter.m_strModelField;
        this.m_arrExplanatory = gwrParameter.m_arrExplanatory;
        this.m_kernelType = gwrParameter.m_kernelType;
        this.m_bandWidthType = gwrParameter.m_bandWidthType;
        this.m_kernelFunction = gwrParameter.m_kernelFunction;
        this.m_dDistTolerance = gwrParameter.m_dDistTolerance;
        this.m_nNeighbors = gwrParameter.m_nNeighbors;
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            int n;
            GWRParameterNative.jni_setModelField(l, this.m_strModelField);
            if (this.m_arrExplanatory != null) {
                n = this.m_arrExplanatory.size();
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = this.m_arrExplanatory.get(i).toString();
                }
                GWRParameterNative.jni_setExplanatoryFields(l, stringArray);
            } else {
                GWRParameterNative.jni_setExplanatoryFields(l, new String[0]);
            }
            n = InternalEnum.getUGCValue(this.m_kernelType);
            GWRParameterNative.jni_setKernelType(l, n);
            n = InternalEnum.getUGCValue(this.m_bandWidthType);
            GWRParameterNative.jni_setBandWidthType(l, n);
            n = InternalEnum.getUGCValue(this.m_kernelFunction);
            GWRParameterNative.jni_setKernelFunction(l, n);
            GWRParameterNative.jni_setDistanceTolerance(l, this.m_dDistTolerance);
            GWRParameterNative.jni_setNeighbors(l, this.m_nNeighbors);
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            GWRParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    @Deprecated
    public String getModelFeild() {
        return this.m_strModelField;
    }

    @Deprecated
    public void setModelFeild(String value) {
        if (value == null || value.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("ModelFeild", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_strModelField = value;
    }

    @Deprecated
    public String[] getExplanatoryFeilds() {
        if (this.m_arrExplanatory == null) {
            return null;
        }
        int n = this.m_arrExplanatory.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_arrExplanatory.get(i).toString();
        }
        return stringArray;
    }

    @Deprecated
    public void setExplanatoryFeilds(String[] value) {
        int n;
        if (value == null) {
            String string = InternalResource.loadString("ExplanatoryFeilds", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = value.length;
        for (n = 0; n < n2; ++n) {
            if (value[n] != null && !value[n].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_arrExplanatory != null) {
            this.m_arrExplanatory.clear();
        } else {
            this.m_arrExplanatory = new ArrayList();
        }
        for (n = 0; n < n2; ++n) {
            this.m_arrExplanatory.add(value[n]);
        }
    }

    public String getModelField() {
        return this.m_strModelField;
    }

    public void setModelField(String value) {
        if (value == null || value.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("ModelField", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_strModelField = value;
    }

    public String[] getExplanatoryFields() {
        if (this.m_arrExplanatory == null) {
            return null;
        }
        int n = this.m_arrExplanatory.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_arrExplanatory.get(i).toString();
        }
        return stringArray;
    }

    public void setExplanatoryFields(String[] value) {
        int n;
        if (value == null) {
            String string = InternalResource.loadString("ExplanatoryFields", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = value.length;
        for (n = 0; n < n2; ++n) {
            if (value[n] != null && !value[n].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_arrExplanatory != null) {
            this.m_arrExplanatory.clear();
        } else {
            this.m_arrExplanatory = new ArrayList();
        }
        for (n = 0; n < n2; ++n) {
            this.m_arrExplanatory.add(value[n]);
        }
    }

    public KernelType getKernelType() {
        return this.m_kernelType;
    }

    public void setKernelType(KernelType value) {
        this.m_kernelType = value;
    }

    public BandWidthType getBandWidthType() {
        return this.m_bandWidthType;
    }

    public void setBandWidthType(BandWidthType value) {
        this.m_bandWidthType = value;
    }

    public KernelFunction getKernelFunction() {
        return this.m_kernelFunction;
    }

    public void setKernelFunction(KernelFunction value) {
        this.m_kernelFunction = value;
    }

    public double getDistanceTolerance() {
        return this.m_dDistTolerance;
    }

    public void setDistanceTolerance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("DistanceTolerance", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dDistTolerance = value;
    }

    public int getNeighbors() {
        return this.m_nNeighbors;
    }

    public void setNeighbors(int value) {
        if (value <= 1) {
            String string = InternalResource.loadString("Neighbors", "Must_Larger_Than_One", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nNeighbors = value;
    }

    public DatasetVector getPredictionDataset() {
        return this.m_PredictDataset;
    }

    public void setPredictionDataset(DatasetVector value) {
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("PredictionDataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_PredictDataset = value;
    }

    public Datasource getTargetPredictedDatasource() {
        return this.m_targetPredictDatasource;
    }

    public void setTargetPredictedDatasource(Datasource value) {
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("TargetPredictedDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_targetPredictDatasource = value;
    }

    public String getTargetPredictedDatasetName() {
        return this.m_targetPredictDatasetName;
    }

    public void setTargetPredictedDatasetName(String value) {
        if (value == null || value.isEmpty()) {
            String string = InternalResource.loadString("TargetPredictedDatasetName", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_targetPredictDatasetName = value;
    }

    public Map<String, String> getExplanatoryFieldsMatching() {
        return this.m_ExplanatoryFieldsMatching;
    }

    public void setExplanatoryFieldsMatching(Map<String, String> value) {
        if (value == null || value.size() == 0) {
            String string = InternalResource.loadString("ExplanatoryFieldsMatching", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        for (String string : value.keySet()) {
            if (string != null && !string.isEmpty() && value.get(string) != null && !value.get(string).isEmpty()) continue;
            String string2 = InternalResource.loadString("ExplanatoryFieldsMatching key or value", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string2);
        }
        this.m_ExplanatoryFieldsMatching = value;
    }
}

