/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.BoundingBox;
import com.supermap.data.Colors;
import com.supermap.data.Point3D;
import com.supermap.realspace.InternalColors;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DDataset;
import com.supermap.realspace.Layer3DNative;
import com.supermap.realspace.Layer3DSetting;
import com.supermap.realspace.Layer3DSettingType;
import com.supermap.realspace.VolumeRenderMode;

public class Layer3DSettingVolume
extends Layer3DSetting {
    private int m_nOpaqueRate;
    private Colors m_colors;
    private double[] m_gridValueTable;
    private String m_layerName;
    private VolumeRenderMode m_renderMode;
    private Point3D m_sliceCoordinate;
    private boolean m_isBoxWireframeVisible;
    private double m_ScaleX;
    private double m_ScaleY;
    private double m_ScaleZ;
    private double m_MaxFiltration;
    private double m_MinFiltration;
    private double m_TexSampleDist;
    private BoundingBox m_VisibleBoundingBox;

    protected Layer3DSettingVolume(Layer3D layer3D) {
        this.m_Layer3D = layer3D;
        long l = InternalHandle.getHandle(layer3D);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)((Layer3DDataset)layer3D).getDataset());
        long l3 = Layer3DNative.jni_GetColorsetTable(l, l2);
        this.m_colors = InternalColors.createInstance(l3, false);
        this.m_gridValueTable = Layer3DNative.jni_GetgridValueTable(l);
    }

    public Layer3DSettingVolume() {
        this.m_nOpaqueRate = 100;
        Colors colors = new Colors();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colors = InternalColors.createInstance(l, false);
        this.m_layerName = null;
        this.m_renderMode = VolumeRenderMode.VOLUMERENDERING;
        this.m_sliceCoordinate = new Point3D(0.0, 0.0, 0.0);
        this.m_isBoxWireframeVisible = true;
        this.m_ScaleX = 1.0;
        this.m_ScaleY = 1.0;
        this.m_ScaleZ = 1.0;
    }

    public Layer3DSettingVolume(Layer3DSettingVolume layer3DSettingVolume) {
        Colors colors = new Colors();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colors = InternalColors.createInstance(l, false);
    }

    @Override
    public Layer3DSettingType getType() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DSettingType.VOLUME;
    }

    public int getOpaqueRate() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            return Layer3DNative.jni_GetOpaqueRate(l);
        }
        return this.m_nOpaqueRate;
    }

    public void setOpaqueRate(int value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetOpaqueRate(l, value);
        } else {
            this.m_nOpaqueRate = value;
        }
    }

    public Colors getColorTable() {
        if (this.m_colors == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_colors) == 0L) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_colors;
    }

    public void setColorTable(Colors value) {
        if (this.m_colors == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_colors) == 0L) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        if (l == 0L) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l2 = 0L;
        Colors colors = new Colors(value);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        if (this.m_Layer3D != null) {
            l2 = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetColorTable(l2, l3);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
            InternalColors.changeHandle(this.m_colors, l3);
        }
    }

    public double[] getGridValueTable() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_gridValueTable;
    }

    public void setGridValueTable(double[] value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            double[] dArray = (double[])value.clone();
            Layer3DNative.jni_SetGridValueTable(l, dArray);
        }
        this.m_gridValueTable = value;
    }

    public String getClampLayer() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_layerName;
    }

    public void setClampLayer(String value) {
        long l;
        long l2;
        String string;
        if (this.isDisposed()) {
            String string2 = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        this.m_layerName = value;
        if (this.m_Layer3D != null && (string = Layer3DNative.jni_SetClampLayer(l2 = InternalHandle.getHandle(this.m_Layer3D), l = InternalHandle.getHandle(this.m_Layer3D.m_layer3Ds), value)) == null) {
            this.m_layerName = null;
        }
    }

    public boolean isBoxWireframeVisible() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            this.m_isBoxWireframeVisible = Layer3DNative.jni_IsBoxWireframeVisible(l);
        }
        return this.m_isBoxWireframeVisible;
    }

    public void setBoxWireframeVisible(boolean value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_isBoxWireframeVisible = value;
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetBoxWireframeVisible(l, value);
        }
    }

    public VolumeRenderMode getRenderMode() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_renderMode;
    }

    public void setRenderMode(VolumeRenderMode value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value != this.m_renderMode) {
            this.m_renderMode = value;
            if (this.m_Layer3D != null) {
                long l = InternalHandle.getHandle(this.m_Layer3D);
                long l2 = InternalHandle.getHandle(this.m_Layer3D.m_layer3Ds);
                Layer3DNative.jni_SetRenderMode(l, l2, value.value(), this.m_layerName);
            }
        }
    }

    public double getMaxFiltration() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            this.m_MaxFiltration = Layer3DNative.jni_GetMaxFiltration(l);
        }
        return this.m_MaxFiltration;
    }

    public void setMaxFiltration(double value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_MaxFiltration = value;
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetMaxFiltration(l, this.m_MaxFiltration);
        }
    }

    public double getMinFiltration() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            this.m_MinFiltration = Layer3DNative.jni_GetMinFiltration(l);
        }
        return this.m_MinFiltration;
    }

    public void setMinFiltration(double value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_MinFiltration = value;
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetMinFiltration(l, this.m_MinFiltration);
        }
    }

    public double getScaleX() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            this.m_ScaleX = Layer3DNative.jni_GetScaleX(l);
        }
        return this.m_ScaleX;
    }

    public void setScaleX(double value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_ScaleX = value;
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetScaleX(l, value);
        }
    }

    public double getScaleY() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            this.m_ScaleY = Layer3DNative.jni_GetScaleY(l);
        }
        return this.m_ScaleY;
    }

    public void setScaleY(double value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_ScaleY = value;
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetScaleY(l, value);
        }
    }

    public double getScaleZ() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            this.m_ScaleZ = Layer3DNative.jni_GetScaleZ(l);
        }
        return this.m_ScaleZ;
    }

    public void setScaleZ(double value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_ScaleZ = value;
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetScaleZ(l, value);
        }
    }

    public Point3D getSliceCoordinate() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_sliceCoordinate;
    }

    public void setSliceCoordinate(Point3D value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_sliceCoordinate = value;
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetSliceCoordinate(l, value.getX(), value.getY(), value.getZ());
        }
    }

    public double getTexSampleDist() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            this.m_TexSampleDist = Layer3DNative.jni_GetTexSampleDist(l);
        }
        return this.m_TexSampleDist;
    }

    public void setTexSampleDist(double value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_TexSampleDist = value;
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetTexSampleDist(l, this.m_TexSampleDist);
        }
    }

    public BoundingBox getVisibleBoundingBox() {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            double[] dArray = new double[6];
            Layer3DNative.jni_GetVisibleBoundingBox(l, dArray);
            Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
            Point3D point3D2 = new Point3D(dArray[3], dArray[4], dArray[5]);
            this.m_VisibleBoundingBox = new BoundingBox(point3D, point3D2);
        }
        return this.m_VisibleBoundingBox;
    }

    public void setVisibleBoundingBox(BoundingBox value) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_VisibleBoundingBox = value;
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_VisibleBoundingBox);
            long l2 = InternalHandle.getHandle(this.m_Layer3D);
            Layer3DNative.jni_SetVisibleBoundingBox(l2, l);
        }
    }

    public double getValue(double longitude, double latitude, double altitude) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DSettingVolume", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Layer3D != null) {
            long l = InternalHandle.getHandle(this.m_Layer3D);
            return Layer3DNative.jni_GetValue(l, longitude, latitude, altitude);
        }
        return 0.0;
    }

    public void dispose() {
        if (this.isDisposed()) {
            long l = InternalHandle.getHandle(this.m_Layer3D.m_layer3Ds);
            Layer3DNative.jni_RemoveVolume(l, this.m_layerName);
        }
    }

    @Override
    void reset(Layer3DSetting layser3DSetting) {
        Layer3DSettingVolume layer3DSettingVolume = (Layer3DSettingVolume)layser3DSetting;
        this.setColorTable(layer3DSettingVolume.getColorTable());
        this.setGridValueTable(layer3DSettingVolume.getGridValueTable());
        this.setOpaqueRate(layer3DSettingVolume.getOpaqueRate());
        this.setBoxWireframeVisible(layer3DSettingVolume.isBoxWireframeVisible());
        this.setRenderMode(layer3DSettingVolume.getRenderMode());
        this.setSliceCoordinate(layer3DSettingVolume.getSliceCoordinate());
        this.setClampLayer(layer3DSettingVolume.getClampLayer());
        this.setScaleX(layer3DSettingVolume.getScaleX());
        this.setScaleY(layer3DSettingVolume.getScaleY());
        this.setScaleZ(layer3DSettingVolume.getScaleZ());
    }

    @Override
    void clearHandle() {
        this.m_Layer3D = null;
    }
}

