/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Workspace;
import com.supermap.mapping.Map;
import com.supermap.realspace.InternalMap;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DMapNative;
import com.supermap.realspace.Layer3DNative;
import com.supermap.realspace.Layer3Ds;
import java.awt.Color;

public class Layer3DMap
extends Layer3D {
    private Map m_map;

    Layer3DMap(long handle, Layer3Ds layer3Ds) {
        super(handle, layer3Ds);
    }

    public Map getMap() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMap()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map == null && (l = Layer3DMapNative.jni_GetMap(this.getHandle())) != 0L) {
            this.m_map = InternalMap.createInstance(l, ((Object)((Object)this)).getClass().getSimpleName());
            Workspace workspace = this.getLayer3Ds().getScene().getWorkspace();
            if (workspace != null) {
                this.m_map.setWorkspace(workspace);
            }
        }
        return this.m_map;
    }

    public String getCacheDirectory() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheDirectory()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DMapNative.jni_GetCacheDirectory(this.getHandle());
    }

    public void setCacheDirectory(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheDirectory(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DMapNative.jni_SetCacheDirectory(this.getHandle(), value);
    }

    public long getCacheCapacity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheCapacity()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DMapNative.jni_GetCacheCapacity(this.getHandle());
    }

    public void setCacheCapacity(long value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheCapacity()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DMapNative.jni_SetCacheCapacity(this.getHandle(), value);
    }

    public boolean isCacheAutoCleared() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAutoClearCache()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DMapNative.jni_GetAutoClearCache(this.getHandle());
    }

    public void setCacheAutoCleared(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAutoClearCache(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DMapNative.jni_SetAutoClearCache(this.getHandle(), value);
    }

    public boolean isCacheEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCacheEnabled()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DMapNative.jni_IsUseCache(this.getHandle());
    }

    public void setCacheEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DMapNative.jni_SetUseCache(this.getHandle(), value);
    }

    public boolean isTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTransparent()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DMapNative.jni_IsTransparent(this.getHandle());
    }

    public void setTransparent(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DMapNative.jni_SetTransparent(this.getHandle(), value);
    }

    public Color getTransparentColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTransparentColor()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(Layer3DMapNative.jni_GetTransparentColor(this.getHandle()));
        return color;
    }

    public void setTransparentColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransparentColor(Color value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DMapNative.jni_SetTransparentColor(this.getHandle(), value.getRGB());
    }

    public int getTransparentColorTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTransparentColorTolerance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DMapNative.jni_GetTransparentColorTolerance(this.getHandle());
    }

    public void setTransparentColorTolerance(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransparentColorTolerance(int value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0 || value > 255) {
            String string = InternalResource.loadString("setTransparentColorTolerance(int value)", "TransparentColorTolerance_ShouldBetween0And255", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DMapNative.jni_SetTransparentColorTolerance(this.getHandle(), value);
    }

    public boolean isRenderingWithMultiResolution() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRenderingWithMultiResolution()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getLayer3Ds().getLayersList().indexOf((Object)this);
        if (n == -1) {
            String string = InternalResource.loadString("isRenderingWithMultiResolution()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_IsRenderingWithMultiResolution(this.getHandle());
    }

    public void setRenderingWithMultiResolution(boolean renderingWithMultiResolution) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRenderingWithMultiResolution(boolean renderingWithMultiResolution)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getLayer3Ds().getLayersList().indexOf((Object)this);
        if (n == -1) {
            String string = InternalResource.loadString("setRenderingWithMultiResolution(boolean renderingWithMultiResolution)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetRenderingWithMultiResolution(this.getHandle(), renderingWithMultiResolution);
    }

    public boolean isBackgroundTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTransparent()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DMapNative.jni_IsBackTransparent(this.getHandle());
    }

    public void setBackgroundTransparent(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DMapNative.jni_SetBackTransparent(this.getHandle(), value);
    }

    @Override
    protected void clearHandle() {
        if (this.m_map != null) {
            InternalMap.clearHandle(this.m_map);
            this.m_map = null;
        }
        super.clearHandle();
    }
}

