/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Enum;
import com.supermap.realspace.FlyEventType;
import com.supermap.realspace.FlyManagerNative;
import com.supermap.realspace.FlyStatus;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.PropertiesChangedEvent;
import com.supermap.realspace.PropertiesChangedListener;
import com.supermap.realspace.Routes;
import com.supermap.realspace.Scene;
import com.supermap.realspace.StatusChangedEvent;
import com.supermap.realspace.StatusChangedListener;
import com.supermap.realspace.StopArrivedEvent;
import com.supermap.realspace.StopArrivedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Timer;

public class FlyManager
extends InternalHandleDisposable {
    transient Vector<StopArrivedListener> m_stopArrivedListeners;
    transient Vector<StatusChangedListener> m_statusChangedListener;
    transient Vector<PropertiesChangedListener> m_propertiesChangedListener;
    private Routes m_routes;
    private Scene m_scene;
    private Timer m_timer;

    static void flyStatusChangedCallBack(FlyManager flyManager, int preStatus, int currentStatus) {
        if (flyManager.getHandle() == 0L) {
            String string = InternalResource.loadString("fly()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        StatusChangedEvent statusChangedEvent = new StatusChangedEvent((Object)flyManager, (FlyStatus)Enum.parse(FlyStatus.class, (int)preStatus), (FlyStatus)Enum.parse(FlyStatus.class, (int)currentStatus));
        flyManager.fireStatusChanged(statusChangedEvent);
    }

    public FlyManager() {
        long l = FlyManagerNative.jni_New();
        this.setHandle(l, true);
        this.initFlyManager();
    }

    protected FlyManager(long handle) {
        this.setHandle(handle, false);
        this.initFlyManager();
    }

    public void dispose() {
        this.m_timer.stop();
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            FlyManagerNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    private void initFlyManager() {
        this.m_timer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlyManager.this.flyMonitor();
            }
        });
        this.m_routes = new Routes(this);
        FlyManagerNative.jni_NewSelfEventHandle(this.getHandle(), this);
    }

    public Routes getRoutes() {
        return this.m_routes;
    }

    public Scene getScene() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScene()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_scene;
    }

    public void setScene(Scene scene) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene scene)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)scene) == 0L) {
            String string = InternalResource.loadString("the param has no handle!", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_scene = scene;
        FlyManagerNative.jni_SetScene(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)scene));
    }

    private void flyMonitor() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fly()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n2 = FlyManagerNative.jni_GetNewArrivedStopIndex(this.getHandle());
        if (n2 != -1 && n2 < (n = this.m_routes.getCurrentRoute().getStops().getCount()) && n2 >= 0) {
            StopArrivedEvent stopArrivedEvent = new StopArrivedEvent((Object)this, this.m_routes.getCurrentRoute(), this.m_routes.getCurrentRoute().getStops().get(n2));
            this.fireStopArrived(stopArrivedEvent);
        }
    }

    public void play() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("play()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_Play(this.getHandle());
        this.m_timer.start();
    }

    public void stop() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("stop()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_Stop(this.getHandle());
        this.m_timer.stop();
    }

    public void pause() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pause()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_Pause(this.getHandle());
        this.m_timer.stop();
    }

    public void update() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("update()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_Update(this.getHandle());
    }

    public double getDuration() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDuration()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FlyManagerNative.jni_GetDuration(this.getHandle());
    }

    public void setDuration(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDuration(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_SetDuration(this.getHandle(), value);
        PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.FLYMANAGER_PROPERTIES_CHANGED);
        this.firePropertiesChanged(propertiesChangedEvent);
    }

    public double getProgress() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProgress()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FlyManagerNative.jni_GetProgress(this.getHandle());
    }

    public void setProgress(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProgress(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_SetProgress(this.getHandle(), value);
        PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.FLYMANAGER_PROPERTIES_CHANGED);
        this.firePropertiesChanged(propertiesChangedEvent);
    }

    public double getPlayRate() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPlayRate()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FlyManagerNative.jni_GetPlayRate(this.getHandle());
    }

    public void setPlayRate(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPlayRate(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_SetPlayRate(this.getHandle(), value);
        PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.FLYMANAGER_PROPERTIES_CHANGED);
        this.firePropertiesChanged(propertiesChangedEvent);
    }

    public int getCurrentStopIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentStopIndex()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FlyManagerNative.jni_GetCurrentStopIndex(this.getHandle());
    }

    public void setCurrentStopIndex(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurrentStopIndex(int value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_SetCurrentStopIndex(this.getHandle(), value);
        PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.FLYMANAGER_PROPERTIES_CHANGED);
        this.firePropertiesChanged(propertiesChangedEvent);
    }

    public FlyStatus getStatus() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFlyStatus()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = FlyManagerNative.jni_GetFlyStatus(this.getHandle());
        return (FlyStatus)Enum.parse(FlyStatus.class, (int)n);
    }

    protected void clearHandle() {
        this.setHandle(0L);
        this.m_routes.clearHandle();
    }

    public synchronized void addStopArrivedListener(StopArrivedListener l) {
        if (this.m_stopArrivedListeners == null) {
            this.m_stopArrivedListeners = new Vector();
        }
        if (!this.m_stopArrivedListeners.contains(l)) {
            this.m_stopArrivedListeners.add(l);
        }
    }

    public synchronized void removeStopArrivedListener(StopArrivedListener l) {
        if (this.m_stopArrivedListeners != null && this.m_stopArrivedListeners.contains(l)) {
            this.m_stopArrivedListeners.remove(l);
        }
    }

    protected void fireStopArrived(StopArrivedEvent event) {
        if (this.m_stopArrivedListeners != null) {
            Vector<StopArrivedListener> vector = this.m_stopArrivedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).stopArrived(event);
            }
        }
    }

    public synchronized void addStatusChangedListener(StatusChangedListener l) {
        if (this.m_statusChangedListener == null) {
            this.m_statusChangedListener = new Vector();
        }
        if (!this.m_statusChangedListener.contains(l)) {
            this.m_statusChangedListener.add(l);
        }
    }

    public synchronized void removeStatusChangedListener(StatusChangedListener l) {
        if (this.m_statusChangedListener != null && this.m_statusChangedListener.contains(l)) {
            this.m_statusChangedListener.remove(l);
        }
    }

    protected void fireStatusChanged(StatusChangedEvent event) {
        if (this.m_statusChangedListener != null) {
            Vector<StatusChangedListener> vector = this.m_statusChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).statusChanged(event);
            }
        }
    }

    public synchronized void addPropertiesChangedListener(PropertiesChangedListener l) {
        if (this.m_propertiesChangedListener == null) {
            this.m_propertiesChangedListener = new Vector();
        }
        if (!this.m_propertiesChangedListener.contains(l)) {
            this.m_propertiesChangedListener.add(l);
        }
    }

    public synchronized void removePropertiesChangedListener(PropertiesChangedListener l) {
        if (this.m_propertiesChangedListener != null && this.m_propertiesChangedListener.contains(l)) {
            this.m_propertiesChangedListener.remove(l);
        }
    }

    protected void firePropertiesChanged(PropertiesChangedEvent event) {
        if (this.m_propertiesChangedListener != null) {
            Vector<PropertiesChangedListener> vector = this.m_propertiesChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).propertiesChanged(event);
            }
        }
    }
}

