/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.AltitudeMode;
import com.supermap.data.Enum;
import com.supermap.data.Geometry3D;
import com.supermap.realspace.Camera;
import com.supermap.realspace.Feature3D;
import com.supermap.realspace.Feature3DSearchOption;
import com.supermap.realspace.Feature3DsNative;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import java.io.File;
import java.util.ArrayList;

public class Feature3Ds
extends InternalHandleDisposable {
    private ArrayList m_all;
    private Feature3Ds m_parent;
    private UserType m_userType;
    private static final double DTOR = Math.PI / 180;
    private static final double RTOD = 57.29577951308232;

    public Feature3Ds() {
        long l = Feature3DsNative.jni_New();
        this.m_all = new ArrayList();
        this.setHandle(l, true);
        this.m_userType = UserType.NONE;
        this.setName("UntitledFeature3Ds");
    }

    Feature3Ds(long handle, Feature3Ds parent) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, false);
        if (this.m_all == null) {
            this.m_all = new ArrayList();
        }
        this.m_userType = UserType.NONE;
        this.setParent(parent);
        this.init();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parent));
    }

    public Feature3D[] getFeatureArray(Feature3DSearchOption option) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFeatureArray(Feature3DSearchOption option)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("getFeatureArray(Feature3DSearchOption option)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getFeatureArray(Feature3DSearchOption option)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        ArrayList arrayList = new ArrayList();
        this.getAllFeaturesArray(arrayList, option);
        int n = arrayList.size();
        Feature3D[] feature3DArray = new Feature3D[n];
        for (int i = 0; i < feature3DArray.length; ++i) {
            feature3DArray[i] = (Feature3D)((Object)arrayList.get(i));
        }
        return feature3DArray;
    }

    public Feature3Ds[] getFeaturesArray(Feature3DSearchOption option) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFeatureArray(Feature3DSearchOption option)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("getFeaturesArray(Feature3DSearchOption option)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getFeaturesArray(Feature3DSearchOption option)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        ArrayList arrayList = new ArrayList();
        this.getAllFeature3DsArray(arrayList, option);
        int n = arrayList.size();
        Feature3Ds[] feature3DsArray = new Feature3Ds[n];
        for (int i = 0; i < feature3DsArray.length; ++i) {
            feature3DsArray[i] = (Feature3Ds)((Object)arrayList.get(i));
        }
        return feature3DsArray;
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("getName()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return Feature3DsNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("setName()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        Feature3DsNative.jni_SetName(this.getHandle(), value);
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("getDescription()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return Feature3DsNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDescription(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("setDescription()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setDescription()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        Feature3DsNative.jni_SetDescription(this.getHandle(), value);
    }

    public Feature3Ds getParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParent()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("getParent()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getParent()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return this.m_parent;
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("getVisible()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return Feature3DsNative.jni_GetVisible(this.getHandle());
    }

    public void setVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("setVisible()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        Feature3DsNative.jni_SetVisible(this.getHandle(), value);
    }

    public Camera getCamera() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("getCamera()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        double[] dArray = new double[6];
        long l = Feature3DsNative.jni_GetCamera(this.getHandle(), dArray);
        Camera camera = null;
        if (l != 0L) {
            camera = new Camera(dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, Camera.computeAltitude(dArray[2], dArray[5] * 57.29577951308232), (AltitudeMode)InternalEnum.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * 57.29577951308232, dArray[5] * 57.29577951308232);
        }
        return camera;
    }

    public void setCamera(Camera value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCamera(Camera value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("setCamera(Camera value)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setCamera(Camera value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (value == null) {
            Feature3DsNative.jni_SetCamera(this.getHandle(), 0L);
        } else {
            Feature3DsNative.jni_SetCameraValue(this.getHandle(), value.getLongitude() * (Math.PI / 180), value.getLatitude() * (Math.PI / 180), Camera.computeDistance(value.getAltitude(), value.getTilt()), InternalEnum.getUGCValue((Enum)value.getAltitudeMode()), value.getHeading() * (Math.PI / 180), value.getTilt() * (Math.PI / 180));
        }
    }

    public Feature3D findFeature(int id, Feature3DSearchOption option) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("find(int id,Feature3DSearchOption option)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("find(int id,Feature3DSearchOption option)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("find(int id,Feature3DSearchOption option)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        Feature3D[] feature3DArray = this.getFeatureArray(option);
        Feature3D feature3D = null;
        for (int i = 0; i < feature3DArray.length; ++i) {
            if (feature3DArray[i].getID() != id) continue;
            feature3D = feature3DArray[i];
            break;
        }
        return feature3D;
    }

    public Feature3D[] findFeature(String name, Feature3DSearchOption option) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findFeature(String name,Feature3DSearchOption option)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("findFeature(String name,Feature3DSearchOption option)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("findFeature(String name,Feature3DSearchOption option)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        ArrayList<Feature3D> arrayList = new ArrayList<Feature3D>();
        Feature3D[] feature3DArray = this.getFeatureArray(option);
        for (int i = 0; i < feature3DArray.length; ++i) {
            if (!feature3DArray[i].getName().equals(name)) continue;
            arrayList.add(feature3DArray[i]);
        }
        Feature3D[] feature3DArray2 = new Feature3D[arrayList.size()];
        return arrayList.toArray(feature3DArray2);
    }

    public Feature3Ds[] findFeatures(String name, Feature3DSearchOption option) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findFeatures(String name,Feature3DSearchOption option)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("findFeatures(String name,Feature3DSearchOption option)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("findFeatures(String name,Feature3DSearchOption option)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        ArrayList<Feature3Ds> arrayList = new ArrayList<Feature3Ds>();
        Feature3Ds[] feature3DsArray = this.getFeaturesArray(option);
        for (int i = 0; i < feature3DsArray.length; ++i) {
            if (!feature3DsArray[i].getName().equals(name)) continue;
            arrayList.add(feature3DsArray[i]);
        }
        Feature3Ds[] feature3DsArray2 = new Feature3Ds[arrayList.size()];
        return arrayList.toArray(feature3DsArray2);
    }

    public Feature3D add(Feature3D feature) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Feature3D feature)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("add(Feature3D feature)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("add(Feature3D feature)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (feature == null) {
            String string = InternalResource.loadString("feature", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)feature);
        if (l == 0L) {
            String string = InternalResource.loadString("feature", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Feature3D feature3D = null;
        long l2 = Feature3DsNative.jni_AddFeature3D(this.getHandle(), l);
        if (l2 != 0L && (feature3D = new Feature3D(l2, this)) != null) {
            this.m_all.add(feature3D);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)feature));
        return feature3D;
    }

    public Feature3Ds add(Feature3Ds features) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Feature3Ds features)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("add(Feature3Ds features)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("add(Feature3Ds features)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (features == null) {
            String string = InternalResource.loadString("features", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)features);
        if (l == 0L) {
            String string = InternalResource.loadString("features", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Feature3Ds feature3Ds = null;
        long l2 = Feature3DsNative.jni_AddFeature3Ds(this.getHandle(), l);
        if (l2 != 0L) {
            feature3Ds = new Feature3Ds(l2, this);
            this.m_all.add(feature3Ds);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)features));
        return feature3Ds;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("getCount()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return this.m_all.size();
    }

    public Feature3Ds insert(int index, Feature3Ds features) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, Feature3Ds features)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("insert(int index, Feature3Ds features)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("insert(int index, Feature3Ds features)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (features == null) {
            String string = InternalResource.loadString("features", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)features);
        if (l == 0L) {
            String string = InternalResource.loadString("features", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Feature3Ds feature3Ds = null;
        long l2 = Feature3DsNative.jni_insert1(this.getHandle(), l, index);
        if (l2 != 0L) {
            feature3Ds = new Feature3Ds(l2, this);
            this.m_all.add(index, feature3Ds);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)features));
        return feature3Ds;
    }

    public Feature3D insert(int index, Feature3D feature) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, Feature3D feature)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("insert(int index, Feature3D feature)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("insert(int index, Feature3D feature)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (feature == null) {
            String string = InternalResource.loadString("feature", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)feature);
        if (l == 0L) {
            String string = InternalResource.loadString("feature", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Feature3D feature3D = null;
        long l2 = Feature3DsNative.jni_insert(this.getHandle(), l, index);
        if (l2 != 0L) {
            feature3D = new Feature3D(l2, this);
            this.m_all.add(index, feature3D);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)feature));
        return feature3D;
    }

    public void removeAt(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeAt(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Object e = this.m_all.get(index);
        if (e instanceof Feature3Ds) {
            Feature3Ds feature3Ds = (Feature3Ds)((Object)e);
            this.remove(feature3Ds);
        } else {
            Feature3D feature3D = (Feature3D)((Object)e);
            this.remove(feature3D);
        }
    }

    public Feature3D add(Geometry3D geometry3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Geometry3D geometry3D)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("add(Geometry3D geometry3D)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("add(Geometry3D geometry3D)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (geometry3D == null) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry3D);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry3D", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Feature3D feature3D = new Feature3D();
        feature3D.setGeometry(geometry3D);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry3D);
        return this.add(feature3D);
    }

    public void exchange(int index1, int index2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("exchange(int index1, int index2)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index1 < 0 || index1 >= this.getCount()) {
            String string = InternalResource.loadString("index1", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (index2 < 0 || index2 >= this.getCount()) {
            String string = InternalResource.loadString("index2", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Object e = this.m_all.get(index1);
        Object e2 = this.m_all.get(index2);
        if (index1 != index2) {
            Feature3DsNative.jni_Swap(this.getHandle(), index1, index2);
            this.m_all.set(index1, e2);
            this.m_all.set(index2, e);
        }
    }

    public Object get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_all.get(index);
    }

    public void remove(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int id )", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("remove(int id)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("remove(int id)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        ArrayList arrayList = new ArrayList();
        this.getAllFeature3DsFromAll(arrayList);
        Feature3D[] feature3DArray = new Feature3D[arrayList.size()];
        arrayList.toArray(feature3DArray);
        for (Feature3D feature3D : feature3DArray) {
            if (id != feature3D.getID()) continue;
            this.remove(feature3D);
            break;
        }
    }

    public void remove(Feature3D feature) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(Feature3D feature)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("remove(Feature3D feature)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("remove(Feature3D feature)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (feature == null) {
            String string = InternalResource.loadString("feature", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)feature);
        if (l == 0L) {
            String string = InternalResource.loadString("feature", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        ArrayList arrayList = new ArrayList();
        this.getAllFeature3DsFromAll(arrayList);
        int n = arrayList.indexOf((Object)feature);
        if (n != -1) {
            this.removeFeature3DFromAll(feature);
            Feature3DsNative.jni_RemoveFeature3D(this.getHandle(), l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)feature));
    }

    public void remove(Feature3Ds features) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(Feature3Ds features)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("remove(Feature3Ds features)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("remove(Feature3Ds features)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (features == null) {
            String string = InternalResource.loadString("features", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)features);
        if (l == 0L) {
            String string = InternalResource.loadString("features", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_all.indexOf((Object)features);
        if (n != -1) {
            Feature3DsNative.jni_RemoveFeature3Ds(this.getHandle(), l);
            this.m_all.remove((Object)features);
            features.clearHandle();
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)features));
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("clear()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        Feature3DsNative.jni_Clear(this.getHandle());
        this.clearItems();
    }

    public String toKML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toKML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("toKML()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("toKML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return Feature3DsNative.jni_ToKML(this.getHandle());
    }

    public Feature3Ds add(String kmlFile) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String kmlFile)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("toKML()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("toKML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        Feature3Ds feature3Ds = new Feature3Ds();
        feature3Ds.fromKML(kmlFile);
        return this.add(feature3Ds);
    }

    public boolean fromKML(String kml) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromKML(String kml)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("fromKML(String kml)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("fromKML(String kml)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        n = 0;
        if (kml != null && kml.trim().length() != 0 && (n = (int)(Feature3DsNative.jni_FromKML(this.getHandle(), kml) ? 1 : 0)) != 0) {
            this.reset();
        }
        return n != 0;
    }

    public boolean fromKMLFile(String kmlFile) {
        File file;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromKMLFile(String kmlFile)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("fromKMLFile(String kmlFile)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("fromKMLFile(String kmlFile)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (!(file = new File(kmlFile)).exists()) {
            String string = InternalResource.loadString("fromKMLFile(String kmlFile)", "Feature3Ds_SpecifiedNameNotExists", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = Feature3DsNative.jni_FromKMLFile(this.getHandle(), kmlFile);
        if (bl) {
            this.reset();
        }
        return bl;
    }

    public void toKMLFile(String kmlFile) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toKMLFile(String kmlFile)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_userType.value() == UserType.FEATURE3DS.value()) {
            if (this.m_parent.getHandle() == 0L) {
                String string = InternalResource.loadString("toKMLFile(String kmlFile)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_parent.getFeature3DsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("toKMLFile(String kmlFile)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        String string = ".kml";
        String string2 = ".kmz";
        if (kmlFile.endsWith(string2)) {
            Feature3DsNative.jni_ToKMZFile(this.getHandle(), kmlFile);
        } else {
            if (!kmlFile.endsWith(string)) {
                kmlFile = kmlFile + string;
            }
            Feature3DsNative.jni_ToKMLFile(this.getHandle(), kmlFile);
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            Feature3DsNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    void setParent(Feature3Ds value) {
        if (value != null) {
            if (value.getHandle() == 0L) {
                String string = InternalResource.loadString("setParent(Feature3Ds feature3Ds, Feature3Ds value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_parent = value;
            this.setUserType(UserType.FEATURE3DS);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)value));
    }

    void getAllFeature3DsArray(ArrayList arrayList, Feature3DSearchOption option) {
        for (int i = 0; i < this.m_all.size(); ++i) {
            Object e = this.m_all.get(i);
            if (e instanceof Feature3Ds) {
                arrayList.add(e);
            }
            if (option != Feature3DSearchOption.ALLFEATURES || !(e instanceof Feature3Ds)) continue;
            Feature3Ds feature3Ds = (Feature3Ds)((Object)e);
            feature3Ds.getAllFeature3DsArray(arrayList, option);
        }
    }

    void getAllFeaturesArray(ArrayList arrayList, Feature3DSearchOption option) {
        for (int i = 0; i < this.m_all.size(); ++i) {
            Object e = this.m_all.get(i);
            if (e instanceof Feature3D) {
                arrayList.add(e);
            }
            if (option != Feature3DSearchOption.ALLFEATURES || !(e instanceof Feature3Ds)) continue;
            Feature3Ds feature3Ds = (Feature3Ds)((Object)e);
            feature3Ds.getAllFeaturesArray(arrayList, option);
        }
    }

    void getAllFeature3DsFromAll(ArrayList arrayList) {
        for (int i = 0; i < this.m_all.size(); ++i) {
            Object e = this.m_all.get(i);
            if (e instanceof Feature3D) {
                arrayList.add(e);
            }
            if (!(e instanceof Feature3Ds)) continue;
            Feature3Ds feature3Ds = (Feature3Ds)((Object)e);
            feature3Ds.getAllFeature3DsFromAll(arrayList);
        }
    }

    void removeFeature3DFromAll(Feature3D feature3D) {
        for (int i = 0; i < this.m_all.size(); ++i) {
            InternalHandleDisposable internalHandleDisposable;
            Object e = this.m_all.get(i);
            if (e instanceof Feature3D && ((Object)((Object)(internalHandleDisposable = (Feature3D)((Object)e)))).equals((Object)feature3D)) {
                this.m_all.remove(i);
                ((Feature3D)internalHandleDisposable).clearHandle();
                return;
            }
            if (!(e instanceof Feature3Ds)) continue;
            internalHandleDisposable = (Feature3Ds)((Object)e);
            ((Feature3Ds)internalHandleDisposable).removeFeature3DFromAll(feature3D);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)feature3D));
    }

    protected void clearHandle() {
        if (this.m_all != null) {
            this.clearItems();
            this.m_all = null;
        }
        if (this.m_parent != null) {
            this.m_parent = null;
        }
        this.setHandle(0L);
    }

    private void clearItems() {
        for (int i = 0; i < this.m_all.size(); ++i) {
            InternalHandleDisposable internalHandleDisposable;
            Object e = this.m_all.get(0);
            if (e instanceof Feature3D) {
                internalHandleDisposable = (Feature3D)((Object)e);
                ((Feature3D)internalHandleDisposable).clearHandle();
                continue;
            }
            if (!(e instanceof Feature3Ds)) continue;
            internalHandleDisposable = (Feature3Ds)((Object)e);
            ((Feature3Ds)internalHandleDisposable).clearHandle();
        }
        this.m_all.clear();
    }

    ArrayList getFeature3DList() {
        return this.m_all;
    }

    ArrayList getFeature3DsList() {
        return this.m_all;
    }

    UserType getUserType() {
        return this.m_userType;
    }

    void setUserType(UserType userType) {
        this.m_userType = userType;
    }

    void init() {
        int n = Feature3DsNative.jni_GetCount(this.getHandle());
        long[] lArray = new long[n];
        Feature3DsNative.jni_Fill(this.getHandle(), lArray);
        Feature3D feature3D = null;
        Feature3Ds feature3Ds = null;
        for (int i = 0; i < n; ++i) {
            int n2 = Feature3DsNative.jni_GetType(lArray[i]);
            if (n2 == 2) {
                feature3D = new Feature3D(lArray[i], this);
                this.m_all.add(feature3D);
                continue;
            }
            if (n2 != 3) continue;
            feature3Ds = new Feature3Ds(lArray[i], this);
            this.m_all.add(feature3Ds);
        }
    }

    void reset() {
        this.clearItems();
        this.init();
    }

    static class UserType
    extends Enum {
        public static final UserType NONE = new UserType(1, 1);
        public static final UserType FEATURE3DS = new UserType(2, 2);

        private UserType(int value, int ugcValue) {
            super(value, ugcValue);
        }
    }
}

