/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Geometry;
import com.supermap.realspace.InternalGeometry;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Scene;
import com.supermap.realspace.TrackingLayer3DNative;
import java.awt.Point;

public class TrackingLayer3D
extends InternalHandle {
    private Scene m_scene;

    TrackingLayer3D(long handle, Scene scene) {
        this.setHandle(handle);
        this.m_scene = scene;
        TrackingLayer3DNative.jni_Reset(this.getHandle());
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayer3DNative.jni_GetCount(this.getHandle());
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayer3DNative.jni_GetIsVisible(this.getHandle());
    }

    public void setVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TrackingLayer3DNative.jni_SetIsVisible(this.getHandle(), value);
    }

    public int add(Geometry geometry, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Geometry geometry, String tag)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (tag == null) {
            tag = "";
        }
        Geometry geometry2 = geometry.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry2, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry2);
        int n = TrackingLayer3DNative.jni_Add(this.getHandle(), l2, tag);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry2);
        return n;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return TrackingLayer3DNative.jni_Remove(this.getHandle(), index);
    }

    public Geometry get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry = null;
        long l = TrackingLayer3DNative.jni_Get(this.getHandle(), index);
        if (l != 0L) {
            geometry = InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
        }
        return geometry;
    }

    public boolean set(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry2, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry2);
        boolean bl = TrackingLayer3DNative.jni_Set(this.getHandle(), index, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry2);
        return bl;
    }

    public String getTag(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTag(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return TrackingLayer3DNative.jni_GetTag(this.getHandle(), index);
    }

    public boolean setTag(int index, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTag(int index, String tag)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (tag == null) {
            tag = "";
        }
        return TrackingLayer3DNative.jni_SetTag(this.getHandle(), index, tag);
    }

    public int indexOf(String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String tag)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (tag == null) {
            String string = InternalResource.loadString("indexOf(String tag)", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        return TrackingLayer3DNative.jni_IndexOf(this.getHandle(), tag);
    }

    public int hitTest(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point point)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        return TrackingLayer3DNative.jni_HitTest(this.getHandle(), l, point.getX(), point.getY());
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TrackingLayer3DNative.jni_Clear(this.getHandle());
    }

    public boolean isSelectable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TrackingLayer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayer3DNative.jni_IsSelectable(this.getHandle());
    }

    public void setSelectable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TrackingLayer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TrackingLayer3DNative.jni_SetSelectable(this.getHandle(), value);
    }

    protected static TrackingLayer3D createInstance(long handle, Scene scene) {
        return new TrackingLayer3D(handle, scene);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }
}

