/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Geometry;
import com.supermap.realspace.InternalGeometry;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.SlopeDisplayMode;
import com.supermap.realspace.SlopeSettingNative;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SlopeSetting
extends InternalHandleDisposable {
    public SlopeSetting() {
        long l = SlopeSettingNative.jni_New();
        this.setHandle(l, true);
    }

    public SlopeSetting(SlopeSetting slopeSetting) {
        long l = 0L;
        if (slopeSetting != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)slopeSetting)) == 0L) {
            String string = InternalResource.loadString("slopeSetting", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l2 = SlopeSettingNative.jni_New2(l);
        this.setHandle(l2, true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SlopeSettingNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean isArrowMove() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isArrowMove", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SlopeSettingNative.jni_GetArrowMove(this.getHandle());
    }

    public void setArrowMove(boolean isArrowMove) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setArrowMove", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SlopeSettingNative.jni_SetArrowMove(this.getHandle(), isArrowMove);
    }

    public Geometry getCoverageRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoverageRegion", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = SlopeSettingNative.jni_GetCoverageRegion(this.getHandle());
        if (l == 0L) {
            return null;
        }
        return InternalGeometry.createInstance(l);
    }

    public void setCoverageRegion(Geometry coverageRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoverageRegion", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (coverageRegion == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)coverageRegion);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry = coverageRegion.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        SlopeSettingNative.jni_SetCoverageRegion(this.getHandle(), l2);
    }

    public double getOpacity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOpacity", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SlopeSettingNative.jni_GetOpacity(this.getHandle());
    }

    public void setOpacity(double opacity) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOpacity", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SlopeSettingNative.jni_SetOpacity(this.getHandle(), opacity);
    }

    public SlopeDisplayMode getDisplayStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayStyle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = SlopeSettingNative.jni_GetDisplayStyle(this.getHandle());
        if (n == 0) {
            return SlopeDisplayMode.NONE;
        }
        if (n == 1) {
            return SlopeDisplayMode.FACE;
        }
        if (n == 2) {
            return SlopeDisplayMode.ARROW;
        }
        return SlopeDisplayMode.FACE_AND_ARROW;
    }

    public void setDisplayStyle(SlopeDisplayMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayStyle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SlopeSettingNative.jni_SetDisplayStyle(this.getHandle(), mode.value());
    }

    public double getMinVisibleValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleValue", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SlopeSettingNative.jni_GetMinVisibleValue(this.getHandle());
    }

    public void setMinVisibleValue(double minVisibleValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleValue", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SlopeSettingNative.jni_SetMinVisibleValue(this.getHandle(), minVisibleValue);
    }

    public double getMaxVisibleValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleValue", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SlopeSettingNative.jni_GetMaxVisibleValue(this.getHandle());
    }

    public void setMaxVisibleValue(double maxVisibleValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleValue", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SlopeSettingNative.jni_SetMaxVisibleValue(this.getHandle(), maxVisibleValue);
    }

    public void setColorDictTable(HashMap<Double, Color> colorTable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorDictTable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = colorTable.size();
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        Set<Map.Entry<Double, Color>> set = colorTable.entrySet();
        Iterator<Map.Entry<Double, Color>> iterator = set.iterator();
        Map.Entry<Double, Color> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            nArray[i] = entry.getValue().getRGB();
        }
        SlopeSettingNative.jni_SetColorDictTable(this.getHandle(), dArray, nArray);
    }

    public HashMap<Double, Color> getColorDictTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorDictTable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Double, Color> hashMap = new HashMap<Double, Color>();
        double[] dArray = SlopeSettingNative.jni_GetColorTable_Keys(this.getHandle());
        int[] nArray = SlopeSettingNative.jni_GetColotTable_Colors(this.getHandle());
        for (int i = 0; i < dArray.length; ++i) {
            hashMap.put(dArray[i], new Color(nArray[i], true));
        }
        return hashMap;
    }
}

