/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.License;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.InternalHandle;
import com.supermap.data.Workspace;
import com.supermap.realspace.ImageFormatType;
import com.supermap.realspace.InternalDataset;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalToolkitSpace;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DAddedEvent;
import com.supermap.realspace.Layer3DAddedListener;
import com.supermap.realspace.Layer3DAlwaysRenderChangedEvent;
import com.supermap.realspace.Layer3DAlwaysRenderChangedListener;
import com.supermap.realspace.Layer3DCaptionChangedEvent;
import com.supermap.realspace.Layer3DCaptionChangedListener;
import com.supermap.realspace.Layer3DDataset;
import com.supermap.realspace.Layer3DEditableChangedEvent;
import com.supermap.realspace.Layer3DEditableChangedListener;
import com.supermap.realspace.Layer3DGroup;
import com.supermap.realspace.Layer3DMap;
import com.supermap.realspace.Layer3DNative;
import com.supermap.realspace.Layer3DRemovedEvent;
import com.supermap.realspace.Layer3DRemovedListener;
import com.supermap.realspace.Layer3DSelectableChangedEvent;
import com.supermap.realspace.Layer3DSelectableChangedListener;
import com.supermap.realspace.Layer3DSetting;
import com.supermap.realspace.Layer3DSettingType;
import com.supermap.realspace.Layer3DType;
import com.supermap.realspace.Layer3DVisibleChangedEvent;
import com.supermap.realspace.Layer3DVisibleChangedListener;
import com.supermap.realspace.Layer3DsNative;
import com.supermap.realspace.Scene;
import com.supermap.realspace.Theme3D;
import com.supermap.realspace.Theme3DGraph;
import com.supermap.realspace.Theme3DType;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class Layer3Ds
extends InternalHandle {
    private Scene m_scene;
    private ArrayList<Layer3D> m_layer3Ds;
    transient Vector m_layerAddedListeners;
    transient Vector m_layerRemovedListeners;
    transient Vector<Layer3DCaptionChangedListener> m_layer3DCaptionChangedListeners;
    transient Vector<Layer3DSelectableChangedListener> m_layer3DSelectableChangedListeners;
    transient Vector<Layer3DEditableChangedListener> m_layer3DEditableChangedListeners;
    transient Vector<Layer3DVisibleChangedListener> m_layer3DVisibleChangedListeners;
    transient Vector<Layer3DAlwaysRenderChangedListener> m_layer3DAlwaysRenderChangedListeners;

    Layer3Ds(long handle, Scene scene) {
        this.setHandle(handle);
        this.m_layer3Ds = new ArrayList();
        this.m_scene = scene;
        Workspace workspace = this.m_scene.getWorkspace();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            long l = Layer3DsNative.jni_GetItemByIndex(this.getHandle(), i);
            if (l == 0L) continue;
            Layer3D layer3D = null;
            int n2 = Layer3DNative.jni_GetType(l);
            Layer3DType layer3DType = (Layer3DType)InternalEnum.parse(Layer3DType.class, (int)n2);
            if (layer3DType.equals((Object)Layer3DType.DATASET)) {
                long l2 = Layer3DNative.jni_GetDataset(l);
                Dataset dataset = InternalToolkitSpace.toMangedDataset(workspace, l2);
                layer3D = new Layer3DDataset(l, dataset, this);
            } else if (layer3DType.equals((Object)Layer3DType.MAP)) {
                String string = Layer3DNative.jni_GetName(l);
                layer3D = new Layer3DMap(l, this);
            } else {
                layer3D = Layer3D.createInstance(l, this, layer3DType);
            }
            this.m_layer3Ds.add(layer3D);
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DsNative.jni_GetCount(this.getHandle());
    }

    public Layer3D get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_layer3Ds.get(index);
    }

    public Layer3D get(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3D layer3D = null;
        for (int i = 0; i < this.m_layer3Ds.size(); ++i) {
            layer3D = this.m_layer3Ds.get(i);
            if (!layer3D.getName().equals(name)) continue;
            return layer3D;
        }
        return null;
    }

    public Layer3DDataset add(Dataset dataset, Layer3DSetting layer3DSetting, boolean addToHead) {
        long l;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Dataset  dataset, Layer3DSetting layer3DSetting,boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)dataset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (layer3DSetting != null && (InternalDataset.getIsVector(dataset) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.VECTOR) || dataset.getType().equals((Object)DatasetType.IMAGE) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.IMAGE) || dataset.getType().equals((Object)DatasetType.GRID) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.GRID))) {
            String string = InternalResource.loadString("dataset", "Layer3Ds_AddDatasetTypeAndLayer3DTypeIsNotMatching", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Workspace workspace = dataset.getDatasource().getWorkspace();
        Workspace workspace2 = this.m_scene.getWorkspace();
        long l3 = InternalHandle.getHandle((InternalHandle)workspace);
        if (l3 != (l = InternalHandle.getHandle((InternalHandle)workspace2))) {
            String string = InternalResource.loadString("dataset", "Layer3Ds_TheWorkspaceOfDatasetShouldBeTheSameAsScene", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3DsNative.jni_SetDatasource(this.getHandle(), InternalHandle.getHandle((InternalHandle)workspace));
        String string = "";
        string = dataset.getName() + "@" + dataset.getDatasource().getAlias();
        Layer3DDataset layer3DDataset = null;
        long l4 = 0L;
        boolean bl = false;
        if (InternalDataset.getIsVector(dataset) && ((DatasetVector)dataset).getRecordCount() <= 3000) {
            bl = true;
        }
        if ((l4 = Layer3DsNative.jni_Add(this.getHandle(), Layer3DType.DATASET.value(), string, addToHead, bl, 0L)) != 0L) {
            layer3DDataset = new Layer3DDataset(l4, dataset, this);
            if (addToHead) {
                this.m_layer3Ds.add(0, layer3DDataset);
            } else {
                this.m_layer3Ds.add(layer3DDataset);
            }
            if (layer3DSetting != null) {
                layer3DDataset.setAdditionalSetting(layer3DSetting);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3DDataset);
            this.fireLayer3DAdded(layer3DAddedEvent);
        }
        return layer3DDataset;
    }

    public Layer3D add(String dataName, Layer3DType layerType, boolean addToHead) {
        long l;
        Object object;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String file,boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if ((layerType.equals((Object)Layer3DType.KML) || layerType.equals((Object)Layer3DType.IMAGEFILE) || layerType.equals((Object)Layer3DType.MODEL) || layerType.equals((Object)Layer3DType.GRID) || layerType.equals((Object)Layer3DType.OSGB) || layerType.equals((Object)Layer3DType.VECTORFILE) || layerType.equals((Object)Layer3DType.VOLUMEFILE) || layerType.equals((Object)Layer3DType.OSGBGROUP)) && !((File)(object = new File(dataName))).exists()) {
            String string = InternalResource.loadString("", "Global_PathIsNotValid", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.checkDataNameAndType(dataName, layerType, "")) {
            object = InternalResource.loadString("layerType", "Layer3Ds_AddDataNameAndLayer3DTypeIsNotMatching", "realspace_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = dataName;
        Workspace workspace = this.m_scene.getWorkspace();
        long l2 = 0L;
        if (workspace != null) {
            l2 = InternalHandle.getHandle((InternalHandle)workspace);
        }
        if ((l = Layer3DsNative.jni_Add(this.getHandle(), layerType.value(), (String)object, addToHead, false, l2)) != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, layerType);
            if (addToHead) {
                this.m_layer3Ds.add(0, layer3D);
            } else {
                this.m_layer3Ds.add(layer3D);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public Layer3DDataset add(Dataset dataset, Theme3D theme3D, boolean addToHead) {
        Object object;
        int n;
        long l;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Dataset dataset, Theme3D theme3D, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)dataset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (theme3D != null && InternalHandle.getHandle((InternalHandle)theme3D) == 0L) {
            String string = InternalResource.loadString("theme3D", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Workspace workspace = dataset.getDatasource().getWorkspace();
        Workspace workspace2 = this.m_scene.getWorkspace();
        long l3 = InternalHandle.getHandle((InternalHandle)workspace);
        if (l3 != (l = InternalHandle.getHandle((InternalHandle)workspace2))) {
            String string = InternalResource.loadString("dataset", "Layer3Ds_TheWorkspaceOfDatasetShouldBeTheSameAsScene", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3DsNative.jni_SetDatasource(this.getHandle(), InternalHandle.getHandle((InternalHandle)workspace));
        String string = "";
        string = dataset.getName() + "@" + dataset.getDatasource().getAlias();
        Layer3DDataset layer3DDataset = null;
        long l4 = 0L;
        boolean bl = false;
        if (InternalDataset.getIsVector(dataset) && ((DatasetVector)dataset).getRecordCount() <= 3000) {
            bl = true;
        }
        int n2 = n = addToHead ? 0 : this.m_layer3Ds.size();
        if (theme3D != null) {
            if (theme3D.getType() == Theme3DType.GRAPH3D) {
                object = (Theme3DGraph)theme3D;
                Theme3DGraph theme3DGraph = new Theme3DGraph((Theme3DGraph)((Object)object));
                theme3DGraph.calculateExtremum(dataset);
                object.setBarWidth(theme3DGraph.getBarWidth());
                object.setMaxGraphSize(theme3DGraph.getMaxGraphSize());
                object.setMinGraphSize(theme3DGraph.getMinGraphSize());
                l4 = Layer3DsNative.jni_AddTheme(this.getHandle(), string, InternalHandle.getHandle((InternalHandle)dataset), InternalHandle.getHandle((InternalHandle)theme3DGraph), n, bl);
            } else {
                l4 = Layer3DsNative.jni_AddTheme(this.getHandle(), string, InternalHandle.getHandle((InternalHandle)dataset), InternalHandle.getHandle((InternalHandle)theme3D), n, bl);
            }
        } else {
            l4 = Layer3DsNative.jni_Add(this.getHandle(), Layer3DType.DATASET.value(), string, addToHead, bl, 0L);
        }
        if (l4 != 0L) {
            layer3DDataset = new Layer3DDataset(l4, dataset, this);
            if (theme3D != null) {
                theme3D.setLayer(layer3DDataset);
            }
            if (addToHead) {
                this.m_layer3Ds.add(0, layer3DDataset);
            } else {
                this.m_layer3Ds.add(layer3DDataset);
            }
            object = new Layer3DAddedEvent((Object)this, layer3DDataset);
            this.fireLayer3DAdded((Layer3DAddedEvent)object);
        }
        return layer3DDataset;
    }

    public Layer3DDataset insert(int index, Dataset dataset, Layer3DSetting layer3DSetting) {
        long l;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, Dataset dataset,Layer3DSetting layer3DSetting)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        Layer3DDataset layer3DDataset = null;
        if (InternalHandle.getHandle((InternalHandle)dataset) == 0L) {
            String string2 = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (layer3DSetting != null && (InternalDataset.getIsVector(dataset) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.VECTOR) || dataset.getType().equals((Object)DatasetType.IMAGE) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.IMAGE) || dataset.getType().equals((Object)DatasetType.GRID) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.GRID))) {
            String string3 = InternalResource.loadString("dataset", "Layer3Ds_AddDatasetTypeAndLayer3DTypeIsNotMatching", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        Workspace workspace = dataset.getDatasource().getWorkspace();
        Layer3DsNative.jni_SetDatasource(this.getHandle(), InternalHandle.getHandle((InternalHandle)workspace));
        string = dataset.getName() + "@" + dataset.getDatasource().getAlias();
        boolean bl = false;
        if (InternalDataset.getIsVector(dataset) && ((DatasetVector)dataset).getRecordCount() <= 3000) {
            bl = true;
        }
        if ((l = Layer3DsNative.jni_Insert(this.getHandle(), Layer3DType.DATASET.value(), string, index, bl)) != 0L) {
            layer3DDataset = new Layer3DDataset(l, dataset, this);
            this.m_layer3Ds.add(index, layer3DDataset);
            if (layer3DSetting != null) {
                layer3DDataset.setAdditionalSetting(layer3DSetting);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3DDataset);
            this.fireLayer3DAdded(layer3DAddedEvent);
        }
        return layer3DDataset;
    }

    public Layer3D insert(int index, String dataName, Layer3DType layerType) {
        Object object;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index,  String dataName)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if ((layerType.equals((Object)Layer3DType.KML) || layerType.equals((Object)Layer3DType.IMAGEFILE) || layerType.equals((Object)Layer3DType.MODEL)) && !((File)(object = new File(dataName))).exists()) {
            String string = InternalResource.loadString("", "Global_PathIsNotValid", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.checkDataNameAndType(dataName, layerType, "")) {
            object = InternalResource.loadString("layerType", "Layer3Ds_AddDataNameAndLayer3DTypeIsNotMatching", "realspace_resources");
            throw new IllegalArgumentException((String)object);
        }
        long l = Layer3DsNative.jni_Insert(this.getHandle(), layerType.value(), dataName, index, false);
        if (l != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, layerType);
            this.m_layer3Ds.add(index, layer3D);
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public Layer3DDataset insert(int index, Dataset dataset, Theme3D theme3D) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, Dataset dataset,Theme3D theme3D)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        Layer3DDataset layer3DDataset = null;
        if (InternalHandle.getHandle((InternalHandle)dataset) == 0L) {
            String string2 = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (theme3D != null && InternalHandle.getHandle((InternalHandle)theme3D) == 0L) {
            String string3 = InternalResource.loadString("theme3D", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        Workspace workspace = dataset.getDatasource().getWorkspace();
        Layer3DsNative.jni_SetDatasource(this.getHandle(), InternalHandle.getHandle((InternalHandle)workspace));
        string = dataset.getName() + "@" + dataset.getDatasource().getAlias();
        boolean bl = false;
        if (InternalDataset.getIsVector(dataset) && ((DatasetVector)dataset).getRecordCount() <= 3000) {
            bl = true;
        }
        long l = 0L;
        l = theme3D != null ? Layer3DsNative.jni_AddTheme(this.getHandle(), string, InternalHandle.getHandle((InternalHandle)dataset), InternalHandle.getHandle((InternalHandle)theme3D), index, bl) : Layer3DsNative.jni_Insert(this.getHandle(), Layer3DType.DATASET.value(), string, index, bl);
        if (l != 0L) {
            layer3DDataset = new Layer3DDataset(l, dataset, this);
            this.m_layer3Ds.add(index, layer3DDataset);
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3DDataset);
            this.fireLayer3DAdded(layer3DAddedEvent);
        }
        return layer3DDataset;
    }

    public Layer3DDataset add(Dataset dataset, Layer3DSetting layer3DSetting, boolean addToHead, String layerName) {
        if (layerName == null || layerName.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(layerName) != -1) {
            String string = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3DDataset layer3DDataset = this.add(dataset, layer3DSetting, addToHead);
        layer3DDataset.setName(layerName);
        return layer3DDataset;
    }

    public Layer3D add(String dataName, Layer3DType layerType, boolean addToHead, String layerName) {
        if (layerName == null || layerName.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(layerName) != -1) {
            String string = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3D layer3D = this.add(dataName, layerType, addToHead);
        layer3D.setName(layerName);
        return layer3D;
    }

    public Layer3DDataset add(Dataset dataset, Theme3D theme3D, boolean addToHead, String layerName) {
        if (layerName == null || layerName.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(layerName) != -1) {
            String string = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3DDataset layer3DDataset = this.add(dataset, theme3D, addToHead);
        layer3DDataset.setName(layerName);
        return layer3DDataset;
    }

    public void add(Layer3D layer) {
        this.internalInsert(this.getCount(), layer);
    }

    public Layer3D add(String dataName, Layer3DType layerType, boolean addToHead, String layerName, String password) {
        long l;
        Object object;
        if (layerName == null || layerName.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(layerName) != -1) {
            String string = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String file,boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if ((layerType.equals((Object)Layer3DType.KML) || layerType.equals((Object)Layer3DType.IMAGEFILE) || layerType.equals((Object)Layer3DType.MODEL)) && !((File)(object = new File(dataName))).exists()) {
            String string = InternalResource.loadString("", "Global_PathIsNotValid", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        object = dataName;
        Workspace workspace = this.m_scene.getWorkspace();
        long l2 = 0L;
        if (workspace != null) {
            l2 = InternalHandle.getHandle((InternalHandle)workspace);
        }
        if ((l = Layer3DsNative.jni_AddWithPassword(this.getHandle(), layerType.value(), addToHead, (String)object, password, l2)) != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, layerType);
            layer3D.setName(layerName);
            if (addToHead) {
                this.m_layer3Ds.add(0, layer3D);
            } else {
                this.m_layer3Ds.add(layer3D);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public Layer3D add(String iserverURL, Layer3DType layerType, String layerName, boolean addToHead) {
        long l;
        if (iserverURL == null || iserverURL.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Boolean bl = false;
        if (this.indexOf(layerName) != -1) {
            bl = true;
        }
        if ((l = Layer3DsNative.jni_AddIserver(this.getHandle(), iserverURL, layerType.value(), layerName)) != 0L) {
            Object object;
            Layer3D layer3D = Layer3D.createInstance(l, this, layerType);
            if (!bl.booleanValue()) {
                layer3D.setName(layerName);
            } else {
                object = layerName + "_1";
                Boolean bl2 = this.indexOf((String)object) != -1;
                while (bl2.booleanValue()) {
                    bl2 = this.indexOf((String)(object = (String)object + "_1")) != -1;
                }
                layer3D.setName((String)object);
            }
            if (addToHead) {
                this.m_layer3Ds.add(0, layer3D);
            } else {
                this.m_layer3Ds.add(layer3D);
            }
            object = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded((Layer3DAddedEvent)object);
            return layer3D;
        }
        return null;
    }

    public Layer3D add(String iserverURL, String layerName, String dataName, double dDPI, ImageFormatType imageType, boolean addToHead) {
        long l;
        if (iserverURL == null || iserverURL.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Boolean bl = false;
        if (this.indexOf(layerName) != -1) {
            bl = true;
        }
        if ((l = Layer3DsNative.jni_AddTianditu(this.getHandle(), iserverURL, layerName, layerName, dDPI, imageType.value(), addToHead)) != 0L) {
            Object object;
            Layer3D layer3D = Layer3D.createInstance(l, this, Layer3DType.WMTS);
            if (!bl.booleanValue()) {
                layer3D.setName(layerName);
            } else {
                object = layerName + "_1";
                Boolean bl2 = this.indexOf((String)object) != -1;
                while (bl2.booleanValue()) {
                    bl2 = this.indexOf((String)(object = (String)object + "_1")) != -1;
                }
                layer3D.setName((String)object);
            }
            if (addToHead) {
                this.m_layer3Ds.add(0, layer3D);
            } else {
                this.m_layer3Ds.add(layer3D);
            }
            object = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded((Layer3DAddedEvent)object);
            return layer3D;
        }
        return null;
    }

    public Layer3D add(String layerName, Layer3DType layerType, String userName, String passWord, boolean addToHead) {
        if (this.getHandle() == 0L || this.m_layer3Ds == null) {
            String string = InternalResource.loadString("Layer3Ds", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        this.verifyLicense();
        if (layerName == null || layerName.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (layerType != Layer3DType.BINGMAPS && layerType != Layer3DType.GOOGLEMAPS && layerType != Layer3DType.OPENSTREETMAPS) {
            return null;
        }
        long l = Layer3DsNative.jni_Add(this.getHandle(), layerName, layerType.value(), userName, passWord, addToHead);
        if (l != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, this.m_scene.getWorkspace());
            if (addToHead) {
                this.m_layer3Ds.add(0, layer3D);
            } else {
                this.m_layer3Ds.add(layer3D);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public Layer3D add(String iserverURL, Layer3DType layerType, String sceneName, String layerName, String dataName, boolean addToHead) {
        if (this.getHandle() == 0L || this.m_layer3Ds == null) {
            String string = InternalResource.loadString("Layer3Ds", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        this.verifyLicense();
        if (iserverURL == null || iserverURL.trim().length() == 0) {
            String string = InternalResource.loadString("iserverURL", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (sceneName == null || sceneName.trim().length() == 0) {
            String string = InternalResource.loadString("sceneName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (layerName == null || layerName.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataName == null || dataName.trim().length() == 0) {
            String string = InternalResource.loadString("dataName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_scene.getIServerCacheDirectory();
        long l = Layer3DsNative.jni_Add(this.getHandle(), iserverURL, layerType.value(), sceneName, layerName, dataName, addToHead, string);
        if (l != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, this.m_scene.getWorkspace());
            if (addToHead) {
                this.m_layer3Ds.add(0, layer3D);
            } else {
                this.m_layer3Ds.add(layer3D);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public Layer3DDataset insert(int index, Dataset dataset, Layer3DSetting layer3DSetting, String layerName) {
        if (layerName == null || layerName.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(layerName) != -1) {
            String string = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3DDataset layer3DDataset = this.insert(index, dataset, layer3DSetting);
        layer3DDataset.setName(layerName);
        return layer3DDataset;
    }

    public Layer3D insert(int index, String dataName, String layerName, Layer3DType layerType) {
        if (layerName == null || layerName.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(layerName) != -1) {
            String string = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3D layer3D = this.insert(index, dataName, layerType);
        layer3D.setName(layerName);
        return layer3D;
    }

    public Layer3DDataset insert(int index, Dataset dataset, Theme3D theme3D, String layerName) {
        if (layerName == null || layerName.trim().length() == 0) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(layerName) != -1) {
            String string = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3DDataset layer3DDataset = this.insert(index, dataset, theme3D);
        layer3DDataset.setName(layerName);
        return layer3DDataset;
    }

    public Layer3D insert(int index, String dataName, String layerName, Layer3DType layerType, String password) {
        Object object;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index,  String dataName)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if ((layerType.equals((Object)Layer3DType.KML) || layerType.equals((Object)Layer3DType.IMAGEFILE) || layerType.equals((Object)Layer3DType.MODEL)) && !((File)(object = new File(dataName))).exists()) {
            String string = InternalResource.loadString("", "Global_PathIsNotValid", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.checkDataNameAndType(dataName, layerType, password)) {
            object = InternalResource.loadString("layerType", "Layer3Ds_AddDataNameAndLayer3DTypeIsNotMatching", "realspace_resources");
            throw new IllegalArgumentException((String)object);
        }
        long l = Layer3DsNative.jni_Insert2(this.getHandle(), index, dataName, layerType.value(), password);
        if (l != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, layerType);
            layer3D.setName(layerName);
            this.m_layer3Ds.add(index, layer3D);
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public void insert(int index, Layer3D layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3Ds", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.internalInsert(index, layer);
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Layer3D layer3D = this.m_layer3Ds.get(index);
        String string = layer3D.getName();
        boolean bl = Layer3DsNative.jni_Remove(this.getHandle(), layer3D.getName());
        if (bl) {
            this.m_layer3Ds.remove(index);
            layer3D.clearHandle();
            Layer3DRemovedEvent layer3DRemovedEvent = new Layer3DRemovedEvent((Object)this, layer3D, string, index);
            this.fireLayer3DRemoved(layer3DRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String name) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        Layer3D layer3D = null;
        boolean bl = false;
        for (n = 0; n < this.m_layer3Ds.size(); ++n) {
            layer3D = this.m_layer3Ds.get(n);
            if (!layer3D.getName().equals(name)) continue;
            bl = true;
            break;
        }
        n = this.indexOf(name);
        boolean bl2 = false;
        if (bl && (bl2 = Layer3DsNative.jni_Remove(this.getHandle(), name))) {
            this.m_layer3Ds.remove((Object)layer3D);
            layer3D.clearHandle();
            Layer3DRemovedEvent layer3DRemovedEvent = new Layer3DRemovedEvent((Object)this, layer3D, name, n);
            this.fireLayer3DRemoved(layer3DRemovedEvent);
        }
        return bl2;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        while (this.getCount() > 0) {
            this.remove(0);
        }
    }

    public int indexOf(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null) {
            n = Layer3DsNative.jni_IndexOf(this.getHandle(), name);
        }
        return n;
    }

    public boolean contains(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("contains(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (name != null) {
            bl = Layer3DsNative.jni_Contains(this.getHandle(), name);
        }
        return bl;
    }

    public boolean moveToTop(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToTop(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (index == 0) {
            bl = true;
        } else {
            bl = Layer3DsNative.jni_MoveToTop(this.getHandle(), index);
            if (bl) {
                Layer3D layer3D = this.m_layer3Ds.remove(index);
                this.m_layer3Ds.add(0, layer3D);
            }
        }
        return bl;
    }

    public boolean moveToBottom(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToBottom(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (index == n - 1) {
            bl = true;
        } else {
            bl = Layer3DsNative.jni_MoveToBottom(this.getHandle(), index);
            if (bl) {
                Layer3D layer3D = this.m_layer3Ds.remove(index);
                this.m_layer3Ds.add(layer3D);
            }
        }
        return bl;
    }

    public boolean moveUp(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveUp(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (index == 0) {
            bl = true;
        } else {
            bl = Layer3DsNative.jni_MoveUp(this.getHandle(), index);
            if (bl) {
                Layer3D layer3D = this.m_layer3Ds.remove(index);
                this.m_layer3Ds.add(index - 1, layer3D);
            }
        }
        return bl;
    }

    public boolean moveDown(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveDown(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (index == n - 1) {
            bl = true;
        } else {
            bl = Layer3DsNative.jni_MoveDown(this.getHandle(), index);
            if (bl) {
                Layer3D layer3D = this.m_layer3Ds.remove(index + 1);
                this.m_layer3Ds.add(index, layer3D);
            }
        }
        return bl;
    }

    public boolean moveTo(int sourceIndex, int targetIndex) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int srcIndex, int desIndex)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (sourceIndex < 0 || sourceIndex >= n) {
            String string = InternalResource.loadString("srcIndex", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (targetIndex < 0 || targetIndex >= n) {
            String string = InternalResource.loadString("desIndex", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (sourceIndex == targetIndex) {
            bl = true;
        } else {
            bl = Layer3DsNative.jni_MoveTo(this.getHandle(), sourceIndex, targetIndex);
            if (bl) {
                Layer3D layer3D = this.m_layer3Ds.remove(sourceIndex);
                this.m_layer3Ds.add(targetIndex, layer3D);
            }
        }
        return bl;
    }

    private Layer3D findSameNameLayer(Layer3D currentLayer, String findName) {
        return currentLayer;
    }

    ArrayList getLayersList() {
        return this.m_layer3Ds;
    }

    Scene getScene() {
        return this.m_scene;
    }

    protected void clearHandle() {
        if (this.m_layer3Ds != null) {
            int n = this.m_layer3Ds.size();
            for (int i = 0; i < n; ++i) {
                Layer3D layer3D = this.m_layer3Ds.get(i);
                if (layer3D == null) continue;
                layer3D.clearHandle();
            }
            this.m_layer3Ds.clear();
            this.m_layer3Ds = null;
        }
        this.m_scene = null;
        this.setHandle(0L);
    }

    protected static Layer3Ds createInstance(long handle, Scene scene) {
        return new Layer3Ds(handle, scene);
    }

    protected boolean checkDataNameAndType(String dataName, Layer3DType type, String password) {
        if (type.equals((Object)Layer3DType.DATASET)) {
            return false;
        }
        if (type.equals((Object)Layer3DType.DYNAMICMODEL)) {
            return true;
        }
        boolean bl = false;
        int n = type.value();
        bl = Layer3DsNative.jni_CheckDataNameAndType(this.getHandle(), dataName, n, password);
        return bl;
    }

    protected void removeLayerForMove(Layer3D layer) {
        if (this.getHandle() == 0L || this.m_scene.getLayers() == null) {
            return;
        }
        if (layer == null) {
            return;
        }
        long l = InternalHandle.getHandle((InternalHandle)layer);
        if (l == 0L) {
            return;
        }
        int n = this.m_layer3Ds.indexOf((Object)layer);
        if (n >= 0) {
            String string = layer.getName();
            if (Layer3DsNative.jni_Remove(this.getHandle(), l)) {
                this.m_layer3Ds.remove((Object)layer);
                boolean bl = layer instanceof Layer3DGroup;
                Layer3DRemovedEvent layer3DRemovedEvent = new Layer3DRemovedEvent((Object)this, layer, string, n, null, bl);
                this.fireLayer3DRemoved(layer3DRemovedEvent);
            }
        }
    }

    void moveBackLayerFromGroup(int index, Layer3D layer) {
        if (this.getHandle() == 0L || this.m_scene.getLayers() == null) {
            return;
        }
        if (layer == null) {
            return;
        }
        long l = InternalHandle.getHandle((InternalHandle)layer);
        if (l == 0L) {
            return;
        }
        boolean bl = layer instanceof Layer3DGroup;
        if (index >= 0 && index < Layer3DsNative.jni_GetCount(this.getHandle())) {
            Layer3DsNative.jni_InsertBefore(this.getHandle(), index, l);
            this.m_layer3Ds.add(index, layer);
        } else {
            Layer3DsNative.jni_Add(this.getHandle(), l);
            this.m_layer3Ds.add(layer);
            index = this.m_layer3Ds.size() - 1;
        }
        Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer, index, null, bl);
        this.fireLayer3DAdded(layer3DAddedEvent);
    }

    private void verifyLicense() {
        int n = this.m_scene.getLicense().verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public synchronized void addLayer3DAddedListener(Layer3DAddedListener l) {
        if (this.m_layerAddedListeners == null) {
            this.m_layerAddedListeners = new Vector();
        }
        if (!this.m_layerAddedListeners.contains(l)) {
            this.m_layerAddedListeners.add(l);
        }
    }

    public synchronized void removeLayer3DAddedListener(Layer3DAddedListener l) {
        if (this.m_layerAddedListeners != null && this.m_layerAddedListeners.contains(l)) {
            this.m_layerAddedListeners.remove(l);
        }
    }

    protected void fireLayer3DAdded(Layer3DAddedEvent event) {
        if (this.m_layerAddedListeners != null) {
            Vector vector = this.m_layerAddedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((Layer3DAddedListener)vector.elementAt(i)).layer3DAdded(event);
            }
        }
    }

    public synchronized void addLayer3DRemovedListener(Layer3DRemovedListener l) {
        if (this.m_layerRemovedListeners == null) {
            this.m_layerRemovedListeners = new Vector();
        }
        if (!this.m_layerRemovedListeners.contains(l)) {
            this.m_layerRemovedListeners.add(l);
        }
    }

    public synchronized void removeLayer3DRemovedListener(Layer3DRemovedListener l) {
        if (this.m_layerRemovedListeners != null && this.m_layerRemovedListeners.contains(l)) {
            this.m_layerRemovedListeners.remove(l);
        }
    }

    protected void fireLayer3DRemoved(Layer3DRemovedEvent event) {
        if (this.m_layerRemovedListeners != null) {
            Vector vector = this.m_layerRemovedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((Layer3DRemovedListener)vector.elementAt(i)).layer3DRemoved(event);
            }
        }
    }

    public synchronized void addLayer3DCaptionChangedListener(Layer3DCaptionChangedListener l) {
        if (this.m_layer3DCaptionChangedListeners == null) {
            this.m_layer3DCaptionChangedListeners = new Vector();
        }
        if (!this.m_layer3DCaptionChangedListeners.contains(l)) {
            this.m_layer3DCaptionChangedListeners.add(l);
        }
    }

    public synchronized void removeLayer3DCaptionChangedListener(Layer3DCaptionChangedListener l) {
        if (this.m_layer3DCaptionChangedListeners != null && this.m_layer3DCaptionChangedListeners.contains(l)) {
            this.m_layer3DCaptionChangedListeners.remove(l);
        }
    }

    protected void fireLyer3DCaptionChanged(Layer3DCaptionChangedEvent event) {
        if (this.m_layer3DCaptionChangedListeners != null) {
            Vector<Layer3DCaptionChangedListener> vector = this.m_layer3DCaptionChangedListeners;
            int n = this.m_layer3DCaptionChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).Layer3DCaptionChanged(event);
            }
        }
    }

    public synchronized void addLayer3DSelectableChangedListener(Layer3DSelectableChangedListener l) {
        if (this.m_layer3DSelectableChangedListeners == null) {
            this.m_layer3DSelectableChangedListeners = new Vector();
        }
        if (!this.m_layer3DSelectableChangedListeners.contains(l)) {
            this.m_layer3DSelectableChangedListeners.add(l);
        }
    }

    public synchronized void removeLayer3DSelectableChangedListener(Layer3DSelectableChangedListener l) {
        if (this.m_layer3DSelectableChangedListeners != null && this.m_layer3DSelectableChangedListeners.contains(l)) {
            this.m_layer3DSelectableChangedListeners.remove(l);
        }
    }

    protected void fireLyer3DSelectableChanged(Layer3DSelectableChangedEvent event) {
        if (this.m_layer3DSelectableChangedListeners != null) {
            Vector<Layer3DSelectableChangedListener> vector = this.m_layer3DSelectableChangedListeners;
            int n = this.m_layer3DSelectableChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).layer3DSelectableChanged(event);
            }
        }
    }

    public synchronized void addLayer3DEditableChangedListener(Layer3DEditableChangedListener l) {
        if (this.m_layer3DEditableChangedListeners == null) {
            this.m_layer3DEditableChangedListeners = new Vector();
        }
        if (!this.m_layer3DEditableChangedListeners.contains(l)) {
            this.m_layer3DEditableChangedListeners.add(l);
        }
    }

    public synchronized void removeLayer3DEditableChangedListener(Layer3DEditableChangedListener l) {
        if (this.m_layer3DEditableChangedListeners != null && this.m_layer3DEditableChangedListeners.contains(l)) {
            this.m_layer3DEditableChangedListeners.remove(l);
        }
    }

    protected void fireLyer3DEditableChanged(Layer3DEditableChangedEvent event) {
        if (this.m_layer3DEditableChangedListeners != null) {
            Vector<Layer3DEditableChangedListener> vector = this.m_layer3DEditableChangedListeners;
            int n = this.m_layer3DEditableChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).Layer3DEditableChanged(event);
            }
        }
    }

    public synchronized void addLayer3DVisibleChangedListener(Layer3DVisibleChangedListener l) {
        if (this.m_layer3DVisibleChangedListeners == null) {
            this.m_layer3DVisibleChangedListeners = new Vector();
        }
        if (!this.m_layer3DVisibleChangedListeners.contains(l)) {
            this.m_layer3DVisibleChangedListeners.add(l);
        }
    }

    public synchronized void removeLayer3DVisibleChangedListener(Layer3DVisibleChangedListener l) {
        if (this.m_layer3DVisibleChangedListeners != null && this.m_layer3DVisibleChangedListeners.contains(l)) {
            this.m_layer3DVisibleChangedListeners.remove(l);
        }
    }

    protected void fireLyer3DVisibleChanged(Layer3DVisibleChangedEvent event) {
        if (this.m_layer3DVisibleChangedListeners != null) {
            Vector<Layer3DVisibleChangedListener> vector = this.m_layer3DVisibleChangedListeners;
            int n = this.m_layer3DVisibleChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).layer3DVisibleChanged(event);
            }
        }
    }

    public synchronized void addLayer3DAlwaysRenderChangedListener(Layer3DAlwaysRenderChangedListener l) {
        if (this.m_layer3DAlwaysRenderChangedListeners == null) {
            this.m_layer3DAlwaysRenderChangedListeners = new Vector();
        }
        if (!this.m_layer3DAlwaysRenderChangedListeners.contains(l)) {
            this.m_layer3DAlwaysRenderChangedListeners.add(l);
        }
    }

    public synchronized void removeLayer3DAlwaysRenderChangedListener(Layer3DAlwaysRenderChangedListener l) {
        if (this.m_layer3DAlwaysRenderChangedListeners != null && this.m_layer3DAlwaysRenderChangedListeners.contains(l)) {
            this.m_layer3DAlwaysRenderChangedListeners.remove(l);
        }
    }

    protected void fireLayer3DAlwaysRenderChanged(Layer3DAlwaysRenderChangedEvent event) {
        if (this.m_layer3DAlwaysRenderChangedListeners != null) {
            Vector<Layer3DAlwaysRenderChangedListener> vector = this.m_layer3DAlwaysRenderChangedListeners;
            int n = this.m_layer3DAlwaysRenderChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).layer3DAlwaysRenderChanged(event);
            }
        }
    }

    private void internalInsert(int index, Layer3D layer) {
        if (layer.getParentGroup() != null) {
            Layer3DGroup layer3DGroup = layer.getParentGroup();
            layer3DGroup.moveout(layer, false);
        }
        layer.setParentGroup(null);
        layer.setLayers(this);
        if (index < 0) {
            index = 0;
        }
        Layer3DsNative.jni_TreeAddLayer(this.getHandle(), index, InternalHandle.getHandle((InternalHandle)layer));
        if (index >= this.m_layer3Ds.size()) {
            this.m_layer3Ds.add(layer);
        } else {
            this.m_layer3Ds.add(index, layer);
        }
        boolean bl = layer instanceof Layer3DGroup;
        Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer, index, null, bl);
        this.fireLayer3DAdded(layer3DAddedEvent);
    }
}

