/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.AltitudeMode;
import com.supermap.data.Toolkit;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalToolkitSpace;

public class Camera {
    private double m_altitude;
    private double m_heading;
    private double m_latitude;
    private double m_longitude;
    private double m_tilt;
    private AltitudeMode m_mode = AltitudeMode.RELATIVE_TO_GROUND;
    private static final double DTOR = Math.PI / 180;
    private static final double RTOD = 57.29577951308232;
    private static final double GLOBAL_RADIUS = 6378137.0;

    public Camera() {
    }

    public Camera(Camera camera) {
        this(camera.getLongitude(), camera.getLatitude(), camera.getAltitude(), camera.getAltitudeMode(), camera.getHeading(), camera.getTilt());
    }

    public Camera(double longitude, double latitude, double altitude) {
        this(longitude, latitude, altitude, AltitudeMode.ABSOLUTE, 0.0, 0.0);
    }

    public Camera(double longitude, double latitude, double altitude, AltitudeMode altitudeMode, double heading, double tilt) {
        this.m_altitude = altitude;
        this.m_latitude = latitude;
        this.m_heading = heading;
        this.m_tilt = tilt;
        this.m_longitude = longitude;
        this.m_mode = altitudeMode;
    }

    public static Camera getEMPTY() {
        return new Camera(InternalToolkitSpace.DBL_MIN_VALUE, InternalToolkitSpace.DBL_MIN_VALUE, InternalToolkitSpace.DBL_MIN_VALUE, AltitudeMode.ABSOLUTE, InternalToolkitSpace.DBL_MIN_VALUE, InternalToolkitSpace.DBL_MIN_VALUE);
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (InternalToolkitSpace.isZero((double)(this.m_altitude - InternalToolkitSpace.DBL_MIN_VALUE), (double)-1.0E-10, (double)1.0E-10)) {
            bl = true;
        }
        return bl;
    }

    public double getAltitude() {
        return this.m_altitude;
    }

    public void setAltitude(double value) {
        this.m_altitude = value;
    }

    public double getHeading() {
        return this.m_heading;
    }

    public void setHeading(double value) {
        if (value < 0.0 || value > 360.0) {
            String string = InternalResource.loadString("value", "Camera_HeadingOutOfRange", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_heading = value;
    }

    public double getLatitude() {
        return this.m_latitude;
    }

    public void setLatitude(double value) {
        if (value < -90.0 || value > 90.0) {
            String string = InternalResource.loadString("value", "Camera_LatitudeOutOfRange", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_latitude = value;
    }

    public double getLongitude() {
        return this.m_longitude;
    }

    public void setLongitude(double value) {
        if (value < -180.0 || value > 180.0) {
            String string = InternalResource.loadString("value", "Camera_LongitudeOutOfRange", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_longitude = value;
    }

    public double getTilt() {
        return this.m_tilt;
    }

    public void setTilt(double value) {
        if (value < -180.0 || value > 180.0) {
            String string = InternalResource.loadString("value", "Camera_TiltOutOfRange", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_tilt = value;
    }

    public AltitudeMode getAltitudeMode() {
        return this.m_mode;
    }

    public void setAltitudeMode(AltitudeMode value) {
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_mode = value;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Altitude=");
        stringBuffer.append(this.getAltitude());
        stringBuffer.append(",Heading=");
        stringBuffer.append(this.getHeading());
        stringBuffer.append(",Latitude=");
        stringBuffer.append(this.getLatitude());
        stringBuffer.append(",Longitude=");
        stringBuffer.append(this.getLongitude());
        stringBuffer.append(",Tilt=");
        stringBuffer.append(this.getTilt());
        stringBuffer.append(",AltitudeMode=");
        stringBuffer.append(this.getAltitudeMode());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Camera clone() {
        return new Camera(this);
    }

    public boolean cameraEquals(Camera camera) {
        if (camera == null) {
            return false;
        }
        return Toolkit.isZero((double)(this.m_tilt - camera.getTilt())) && Toolkit.isZero((double)(this.m_altitude - camera.getAltitude())) && Toolkit.isZero((double)(this.m_latitude - camera.getLatitude())) && Toolkit.isZero((double)(this.m_longitude - camera.getLongitude())) && Toolkit.isZero((double)(this.m_heading - camera.getHeading()));
    }

    static double computeDistance(double altitude, double tilt) {
        double d = Math.PI - tilt * (Math.PI / 180);
        double d2 = 4.0680631590769E13;
        double d3 = Math.cos(d);
        double d4 = d3 * d3;
        double d5 = d2 * (d4 - 1.0) + (6378137.0 + altitude) * (6378137.0 + altitude);
        double d6 = Math.sqrt(d5);
        double d7 = 6378137.0 * (1.0 + d3) + d6 - 6378137.0;
        return d7;
    }

    static double computeAltitude(double distance, double tilt) {
        double d = Math.PI - tilt * (Math.PI / 180);
        double d2 = 4.0680631590769E13;
        double d3 = Math.cos(d);
        double d4 = d3 * d3;
        double d5 = distance + 6378137.0 - 6378137.0 * (1.0 + d3);
        double d6 = Math.sqrt(d5 * d5 - d2 * (d4 - 1.0)) - 6378137.0;
        return d6;
    }
}

