/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.chart.conversion;

import com.supermap.chart.conversion.FileTypeChart;
import com.supermap.chart.conversion.ImportSettingChartNative;
import com.supermap.chart.conversion.InternalDatasourceConnectionInfo;
import com.supermap.chart.conversion.InternalEnum;
import com.supermap.chart.conversion.InternalPrjCoordSys;
import com.supermap.chart.conversion.InternalResource;
import com.supermap.data.DatasetGroup;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EncodeType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSys;
import java.io.File;
import java.util.ArrayList;

public abstract class ImportSettingChart
extends InternalHandleDisposable {
    private DatasourceConnectionInfo m_datasourceConnectionInfo;
    private PrjCoordSys m_prjCoordSys;
    private ArrayList<Boolean> m_states;
    private Datasource m_datasource;
    private boolean m_bConvertToMercator = false;
    private DatasetGroup m_datasetGroup;

    protected ImportSettingChart() {
    }

    public String getSourceFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingChartNative.jni_GetSourceFilePath(this.getHandle());
    }

    public void setSourceFilePath(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSourceFilePath(String path)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (path == null || path.trim().length() == 0) {
            String string = InternalResource.loadString("path", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(path);
        if (!file.exists()) {
            String string = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingChartNative.jni_SetSourceFilePath(this.getHandle(), file.getPath());
    }

    public FileTypeChart getSourceFileTypeChart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFileTypeChart()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingChartNative.jni_GetSourceFileType(this.getHandle());
        return (FileTypeChart)InternalEnum.parseUGCValue(FileTypeChart.class, n);
    }

    public DatasourceConnectionInfo getTargetDatasourceConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasourceConnectionInfo()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasourceConnectionInfo;
    }

    public void setTargetDatasourceConnectionInfo(DatasourceConnectionInfo datasourceConnectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasourceConnectionInfo()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (datasourceConnectionInfo == null) {
            if (this.m_datasourceConnectionInfo != null) {
                InternalDatasourceConnectionInfo.clearHandle(this.m_datasourceConnectionInfo);
                this.m_datasourceConnectionInfo = null;
            }
        } else {
            long l = InternalHandle.getHandle((InternalHandle)datasourceConnectionInfo);
            if (l == 0L) {
                String string = InternalResource.loadString("setTargetDatasourceConnectionInfo(DatasourceConnectionInfo connectionInfo)", "Datasources_ConnectionInfoIsInvalid", "conversion_resources");
                throw new IllegalStateException(string);
            }
            this.m_datasourceConnectionInfo = this.cloneDatasourceConnectionInfo(datasourceConnectionInfo);
            this.setTargetDatasource(null);
            this.setTargetDatasetGroup(null);
        }
    }

    public Datasource getTargetDatasource() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasource()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasource;
    }

    public void setTargetDatasource(Datasource datasource) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasource(Datasource datasource)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_datasource = datasource;
        if (this.m_datasource != null) {
            this.setTargetDatasourceConnectionInfo(null);
            this.setTargetDatasetGroup(null);
        }
    }

    public DatasetGroup getTargetDatasetGroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasetGroup()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasetGroup;
    }

    public void setTargetDatasetGroup(DatasetGroup datasetGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasetGroup(DatasetGroup datasetGroup)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_datasetGroup = datasetGroup;
        if (this.m_datasetGroup != null) {
            this.setTargetDatasourceConnectionInfo(null);
            this.setTargetDatasource(null);
        }
    }

    public EncodeType getTargetEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetEncodeType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingChartNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)InternalEnum.parseUGCValue(EncodeType.class, n);
    }

    public void setTargetEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetEncodeType(EncodeType encodeType )", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingChartNative.jni_SetEncodeType(this.getHandle(), encodeType.value());
    }

    protected void clearHandle() {
        if (this.m_prjCoordSys != null) {
            InternalPrjCoordSys.clearHandle(this.m_prjCoordSys);
            this.m_prjCoordSys = null;
        }
        this.m_datasourceConnectionInfo = null;
        this.setHandle(0L);
    }

    protected DatasourceConnectionInfo cloneDatasourceConnectionInfo(DatasourceConnectionInfo connectionInfo) {
        long l = InternalHandle.getHandle((InternalHandle)connectionInfo);
        long l2 = ImportSettingChartNative.jni_CloneDatasourceConnectionInfo(l);
        DatasourceConnectionInfo datasourceConnectionInfo = InternalDatasourceConnectionInfo.createInstance(l2);
        InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)datasourceConnectionInfo, (boolean)true);
        return datasourceConnectionInfo;
    }

    ArrayList<Boolean> getStates() {
        return this.m_states;
    }

    void setStates(ArrayList<Boolean> states) {
        this.m_states = states;
    }

    public boolean isConvertToMercator() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isConvertToMercator()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_bConvertToMercator = ImportSettingChartNative.jni_IsConvertToMercator(this.getHandle());
        return this.m_bConvertToMercator;
    }

    public void setConvertToMercator(boolean value) {
        this.m_bConvertToMercator = value;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setConvertToMercator(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingChartNative.jni_SetConvertToMercator(this.getHandle(), value);
    }
}

