/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.bslicense.util;

import com.supermap.bslicense.util.AesUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.util.IPAddressUtil;

public final class Tool {
    public static final String DEFAULT_IPV4_ADDRESS = "127.0.0.1";
    private static final Logger locLogger = LoggerFactory.getLogger(AesUtil.class);
    private static InetAddress inetAddress;
    private static String localIP;
    private static String hostName;
    private static final String NETWORK_CARK_INITIAL_SYMBOL = "%";
    private static final String NETNODE_DIVISION_SYMBOL = ":";
    public static final String DEFAULT_IPV6_ADDRESS = "0:0:0:0:0:0:0:1";

    private Tool() {
    }

    public static String getHostName() {
        return hostName;
    }

    public static String doGetHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return Tool.getHostNameFromEnv();
        }
        catch (RuntimeException e) {
            return Tool.getHostNameFromEnv();
        }
    }

    public static String getHostNameFromEnv() {
        String result = System.getenv("COMPUTERNAME");
        if (StringUtils.isEmpty((CharSequence)result)) {
            try {
                Process processHN = Runtime.getRuntime().exec("hostname");
                BufferedReader bufReaderHN = new BufferedReader(new InputStreamReader(processHN.getInputStream()));
                String line = null;
                while ((line = bufReaderHN.readLine()) != null) {
                    result = line;
                }
                processHN.destroy();
                bufReaderHN.close();
            }
            catch (IOException e) {
                locLogger.error(e.getMessage(), (Throwable)e);
            }
        }
        return StringUtils.isEmpty((CharSequence)result) ? "UnknownHost" + System.identityHashCode(System.class) : result;
    }

    public static String getLocalHostIP() {
        String serverAddress;
        if (localIP != null) {
            return localIP;
        }
        String defaultAddress = DEFAULT_IPV4_ADDRESS;
        InetAddress tempInetAddress = Tool.getLocalNetAddress();
        if (tempInetAddress != null) {
            serverAddress = tempInetAddress.getHostAddress();
        } else {
            try {
                serverAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                serverAddress = defaultAddress;
            }
        }
        if (StringUtils.isBlank((CharSequence)serverAddress)) {
            serverAddress = defaultAddress;
        }
        localIP = Tool.isIPV6(serverAddress) ? Tool.updateIPV6Address(serverAddress) : serverAddress;
        return serverAddress;
    }

    public static String updateIPV6Address(String ip) {
        if (IPAddressUtil.isIPv6LiteralAddress(ip)) {
            StringBuilder resultIP = new StringBuilder();
            String tempIp = ip.contains(NETWORK_CARK_INITIAL_SYMBOL) ? ip.substring(0, ip.indexOf(NETWORK_CARK_INITIAL_SYMBOL)) : ip;
            String[] nodes = tempIp.split(NETNODE_DIVISION_SYMBOL);
            boolean isClearContinueZeroNode = true;
            for (int i = 0; i < nodes.length; ++i) {
                int j;
                if (i == nodes.length - 1) {
                    resultIP.append(nodes[i]);
                    continue;
                }
                if (!nodes[i].equals("0") || !isClearContinueZeroNode) {
                    resultIP.append(nodes[i]).append(NETNODE_DIVISION_SYMBOL);
                    continue;
                }
                int tep = i;
                if (!nodes[++tep].equals("0")) {
                    resultIP.append(nodes[i]).append(NETNODE_DIVISION_SYMBOL);
                    continue;
                }
                for (j = i + 1; j < nodes.length && nodes[j].equals("0"); ++j) {
                }
                if (i == 0) {
                    resultIP.append(NETNODE_DIVISION_SYMBOL).append(NETNODE_DIVISION_SYMBOL);
                } else {
                    resultIP.append(NETNODE_DIVISION_SYMBOL);
                }
                i = j - 1;
                isClearContinueZeroNode = false;
            }
            return resultIP.toString();
        }
        return ip;
    }

    public static boolean isIPV6(String ip) {
        int index;
        if (StringUtils.isBlank((CharSequence)ip)) {
            return false;
        }
        return ip.length() > 0 && ip.charAt(0) == '[' && (index = ip.indexOf(93)) > 2 ? IPAddressUtil.isIPv6LiteralAddress(ip.substring(1, index)) : IPAddressUtil.isIPv6LiteralAddress(ip);
    }

    public static InetAddress getLocalNetAddress() {
        if (inetAddress != null) {
            return inetAddress;
        }
        InetAddress local = null;
        try {
            local = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e1) {
            locLogger.warn("Tool.getLocalHost.UnknownHostException", (Throwable)e1);
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface interfaceN = interfaces.nextElement();
                String netName = interfaceN.getName();
                String displayName = interfaceN.getDisplayName();
                if (netName.contains("docker") || netName.startsWith("br-") || netName.startsWith("cni") || netName.startsWith("tun") || netName.startsWith("kube-") || displayName.contains("Tunneling Adapter") || displayName.contains("ISATAP Adapter")) continue;
                displayName = displayName.toLowerCase();
                if (interfaceN.isLoopback() || interfaceN.isVirtual() || !interfaceN.isUp() || interfaceN.isPointToPoint() || displayName.indexOf("vpn") != -1 || displayName.indexOf("wifi") != -1) continue;
                Enumeration<InetAddress> ienum = interfaceN.getInetAddresses();
                while (ienum.hasMoreElements()) {
                    InetAddress ia = ienum.nextElement();
                    String hostAddress = ia.getHostAddress();
                    if (hostAddress.equals(DEFAULT_IPV6_ADDRESS) || Tool.isIPV6(hostAddress) || IPAddressUtil.isIPv4LiteralAddress(hostAddress) && hostAddress.startsWith("127") && hostAddress.indexOf(58) == -1) continue;
                    inetAddress = ia;
                    return ia;
                }
            }
        }
        catch (Exception e) {
            return inetAddress != null ? inetAddress : local;
        }
        return inetAddress != null ? inetAddress : local;
    }

    public static String getLocalMACAddr() {
        String addr = "";
        byte[] macAddr = null;
        char[] macChars = null;
        try {
            NetworkInterface netInterface = NetworkInterface.getByInetAddress(Tool.getLocalNetAddress());
            macAddr = netInterface.getHardwareAddress();
            if (macAddr != null) {
                macChars = Hex.encodeHex((byte[])macAddr);
            }
        }
        catch (Exception e) {
            locLogger.warn(e.getMessage(), (Throwable)e);
        }
        for (int i = 1; macChars != null && i <= macChars.length; ++i) {
            addr = addr + macChars[i - 1];
            if (i % 2 != 0 || i >= macChars.length) continue;
            addr = SystemUtils.IS_OS_WINDOWS ? addr + "-" : addr + NETNODE_DIVISION_SYMBOL;
        }
        return addr;
    }

    static {
        localIP = null;
        hostName = Tool.doGetHostName();
    }
}

