/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.plot;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.GeoGraphicObject;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.GraphicObjectType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Recordset;
import com.supermap.plot.InternalPlotEnvironment;
import com.supermap.plot.InternalToolkitPlot;
import com.supermap.plot.SymbolInfo;
import com.supermap.plot.SymbolLibManagerNative;
import com.supermap.plot.SymbolLibrary;
import java.io.File;
import java.util.ArrayList;

public class SymbolLibManager
extends InternalHandleDisposable {
    private static License m_license;
    private static License m_mLicense;

    public void dispose() {
    }

    public static boolean IsJBSymbolLib(String symbolPath) {
        return SymbolLibManagerNative.jni_IsJBSymbolLib(symbolPath);
    }

    public static int AddSymbolLib(String symbolPath) {
        SymbolLibManager.verifyLicense();
        if (!new File(symbolPath).exists()) {
            return -1;
        }
        if (SymbolLibManager.IsJBSymbolLib(symbolPath)) {
            if (SymbolLibManager.verifyMLicense()) {
                return SymbolLibManagerNative.jni_AddSymbolLib(symbolPath);
            }
            return -1;
        }
        return SymbolLibManagerNative.jni_AddSymbolLib(symbolPath);
    }

    public static void CloseSymbolLib(int libID) {
        SymbolLibManagerNative.jni_CloseSymbolLib(libID);
    }

    public static void AddModelLib(String modelPath) {
        SymbolLibManager.verifyLicense();
        SymbolLibManagerNative.jni_AddModelLib(modelPath);
    }

    public static int getLibCount() {
        return SymbolLibManagerNative.jni_GetCount();
    }

    public static SymbolLibrary getSymbolLibrary(int libID) {
        long l = SymbolLibManagerNative.jni_GetLibrary(libID);
        if (l == 0L) {
            return null;
        }
        return new SymbolLibrary(l);
    }

    public static Boolean isSymbolLibraryExist(int libID) {
        long l = SymbolLibManagerNative.jni_GetLibrary(libID);
        if (l == 0L) {
            return false;
        }
        return true;
    }

    public static int[] getAllLibraryId() {
        int n = SymbolLibManagerNative.jni_GetCount();
        int[] nArray = new int[n];
        SymbolLibManagerNative.jni_GetLibraryId(nArray);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyMLicense() {
        if (m_mLicense == null) {
            return false;
        }
        int n = -1;
        License license = m_mLicense;
        synchronized (license) {
            n = m_mLicense.verify();
        }
        return n == 0;
    }

    public static GraphicObjectType getSymbolType(int libId, int code) {
        int n = SymbolLibManagerNative.jni_GetSymbolType(libId, code);
        GraphicObjectType graphicObjectType = new GraphicObjectType(n, n);
        return graphicObjectType;
    }

    public static int getSymbolMaxEidtPts(int libId, int code) {
        return SymbolLibManagerNative.jni_GetSymbolMaxEidtPts(libId, code);
    }

    public static int getSymbolMinEidtPts(int libId, int code) {
        return SymbolLibManagerNative.jni_GetSymbolMinEidtPts(libId, code);
    }

    public static String getSymbolName(int libId, int code) {
        return SymbolLibManagerNative.jni_GetSymbolName(libId, code);
    }

    public static ArrayList<SymbolInfo> querySymbol(String strkey) {
        ArrayList<SymbolInfo> arrayList = new ArrayList<SymbolInfo>();
        int[] nArray = SymbolLibManager.getAllLibraryId();
        for (int i = 0; i < nArray.length; ++i) {
            SymbolLibrary symbolLibrary = SymbolLibManager.getSymbolLibrary(nArray[i]);
            if (null == symbolLibrary) continue;
            SymbolInfo[] symbolInfoArray = symbolLibrary.querySymbol(strkey);
            for (int j = 0; j < symbolInfoArray.length; ++j) {
                arrayList.add(symbolInfoArray[j]);
            }
        }
        return arrayList;
    }

    public static void createSymbolLib(int libID, String libName) {
        SymbolLibManagerNative.jni_CreateSymbolLib(libID, libName);
    }

    public static void symbolCentral(Recordset rec) {
        ArrayList<GeoGraphicObject> arrayList = SymbolLibManager.getCells(rec);
        int n = arrayList.size();
        if (n == arrayList.size()) {
            return;
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            GeoGraphicObject geoGraphicObject = arrayList.get(i);
            lArray[i] = InternalHandle.getHandle((InternalHandle)geoGraphicObject);
        }
        long[] lArray2 = new long[n];
        SymbolLibManagerNative.jni_SymbolCentral(lArray, lArray2);
        arrayList.clear();
        for (int i = 0; i < n; ++i) {
            GeoGraphicObject geoGraphicObject = new GeoGraphicObject();
            InternalHandle.setHandle((InternalHandle)geoGraphicObject, (long)lArray2[i]);
            arrayList.add(geoGraphicObject);
        }
        SymbolLibManager.updateModify(rec, arrayList);
    }

    public static void resetSymbolSize(Recordset rec, double size) {
        ArrayList<GeoGraphicObject> arrayList = SymbolLibManager.getCells(rec);
        int n = arrayList.size();
        if (n == arrayList.size()) {
            return;
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            GeoGraphicObject geoGraphicObject = arrayList.get(i);
            lArray[i] = InternalHandle.getHandle((InternalHandle)geoGraphicObject);
        }
        long[] lArray2 = new long[n];
        SymbolLibManagerNative.jni_ResetSymbolSize(lArray, size, lArray2);
        arrayList.clear();
        for (int i = 0; i < n; ++i) {
            GeoGraphicObject geoGraphicObject = new GeoGraphicObject();
            InternalHandle.setHandle((InternalHandle)geoGraphicObject, (long)lArray2[i]);
            arrayList.add(geoGraphicObject);
        }
        SymbolLibManager.updateModify(rec, arrayList);
    }

    public static void centralAndResetSymbolSize(Recordset rec, double size) {
        ArrayList<GeoGraphicObject> arrayList = SymbolLibManager.getCells(rec);
        int n = arrayList.size();
        if (n == arrayList.size()) {
            return;
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            GeoGraphicObject geoGraphicObject = arrayList.get(i);
            lArray[i] = InternalHandle.getHandle((InternalHandle)geoGraphicObject);
        }
        long[] lArray2 = new long[n];
        SymbolLibManagerNative.jni_CentralAndResetSymbolSize(lArray, size, lArray2);
        arrayList.clear();
        for (int i = 0; i < n; ++i) {
            GeoGraphicObject geoGraphicObject = new GeoGraphicObject();
            InternalHandle.setHandle((InternalHandle)geoGraphicObject, (long)lArray2[i]);
            arrayList.add(geoGraphicObject);
        }
        SymbolLibManager.updateModify(rec, arrayList);
    }

    private static ArrayList<GeoGraphicObject> getCells(Recordset rec) {
        ArrayList<GeoGraphicObject> arrayList = new ArrayList<GeoGraphicObject>();
        if (null == rec) {
            return arrayList;
        }
        if (0 == rec.getRecordCount()) {
            return arrayList;
        }
        boolean bl = rec.moveFirst();
        while (bl) {
            GeoGraphicObject geoGraphicObject;
            Geometry geometry = rec.getGeometry();
            if (null != geometry && geometry.getType() == GeometryType.GRAPHICOBJECT && null != (geoGraphicObject = (GeoGraphicObject)geometry)) {
                arrayList.add(geoGraphicObject);
            }
            bl = rec.moveNext();
        }
        return arrayList;
    }

    private static void updateModify(Recordset rec, ArrayList<GeoGraphicObject> arrCells) {
        if (null == rec || null == arrCells) {
            return;
        }
        int n = arrCells.size();
        if (0 == n) {
            return;
        }
        boolean bl = rec.moveFirst();
        while (bl) {
            Geometry geometry = rec.getGeometry();
            if (null != geometry) {
                for (int i = 0; i < n; ++i) {
                    if (geometry.getID() != arrCells.get(i).getID()) continue;
                    rec.setGeometry((Geometry)arrCells.get(i));
                    rec.update();
                    break;
                }
            }
            bl = rec.moveNext();
        }
    }

    static {
        InternalPlotEnvironment.LoadWrapJ();
        ArrayList<ProductType> arrayList = InternalToolkitPlot.managerProducts(InternalToolkitPlot.getPlot3DProducts());
        m_license = InternalToolkitPlot.verifyLicense(arrayList);
        ArrayList<ProductType> arrayList2 = InternalToolkitPlot.getJSProducts();
        m_mLicense = InternalToolkitPlot.verifyMLicense(arrayList2);
    }
}

