/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialstatistics.GWRAnalystResult;
import com.supermap.analyst.spatialstatistics.GWRParameter;
import com.supermap.analyst.spatialstatistics.GWRSummary;
import com.supermap.analyst.spatialstatistics.InternalDatasetVector;
import com.supermap.analyst.spatialstatistics.InternalDatasets;
import com.supermap.analyst.spatialstatistics.InternalHandle;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.InternalToolkitSpatialStatistics;
import com.supermap.analyst.spatialstatistics.OLSAnalystResult;
import com.supermap.analyst.spatialstatistics.OLSParameter;
import com.supermap.analyst.spatialstatistics.OLSSummary;
import com.supermap.analyst.spatialstatistics.SpatialRelModelingNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class SpatialRelModeling {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private SpatialRelModeling() {
    }

    public static OLSAnalystResult ordinaryLeastSquares(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, OLSParameter olsParameter) {
        SpatialRelModeling.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (olsParameter == null) {
            String string = InternalResource.loadString("olsParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        OLSSummary oLSSummary = new OLSSummary();
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)oLSSummary);
        long[] lArray = new long[1];
        String[] stringArray = new String[1];
        boolean bl = SpatialRelModelingNative.jni_ordinaryLeastSquares(l, l2, targetDatasetName, olsParameter.getModelField(), olsParameter.getExplanatoryFields(), lArray, l3, stringArray);
        OLSAnalystResult oLSAnalystResult = null;
        if (bl) {
            DatasetVector datasetVector = null;
            long l4 = lArray[0];
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                throw new RuntimeException(stringArray[0]);
            }
            oLSAnalystResult = new OLSAnalystResult(oLSSummary, datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return oLSAnalystResult;
    }

    public static GWRAnalystResult geographicWeightedRegression(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, GWRParameter gwrParameter) {
        SpatialRelModeling.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (gwrParameter == null) {
            String string = InternalResource.loadString("gwrParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (gwrParameter.getPredictionDataset() != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)gwrParameter.getPredictionDataset()) != 0L) {
            if (gwrParameter.getTargetPredictedDatasource() == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)gwrParameter.getTargetPredictedDatasource()) == 0L) {
                String string = InternalResource.loadString("gwrParameter.getTargetPredictedDatasource()", "Global_ArgumentNull", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
            if (gwrParameter.getTargetPredictedDatasetName() == null || gwrParameter.getTargetPredictedDatasetName().isEmpty()) {
                String string = InternalResource.loadString("gwrParameter.getTargetPredictedDatasetName()", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
            if (gwrParameter.getTargetPredictedDatasource() == targetDatasource && gwrParameter.getTargetPredictedDatasetName().compareToIgnoreCase(targetDatasetName) == 0) {
                String string = InternalResource.loadString("gwrParameter.getTargetPredictedDatasetName() and targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
            if (!gwrParameter.getTargetPredictedDatasource().getDatasets().isAvailableDatasetName(gwrParameter.getTargetPredictedDatasetName())) {
                String string = InternalResource.loadString("gwrParameter.getTargetPredictedDatasetName()", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)gwrParameter);
        String[] stringArray = new String[1];
        int[] nArray = new int[1];
        double[] dArray = new double[9];
        long[] lArray = new long[2];
        long l4 = 0L;
        long l5 = 0L;
        String string = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (gwrParameter.getPredictionDataset() != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)gwrParameter.getPredictionDataset()) != 0L) {
            l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)gwrParameter.getPredictionDataset());
            l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)gwrParameter.getTargetPredictedDatasource());
            string = gwrParameter.getTargetPredictedDatasetName();
            if (gwrParameter.getExplanatoryFieldsMatching() != null && gwrParameter.getExplanatoryFieldsMatching().size() > 0) {
                Object[] objectArray = gwrParameter.getExplanatoryFieldsMatching().keySet().toArray();
                int n = objectArray.length;
                stringArray2 = new String[n];
                stringArray3 = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray2[i] = (String)objectArray[i];
                    if (stringArray2[i] == null || stringArray2[i].length() == 0) {
                        String string2 = InternalResource.loadString("gwrParameter.getExplanatoryFieldsMatching() key", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
                        throw new IllegalArgumentException(string2);
                    }
                    stringArray3[i] = gwrParameter.getExplanatoryFieldsMatching().get(stringArray2[i]);
                    if (stringArray3[i] != null && stringArray3[i].length() != 0) continue;
                    String string3 = InternalResource.loadString("gwrParameter.getExplanatoryFieldsMatching().get(\"" + stringArray2[i] + "\")", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
                    throw new IllegalArgumentException(string3);
                }
            }
        }
        boolean bl = SpatialRelModelingNative.jni_geographicWeightedRegression(l, l2, targetDatasetName, l3, l4, l5, string, stringArray2, stringArray3, nArray, dArray, lArray, stringArray);
        GWRAnalystResult gWRAnalystResult = null;
        if (bl) {
            GWRSummary gWRSummary = new GWRSummary(nArray[0], dArray);
            DatasetVector datasetVector = null;
            long l6 = lArray[0];
            if (l6 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l6, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                throw new RuntimeException(stringArray[0]);
            }
            DatasetVector datasetVector2 = null;
            l6 = lArray[1];
            if (gwrParameter.getPredictionDataset() != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)gwrParameter.getPredictionDataset()) != 0L) {
                if (l6 != 0L) {
                    datasetVector2 = InternalDatasetVector.createInstance(l6, gwrParameter.getTargetPredictedDatasource());
                    InternalDatasets.add(gwrParameter.getTargetPredictedDatasource().getDatasets(), (Dataset)datasetVector2);
                } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                    throw new RuntimeException(stringArray[0]);
                }
            }
            gWRAnalystResult = new GWRAnalystResult(gWRSummary, datasetVector, datasetVector2);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)l3);
        return gWRAnalystResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "SpatialRelModeling";
        boolean bl = InternalToolkitSpatialStatistics.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SpatialRelModeling.fireStepped(steppedEvent);
        InternalToolkitSpatialStatistics.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialStatistics.managerProducts(InternalToolkitSpatialStatistics.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialStatistics.verifyLicense(arrayList);
    }
}

