/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.SamplingFunctionParameter;
import com.supermap.analyst.spatialstatistics.SamplingFunctionType;
import com.supermap.analyst.spatialstatistics.SamplingParameterNative;

public class SamplingFunctionScaleCParameter
extends SamplingFunctionParameter {
    private double m_dPopulationVariance = 0.0;
    private double m_dAbsoluteError = 0.0;
    private double m_dSignificanceLevel = 0.0;

    private SamplingFunctionScaleCParameter() {
    }

    public SamplingFunctionScaleCParameter(double dPopulationVariance, double dAbsoluteError, double dSignificanceLevel) {
        this.m_FunctionType = SamplingFunctionType.FUNCTIONSCALEC;
        this.setPopulationVariance(dPopulationVariance);
        this.setAbsoluteError(dAbsoluteError);
        this.setSignificanceLevel(dSignificanceLevel);
    }

    public double getPopulationVariance() {
        return this.m_dPopulationVariance;
    }

    public void setPopulationVariance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("PopulationVariance", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dPopulationVariance = value;
    }

    public double getAbsoluteError() {
        return this.m_dAbsoluteError;
    }

    public void setAbsoluteError(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("AbsoluteError", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dAbsoluteError = value;
    }

    public double getSignificanceLevel() {
        return this.m_dSignificanceLevel;
    }

    public void setSignificanceLevel(double value) {
        if (value > 1.0 || value < 0.0) {
            String string = InternalResource.loadString("SignificanceLevel", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dSignificanceLevel = value;
    }

    @Override
    protected void SetSampleParameter(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("SamplingFunctionScaleCParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        SamplingParameterNative.jni_setPopulationVariance(handle, this.m_dPopulationVariance);
        SamplingParameterNative.jni_setAbsoluteError(handle, this.m_dAbsoluteError);
        SamplingParameterNative.jni_setSignificanceLevel(handle, this.m_dSignificanceLevel);
    }
}

