/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.InternalHandle;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.data.DatasetVector;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class AddressLoadSetting {
    private ArrayList<DatasetVector> m_datasets;
    private ArrayList<String> m_fields;
    private ArrayList<String> m_fieldsSave;
    private String m_dictionaryFile;
    private String m_loadDirectory;
    private String m_fieldTopGroup;
    private String m_fieldSecondaryGroup;
    private String m_fieldLowestGroup;
    private double m_dBINDistance;
    private boolean m_bLoadPoint;

    public AddressLoadSetting() {
        this.m_datasets = new ArrayList();
        this.m_fields = new ArrayList();
        this.m_fieldsSave = new ArrayList();
    }

    public AddressLoadSetting(AddressLoadSetting addressLoadSetting) {
        if (addressLoadSetting == null) {
            String string = InternalResource.loadString("addressLoadSetting", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_datasets = new ArrayList();
        this.m_fields = new ArrayList();
        this.m_fieldsSave = new ArrayList();
        this.copyFrom(addressLoadSetting);
    }

    void copyFrom(AddressLoadSetting addressLoadSetting) {
        if (addressLoadSetting != null && !this.equals(addressLoadSetting)) {
            this.m_datasets.clear();
            this.m_fields.clear();
            this.m_fieldsSave.clear();
            DatasetVector[] datasetVectorArray = addressLoadSetting.getDatasets();
            int n = datasetVectorArray.length;
            for (int i = 0; i < n; ++i) {
                this.m_datasets.add(datasetVectorArray[i]);
            }
            String[] stringArray = addressLoadSetting.getIndexFields();
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.m_fields.add(stringArray[i]);
            }
            String[] stringArray2 = addressLoadSetting.getSaveFields();
            n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                this.m_fieldsSave.add(stringArray2[i]);
            }
            this.m_dictionaryFile = addressLoadSetting.m_dictionaryFile;
            this.m_loadDirectory = addressLoadSetting.m_loadDirectory;
            this.m_fieldTopGroup = addressLoadSetting.m_fieldTopGroup;
            this.m_fieldSecondaryGroup = addressLoadSetting.m_fieldSecondaryGroup;
            this.m_fieldLowestGroup = addressLoadSetting.m_fieldLowestGroup;
            this.m_dBINDistance = addressLoadSetting.m_dBINDistance;
            this.m_bLoadPoint = addressLoadSetting.m_bLoadPoint;
        }
    }

    public DatasetVector[] getDatasets() {
        int n = this.m_datasets.size();
        DatasetVector[] datasetVectorArray = new DatasetVector[n];
        for (int i = 0; i < n; ++i) {
            datasetVectorArray[i] = this.m_datasets.get(i);
        }
        return datasetVectorArray;
    }

    @Deprecated
    public String[] getFields() {
        int n = this.m_fields.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_fields.get(i);
        }
        return stringArray;
    }

    public String getDictionaryFile() {
        return this.m_dictionaryFile;
    }

    public void setDictionaryFile(String value) throws FileNotFoundException {
        File file = new File(value);
        if (!file.exists()) {
            String string = InternalResource.loadString("value", "Global_FileNotFound", "addressmatching_resources");
            throw new FileNotFoundException(string);
        }
        this.m_dictionaryFile = value;
    }

    public String getLoadDirectory() {
        return this.m_loadDirectory;
    }

    public void setLoadDirectory(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setLoadDirectory(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_loadDirectory = value;
    }

    public int addDataset(DatasetVector dataset) {
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        int n = this.m_datasets.size();
        for (int i = 0; i < n; ++i) {
            if (!dataset.equals(this.m_datasets.get(i))) continue;
            String string = InternalResource.loadString("dataset:", "AddressMatchSetting_SearchDataAlreadyExist", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_datasets.add(dataset);
        return this.m_datasets.size() - 1;
    }

    @Deprecated
    public int addField(String addressField) {
        if (addressField == null || addressField.trim().length() == 0) {
            String string = InternalResource.loadString("addressField", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_fields.size();
        for (int i = 0; i < n; ++i) {
            if (!addressField.equalsIgnoreCase(this.m_fields.get(i).toString())) continue;
            String string = InternalResource.loadString("addressField:", "AddressMatchSetting_SearchDataAlreadyExist", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_fields.add(addressField);
        return this.m_fields.size() - 1;
    }

    public void clearData() {
        this.m_datasets.clear();
        this.m_fields.clear();
        this.m_fieldsSave.clear();
    }

    public int addIndexField(String indexField) {
        if (indexField == null || indexField.trim().length() == 0) {
            String string = InternalResource.loadString("indexField", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_fields.size();
        for (int i = 0; i < n; ++i) {
            if (!indexField.equalsIgnoreCase(this.m_fields.get(i).toString())) continue;
            String string = InternalResource.loadString("indexField:", "AddressMatchSetting_SearchDataAlreadyExist", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_fields.add(indexField);
        return this.m_fields.size() - 1;
    }

    public String[] getIndexFields() {
        int n = this.m_fields.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_fields.get(i);
        }
        return stringArray;
    }

    public int addSaveField(String saveField) {
        if (saveField == null || saveField.trim().length() == 0) {
            String string = InternalResource.loadString("saveField", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_fieldsSave.size();
        for (int i = 0; i < n; ++i) {
            if (!saveField.equalsIgnoreCase(this.m_fieldsSave.get(i).toString())) continue;
            String string = InternalResource.loadString("saveField:", "AddressMatchSetting_SearchDataAlreadyExist", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_fieldsSave.add(saveField);
        return this.m_fieldsSave.size() - 1;
    }

    public String[] getSaveFields() {
        int n = this.m_fieldsSave.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_fieldsSave.get(i);
        }
        return stringArray;
    }

    public String getTopGroupField() {
        return this.m_fieldTopGroup;
    }

    public void setTopGroupField(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setTopGroupField(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_fieldTopGroup = value;
    }

    public String getSecondaryGroupField() {
        return this.m_fieldSecondaryGroup;
    }

    public void setSecondaryGroupField(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setSecondaryGroupField(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (this.m_fieldTopGroup == null) {
            String string = InternalResource.loadString("setTopGroupField(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_fieldSecondaryGroup = value;
    }

    public String getLowestGroupField() {
        return this.m_fieldLowestGroup;
    }

    public void setLowestGroupField(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setLowestGroupField(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (this.m_fieldSecondaryGroup == null) {
            String string = InternalResource.loadString("setSecondaryGroupField(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_fieldLowestGroup = value;
    }

    public void setBINDistance(Double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("BINDistance", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dBINDistance = value;
    }

    public Double getBINDistance() {
        return this.m_dBINDistance;
    }

    public void setLoadPoint(Boolean value) {
        this.m_bLoadPoint = value;
    }

    public Boolean getLoadPoint() {
        return this.m_bLoadPoint;
    }
}

