/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.iobjects.process.ml.inference;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridInfo;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageInfo;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EngineType;
import com.supermap.data.PixelFormat;
import com.supermap.iobjects.process.ml.inference.MLToolkits;
import com.supermap.jsuperpy.Tile;
import com.supermap.jsuperpy.TileMeta;
import com.supermap.jsuperpy.TileRef;
import com.supermap.jsuperpy.callpy.ProcessTilePipe;
import com.supermap.jsuperpy.callpy.Processes;
import com.supermap.jsuperpy.callpy.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class BinaryClassification {
    public static boolean processBinaryClassify(String inDataPath, String inDatasetName, String modelFile, int offset, String outDataPath, String outDatasetName) throws Exception {
        String pyFileName = "process_binary_classification";
        String pyClassName = MLToolkits.getPyClassName(pyFileName);
        File operatorPyFile = MLToolkits.getOperatorPyFile(pyFileName);
        String inputData = MLToolkits.getStrInputData(inDataPath, inDatasetName);
        HashMap<String, Object> processArgs = new HashMap<String, Object>();
        processArgs.put("InputData", inputData);
        processArgs.put("ModelPath", modelFile);
        processArgs.put("OutData", outDataPath);
        processArgs.put("OutDatasetName", outDatasetName);
        processArgs.put("Offset", offset);
        Map result = Processes.process((File)operatorPyFile, (String)pyClassName, processArgs);
        MLToolkits.getPythonError(result);
        return Boolean.parseBoolean(result.get("result").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processBinaryClassifyTile(String inDataPath, String inDatasetName, String modelFile, int offset, String outDataPath, String outDatasetName) throws Exception {
        boolean isSuccessful = false;
        int numRows = 0;
        int numCols = 0;
        Reader inputStream = null;
        String pyClassName = null;
        String processPyFile = null;
        try {
            inputStream = new FileReader(new File(modelFile));
            Yaml configYaml = new Yaml();
            Map configMap = (Map)configYaml.loadAs(inputStream, Map.class);
            String modelType = (String)configMap.get("model_type");
            String modelTag = (String)configMap.get("model_tag");
            ArrayList modelInput = (ArrayList)configMap.get("model_input");
            Map shapeMap = (Map)modelInput.get(0);
            ArrayList shapeList = (ArrayList)shapeMap.get("shape");
            if (modelType == null || modelTag == null) {
                System.err.println("ModelType or ModelTag is null, please check your sdm file!");
                return;
            }
            if (shapeList.size() != 3) {
                System.err.println("ModelInput's Shape don't fit this feature, please check your sdm file!");
                return;
            }
            numRows = (Integer)shapeList.get(0);
            numCols = (Integer)shapeList.get(1);
            String pyFileName = "process_" + modelType + "_" + modelTag;
            String[] pyFileNameSplit = pyFileName.split("_");
            StringBuilder pyClassNameBuilder = null;
            for (int i = 0; i < pyFileNameSplit.length; ++i) {
                String body = pyFileNameSplit[i].substring(0, 1).toUpperCase() + pyFileNameSplit[i].substring(1);
                if (i == 0) {
                    pyClassNameBuilder = new StringBuilder(body);
                    continue;
                }
                pyClassNameBuilder.append(body);
            }
            pyClassName = pyClassNameBuilder.toString();
            String mlHome = System.getenv("ML_HOME");
            processPyFile = mlHome + File.separator + "process_operator" + File.separator + pyFileName + ".py";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String[] inDataPathSplit = inDataPath.split("\\.");
        String inDataFormat = inDataPathSplit[inDataPathSplit.length - 1].toUpperCase();
        EngineType inEngineType = (EngineType)EngineType.parse(EngineType.class, (String)inDataFormat);
        Datasource inDatasource = new Datasource(inEngineType);
        DatasourceConnectionInfo inConn = new DatasourceConnectionInfo();
        inConn.setServer(inDataPath);
        inConn.setEngineType(inEngineType);
        inDatasource.open(inConn);
        ProcessTilePipe processTilePipe = null;
        Datasource outDatasource = null;
        try {
            TileRef[] tileRefs;
            String outName;
            DatasetImage inDataset = (DatasetImage)inDatasource.getDatasets().get(inDatasetName);
            if (inDataPath.equals(outDataPath)) {
                outName = inDatasource.getDatasets().getAvailableDatasetName(outDatasetName);
                outDatasource = inDatasource;
            } else {
                String[] outDataPathSplit = outDataPath.split("\\.");
                String outDataFormat = outDataPathSplit[outDataPathSplit.length - 1].toUpperCase();
                EngineType outEngineType = (EngineType)EngineType.parse(EngineType.class, (String)outDataFormat);
                outDatasource = new Datasource(outEngineType);
                DatasourceConnectionInfo outConn = new DatasourceConnectionInfo();
                outConn.setServer(outDataPath);
                outConn.setEngineType(outEngineType);
                outDatasource.open(outConn);
                outName = outDatasource.getDatasets().getAvailableDatasetName(outDatasetName);
            }
            File pyFile = new File(processPyFile);
            HashMap<String, Object> processArgs = new HashMap<String, Object>();
            processArgs.put("ModelPath", modelFile);
            TileMeta tileMeta = Processes.getDatasetInfo((Dataset)inDataset);
            processArgs.put("PixelFormat", tileMeta.getPixelFormat());
            processArgs.put("Bands", tileMeta.getBands());
            processArgs.put("NoValue", tileMeta.getNoValue());
            String pyText = Utils.readPyFile((File)pyFile);
            processTilePipe = new ProcessTilePipe(pyText, pyClassName);
            processTilePipe.start();
            processTilePipe.setArgs(processArgs);
            Map updateInfo = processTilePipe.getUpdateInfo();
            PixelFormat pixelFormat = (PixelFormat)updateInfo.get("PixelFormat");
            double noValue = Double.parseDouble(updateInfo.get("NoValue").toString());
            DatasetGridInfo dtInfo = new DatasetGridInfo();
            DatasetImageInfo imageInfo = new DatasetImageInfo();
            dtInfo.setBounds(inDataset.getBounds());
            dtInfo.setHeight(inDataset.getHeight());
            dtInfo.setWidth(inDataset.getWidth());
            dtInfo.setPixelFormat(pixelFormat);
            dtInfo.setName(outName);
            dtInfo.setNoValue(noValue);
            DatasetGrid img = outDatasource.getDatasets().create(dtInfo);
            if (img == null) {
                throw new RuntimeException("Failed to create result dataset");
            }
            for (TileRef tileRef : tileRefs = Processes.getDatasetTileRefs((Dataset)inDataset, (int)numRows, (int)numCols)) {
                Tile result = processTilePipe.processTiles(new Tile[]{tileRef.getData()});
                Processes.writeTileToDataset((Dataset)img, (Tile)result, (TileRef)tileRef);
                System.out.println(result.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (processTilePipe != null) {
                processTilePipe.shutdown();
            }
            inDatasource.close();
            if (!inDataPath.equals(outDataPath)) {
                outDatasource.close();
            }
        }
    }
}

