/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.DatasetVector;
import com.supermap.data.GeoStyle;
import com.supermap.mapping.GraduatedMode;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeGraduatedSymbolNative;

public class ThemeGraduatedSymbol
extends Theme {
    private GeoStyle m_leaderLineStyle = null;
    private GeoStyle m_negativeStyle = null;
    private GeoStyle m_positiveStyle = null;
    private GeoStyle m_zeroStyle = null;

    public ThemeGraduatedSymbol() {
        long l = ThemeGraduatedSymbolNative.jni_New();
        this.setHandle(l, true);
    }

    public ThemeGraduatedSymbol(ThemeGraduatedSymbol themeGraduatedSymbol) {
        if (themeGraduatedSymbol == null) {
            String string = InternalResource.loadString("themeGraduatedSymbol", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = themeGraduatedSymbol.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("graduatedSymbol", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ThemeGraduatedSymbolNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGraduatedSymbol));
    }

    ThemeGraduatedSymbol(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
    }

    public String getExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ThemeGraduatedSymbolNative.jni_GetExpression(this.getHandle());
    }

    public void setExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeGraduatedSymbolNative.jni_SetExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public GraduatedMode getGraduatedMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = ThemeGraduatedSymbolNative.jni_GetGraduatedMode(this.getHandle());
        return (GraduatedMode)InternalEnum.parseUGCValue(GraduatedMode.class, n);
    }

    public void setGraduatedMode(GraduatedMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRangeMode(RangeMode value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(value);
        ThemeGraduatedSymbolNative.jni_SetGraduatedMode(this.getHandle(), n);
    }

    public String getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetX()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ThemeGraduatedSymbolNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetX(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetX(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraduatedSymbolNative.jni_SetOffsetX(this.getHandle(), value);
    }

    public String getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ThemeGraduatedSymbolNative.jni_GetOffsetY(this.getHandle());
    }

    public void setOffsetY(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetY(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraduatedSymbolNative.jni_SetOffsetY(this.getHandle(), value);
    }

    public GeoStyle getLeaderLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLeaderLineStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_leaderLineStyle == null && (l = ThemeGraduatedSymbolNative.jni_GetLeaderLineStyle(this.getHandle())) != 0L) {
            this.m_leaderLineStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_leaderLineStyle;
    }

    public void setLeaderLineStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLeaderLineStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle);
        ThemeGraduatedSymbolNative.jni_SetLeaderLineStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public boolean isLeaderLineDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsLeaderLineDisplayed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ThemeGraduatedSymbolNative.jni_GetIsLeaderLineDisplayed(this.getHandle());
    }

    public void setLeaderLineDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLeaderLineDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraduatedSymbolNative.jni_SetIsLeaderLineDisplayed(this.getHandle(), value);
    }

    public boolean isFlowEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsFlowEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ThemeGraduatedSymbolNative.jni_GetIsFlowEnabled(this.getHandle());
    }

    public void setFlowEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsFlowEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraduatedSymbolNative.jni_SetIsFlowEnabled(this.getHandle(), value);
    }

    public GeoStyle getNegativeStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNegativeStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_negativeStyle == null && (l = ThemeGraduatedSymbolNative.jni_GetNegativeStyle(this.getHandle())) != 0L) {
            this.m_negativeStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_negativeStyle;
    }

    public void setNegativeStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNegativeStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle);
        ThemeGraduatedSymbolNative.jni_SetNegativeStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public boolean isNegativeDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsNegativeDisplayed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ThemeGraduatedSymbolNative.jni_GetIsNegativeDisplayed(this.getHandle());
    }

    public void setNegativeDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsNegativeDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraduatedSymbolNative.jni_SetIsNegativeDisplayed(this.getHandle(), value);
    }

    public GeoStyle getZeroStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getZeroStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_zeroStyle == null && (l = ThemeGraduatedSymbolNative.jni_GetZeroStyle(this.getHandle())) != 0L) {
            this.m_zeroStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_zeroStyle;
    }

    public void setZeroStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setZeroStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle);
        ThemeGraduatedSymbolNative.jni_SetZeroStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public boolean isZeroDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsZeroDisplayed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ThemeGraduatedSymbolNative.jni_GetIsZeroDisplayed(this.getHandle());
    }

    public void setZeroDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsZeroDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraduatedSymbolNative.jni_SetIsZeroDisplayed(this.getHandle(), value);
    }

    public GeoStyle getPositiveStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPositiveStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_positiveStyle == null && (l = ThemeGraduatedSymbolNative.jni_GetPositiveStyle(this.getHandle())) != 0L) {
            this.m_positiveStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_positiveStyle;
    }

    public void setPositiveStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPositiveStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle);
        ThemeGraduatedSymbolNative.jni_SetPositiveStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public double getBaseValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBaseValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ThemeGraduatedSymbolNative.jni_GetBaseValue(this.getHandle());
    }

    public void setBaseValue(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBaseValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("setBaseValue(double value)", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraduatedSymbolNative.jni_SetBaseValue(this.getHandle(), value);
    }

    @Override
    public boolean fromXML(String xml) {
        if (xml == null || xml.trim().length() == 0) {
            String string = InternalResource.loadString("xml", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = super.fromXML(xml);
        if (bl) {
            this.clearLocalVariable();
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean isOffsetFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsOffsetFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraduatedSymbolNative.jni_isOffsetFixed(this.getHandle());
    }

    public void setOffsetFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetOffsetFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraduatedSymbolNative.jni_setOffsetFixed(this.getHandle(), value);
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{BaseValue = ");
        stringBuffer.append(this.getBaseValue());
        stringBuffer.append(",Expression = ");
        stringBuffer.append(this.getExpression());
        stringBuffer.append(",IsFlowEnabled = ");
        stringBuffer.append(this.isFlowEnabled());
        stringBuffer.append(",IsLeaderLineDisplayed = ");
        stringBuffer.append(this.isLeaderLineDisplayed());
        stringBuffer.append(",IsNegativeDisplayed = ");
        stringBuffer.append(this.isNegativeDisplayed());
        stringBuffer.append(",IsZeroDisplayed = ");
        stringBuffer.append(this.isZeroDisplayed());
        stringBuffer.append(",OffsetX = ");
        stringBuffer.append(this.getOffsetX());
        stringBuffer.append(",OffsetY = ");
        stringBuffer.append(this.getOffsetY());
        stringBuffer.append(",GraduatedMode = ");
        stringBuffer.append(this.getGraduatedMode().name());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeGraduatedSymbolNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public static ThemeGraduatedSymbol makeDefault(DatasetVector dataset, String expression, GraduatedMode graduatedMode) {
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (expression == null || expression.trim().length() == 0) {
            String string = InternalResource.loadString("rangeExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (graduatedMode == null) {
            String string = InternalResource.loadString("graduatedMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ThemeGraduatedSymbolNative.jni_MakeDefault(l, expression);
        ThemeGraduatedSymbol themeGraduatedSymbol = null;
        if (l2 != 0L) {
            themeGraduatedSymbol = new ThemeGraduatedSymbol(l2, true);
            themeGraduatedSymbol.setGraduatedMode(graduatedMode);
        }
        return themeGraduatedSymbol;
    }

    private void clearLocalVariable() {
        if (this.m_leaderLineStyle != null) {
            InternalGeoStyle.clearHandle(this.m_leaderLineStyle);
            this.m_leaderLineStyle = null;
        }
        if (this.m_negativeStyle != null) {
            InternalGeoStyle.clearHandle(this.m_negativeStyle);
            this.m_negativeStyle = null;
        }
        if (this.m_positiveStyle != null) {
            InternalGeoStyle.clearHandle(this.m_positiveStyle);
            this.m_positiveStyle = null;
        }
        if (this.m_zeroStyle != null) {
            InternalGeoStyle.clearHandle(this.m_zeroStyle);
            this.m_zeroStyle = null;
        }
    }

    @Override
    protected void clearHandle() {
        this.clearLocalVariable();
        this.setHandle(0L);
    }
}

