/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Point2D;
import com.supermap.mapping.Layer;
import com.supermap.mapping.SnapMode;
import java.util.ArrayList;

public class SnappedElement {
    private int m_selectedGeometryID;
    private Layer m_layer = null;
    private SnapMode m_snapMode = null;
    private ArrayList m_point2Ds = new ArrayList();

    public SnappedElement(Layer layer, int geometryID, SnapMode snappingMode, Point2D[] snappedPoints) {
        this.m_layer = layer;
        this.m_snapMode = snappingMode;
        this.m_selectedGeometryID = geometryID;
        this.m_point2Ds.clear();
        for (int i = 0; i < snappedPoints.length; ++i) {
            this.m_point2Ds.add(snappedPoints[i].clone());
        }
    }

    public Layer getLayer() {
        return this.m_layer;
    }

    public int getGeometryID() {
        return this.m_selectedGeometryID;
    }

    @Deprecated
    public SnapMode getSnappingMode() {
        return this.m_snapMode;
    }

    public SnapMode getSnapMode() {
        return this.m_snapMode;
    }

    public Point2D[] getSnappedPoints() {
        Point2D[] point2DArray = new Point2D[this.m_point2Ds.size()];
        return this.m_point2Ds.toArray(point2DArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{GeometryID=");
        stringBuffer.append(this.getGeometryID());
        stringBuffer.append(",Layer=");
        if (this.m_layer == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.getLayer().getName());
        }
        stringBuffer.append(",SnappingMode=");
        stringBuffer.append((Object)this.getSnappingMode());
        stringBuffer.append(",SnappedPoints=");
        if (this.m_point2Ds == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.m_point2Ds.toString());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

