/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoRegion;
import com.supermap.data.Point2D;
import com.supermap.mapping.ChartObjectInfo;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerChartNative;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import com.supermap.mapping.Selection;
import java.util.ArrayList;

public class LayerChart
extends Layer {
    private DatasetGroup m_datasetGroup;
    private ArrayList<Selection> m_selections;
    private GeoRegion m_TextClipRegion = null;
    private ChartObjectInfo[] m_chartObjInfos = null;

    protected LayerChart(long handle, Layers layers, Map map, DatasetGroup datasetGroup) {
        super(handle, layers, map);
        this.m_datasetGroup = datasetGroup;
        int n = LayerChartNative.jni_GetSubLayersCount(handle);
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        LayerChartNative.jni_GetSubLayersAndDatasets(handle, lArray, lArray2);
        this.m_selections = new ArrayList();
        for (int i = 0; i < lArray2.length; ++i) {
            DatasetVector datasetVector = (DatasetVector)InternalToolkitMapping.toManageDataset(this.m_map.getWorkspace(), lArray2[i]);
            Layer layer = new Layer(lArray[i], this.m_layers, this.m_map);
            if (datasetVector == null || layer == null) continue;
            long l = LayerNative.jni_GetSelection(lArray[i]);
            Selection selection = new Selection(l, layer);
            this.m_selections.add(selection);
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.m_chartObjInfos != null) {
            for (ChartObjectInfo chartObjectInfo : this.m_chartObjInfos) {
                if (chartObjectInfo == null) continue;
                chartObjectInfo.clearHandle();
            }
            this.m_chartObjInfos = null;
        }
        this.setHandle(0L);
    }

    public DatasetGroup getDatasetGroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasetGroup()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasetGroup;
    }

    public Selection[] getSelections() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelections()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Selection[] selectionArray = new Selection[this.m_selections.size()];
        this.m_selections.toArray(selectionArray);
        return selectionArray;
    }

    public ChartObjectInfo[] getSelectionInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelectionInfos()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<ChartObjectInfo> arrayList = new ArrayList<ChartObjectInfo>();
        for (int i = 0; i < this.m_selections.size(); ++i) {
            if (this.m_selections.get(i) == null) continue;
            long[] lArray = LayerChartNative.jni_GetSelectionInfosBySelectionHandle(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_selections.get(i)));
            for (int j = 0; j < lArray.length; ++j) {
                ChartObjectInfo chartObjectInfo = ChartObjectInfo.createInstance(lArray[j], this.m_selections.get(i));
                arrayList.add(chartObjectInfo);
            }
        }
        if (this.m_chartObjInfos != null) {
            for (ChartObjectInfo chartObjectInfo : this.m_chartObjInfos) {
                if (chartObjectInfo == null) continue;
                chartObjectInfo.clearHandle();
            }
            this.m_chartObjInfos = null;
        }
        if (this.m_chartObjInfos == null) {
            this.m_chartObjInfos = new ChartObjectInfo[arrayList.size()];
            arrayList.toArray(this.m_chartObjInfos);
        }
        return this.m_chartObjInfos;
    }

    public void clearSelections() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearSelections()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerChartNative.jni_ClearSelections(this.getHandle());
    }

    public boolean hitTestExtend(Point2D point, double tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTestExtend()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Layer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LayerChartNative.jni_HitTestExtend(this.getHandle(), point.getX(), point.getY(), tolerance);
    }

    public void highlightObject(long featureID, int recordsetID, boolean isMoveToCenter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("highlightObject()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerChartNative.jni_HighlightObject(this.getHandle(), featureID, recordsetID, isMoveToCenter);
        if (isMoveToCenter) {
            this.m_map.refresh();
        } else {
            this.m_map.refreshTrackingLayer();
        }
    }

    protected boolean deleteSubLayer(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteSubLayer()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            return false;
        }
        boolean bl = true;
        bl = LayerChartNative.jni_DeleteSubLayer(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset));
        if (bl) {
            DatasetVector datasetVector = (DatasetVector)dataset;
            for (int i = 0; i < this.m_selections.size(); ++i) {
                if (datasetVector != this.m_selections.get(i).getDataset()) continue;
                this.m_selections.remove(i);
                break;
            }
        }
        return bl;
    }

    public void setAttributeModifiedFlag() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAttributeModifiedFlag()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerChartNative.jni_SetEditAttributeCompleted(this.getHandle(), true);
    }

    public GeoRegion getTextClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextClipRegion()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_TextClipRegion == null && (l = LayerChartNative.jni_GetTextClipRegion(this.getHandle())) != 0L) {
            this.m_TextClipRegion = (GeoRegion)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_TextClipRegion, false);
            if (this.m_TextClipRegion.isEmpty()) {
                this.m_TextClipRegion = null;
            }
        }
        return this.m_TextClipRegion;
    }

    public void setTextClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextClipRegion(GeoRegion region)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            LayerChartNative.jni_SetTextClipRegion(this.getHandle(), 0L);
            this.m_TextClipRegion = null;
        } else {
            long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
            if (l == 0L) {
                String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            LayerChartNative.jni_SetTextClipRegion(this.getHandle(), l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
    }
}

