/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoStyle;
import com.supermap.mapping.GridType;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalMapControl;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Map;
import com.supermap.mapping.MapLayoutNative;
import com.supermap.mapping.MapNative;

public class GridSetting {
    private Map m_map = null;
    private boolean m_visible = false;
    private boolean m_snapable = false;
    private double m_hSpacing = 100.0;
    private double m_vSpacing = 100.0;
    private boolean m_SizeFixed = true;
    private GeoStyle m_solidStyle = null;
    private GeoStyle m_dashStyle = null;
    private GridType m_gridType = GridType.GRID;
    private long m_mapLayout = 0L;

    public GridSetting() {
    }

    public GridSetting(GridSetting setting) {
        this();
        this.setDashStyle(setting.getDashStyle());
        this.setHorizontalSpacing(setting.getHorizontalSpacing());
        this.setSizeFixed(setting.isSizeFixed());
        this.setSnapable(setting.isSnapable());
        this.setSolidStyle(setting.getSolidStyle());
        this.setType(setting.getType());
        this.setVerticalSpacing(setting.getVerticalSpacing());
        this.setVisible(setting.isVisible());
    }

    GridSetting(Map map) {
        this.m_map = map;
    }

    protected GridSetting(long handle) {
        this();
        this.m_mapLayout = handle;
    }

    public boolean isVisible() {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("isVisible()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return MapNative.jni_IsGridVisible(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map));
        }
        if (this.m_mapLayout != 0L) {
            return MapLayoutNative.jni_IsGridVisible(this.m_mapLayout);
        }
        return this.m_visible;
    }

    public void setVisible(boolean value) {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("setVisible(boolean value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            MapNative.jni_SetGridVisible(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map), value);
        } else if (this.m_mapLayout != 0L) {
            MapLayoutNative.jni_SetVisible(this.m_mapLayout, value);
        }
        this.m_visible = value;
    }

    public boolean isSnapable() {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("isSnapable()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_map.getMapControl() != null) {
                return MapNative.jni_IsGridSnapable(InternalMapControl.getHandle(this.m_map.getMapControl()));
            }
        } else if (this.m_mapLayout != 0L) {
            return MapLayoutNative.jni_IsGridSnapable(this.m_mapLayout);
        }
        return this.m_snapable;
    }

    public void setSnapable(boolean value) {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("setSnapable(boolean value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_map.getMapControl() != null) {
                MapNative.jni_SetGridSnapable(InternalMapControl.getHandle(this.m_map.getMapControl()), value);
            }
        } else if (this.m_mapLayout != 0L) {
            MapLayoutNative.jni_SetGridSnapable(this.m_mapLayout, value);
        }
        this.m_snapable = value;
    }

    public double getHorizontalSpacing() {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("getHorizontalSpacing()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return MapNative.jni_GetGridHorizontalSpacing(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map));
        }
        if (this.m_mapLayout != 0L) {
            return MapLayoutNative.jni_GetGridHorizontalSpacing(this.m_mapLayout);
        }
        return this.m_hSpacing;
    }

    public void setHorizontalSpacing(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("setHorizontalSpacing(boolean value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            MapNative.jni_SetGridHorizontalSpacing(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map), value);
        } else if (this.m_mapLayout != 0L) {
            MapLayoutNative.jni_SetGridHorizontalSpacing(this.m_mapLayout, value);
        }
        this.m_hSpacing = value;
    }

    public double getVerticalSpacing() {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("getVerticalSpacing()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return MapNative.jni_GetGridVerticalSpacing(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map));
        }
        if (this.m_mapLayout != 0L) {
            return MapLayoutNative.jni_GetGridVerticalSpacing(this.m_mapLayout);
        }
        return this.m_vSpacing;
    }

    public void setVerticalSpacing(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("setVerticalSpacing(boolean value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            MapNative.jni_SetGridVerticalSpacing(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map), value);
        } else if (this.m_mapLayout != 0L) {
            MapLayoutNative.jni_SetGridVerticalSpacing(this.m_mapLayout, value);
        }
        this.m_vSpacing = value;
    }

    public boolean isSizeFixed() {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("isSizeFixed()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return MapNative.jni_IsGridSizeFixed(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map));
        }
        if (this.m_mapLayout != 0L) {
            String string = InternalResource.loadString("isSizeFixed()", "Paper_GridSettingNotSupportTheMethod", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_SizeFixed;
    }

    public void setSizeFixed(boolean value) {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("setSizeFixed(boolean value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            MapNative.jni_SetGridSizeFixed(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map), value);
        } else if (this.m_mapLayout != 0L) {
            String string = InternalResource.loadString("setSizeFixed(boolean value)", "Paper_GridSettingNotSupportTheMethod", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_SizeFixed = value;
    }

    public GeoStyle getSolidStyle() {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("getSolidStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_solidStyle == null) {
                long l = MapNative.jni_GetGridSolidStyle(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map));
                this.m_solidStyle = InternalGeoStyle.createInstance(l);
            }
        } else if (this.m_mapLayout != 0L) {
            String string = InternalResource.loadString("getSolidStyle()", "Paper_GridSettingNotSupportTheMethod", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_solidStyle;
    }

    public void setSolidStyle(GeoStyle value) {
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("setSolidStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            MapNative.jni_SetGridSolidStyle(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
        } else if (this.m_mapLayout != 0L) {
            String string = InternalResource.loadString("getSolidStyle()", "Paper_GridSettingNotSupportTheMethod", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_solidStyle = value.clone();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public GeoStyle getDashStyle() {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("getDashStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_dashStyle == null) {
                long l = MapNative.jni_GetGridDashStyle(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map));
                this.m_dashStyle = InternalGeoStyle.createInstance(l);
            }
        } else if (this.m_mapLayout != 0L) {
            String string = InternalResource.loadString("getDashStyle()", "Paper_GridSettingNotSupportTheMethod", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_dashStyle;
    }

    public void setDashStyle(GeoStyle value) {
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("setDashStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            MapNative.jni_SetGridDashStyle(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
        } else if (this.m_mapLayout != 0L) {
            String string = InternalResource.loadString("getDashStyle()", "Paper_GridSettingNotSupportTheMethod", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_dashStyle = value.clone();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public GridType getType() {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = MapNative.jni_GetGridType(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map));
            this.m_gridType = (GridType)GridType.parse(GridType.class, (int)n);
        } else if (this.m_mapLayout != 0L) {
            String string = InternalResource.loadString("getType()", "Paper_GridSettingNotSupportTheMethod", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_gridType;
    }

    public void setType(GridType type) {
        if (this.m_map != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
                String string = InternalResource.loadString("setType(GridType type)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            MapNative.jni_SetGridType(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map), InternalEnum.getUGCValue(type));
        } else if (this.m_mapLayout != 0L) {
            String string = InternalResource.loadString("setType(GridType type)", "Paper_GridSettingNotSupportTheMethod", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_gridType = type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_mapLayout != 0L) {
            stringBuffer.append("{HorizontalSpacing=");
            stringBuffer.append(this.getHorizontalSpacing());
            stringBuffer.append(",VerticalSpacing=");
            stringBuffer.append(this.getVerticalSpacing());
            stringBuffer.append(",IsFixedSize=No Support");
            stringBuffer.append(",IsSnapable=");
            stringBuffer.append(this.isSnapable());
            stringBuffer.append(",IsVisible=");
            stringBuffer.append(this.isVisible());
            stringBuffer.append("}");
            stringBuffer.append(",SolidStyle=No Support");
            stringBuffer.append(",DashStyle=No Support");
            stringBuffer.append(",Type=No Support");
            stringBuffer.append("}");
        } else {
            stringBuffer.append("{HorizontalSpacing=");
            stringBuffer.append(this.getHorizontalSpacing());
            stringBuffer.append(",VerticalSpacing=");
            stringBuffer.append(this.getVerticalSpacing());
            stringBuffer.append(",IsFixedSize=");
            stringBuffer.append(this.isSizeFixed());
            stringBuffer.append(",IsSnapable=");
            stringBuffer.append(this.isSnapable());
            stringBuffer.append(",IsVisible=");
            stringBuffer.append(this.isVisible());
            stringBuffer.append(",SolidStyle=");
            stringBuffer.append(this.getSolidStyle());
            stringBuffer.append(",DashStyle=");
            stringBuffer.append(this.getDashStyle());
            stringBuffer.append(",Type=");
            stringBuffer.append((Object)this.getType());
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }
}

