/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.threeddesigner;

import com.supermap.data.CursorType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfo;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoModel3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.Material3D;
import com.supermap.data.Model;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Recordset;
import com.supermap.data.Skeleton;
import com.supermap.data.SkeletonID;
import com.supermap.data.TextureData;
import com.supermap.jsuperpy.threeddesigner.MaterailParameter;
import com.supermap.jsuperpy.threeddesigner.SteppedEvent;
import com.supermap.jsuperpy.threeddesigner.SteppedListener;
import com.supermap.realspace.threeddesigner.BufferParameter;
import com.supermap.realspace.threeddesigner.JoinType;
import com.supermap.realspace.threeddesigner.ModelBuilder3D;
import com.supermap.realspace.threeddesigner.ModelTools;
import com.supermap.realspace.threeddesigner.TextureMapParameter;
import com.supermap.realspace.threeddesigner.TextureMappingMode;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.imageio.ImageIO;

public class ModelBuilder3DTools {
    private static transient Vector m_steppedListeners;
    private static String m_message;

    public static synchronized void addSteppedListener(SteppedListener listener) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(listener)) {
            m_steppedListeners.add(listener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener listener) {
        if (m_steppedListeners != null && m_steppedListeners.contains(listener)) {
            m_steppedListeners.remove(listener);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector listeners = m_steppedListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((SteppedListener)listeners.elementAt(i)).stepped(event);
            }
        }
    }

    static void stepppedCallBack(int percent, String title, String message) {
        String senderMethodName = "ThreedDesigner";
        Object object = new Object();
        SteppedEvent event = new SteppedEvent(object, percent, title, message);
        ModelBuilder3DTools.fireStepped(event);
    }

    public static boolean linearExtrude(Recordset recordset, DatasetVector datasetR, Object height, Object twist, Object scaleX, Object scaleY) {
        boolean result = false;
        DatasetVector datasetV = recordset.getDataset();
        Recordset recordsetR = datasetR.getRecordset(false, CursorType.DYNAMIC);
        boolean bLonLat = datasetV.getPrjCoordSys().getType() == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE;
        double extrudeHeight = 0.0;
        String heightFieldName = "";
        if (height instanceof String) {
            heightFieldName = height.toString();
        } else {
            extrudeHeight = Double.valueOf(height.toString());
        }
        double dTwist = 0.0;
        String twistFieldName = "";
        if (twist instanceof String) {
            twistFieldName = twist.toString();
        } else {
            dTwist = Double.valueOf(twist.toString());
        }
        double dScaleY = 1.0;
        String scaleYFieldName = "";
        if (scaleY instanceof String) {
            scaleYFieldName = scaleY.toString();
        } else {
            dScaleY = Double.valueOf(scaleY.toString());
        }
        double dScaleX = 1.0;
        String scaleXFieldName = "";
        if (scaleX instanceof String) {
            scaleXFieldName = scaleX.toString();
        } else {
            dScaleX = Double.valueOf(scaleX.toString());
        }
        try {
            int curNum = 1;
            int totalNum = recordset.getRecordCount();
            recordsetR.getBatch().begin();
            recordset.moveFirst();
            while (!recordset.isEOF()) {
                String message = String.format(m_message, curNum, totalNum);
                ModelBuilder3DTools.stepppedCallBack(curNum * 100 / totalNum, "LinearExtrude", message);
                Geometry geometry = recordset.getGeometry();
                extrudeHeight = ModelBuilder3DTools.getFieldValue(recordset, heightFieldName, extrudeHeight);
                dTwist = ModelBuilder3DTools.getFieldValue(recordset, twistFieldName, dTwist);
                dScaleX = ModelBuilder3DTools.getFieldValue(recordset, scaleXFieldName, dScaleX);
                dScaleY = ModelBuilder3DTools.getFieldValue(recordset, scaleYFieldName, dScaleY);
                GeoModel3D geoModel3D = ModelBuilder3D.linearExtrude((Geometry)geometry, (boolean)bLonLat, (double)extrudeHeight, (double)dTwist, (double)dScaleX, (double)dScaleY);
                if (geoModel3D == null) continue;
                recordsetR.addNew((Geometry)geoModel3D);
                recordset.moveNext();
                ++curNum;
            }
            recordsetR.getBatch().update();
            ArrayList<String> fieldsNameArray = new ArrayList<String>();
            for (int i = 0; i < datasetV.getFieldCount(); ++i) {
                FieldInfo fieldInfo = datasetV.getFieldInfos().get(i);
                if (fieldInfo.isSystemField() || datasetR.getFieldInfos().indexOf(fieldInfo.getName()) > -1) continue;
                fieldsNameArray.add(fieldInfo.getName());
            }
            String[] strFieldsName = new String[fieldsNameArray.size()];
            fieldsNameArray.toArray(strFieldsName);
            datasetR.appendFields(datasetV, "SmID", "SmID", strFieldsName);
            if (recordsetR.getRecordCount() > 0) {
                result = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        recordset.close();
        recordsetR.close();
        return result;
    }

    private static double getFieldValue(Recordset recordset, String fieldName, double oriValue) {
        Object object;
        if (!fieldName.equals("") && recordset.getFieldInfos().indexOf(fieldName) > -1 && (object = recordset.getFieldValue(fieldName)) != null) {
            oriValue = Double.valueOf(object.toString());
        }
        return oriValue;
    }

    private static void getValueOrFieldName(Object object, double defaultValue) {
        double extrudeHeight = 0.0;
        String heightFieldName = "";
        if (object instanceof String) {
            heightFieldName = object.toString();
        } else {
            extrudeHeight = Double.valueOf(object.toString());
        }
    }

    public static boolean buildHouse(Recordset recordset, DatasetVector datasetR, Object wallHeight, MaterailParameter wallTextureParameter, Object eaveHeight, Object eaveWidth, MaterailParameter eaveTextureParameter, Object roofWidth, Object roofSlope, MaterailParameter roofTextureParameter) {
        boolean bResult = false;
        try {
            DatasetVector datasetV = recordset.getDataset();
            Recordset recordsetR = datasetR.getRecordset(false, CursorType.DYNAMIC);
            boolean bLonLat = datasetV.getPrjCoordSys().getType() == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE;
            Material3D wallMaterial = ModelBuilder3DTools.getMaterial(wallTextureParameter, "WallMaterial");
            Material3D eaveMaterial = ModelBuilder3DTools.getMaterial(eaveTextureParameter, "EaveMaterial");
            Material3D roofMaterial = ModelBuilder3DTools.getMaterial(roofTextureParameter, "RoofMaterial");
            double dRoofSlope = 0.0;
            String roofSlopeFieldName = "";
            if (roofSlope instanceof String) {
                roofSlopeFieldName = roofSlope.toString();
            } else {
                dRoofSlope = Double.valueOf(roofSlope.toString());
            }
            double dRoofWidth = 0.0;
            String roofWidthFieldName = "";
            if (roofWidth instanceof String) {
                roofWidthFieldName = roofWidth.toString();
            } else {
                dRoofWidth = Double.valueOf(roofWidth.toString());
            }
            double dEaveWidth = 0.0;
            String eaveWidthFieldName = "";
            if (eaveWidth instanceof String) {
                eaveWidthFieldName = eaveWidth.toString();
            } else {
                dEaveWidth = Double.valueOf(eaveWidth.toString());
            }
            double dEaveHeight = 0.0;
            String eaveHightFieldName = "";
            if (eaveHeight instanceof String) {
                eaveHightFieldName = eaveHeight.toString();
            } else {
                dEaveHeight = Double.valueOf(eaveHeight.toString());
            }
            double dWallHeight = 0.0;
            String wallHightFieldName = "";
            if (wallHeight instanceof String) {
                wallHightFieldName = wallHeight.toString();
            } else {
                dWallHeight = Double.valueOf(wallHeight.toString());
            }
            int curNum = 1;
            int totalNum = recordset.getRecordCount();
            recordsetR.getBatch().begin();
            recordset.moveFirst();
            while (!recordset.isEOF()) {
                String message = String.format(m_message, curNum, totalNum);
                ModelBuilder3DTools.stepppedCallBack(curNum * 100 / totalNum, "BuildHouse", message);
                ArrayList<GeoModel3D> arrayModels = new ArrayList<GeoModel3D>();
                Geometry geometry = recordset.getGeometry();
                dWallHeight = ModelBuilder3DTools.getFieldValue(recordset, wallHightFieldName, dWallHeight);
                GeoModel3D wall = ModelBuilder3D.linearExtrude((Geometry)geometry, (boolean)bLonLat, (double)dWallHeight, (double)0.0, (double)1.0, (double)1.0);
                if (wallTextureParameter != null) {
                    wall = ModelBuilder3DTools.buildGeoModelTexture(wall, wallMaterial, wallTextureParameter, recordset);
                }
                if (wall != null) {
                    arrayModels.add(wall);
                }
                Geometry eave = geometry.clone();
                if ((dEaveWidth = ModelBuilder3DTools.getFieldValue(recordset, eaveWidthFieldName, dEaveWidth)) > 0.0) {
                    BufferParameter bufferParameter = new BufferParameter();
                    bufferParameter.setOffset(dEaveWidth);
                    bufferParameter.setType(JoinType.MITER);
                    eave = ModelBuilder3D.createBuffer((Geometry)eave, (boolean)bLonLat, (BufferParameter)bufferParameter);
                }
                if ((dEaveHeight = ModelBuilder3DTools.getFieldValue(recordset, eaveHightFieldName, dEaveHeight)) > 0.0) {
                    eave = ModelBuilder3D.linearExtrude((Geometry)eave, (boolean)bLonLat, (double)dEaveHeight, (double)0.0, (double)1.0, (double)1.0);
                    Point3D position = ((GeoModel3D)eave).getPosition();
                    if (dWallHeight > 0.0) {
                        position.setZ(position.getZ() + dWallHeight);
                    }
                    ((GeoModel3D)eave).setPosition(position);
                    if (eaveTextureParameter != null) {
                        eave = ModelBuilder3DTools.buildGeoModelTexture((GeoModel3D)eave, eaveMaterial, eaveTextureParameter, recordset);
                    }
                }
                if (eave != null && eave instanceof GeoModel3D) {
                    arrayModels.add((GeoModel3D)eave);
                }
                Geometry roof = geometry.clone();
                if ((dRoofWidth = ModelBuilder3DTools.getFieldValue(recordset, roofWidthFieldName, dRoofWidth)) > 0.0) {
                    BufferParameter bufferParameter = new BufferParameter();
                    bufferParameter.setOffset(dRoofWidth);
                    bufferParameter.setType(JoinType.MITER);
                    roof = ModelBuilder3D.createBuffer((Geometry)roof, (boolean)bLonLat, (BufferParameter)bufferParameter);
                }
                if ((dRoofSlope = ModelBuilder3DTools.getFieldValue(recordset, roofSlopeFieldName, dRoofSlope)) > 0.0) {
                    roof = ModelBuilder3D.straightSkeleton((Geometry)roof, (boolean)bLonLat, (double)dRoofSlope);
                    Point3D position = ((GeoModel3D)roof).getPosition();
                    if (dWallHeight + dEaveHeight > 0.0) {
                        position.setZ(position.getZ() + dWallHeight + dEaveHeight);
                    }
                    ((GeoModel3D)roof).setPosition(position);
                    if (roofTextureParameter != null) {
                        roof = ModelBuilder3DTools.buildGeoModelTexture((GeoModel3D)roof, roofMaterial, roofTextureParameter, recordset);
                    }
                }
                if (roof != null && roof instanceof GeoModel3D) {
                    arrayModels.add((GeoModel3D)roof);
                }
                recordsetR.addNew((Geometry)ModelTools.compose(arrayModels));
                recordset.moveNext();
                ++curNum;
            }
            recordsetR.getBatch().update();
            ArrayList<String> fieldsNameArray = new ArrayList<String>();
            for (int i = 0; i < datasetV.getFieldCount(); ++i) {
                FieldInfo fieldInfo = datasetV.getFieldInfos().get(i);
                if (fieldInfo.isSystemField() || datasetR.getFieldInfos().indexOf(fieldInfo.getName()) > -1) continue;
                fieldsNameArray.add(fieldInfo.getName());
            }
            String[] strFieldsName = new String[fieldsNameArray.size()];
            fieldsNameArray.toArray(strFieldsName);
            datasetR.appendFields(datasetV, "SmID", "SmID", strFieldsName);
            if (recordsetR.getRecordCount() > 0) {
                bResult = true;
            }
            recordset.dispose();
            recordsetR.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bResult;
    }

    private static Material3D getMaterial(MaterailParameter textureParameter, String materialName) {
        Material3D material3D = null;
        try {
            if (textureParameter != null) {
                material3D = new Material3D();
                String textureFile = textureParameter.getTextureFile();
                material3D.setName(materialName);
                material3D.setMaterialColor(textureParameter.getMaterialColor());
                TextureData textureData = new TextureData();
                if (!textureFile.equals("") && textureData.fromFile(textureFile)) {
                    textureData.setName(new File(textureFile).getName());
                    textureData.setData(ImageIO.read(new FileInputStream(textureFile)));
                    material3D.setTexture(textureData);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return material3D;
    }

    private static GeoModel3D buildGeoModelTexture(GeoModel3D geoModel3D, Material3D material3D, MaterailParameter textureParameter, Recordset recordset) {
        GeoModel3D result = geoModel3D;
        try {
            if (textureParameter != null) {
                double uTiling = 1.0;
                String uTilingFiledName = "";
                if (textureParameter.getUTiling() instanceof String) {
                    uTilingFiledName = textureParameter.getUTiling().toString();
                    uTiling = ModelBuilder3DTools.getFieldValue(recordset, uTilingFiledName, uTiling);
                } else {
                    uTiling = Double.valueOf(textureParameter.getUTiling().toString());
                }
                double vTiling = 1.0;
                String vTilingFiledName = "";
                if (textureParameter.getUTiling() instanceof String) {
                    vTilingFiledName = textureParameter.getVTiling().toString();
                    vTiling = ModelBuilder3DTools.getFieldValue(recordset, vTilingFiledName, vTiling);
                } else {
                    vTiling = Double.valueOf(textureParameter.getVTiling().toString());
                }
                TextureMapParameter textureMapParameter = new TextureMapParameter();
                textureMapParameter.setIsRealWorldMapSize(textureParameter.isRealWorldMapSize());
                textureMapParameter.setIsRealTexMapSize(textureParameter.isRealTexMapSize());
                textureMapParameter.setUTiling(uTiling);
                textureMapParameter.setVTiling(vTiling);
                textureMapParameter.setMappingMode(TextureMappingMode.BOX);
                ModelBuilder3D.uvwMap((GeoModel3D)geoModel3D, (TextureMapParameter)textureMapParameter);
                result = geoModel3D;
            }
            if (material3D != null) {
                Model model = geoModel3D.getModel();
                int count = model.getSkeletonCount(-1);
                for (int i = 0; i < count; ++i) {
                    Skeleton skeleton = model.getSkeleton(new SkeletonID(-1, 0));
                    skeleton.setMaterial(material3D);
                    model.update(skeleton);
                }
                geoModel3D.setModel(model);
                result = geoModel3D;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static Geometry correctRegionDirection(Geometry geometry) {
        GeoRegion result = null;
        GeoRegion[] geoRegions = null;
        GeoRegion curRegion = null;
        if (geometry.getType() == GeometryType.GEOREGION) {
            curRegion = (GeoRegion)geometry;
            result = new GeoRegion();
        } else if (geometry.getType() == GeometryType.GEOREGION3D) {
            curRegion = ModelBuilder3DTools.convertToRegion((GeoRegion3D)geometry);
        }
        geoRegions = curRegion.getPartCount() > 1 ? curRegion.protectedDecompose() : new GeoRegion[]{curRegion};
        for (int i = 0; i < geoRegions.length; ++i) {
            GeoRegion region = ModelBuilder3DTools.clockwiseRegion(geoRegions[i]);
            for (int j = 0; j < region.getPartCount(); ++j) {
                result.addPart(region.getPart(j));
            }
        }
        return result;
    }

    private static GeoRegion convertToRegion(GeoRegion3D geoRegion3D) {
        GeoRegion result = null;
        if (geoRegion3D != null) {
            for (int i = 0; i < geoRegion3D.getPartCount(); ++i) {
                Point3Ds point3Ds = geoRegion3D.getPart(i);
                result.addPart(point3Ds.toPoint2Ds());
            }
        }
        return result;
    }

    private static GeoRegion clockwiseRegion(GeoRegion geoRegion) {
        if (geoRegion == null) {
            return null;
        }
        for (int i = 0; i < geoRegion.getPartCount(); ++i) {
            if ((i != 0 || geoRegion.isCounterClockwise(i)) && (i <= 0 || !geoRegion.isCounterClockwise(i))) continue;
            GeoLine geoLine = new GeoLine(geoRegion.getPart(i));
            geoLine.reverse();
            geoRegion.setPart(i, geoLine.getPart(0));
        }
        return geoRegion;
    }

    static {
        m_message = "\u6b63\u5728\u5904\u7406\u7b2c%d\u4e2a\u5bf9\u8c61\uff0c\u5171%d\u4e2a\u5bf9\u8c61";
    }
}

