/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy;

import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeometriesRelation;
import com.supermap.data.Geometrist;
import com.supermap.data.Geometry;
import com.supermap.data.Recordset;
import com.supermap.data.SpatialQueryMode;
import com.supermap.jsuperpy.Converts;
import com.supermap.jsuperpy.StatisticsMode;
import com.supermap.jsuperpy.serializer.DataSerializers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

final class UpdateAttributes {
    private UpdateAttributes() {
    }

    public static boolean updateAttributes(DatasetVector sourceDataset, DatasetVector targetDataset, SpatialQueryMode spatialQueryMode, List<String> statFields, List<StatisticsMode> statModes, double tolerance) {
        if (sourceDataset == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        if (targetDataset == null) {
            throw new IllegalArgumentException("DatasetVector target is null");
        }
        if (spatialQueryMode == null) {
            throw new IllegalArgumentException("Spatial Query Mode is null");
        }
        if (statFields == null) {
            throw new IllegalArgumentException("Statistics field names is null");
        }
        if (statModes == null) {
            throw new IllegalArgumentException("Statistics modes is null");
        }
        if (statFields.size() != statModes.size()) {
            throw new RuntimeException("The count of stat field names is not equal stat modes");
        }
        if (tolerance <= 0.0) {
            tolerance = 1.0E-6;
        }
        FieldInfos sourceFieldInfos = sourceDataset.getFieldInfos();
        ArrayList<FieldInfo> targetFieldInfos = new ArrayList<FieldInfo>();
        ArrayList<String> aryStatSourceField = new ArrayList<String>();
        ArrayList<StatisticsMode> aryStatFieldStat = new ArrayList<StatisticsMode>();
        boolean hasRecordCountStat = false;
        for (int i = 0; i < statFields.size(); ++i) {
            FieldInfo newFieldInfo;
            String fieldName = statFields.get(i);
            StatisticsMode statMode = statModes.get(i);
            if (statMode == StatisticsMode.COUNT && !hasRecordCountStat) {
                targetFieldInfos.add(new FieldInfo("RecordCount", FieldType.INT32));
                hasRecordCountStat = true;
                aryStatSourceField.add("");
                aryStatFieldStat.add(StatisticsMode.COUNT);
                continue;
            }
            int sourceFieldIndex = sourceFieldInfos.indexOf(fieldName);
            if (sourceFieldIndex == -1) continue;
            FieldInfo fieldInfo = sourceFieldInfos.get(sourceFieldIndex);
            if (statMode == StatisticsMode.MAX) {
                newFieldInfo = new FieldInfo(fieldInfo);
                newFieldInfo.setName(fieldName + "_Max");
                newFieldInfo.setCaption(newFieldInfo.getName());
                targetFieldInfos.add(newFieldInfo);
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.MIN) {
                newFieldInfo = new FieldInfo(fieldInfo);
                newFieldInfo.setName(fieldName + "_Min");
                targetFieldInfos.add(newFieldInfo);
                newFieldInfo.setCaption(newFieldInfo.getName());
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.MODALVALUE) {
                newFieldInfo = new FieldInfo(fieldInfo);
                newFieldInfo.setName(fieldName + "_ModalValue");
                newFieldInfo.setCaption(newFieldInfo.getName());
                targetFieldInfos.add(newFieldInfo);
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.SUM) {
                if (!Converts.isNumericalField(fieldInfo.getType())) continue;
                newFieldInfo = new FieldInfo(fieldName + "_Sum", FieldType.DOUBLE);
                newFieldInfo.setCaption(newFieldInfo.getName());
                targetFieldInfos.add(newFieldInfo);
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.STDEV) {
                if (!Converts.isNumericalField(fieldInfo.getType())) continue;
                newFieldInfo = new FieldInfo(fieldName + "_Sum", FieldType.DOUBLE);
                newFieldInfo.setCaption(newFieldInfo.getName());
                targetFieldInfos.add(new FieldInfo(fieldName + "_Stdev", FieldType.DOUBLE));
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.VAR) {
                if (!Converts.isNumericalField(fieldInfo.getType())) continue;
                newFieldInfo = new FieldInfo(fieldName + "_Sum", FieldType.DOUBLE);
                newFieldInfo.setCaption(newFieldInfo.getName());
                targetFieldInfos.add(new FieldInfo(fieldName + "_Var", FieldType.DOUBLE));
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.MEAN) {
                if (!Converts.isNumericalField(fieldInfo.getType())) continue;
                newFieldInfo = new FieldInfo(fieldName + "_Sum", FieldType.DOUBLE);
                newFieldInfo.setCaption(newFieldInfo.getName());
                targetFieldInfos.add(new FieldInfo(fieldName + "_Mean", FieldType.DOUBLE));
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode != StatisticsMode.MAXINTERSECTAREA || sourceDataset.getType() != DatasetType.REGION || targetDataset.getType() != DatasetType.REGION) continue;
            newFieldInfo = new FieldInfo(fieldInfo);
            newFieldInfo.setName(fieldName + "_MaxItArea");
            targetFieldInfos.add(newFieldInfo);
            newFieldInfo.setCaption(newFieldInfo.getName());
            aryStatSourceField.add(fieldName);
            aryStatFieldStat.add(statMode);
        }
        ArrayList<Integer> aryStatResultFieldIndex = new ArrayList<Integer>();
        for (int i = 0; i < targetFieldInfos.size(); ++i) {
            FieldInfo fieldInfo = (FieldInfo)targetFieldInfos.get(i);
            if (targetDataset.isAvailableFieldName(fieldInfo.getName())) {
                aryStatResultFieldIndex.add(targetDataset.getFieldInfos().add(fieldInfo));
                continue;
            }
            String validFieldName = targetDataset.getAvailableFieldName(fieldInfo.getName());
            fieldInfo.setName(validFieldName);
            aryStatResultFieldIndex.add(targetDataset.getFieldInfos().add(fieldInfo));
        }
        int[] aryStatSourceFieldIndex = new int[aryStatSourceField.size()];
        HashSet<Integer> fieldsSet = new HashSet<Integer>();
        for (int i = 0; i < aryStatSourceField.size(); ++i) {
            aryStatSourceFieldIndex[i] = sourceFieldInfos.indexOf((String)aryStatSourceField.get(i));
            fieldsSet.add(aryStatSourceFieldIndex[i]);
        }
        Integer[] saveValueFields = new Integer[fieldsSet.size()];
        fieldsSet.toArray(saveValueFields);
        int[] statFieldsIndex = new int[aryStatSourceFieldIndex.length];
        for (int i = 0; i < aryStatSourceFieldIndex.length; ++i) {
            int j;
            for (j = 0; j < saveValueFields.length && aryStatSourceFieldIndex[i] != saveValueFields[j]; ++j) {
            }
            statFieldsIndex[i] = j;
        }
        GeometriesRelation geometriesRelation = new GeometriesRelation();
        geometriesRelation.setTolerance(tolerance);
        Recordset sourceRecordset = sourceDataset.getRecordset(false, CursorType.STATIC);
        if (sourceRecordset == null) {
            throw new RuntimeException("Failed to query source recordset");
        }
        ArrayList<Object[]> aryValues = new ArrayList<Object[]>(sourceRecordset.getRecordCount());
        ArrayList<GeoRegion> aryRegions = new ArrayList<GeoRegion>(sourceRecordset.getRecordCount());
        int indexSrc = 0;
        while (!sourceRecordset.isEOF()) {
            Geometry geo = sourceRecordset.getGeometry();
            geometriesRelation.insert(sourceRecordset.getGeometry(), indexSrc);
            ++indexSrc;
            Object[] values = new Object[saveValueFields.length];
            for (int i = 0; i < saveValueFields.length; ++i) {
                values[i] = saveValueFields[i] == -1 ? null : sourceRecordset.getFieldValue(saveValueFields[i].intValue());
            }
            aryValues.add(values);
            if (geo instanceof GeoRegion) {
                aryRegions.add((GeoRegion)geo);
            }
            sourceRecordset.moveNext();
        }
        sourceRecordset.dispose();
        Recordset targetRecordset = targetDataset.getRecordset(false, CursorType.DYNAMIC);
        if (targetRecordset == null) {
            sourceRecordset.dispose();
            throw new RuntimeException("Failed to query target recordset");
        }
        targetRecordset.getBatch().begin();
        while (!targetRecordset.isEOF()) {
            Geometry geo = targetRecordset.getGeometry();
            int[] sourceIndexes = geometriesRelation.matches(geo, spatialQueryMode);
            for (int i = 0; i < aryStatFieldStat.size(); ++i) {
                int j;
                Object statRes = null;
                StatisticsMode statMode = (StatisticsMode)((Object)aryStatFieldStat.get(i));
                if (statMode == StatisticsMode.COUNT) {
                    statRes = sourceIndexes != null && sourceIndexes.length > 0 ? Integer.valueOf(sourceIndexes.length) : Integer.valueOf(0);
                } else if (sourceIndexes == null || sourceIndexes.length == 0) {
                    statRes = null;
                } else if (statMode == StatisticsMode.MAX) {
                    Object[] tempValues = new Object[sourceIndexes.length];
                    for (int j2 = 0; j2 < sourceIndexes.length; ++j2) {
                        tempValues[j2] = ((Object[])aryValues.get(sourceIndexes[j2]))[i];
                    }
                    Arrays.sort(tempValues);
                    statRes = tempValues[0];
                } else if (statMode == StatisticsMode.MIN) {
                    Object[] tempValues = new Object[sourceIndexes.length];
                    for (int j3 = 0; j3 < sourceIndexes.length; ++j3) {
                        tempValues[j3] = ((Object[])aryValues.get(sourceIndexes[j3]))[i];
                    }
                    Arrays.sort(tempValues);
                    statRes = tempValues[tempValues.length - 1];
                } else if (statMode == StatisticsMode.MODALVALUE) {
                    Object[] tempValues = new Object[sourceIndexes.length];
                    for (int j4 = 0; j4 < sourceIndexes.length; ++j4) {
                        tempValues[j4] = ((Object[])aryValues.get(sourceIndexes[j4]))[i];
                    }
                    Arrays.sort(tempValues);
                    Object modalValue = null;
                    Object prevModalValue = null;
                    int modalCount = 0;
                    int prevModalCount = 0;
                    for (int j5 = 0; j5 < tempValues.length; ++j5) {
                        if (modalCount == 0) {
                            modalCount = 1;
                            modalValue = tempValues[j5];
                            continue;
                        }
                        if (modalValue == tempValues[j5]) {
                            ++modalCount;
                            continue;
                        }
                        if (modalCount > prevModalCount) {
                            prevModalCount = modalCount;
                            prevModalValue = modalValue;
                        }
                        modalCount = 0;
                        modalValue = null;
                    }
                    if (prevModalValue == null) {
                        prevModalValue = modalValue;
                    }
                    statRes = prevModalValue;
                } else if (statMode == StatisticsMode.SUM) {
                    double sum = 0.0;
                    for (int j6 = 0; j6 < sourceIndexes.length; ++j6) {
                        sum += Converts.toDouble(((Object[])aryValues.get(sourceIndexes[j6]))[i]);
                    }
                    statRes = sum;
                } else if (statMode == StatisticsMode.STDEV) {
                    double sum = 0.0;
                    for (int j7 = 0; j7 < sourceIndexes.length; ++j7) {
                        sum += Converts.toDouble(((Object[])aryValues.get(sourceIndexes[j7]))[i]);
                    }
                    double average = sum / (double)sourceIndexes.length;
                    double powValues = 0.0;
                    for (j = 0; j < sourceIndexes.length; ++j) {
                        powValues += Math.pow(Converts.toDouble(((Object[])aryValues.get(sourceIndexes[j]))[i]) - average, 2.0);
                    }
                    statRes = Math.sqrt(powValues / (double)(sourceIndexes.length - 1));
                } else if (statMode == StatisticsMode.VAR) {
                    double sum = 0.0;
                    for (int j8 = 0; j8 < sourceIndexes.length; ++j8) {
                        sum += Converts.toDouble(((Object[])aryValues.get(sourceIndexes[j8]))[i]);
                    }
                    double average = sum / (double)sourceIndexes.length;
                    double powValues = 0.0;
                    for (j = 0; j < sourceIndexes.length; ++j) {
                        powValues += Math.pow(Converts.toDouble(((Object[])aryValues.get(sourceIndexes[j]))[i]) - average, 2.0);
                    }
                    statRes = powValues / (double)(sourceIndexes.length - 1);
                } else if (statMode == StatisticsMode.MEAN) {
                    double sum = 0.0;
                    for (int j9 = 0; j9 < sourceIndexes.length; ++j9) {
                        sum += Converts.toDouble(((Object[])aryValues.get(sourceIndexes[j9]))[i]);
                    }
                    statRes = sum / (double)sourceIndexes.length;
                } else if (statMode == StatisticsMode.MAXINTERSECTAREA) {
                    if (geo instanceof GeoRegion) {
                        GeoRegion targetRegion = (GeoRegion)geo;
                        double maxArea = -1.0;
                        int maxAreaIndex = -1;
                        for (int j10 = 0; j10 < sourceIndexes.length; ++j10) {
                            double tempArea;
                            GeoRegion sourceRegion = (GeoRegion)aryRegions.get(sourceIndexes[j10]);
                            Geometry geoRes = Geometrist.clip((Geometry)sourceRegion, (Geometry)targetRegion);
                            if (geoRes == null || !(geoRes instanceof GeoRegion) || !((tempArea = ((GeoRegion)geoRes).getArea()) > maxArea)) continue;
                            maxArea = tempArea;
                            maxAreaIndex = j10;
                        }
                        statRes = maxAreaIndex != -1 ? ((Object[])aryValues.get(sourceIndexes[maxAreaIndex]))[i] : null;
                    } else {
                        statRes = null;
                    }
                } else {
                    statRes = null;
                }
                if (statRes != null) {
                    targetRecordset.setFieldValue(((Integer)aryStatResultFieldIndex.get(i)).intValue(), statRes);
                    continue;
                }
                targetRecordset.setFieldValueNull(((Integer)aryStatResultFieldIndex.get(i)).intValue());
            }
            targetRecordset.moveNext();
        }
        targetRecordset.getBatch().update();
        targetRecordset.dispose();
        aryRegions.clear();
        geometriesRelation.dispose();
        return true;
    }

    static {
        DataSerializers.registerEnum(StatisticsMode.class);
    }
}

