/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy;

import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldSign;
import com.supermap.data.FieldType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoPoint3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.TextPart;
import com.supermap.jsuperpy.LineToPointMode;
import com.supermap.jsuperpy.RegionToPointMode;
import com.supermap.jsuperpy.StatisticsMode;
import com.supermap.jsuperpy.serializer.DataSerializers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

final class Converts {
    Converts() {
    }

    public static DatasetVector convertDatasetDim2To3(DatasetVector source, String zField, String toZField, List<String> savedFields, Datasource outDatasource, String resultName) {
        Recordset recordset;
        int i;
        FieldInfos sourceFieldInfos;
        DatasetType targetDtType;
        FieldInfo fieldInfo;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        int nZFieldIndex = source.getFieldInfos().indexOf(zField);
        if (nZFieldIndex == -1) {
            throw new IllegalArgumentException("Z field is not existed : " + zField);
        }
        int nToZFieldIndex = -1;
        if (toZField != null && !toZField.isEmpty()) {
            nToZFieldIndex = source.getFieldInfos().indexOf(toZField);
        }
        if (nToZFieldIndex == -1) {
            nToZFieldIndex = nZFieldIndex;
        }
        if ((fieldInfo = source.getFieldInfos().get(nZFieldIndex)).getType() != FieldType.DOUBLE && fieldInfo.getType() != FieldType.SINGLE && fieldInfo.getType() != FieldType.INT16 && fieldInfo.getType() != FieldType.INT32 && fieldInfo.getType() != FieldType.INT64) {
            throw new IllegalArgumentException("Z field must be double, single, int16, int32 or int64, but is " + fieldInfo.getType().name());
        }
        DatasetType sourceType = source.getType();
        if (sourceType == DatasetType.POINT) {
            targetDtType = DatasetType.POINT3D;
        } else if (sourceType == DatasetType.LINE) {
            targetDtType = DatasetType.LINE3D;
        } else if (sourceType == DatasetType.REGION) {
            targetDtType = DatasetType.REGION3D;
        } else {
            throw new IllegalArgumentException("DatasetVector source required Point, Line or Region, but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, targetDtType));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<Integer> sourceFields = new ArrayList<Integer>();
        ArrayList<Integer> targetFields = new ArrayList<Integer>();
        if (savedFields == null) {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add(i);
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(i);
                targetFields.add(nTargetIndex);
            }
        } else {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(sourceFieldInfos.indexOf(savedFields.get(i)));
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(nSrcIndex);
                targetFields.add(nTargetIndex);
            }
        }
        if ((recordset = source.getRecordset(false, CursorType.STATIC)) == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        resultRecordset.getBatch().begin();
        while (!recordset.isEOF()) {
            try {
                Point2Ds point2Ds;
                int i2;
                double zValue = recordset.getDouble(nZFieldIndex);
                double toZValue = 0.0;
                toZValue = nToZFieldIndex != nZFieldIndex ? recordset.getDouble(nToZFieldIndex) : zValue;
                Geometry geo = recordset.getGeometry();
                if (sourceType == DatasetType.POINT) {
                    GeoPoint geoPoint = (GeoPoint)geo;
                    GeoPoint3D geoPoint3D = new GeoPoint3D(geoPoint.getX(), geoPoint.getY(), zValue);
                    resultRecordset.addNew((Geometry)geoPoint3D);
                    geoPoint.dispose();
                    geoPoint3D.dispose();
                } else if (sourceType == DatasetType.LINE) {
                    GeoLine geoLine = (GeoLine)geo;
                    GeoLine3D geoLine3D = new GeoLine3D();
                    for (i2 = 0; i2 < geoLine.getPartCount(); ++i2) {
                        point2Ds = geoLine.getPart(i2);
                        double increment = (zValue - toZValue) / (double)point2Ds.getCount();
                        Point3Ds point3Ds = new Point3Ds();
                        for (int j = 0; j < point2Ds.getCount(); ++j) {
                            point3Ds.add(new Point3D(point2Ds.getItem(j).getX(), point2Ds.getItem(j).getY(), zValue + increment * (double)j));
                        }
                        geoLine3D.addPart(point3Ds);
                    }
                    resultRecordset.addNew((Geometry)geoLine3D);
                    geoLine3D.dispose();
                } else {
                    GeoRegion geoRegion = (GeoRegion)geo;
                    GeoRegion3D geoRegion3D = new GeoRegion3D();
                    for (i2 = 0; i2 < geoRegion.getPartCount(); ++i2) {
                        point2Ds = geoRegion.getPart(i2);
                        Point3Ds point3Ds = new Point3Ds();
                        for (int j = 0; j < point2Ds.getCount(); ++j) {
                            point3Ds.add(new Point3D(point2Ds.getItem(j).getX(), point2Ds.getItem(j).getY(), zValue));
                        }
                        geoRegion3D.addPart(point3Ds);
                    }
                    resultRecordset.addNew((Geometry)geoRegion3D);
                    geoRegion3D.dispose();
                    geoRegion.dispose();
                }
                for (int i3 = 0; i3 < sourceFields.size(); ++i3) {
                    Object value = recordset.getFieldValue(((Integer)sourceFields.get(i3)).intValue());
                    resultRecordset.setFieldValue(((Integer)targetFields.get(i3)).intValue(), value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            recordset.moveNext();
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    public static DatasetVector convertDatasetDim2To3(DatasetVector source, double zValue, List<String> savedFields, Datasource outDatasource, String resultName) {
        Recordset recordset;
        int i;
        FieldInfos sourceFieldInfos;
        DatasetType targetDtType;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType == DatasetType.POINT) {
            targetDtType = DatasetType.POINT3D;
        } else if (sourceType == DatasetType.LINE) {
            targetDtType = DatasetType.LINE3D;
        } else if (sourceType == DatasetType.REGION) {
            targetDtType = DatasetType.REGION3D;
        } else {
            throw new IllegalArgumentException("DatasetVector source required Point, Line or Region, but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, targetDtType));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<Integer> sourceFields = new ArrayList<Integer>();
        ArrayList<Integer> targetFields = new ArrayList<Integer>();
        if (savedFields == null) {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add(i);
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(i);
                targetFields.add(nTargetIndex);
            }
        } else {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(sourceFieldInfos.indexOf(savedFields.get(i)));
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(nSrcIndex);
                targetFields.add(nTargetIndex);
            }
        }
        if ((recordset = source.getRecordset(false, CursorType.STATIC)) == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        resultRecordset.getBatch().begin();
        while (!recordset.isEOF()) {
            try {
                int j;
                Point3Ds point3Ds;
                Point2Ds point2Ds;
                int i2;
                Geometry geo = recordset.getGeometry();
                if (sourceType == DatasetType.POINT) {
                    GeoPoint geoPoint = (GeoPoint)geo;
                    GeoPoint3D geoPoint3D = new GeoPoint3D(geoPoint.getX(), geoPoint.getY(), zValue);
                    resultRecordset.addNew((Geometry)geoPoint3D);
                    geoPoint.dispose();
                    geoPoint3D.dispose();
                } else if (sourceType == DatasetType.LINE) {
                    GeoLine geoLine = (GeoLine)geo;
                    GeoLine3D geoLine3D = new GeoLine3D();
                    for (i2 = 0; i2 < geoLine.getPartCount(); ++i2) {
                        point2Ds = geoLine.getPart(i2);
                        point3Ds = new Point3Ds();
                        for (j = 0; j < point2Ds.getCount(); ++j) {
                            point3Ds.add(new Point3D(point2Ds.getItem(j).getX(), point2Ds.getItem(j).getY(), zValue));
                        }
                        geoLine3D.addPart(point3Ds);
                    }
                    resultRecordset.addNew((Geometry)geoLine3D);
                    geoLine3D.dispose();
                } else {
                    GeoRegion geoRegion = (GeoRegion)geo;
                    GeoRegion3D geoRegion3D = new GeoRegion3D();
                    for (i2 = 0; i2 < geoRegion.getPartCount(); ++i2) {
                        point2Ds = geoRegion.getPart(i2);
                        point3Ds = new Point3Ds();
                        for (j = 0; j < point2Ds.getCount(); ++j) {
                            point3Ds.add(new Point3D(point2Ds.getItem(j).getX(), point2Ds.getItem(j).getY(), zValue));
                        }
                        geoRegion3D.addPart(point3Ds);
                    }
                    resultRecordset.addNew((Geometry)geoRegion3D);
                    geoRegion3D.dispose();
                    geoRegion.dispose();
                }
                for (int i3 = 0; i3 < sourceFields.size(); ++i3) {
                    Object value = recordset.getFieldValue(((Integer)sourceFields.get(i3)).intValue());
                    resultRecordset.setFieldValue(((Integer)targetFields.get(i3)).intValue(), value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            recordset.moveNext();
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    public static DatasetVector convertDatasetDim3To2(DatasetVector source, String outZField, List<String> savedFields, Datasource outDatasource, String resultName) {
        int i;
        FieldInfos sourceFieldInfos;
        DatasetType targetDtType;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType == DatasetType.POINT3D) {
            targetDtType = DatasetType.POINT;
        } else if (sourceType == DatasetType.LINE3D) {
            targetDtType = DatasetType.LINE;
        } else if (sourceType == DatasetType.REGION3D) {
            targetDtType = DatasetType.REGION;
        } else {
            throw new IllegalArgumentException("DatasetVector source required Point3D, Line3D or Region3D, but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, targetDtType));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<Integer> sourceFields = new ArrayList<Integer>();
        ArrayList<Integer> targetFields = new ArrayList<Integer>();
        if (savedFields == null) {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add(i);
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(i);
                targetFields.add(nTargetIndex);
            }
        } else {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(sourceFieldInfos.indexOf(savedFields.get(i)));
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(nSrcIndex);
                targetFields.add(nTargetIndex);
            }
        }
        if (outZField == null || outZField.isEmpty()) {
            outZField = "Z";
        }
        String zFieldName = resultDataset.getAvailableFieldName(outZField);
        int zFieldIndex = resultDataset.getFieldInfos().add(new FieldInfo(zFieldName, FieldType.DOUBLE));
        Recordset recordset = source.getRecordset(false, CursorType.STATIC);
        if (recordset == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        resultRecordset.getBatch().begin();
        while (!recordset.isEOF()) {
            try {
                int j;
                Point2Ds point2Ds;
                Point3Ds point3Ds;
                int i2;
                Geometry geo = recordset.getGeometry();
                if (sourceType == DatasetType.POINT3D) {
                    GeoPoint3D geoPoint3D = (GeoPoint3D)geo;
                    GeoPoint geoPoint = new GeoPoint(geoPoint3D.getX(), geoPoint3D.getY());
                    resultRecordset.addNew((Geometry)geoPoint);
                    resultRecordset.setFieldValue(zFieldIndex, (Object)geoPoint3D.getZ());
                    geoPoint.dispose();
                    geoPoint3D.dispose();
                } else if (sourceType == DatasetType.LINE3D) {
                    GeoLine3D geoLine3D = (GeoLine3D)geo;
                    double zValue = 0.0;
                    GeoLine geoLine = new GeoLine();
                    for (i2 = 0; i2 < geoLine3D.getPartCount(); ++i2) {
                        point3Ds = geoLine3D.getPart(i2);
                        point2Ds = new Point2Ds();
                        for (j = 0; j < point3Ds.getCount(); ++j) {
                            point2Ds.add(new Point2D(point3Ds.getItem(j).getX(), point3Ds.getItem(j).getY()));
                            zValue += point3Ds.getItem(j).getZ();
                        }
                        zValue /= (double)point3Ds.getCount();
                        geoLine.addPart(point2Ds);
                    }
                    resultRecordset.addNew((Geometry)geoLine);
                    resultRecordset.setFieldValue(zFieldIndex, (Object)zValue);
                    geoLine.dispose();
                } else {
                    GeoRegion3D geoRegion3D = (GeoRegion3D)geo;
                    GeoRegion geoRegion = new GeoRegion();
                    double zValue = 0.0;
                    for (i2 = 0; i2 < geoRegion3D.getPartCount(); ++i2) {
                        point3Ds = geoRegion3D.getPart(i2);
                        point2Ds = new Point2Ds();
                        for (j = 0; j < point3Ds.getCount(); ++j) {
                            point2Ds.add(new Point2D(point3Ds.getItem(j).getX(), point3Ds.getItem(j).getY()));
                            zValue += point3Ds.getItem(j).getZ();
                        }
                        zValue /= (double)point3Ds.getCount();
                        geoRegion.addPart(point2Ds);
                    }
                    resultRecordset.addNew((Geometry)geoRegion);
                    resultRecordset.setFieldValue(zFieldIndex, (Object)zValue);
                    geoRegion.dispose();
                    geoRegion3D.dispose();
                }
                for (int i3 = 0; i3 < sourceFields.size(); ++i3) {
                    Object value = recordset.getFieldValue(((Integer)sourceFields.get(i3)).intValue());
                    resultRecordset.setFieldValue(((Integer)targetFields.get(i3)).intValue(), value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            recordset.moveNext();
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    static boolean isNumericalField(FieldType fieldType) {
        return fieldType == FieldType.INT16 || fieldType == FieldType.INT32 || fieldType == FieldType.INT64 || fieldType == FieldType.SINGLE || fieldType == FieldType.DOUBLE;
    }

    public static double toDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (Exception exception) {
                return 0.0;
            }
        }
        return 0.0;
    }

    private static void statAttributes(ArrayList<StatisticsMode> aryStatFieldStat, ArrayList<Integer> aryStatResultFieldIndex, ArrayList<Object[]> aryValues, Recordset resultRecordset) {
        for (int i = 0; i < aryStatFieldStat.size(); ++i) {
            int j;
            StatisticsMode statMode = aryStatFieldStat.get(i);
            if (statMode == StatisticsMode.COUNT) {
                resultRecordset.setFieldValue(aryStatResultFieldIndex.get(i).intValue(), (Object)aryValues.size());
                continue;
            }
            if (statMode == StatisticsMode.MAX) {
                Object[] tempValues = new Object[aryValues.size()];
                for (int j2 = 0; j2 < aryValues.size(); ++j2) {
                    tempValues[j2] = aryValues.get(j2)[i];
                }
                Arrays.sort(tempValues);
                resultRecordset.setFieldValue(aryStatResultFieldIndex.get(i).intValue(), tempValues[0]);
                continue;
            }
            if (statMode == StatisticsMode.MIN) {
                Object[] tempValues = new Object[aryValues.size()];
                for (int j3 = 0; j3 < aryValues.size(); ++j3) {
                    tempValues[j3] = aryValues.get(j3)[i];
                }
                Arrays.sort(tempValues);
                resultRecordset.setFieldValue(aryStatResultFieldIndex.get(i).intValue(), tempValues[tempValues.length - 1]);
                continue;
            }
            if (statMode == StatisticsMode.MODALVALUE) {
                Object[] tempValues = new Object[aryValues.size()];
                for (int j4 = 0; j4 < aryValues.size(); ++j4) {
                    tempValues[j4] = aryValues.get(j4)[i];
                }
                Arrays.sort(tempValues);
                Object modalValue = null;
                Object prevModalValue = null;
                int modalCount = 0;
                int prevModalCount = 0;
                for (int j5 = 0; j5 < tempValues.length; ++j5) {
                    if (modalCount == 0) {
                        modalCount = 1;
                        modalValue = tempValues[j5];
                        continue;
                    }
                    if (modalValue == tempValues[j5]) {
                        ++modalCount;
                        continue;
                    }
                    if (modalCount > prevModalCount) {
                        prevModalCount = modalCount;
                        prevModalValue = modalValue;
                    }
                    modalCount = 0;
                    modalValue = null;
                }
                if (prevModalValue == null) {
                    prevModalValue = modalValue;
                }
                resultRecordset.setFieldValue(aryStatResultFieldIndex.get(i).intValue(), prevModalValue);
                continue;
            }
            if (statMode == StatisticsMode.SUM) {
                double sum = 0.0;
                for (int j6 = 0; j6 < aryValues.size(); ++j6) {
                    sum += Converts.toDouble(aryValues.get(j6)[i]);
                }
                resultRecordset.setFieldValue(aryStatResultFieldIndex.get(i).intValue(), (Object)sum);
                continue;
            }
            if (statMode == StatisticsMode.STDEV) {
                double sum = 0.0;
                for (int j7 = 0; j7 < aryValues.size(); ++j7) {
                    sum += Converts.toDouble(aryValues.get(j7)[i]);
                }
                double average = sum / (double)aryValues.size();
                double powValues = 0.0;
                for (j = 0; j < aryValues.size(); ++j) {
                    powValues += Math.pow(Converts.toDouble(aryValues.get(j)[i]) - average, 2.0);
                }
                resultRecordset.setFieldValue(aryStatResultFieldIndex.get(i).intValue(), (Object)Math.sqrt(powValues / (double)(aryValues.size() - 1)));
                continue;
            }
            if (statMode == StatisticsMode.VAR) {
                double sum = 0.0;
                for (int j8 = 0; j8 < aryValues.size(); ++j8) {
                    sum += Converts.toDouble(aryValues.get(j8)[i]);
                }
                double average = sum / (double)aryValues.size();
                double powValues = 0.0;
                for (j = 0; j < aryValues.size(); ++j) {
                    powValues += Math.pow(Converts.toDouble(aryValues.get(j)[i]) - average, 2.0);
                }
                resultRecordset.setFieldValue(aryStatResultFieldIndex.get(i).intValue(), (Object)(powValues / (double)(aryValues.size() - 1)));
                continue;
            }
            if (statMode != StatisticsMode.MEAN) continue;
            double sum = 0.0;
            for (int j9 = 0; j9 < aryValues.size(); ++j9) {
                sum += Converts.toDouble(aryValues.get(j9)[i]);
            }
            resultRecordset.setFieldValue(aryStatResultFieldIndex.get(i).intValue(), (Object)(sum / (double)aryValues.size()));
        }
    }

    public static DatasetVector convertDatasetPointToLine(DatasetVector source, List<String> groupFields, List<String> orderFields, List<String> statFields, List<StatisticsMode> statModes, Datasource outDatasource, String resultName) {
        int i;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType != DatasetType.POINT && sourceType != DatasetType.POINT3D) {
            throw new IllegalArgumentException("DatasetVector source required Point but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        boolean isPoint3D = false;
        DatasetVectorInfo dtInfo = new DatasetVectorInfo();
        dtInfo.setName(resultName);
        if (sourceType == DatasetType.POINT3D) {
            dtInfo.setType(DatasetType.LINE3D);
            isPoint3D = true;
        } else {
            dtInfo.setType(DatasetType.LINE);
            isPoint3D = false;
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(dtInfo);
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        if (groupFields == null) {
            groupFields = new ArrayList<String>();
        }
        if (orderFields == null) {
            orderFields = new ArrayList<String>();
        }
        source.open();
        FieldInfos sourceFieldInfos = source.getFieldInfos();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        if (statFields == null || statModes == null) {
            statFields = new ArrayList<String>();
            statModes = new ArrayList<StatisticsMode>();
        } else if (statFields.size() != statModes.size()) {
            throw new RuntimeException("The count of stat field names is not equal stat modes");
        }
        ArrayList<FieldInfo> targetFieldInfos = new ArrayList<FieldInfo>();
        ArrayList<String> aryStatSourceField = new ArrayList<String>();
        ArrayList<StatisticsMode> aryStatFieldStat = new ArrayList<StatisticsMode>();
        boolean hasRecordCountStat = false;
        for (int i2 = 0; i2 < statFields.size(); ++i2) {
            FieldInfo newFieldInfo;
            String fieldName = statFields.get(i2);
            StatisticsMode statMode = statModes.get(i2);
            if (statMode == StatisticsMode.COUNT) {
                if (hasRecordCountStat) continue;
                targetFieldInfos.add(new FieldInfo("RecordCount", FieldType.INT32));
                hasRecordCountStat = true;
                aryStatSourceField.add("");
                aryStatFieldStat.add(StatisticsMode.COUNT);
                continue;
            }
            int sourceFieldIndex = sourceFieldInfos.indexOf(fieldName);
            if (sourceFieldIndex == -1) continue;
            FieldInfo fieldInfo = sourceFieldInfos.get(sourceFieldIndex);
            if (statMode == StatisticsMode.MAX) {
                newFieldInfo = new FieldInfo(fieldInfo);
                newFieldInfo.setName(fieldName + "_Max");
                newFieldInfo.setCaption(newFieldInfo.getName());
                targetFieldInfos.add(newFieldInfo);
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.MIN) {
                newFieldInfo = new FieldInfo(fieldInfo);
                newFieldInfo.setName(fieldName + "_Min");
                targetFieldInfos.add(newFieldInfo);
                newFieldInfo.setCaption(newFieldInfo.getName());
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.MODALVALUE) {
                newFieldInfo = new FieldInfo(fieldInfo);
                newFieldInfo.setName(fieldName + "_ModalValue");
                newFieldInfo.setCaption(newFieldInfo.getName());
                targetFieldInfos.add(newFieldInfo);
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.SUM) {
                if (!Converts.isNumericalField(fieldInfo.getType())) continue;
                newFieldInfo = new FieldInfo(fieldName + "_Sum", FieldType.DOUBLE);
                newFieldInfo.setCaption(newFieldInfo.getName());
                targetFieldInfos.add(newFieldInfo);
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.STDEV) {
                if (!Converts.isNumericalField(fieldInfo.getType())) continue;
                targetFieldInfos.add(new FieldInfo(fieldName + "_Stdev", FieldType.DOUBLE));
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode == StatisticsMode.VAR) {
                if (!Converts.isNumericalField(fieldInfo.getType())) continue;
                targetFieldInfos.add(new FieldInfo(fieldName + "_Var", FieldType.DOUBLE));
                aryStatSourceField.add(fieldName);
                aryStatFieldStat.add(statMode);
                continue;
            }
            if (statMode != StatisticsMode.MEAN || !Converts.isNumericalField(fieldInfo.getType())) continue;
            targetFieldInfos.add(new FieldInfo(fieldName + "_Mean", FieldType.DOUBLE));
            aryStatSourceField.add(fieldName);
            aryStatFieldStat.add(statMode);
        }
        ArrayList<Integer> aryStatResultFieldIndex = new ArrayList<Integer>();
        for (int i3 = 0; i3 < targetFieldInfos.size(); ++i3) {
            FieldInfo fieldInfo = (FieldInfo)targetFieldInfos.get(i3);
            if (resultDataset.isAvailableFieldName(fieldInfo.getName())) {
                aryStatResultFieldIndex.add(resultDataset.getFieldInfos().add(fieldInfo));
                continue;
            }
            String validFieldName = resultDataset.getAvailableFieldName(fieldInfo.getName());
            fieldInfo.setName(validFieldName);
            aryStatResultFieldIndex.add(resultDataset.getFieldInfos().add(fieldInfo));
        }
        int[] aryStatSourceFieldIndex = new int[aryStatSourceField.size()];
        for (int i4 = 0; i4 < aryStatSourceField.size(); ++i4) {
            aryStatSourceFieldIndex[i4] = sourceFieldInfos.indexOf((String)aryStatSourceField.get(i4));
        }
        ArrayList<String> validOrderFields = new ArrayList<String>();
        if (orderFields != null || orderFields.isEmpty()) {
            for (int i5 = 0; i5 < orderFields.size(); ++i5) {
                if (sourceFieldInfos.indexOf(orderFields.get(i5)) == -1) continue;
                validOrderFields.add(orderFields.get(i5));
            }
        } else {
            validOrderFields.add("SmID");
        }
        ArrayList<String> validGroupFields = new ArrayList<String>();
        if (groupFields != null) {
            for (int i6 = 0; i6 < groupFields.size(); ++i6) {
                if (sourceFieldInfos.indexOf(groupFields.get(i6)) == -1) continue;
                validGroupFields.add(groupFields.get(i6));
            }
        }
        ArrayList<String> sortsFields = new ArrayList<String>();
        for (i = 0; i < validGroupFields.size(); ++i) {
            sortsFields.add((String)validGroupFields.get(i) + " asc");
        }
        for (i = 0; i < validOrderFields.size(); ++i) {
            sortsFields.add((String)validOrderFields.get(i) + " asc");
        }
        String[] allSortFields = new String[validGroupFields.size() + validOrderFields.size()];
        sortsFields.toArray(allSortFields);
        QueryParameter parameter = new QueryParameter();
        if (allSortFields.length > 0) {
            parameter.setOrderBy(allSortFields);
        }
        parameter.setCursorType(CursorType.STATIC);
        Recordset recordset = source.query(parameter);
        if (recordset == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        int[] groupFieldIndexes = new int[groupFields.size()];
        for (int i7 = 0; i7 < groupFields.size(); ++i7) {
            groupFieldIndexes[i7] = sourceFieldInfos.indexOf(groupFields.get(i7));
        }
        ArrayList<Object> aryPoints = new ArrayList<Object>();
        ArrayList<Object[]> aryValues = new ArrayList<Object[]>();
        Object[] groupValues = new Object[validGroupFields.size()];
        resultRecordset.getBatch().begin();
        while (!recordset.isEOF()) {
            try {
                int i8;
                Geometry geometry = recordset.getGeometry();
                Object[] values = new Object[validGroupFields.size()];
                for (int i9 = 0; i9 < groupFieldIndexes.length; ++i9) {
                    values[i9] = recordset.getFieldValue(groupFieldIndexes[i9]);
                }
                Object[] statValues = new Object[aryStatSourceFieldIndex.length];
                for (i8 = 0; i8 < aryStatSourceFieldIndex.length; ++i8) {
                    statValues[i8] = aryStatSourceFieldIndex[i8] != -1 ? recordset.getFieldValue(aryStatSourceFieldIndex[i8]) : null;
                }
                if (aryPoints.size() == 0) {
                    if (isPoint3D) {
                        aryPoints.add(((GeoPoint3D)geometry).getInnerPoint3D());
                    } else {
                        aryPoints.add(geometry.getInnerPoint());
                    }
                    aryValues.add(statValues);
                    for (i8 = 0; i8 < groupValues.length; ++i8) {
                        groupValues[i8] = values[i8];
                    }
                } else {
                    int i10;
                    boolean isEqual = true;
                    for (i10 = 0; i10 < groupValues.length; ++i10) {
                        if (groupValues[i10] != null) {
                            if (groupValues[i10].equals(values[i10])) continue;
                            isEqual = false;
                            break;
                        }
                        if (values[i10] == null) continue;
                        isEqual = false;
                        break;
                    }
                    if (isEqual) {
                        if (isPoint3D) {
                            aryPoints.add(((GeoPoint3D)geometry).getInnerPoint3D());
                        } else {
                            aryPoints.add(geometry.getInnerPoint());
                        }
                        aryValues.add(statValues);
                    } else {
                        if (aryPoints.size() > 1) {
                            Point3D[] pnts;
                            GeoLine3D geoLine;
                            if (isPoint3D) {
                                geoLine = new GeoLine3D();
                                pnts = new Point3D[aryPoints.size()];
                                aryPoints.toArray(pnts);
                                geoLine.addPart(new Point3Ds(pnts));
                                resultRecordset.addNew((Geometry)geoLine);
                            } else {
                                geoLine = new GeoLine();
                                pnts = new Point2D[aryPoints.size()];
                                aryPoints.toArray(pnts);
                                geoLine.addPart(new Point2Ds((Point2D[])pnts));
                                resultRecordset.addNew((Geometry)geoLine);
                            }
                            Converts.statAttributes(aryStatFieldStat, aryStatResultFieldIndex, aryValues, resultRecordset);
                        }
                        aryPoints.clear();
                        aryValues.clear();
                        if (isPoint3D) {
                            aryPoints.add(((GeoPoint3D)geometry).getInnerPoint3D());
                        } else {
                            aryPoints.add(geometry.getInnerPoint());
                        }
                        aryValues.add(statValues);
                        for (i10 = 0; i10 < groupValues.length; ++i10) {
                            groupValues[i10] = values[i10];
                        }
                    }
                }
            }
            catch (Exception geometry) {
                // empty catch block
            }
            recordset.moveNext();
        }
        if (aryPoints.size() > 1) {
            Point3D[] pnts;
            GeoLine3D geoLine;
            if (isPoint3D) {
                geoLine = new GeoLine3D();
                pnts = new Point3D[aryPoints.size()];
                aryPoints.toArray(pnts);
                geoLine.addPart(new Point3Ds(pnts));
                resultRecordset.addNew((Geometry)geoLine);
            } else {
                geoLine = new GeoLine();
                pnts = new Point2D[aryPoints.size()];
                aryPoints.toArray(pnts);
                geoLine.addPart(new Point2Ds((Point2D[])pnts));
                resultRecordset.addNew((Geometry)geoLine);
            }
            Converts.statAttributes(aryStatFieldStat, aryStatResultFieldIndex, aryValues, resultRecordset);
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    static ArrayList<GeoPoint> convertGeoLineToPoint(GeoLine geoLine, LineToPointMode mode) {
        ArrayList<GeoPoint> aryPoints;
        block10: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block9: {
                                                aryPoints = new ArrayList<GeoPoint>();
                                                if (mode != LineToPointMode.VERTEX) break block9;
                                                int partCount = geoLine.getPartCount();
                                                for (int i = 0; i < partCount; ++i) {
                                                    Point2Ds pnts = geoLine.getPart(i);
                                                    for (int j = 0; j < pnts.getCount(); ++j) {
                                                        aryPoints.add(new GeoPoint(pnts.getItem(j)));
                                                    }
                                                }
                                                break block10;
                                            }
                                            if (mode != LineToPointMode.INNER_POINT) break block11;
                                            aryPoints.add(new GeoPoint(geoLine.getInnerPoint()));
                                            break block10;
                                        }
                                        if (mode != LineToPointMode.END_NODE) break block12;
                                        Point2Ds pnts = geoLine.getPart(geoLine.getPartCount() - 1);
                                        aryPoints.add(new GeoPoint(pnts.getItem(pnts.getCount() - 1)));
                                        break block10;
                                    }
                                    if (mode != LineToPointMode.START_NODE) break block13;
                                    Point2Ds pnts = geoLine.getPart(0);
                                    aryPoints.add(new GeoPoint(pnts.getItem(0)));
                                    break block10;
                                }
                                if (mode != LineToPointMode.START_END_NODE) break block14;
                                Point2Ds pnts = geoLine.getPart(0);
                                aryPoints.add(new GeoPoint(pnts.getItem(0)));
                                pnts = geoLine.getPart(geoLine.getPartCount() - 1);
                                aryPoints.add(new GeoPoint(pnts.getItem(pnts.getCount() - 1)));
                                break block10;
                            }
                            if (mode != LineToPointMode.SEGMENT_INNER_POINT) break block15;
                            int partCount = geoLine.getPartCount();
                            for (int i = 0; i < partCount; ++i) {
                                Point2Ds pnts = geoLine.getPart(i);
                                for (int j = 0; j < pnts.getCount() - 1; ++j) {
                                    Point2D pnt1 = pnts.getItem(j);
                                    Point2D pnt2 = pnts.getItem(j + 1);
                                    aryPoints.add(new GeoPoint(new Point2D((pnt1.x + pnt2.x) / 2.0, (pnt1.y + pnt2.y) / 2.0)));
                                }
                            }
                            break block10;
                        }
                        if (mode != LineToPointMode.SUB_INNER_POINT) break block16;
                        int partCount = geoLine.getPartCount();
                        GeoLine temLine = new GeoLine();
                        for (int i = 0; i < partCount; ++i) {
                            Point2Ds pnts = geoLine.getPart(i);
                            if (temLine.getPartCount() > 0) {
                                temLine.removePart(0);
                            }
                            temLine.addPart(pnts);
                            aryPoints.add(new GeoPoint(temLine.getInnerPoint()));
                        }
                        break block10;
                    }
                    if (mode != LineToPointMode.SUB_START_END_NODE) break block17;
                    int partCount = geoLine.getPartCount();
                    for (int i = 0; i < partCount; ++i) {
                        Point2Ds pnts = geoLine.getPart(i);
                        aryPoints.add(new GeoPoint(pnts.getItem(0)));
                        aryPoints.add(new GeoPoint(pnts.getItem(pnts.getCount() - 1)));
                    }
                    break block10;
                }
                if (mode != LineToPointMode.SUB_END_NODE) break block18;
                int partCount = geoLine.getPartCount();
                for (int i = 0; i < partCount; ++i) {
                    Point2Ds pnts = geoLine.getPart(i);
                    aryPoints.add(new GeoPoint(pnts.getItem(pnts.getCount() - 1)));
                }
                break block10;
            }
            if (mode != LineToPointMode.SUB_START_NODE) break block10;
            int partCount = geoLine.getPartCount();
            for (int i = 0; i < partCount; ++i) {
                Point2Ds pnts = geoLine.getPart(i);
                aryPoints.add(new GeoPoint(pnts.getItem(0)));
            }
        }
        return aryPoints;
    }

    static ArrayList<GeoPoint> convertGeoRegionToPoint(GeoRegion geoRegion, RegionToPointMode mode) {
        ArrayList<GeoPoint> aryPoints = new ArrayList<GeoPoint>();
        if (mode == RegionToPointMode.INNER_POINT) {
            aryPoints.add(new GeoPoint(geoRegion.getInnerPoint()));
        } else if (mode == RegionToPointMode.SUB_INNER_POINT) {
            int partCount = geoRegion.getPartCount();
            GeoLine temLine = new GeoLine();
            for (int i = 0; i < partCount; ++i) {
                Point2Ds pnts = geoRegion.getPart(i);
                if (temLine.getPartCount() > 0) {
                    temLine.removePart(0);
                }
                temLine.addPart(pnts);
                aryPoints.add(new GeoPoint(temLine.getInnerPoint()));
            }
        } else if (mode == RegionToPointMode.VERTEX) {
            int partCount = geoRegion.getPartCount();
            for (int i = 0; i < partCount; ++i) {
                Point2Ds pnts = geoRegion.getPart(i);
                for (int j = 0; j < pnts.getCount(); ++j) {
                    aryPoints.add(new GeoPoint(pnts.getItem(j)));
                }
            }
        } else if (mode == RegionToPointMode.TOPO_INNER_POINT) {
            if (geoRegion.getPartCount() > 1) {
                GeoRegion[] regions;
                for (GeoRegion region : regions = geoRegion.protectedDecompose()) {
                    aryPoints.add(new GeoPoint(region.getInnerPoint()));
                    region.dispose();
                }
            } else {
                aryPoints.add(new GeoPoint(geoRegion.getInnerPoint()));
            }
        }
        return aryPoints;
    }

    static ArrayList<GeoPoint> convertGeoTextToPoint(GeoText geoText) {
        ArrayList<GeoPoint> aryPoints = new ArrayList<GeoPoint>();
        for (int i = 0; i < geoText.getPartCount(); ++i) {
            Point2D point = new Point2D(geoText.getPart(i).getX(), geoText.getPart(i).getY());
            aryPoints.add(new GeoPoint(point));
        }
        return aryPoints;
    }

    public static DatasetVector convertDatasetLineToPoint(DatasetVector source, LineToPointMode mode, List<String> savedFields, Datasource outDatasource, String resultName) {
        Recordset recordset;
        int i;
        FieldInfos sourceFieldInfos;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType != DatasetType.LINE) {
            throw new IllegalArgumentException("DatasetVector source required Line, but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, DatasetType.POINT));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<Integer> sourceFields = new ArrayList<Integer>();
        ArrayList<Integer> targetFields = new ArrayList<Integer>();
        if (savedFields == null) {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add(i);
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(i);
                targetFields.add(nTargetIndex);
            }
        } else {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(sourceFieldInfos.indexOf(savedFields.get(i)));
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(nSrcIndex);
                targetFields.add(nTargetIndex);
            }
        }
        if ((recordset = source.getRecordset(false, CursorType.STATIC)) == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        HashMap targetValues = new HashMap();
        resultRecordset.getBatch().begin();
        while (!recordset.isEOF()) {
            try {
                GeoLine geoLine = (GeoLine)recordset.getGeometry();
                ArrayList<GeoPoint> geoPoints = Converts.convertGeoLineToPoint(geoLine, mode);
                targetValues.clear();
                for (int i2 = 0; i2 < sourceFields.size(); ++i2) {
                    targetValues.put(targetFields.get(i2), recordset.getFieldValue(((Integer)sourceFields.get(i2)).intValue()));
                }
                for (GeoPoint geo : geoPoints) {
                    resultRecordset.addNew((Geometry)geo);
                    for (Integer key : targetValues.keySet()) {
                        resultRecordset.setFieldValue(key.intValue(), targetValues.get(key));
                    }
                    geo.dispose();
                }
                geoLine.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            recordset.moveNext();
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    public static DatasetVector convertDatasetLineToRegion(DatasetVector source, List<String> savedFields, Datasource outDatasource, String resultName) {
        Recordset recordset;
        int i;
        FieldInfos sourceFieldInfos;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType != DatasetType.LINE) {
            throw new IllegalArgumentException("DatasetVector source required Line, but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, DatasetType.REGION));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<Integer> sourceFields = new ArrayList<Integer>();
        ArrayList<Integer> targetFields = new ArrayList<Integer>();
        if (savedFields == null) {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add(i);
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(i);
                targetFields.add(nTargetIndex);
            }
        } else {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(sourceFieldInfos.indexOf(savedFields.get(i)));
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(nSrcIndex);
                targetFields.add(nTargetIndex);
            }
        }
        if ((recordset = source.getRecordset(false, CursorType.STATIC)) == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        resultRecordset.getBatch().begin();
        while (!recordset.isEOF()) {
            try {
                GeoLine geoLine = (GeoLine)recordset.getGeometry();
                GeoRegion geoRegion = geoLine.convertToRegion();
                resultRecordset.addNew((Geometry)geoRegion);
                for (int i2 = 0; i2 < sourceFields.size(); ++i2) {
                    resultRecordset.setFieldValue(((Integer)targetFields.get(i2)).intValue(), recordset.getFieldValue(((Integer)sourceFields.get(i2)).intValue()));
                }
                geoLine.dispose();
                geoRegion.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            recordset.moveNext();
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    public static DatasetVector convertDatasetRegionToLine(DatasetVector source, List<String> savedFields, Datasource outDatasource, String resultName) {
        Recordset recordset;
        int i;
        FieldInfos sourceFieldInfos;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType != DatasetType.REGION) {
            throw new IllegalArgumentException("DatasetVector source required Region, but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, DatasetType.LINE));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<Integer> sourceFields = new ArrayList<Integer>();
        ArrayList<Integer> targetFields = new ArrayList<Integer>();
        if (savedFields == null) {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add(i);
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(i);
                targetFields.add(nTargetIndex);
            }
        } else {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(sourceFieldInfos.indexOf(savedFields.get(i)));
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(nSrcIndex);
                targetFields.add(nTargetIndex);
            }
        }
        if ((recordset = source.getRecordset(false, CursorType.STATIC)) == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        resultRecordset.getBatch().begin();
        while (!recordset.isEOF()) {
            try {
                GeoRegion geoRegion = (GeoRegion)recordset.getGeometry();
                GeoLine geoLine = geoRegion.convertToLine();
                resultRecordset.addNew((Geometry)geoLine);
                for (int i2 = 0; i2 < sourceFields.size(); ++i2) {
                    resultRecordset.setFieldValue(((Integer)targetFields.get(i2)).intValue(), recordset.getFieldValue(((Integer)sourceFields.get(i2)).intValue()));
                }
                geoLine.dispose();
                geoRegion.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            recordset.moveNext();
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    public static DatasetVector convertDatasetRegionToPoint(DatasetVector source, RegionToPointMode mode, List<String> savedFields, Datasource outDatasource, String resultName) {
        Recordset recordset;
        int i;
        FieldInfos sourceFieldInfos;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType != DatasetType.REGION) {
            throw new IllegalArgumentException("DatasetVector source required Region, but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, DatasetType.POINT));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<Integer> sourceFields = new ArrayList<Integer>();
        ArrayList<Integer> targetFields = new ArrayList<Integer>();
        if (savedFields == null) {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add(i);
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                System.out.println(sourceFieldInfos.get(i).getName());
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(i);
                targetFields.add(nTargetIndex);
            }
        } else {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(sourceFieldInfos.indexOf(savedFields.get(i)));
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(nSrcIndex);
                targetFields.add(nTargetIndex);
            }
        }
        if ((recordset = source.getRecordset(false, CursorType.STATIC)) == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        resultRecordset.getBatch().begin();
        HashMap targetValues = new HashMap();
        while (!recordset.isEOF()) {
            try {
                GeoRegion geoRegion = (GeoRegion)recordset.getGeometry();
                ArrayList<GeoPoint> geoPoints = Converts.convertGeoRegionToPoint(geoRegion, mode);
                targetValues.clear();
                for (int i2 = 0; i2 < sourceFields.size(); ++i2) {
                    targetValues.put(targetFields.get(i2), recordset.getFieldValue(((Integer)sourceFields.get(i2)).intValue()));
                }
                for (GeoPoint geo : geoPoints) {
                    resultRecordset.addNew((Geometry)geo);
                    for (Integer key : targetValues.keySet()) {
                        resultRecordset.setFieldValue(key.intValue(), targetValues.get(key));
                    }
                    geo.dispose();
                }
                geoRegion.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            recordset.moveNext();
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    public static boolean convertDatasetTextToField(DatasetVector source, String outField) {
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType != DatasetType.TEXT) {
            throw new IllegalArgumentException("DatasetVector source required Text, but is " + sourceType.name());
        }
        int indexField = source.getFieldInfos().indexOf(outField);
        if (indexField != -1 && source.getFieldInfos().get(indexField).getType() != FieldType.TEXT && source.getFieldInfos().get(indexField).getType() != FieldType.WTEXT) {
            indexField = -1;
        }
        if (indexField == -1) {
            if (outField == null) {
                outField = "Text";
            }
            String fieldName = source.getAvailableFieldName(outField);
            indexField = source.getFieldInfos().add(new FieldInfo(fieldName, FieldType.WTEXT));
        }
        Recordset recordset = source.getRecordset(false, CursorType.DYNAMIC);
        recordset.getBatch().begin();
        while (!recordset.isEOF()) {
            try {
                GeoText geoText = (GeoText)recordset.getGeometry();
                recordset.setFieldValue(indexField, (Object)geoText.getText());
                geoText.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            recordset.moveNext();
        }
        recordset.getBatch().update();
        recordset.dispose();
        return true;
    }

    public static DatasetVector convertDatasetFieldToPoint(DatasetVector source, String x, String y, String z, List<String> savedFields, Datasource outDatasource, String resultName) {
        Recordset recordset;
        int i;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        if (x == null || y == null) {
            throw new IllegalArgumentException(" x or y value cannot be null. ");
        }
        FieldInfos sourceFieldInfos = source.getFieldInfos();
        int xIndex = sourceFieldInfos.indexOf(x);
        int yIndex = sourceFieldInfos.indexOf(y);
        if (xIndex == -1) {
            throw new IllegalArgumentException("x field is not existed");
        }
        if (yIndex == -1) {
            throw new IllegalArgumentException("y field is not existed");
        }
        DatasetVector resultDataset = null;
        int zIndex = -1;
        if (z == null || sourceFieldInfos.indexOf(z) == -1) {
            resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, DatasetType.POINT));
        } else {
            zIndex = sourceFieldInfos.indexOf(z);
            resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, DatasetType.POINT3D));
        }
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<Integer> sourceFields = new ArrayList<Integer>();
        ArrayList<Integer> targetFields = new ArrayList<Integer>();
        if (savedFields == null) {
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add(i);
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(i);
                targetFields.add(nTargetIndex);
            }
        } else {
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(sourceFieldInfos.indexOf(savedFields.get(i)));
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(nSrcIndex);
                targetFields.add(nTargetIndex);
            }
        }
        if ((recordset = source.getRecordset(false, CursorType.STATIC)) == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        resultRecordset.getBatch().begin();
        while (!recordset.isEOF()) {
            try {
                double dx = recordset.getDouble(xIndex);
                double dy = recordset.getDouble(yIndex);
                if (zIndex == -1) {
                    resultRecordset.addNew((Geometry)new GeoPoint(dx, dy));
                } else {
                    double dz = recordset.getDouble(zIndex);
                    resultRecordset.addNew((Geometry)new GeoPoint3D(dx, dy, dz));
                }
                for (int i2 = 0; i2 < sourceFields.size(); ++i2) {
                    resultRecordset.setFieldValue(((Integer)targetFields.get(i2)).intValue(), recordset.getFieldValue(((Integer)sourceFields.get(i2)).intValue()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            recordset.moveNext();
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    public static DatasetVector convertDatasetFieldToText(DatasetVector source, String field, List<String> savedFields, Datasource outDatasource, String resultName) {
        Recordset recordset;
        int i;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        if (source.getType() != DatasetType.POINT) {
            throw new IllegalArgumentException("DatasetVector source required Point but is " + source.getType().name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        if (field == null) {
            throw new IllegalArgumentException("field is null");
        }
        FieldInfos sourceFieldInfos = source.getFieldInfos();
        int textFieldIndex = sourceFieldInfos.indexOf(field);
        if (textFieldIndex == -1) {
            throw new IllegalArgumentException("field is not existed : " + field);
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, DatasetType.TEXT));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<Integer> sourceFields = new ArrayList<Integer>();
        ArrayList<Integer> targetFields = new ArrayList<Integer>();
        if (savedFields == null) {
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add(i);
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(i);
                targetFields.add(nTargetIndex);
            }
        } else {
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(sourceFieldInfos.indexOf(savedFields.get(i)));
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(nSrcIndex);
                targetFields.add(nTargetIndex);
            }
        }
        if ((recordset = source.getRecordset(false, CursorType.STATIC)) == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        resultRecordset.getBatch().begin();
        while (!recordset.isEOF()) {
            try {
                GeoPoint geoPoint = (GeoPoint)recordset.getGeometry();
                String text = recordset.getString(textFieldIndex);
                if (text != null && !text.isEmpty()) {
                    resultRecordset.addNew((Geometry)new GeoText(new TextPart(text, geoPoint.getInnerPoint())));
                    for (int i2 = 0; i2 < sourceFields.size(); ++i2) {
                        resultRecordset.setFieldValue(((Integer)targetFields.get(i2)).intValue(), recordset.getFieldValue(((Integer)sourceFields.get(i2)).intValue()));
                    }
                }
                geoPoint.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            recordset.moveNext();
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    public static DatasetVector convertDatasetTextToPoint(DatasetVector source, String outField, List<String> savedFields, Datasource outDatasource, String resultName) {
        Recordset recordset;
        int indexField;
        int i;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType != DatasetType.TEXT) {
            throw new IllegalArgumentException("DatasetVector source required Text, but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, DatasetType.POINT));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<Integer> sourceFields = new ArrayList<Integer>();
        ArrayList<Integer> targetFields = new ArrayList<Integer>();
        FieldInfos sourceFieldInfos = source.getFieldInfos();
        if (savedFields == null) {
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add(i);
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(i);
                targetFields.add(nTargetIndex);
            }
        } else {
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(sourceFieldInfos.indexOf(savedFields.get(i)));
                    targetFields.add(resultDataset.getFieldInfos().indexOf("SmUserID"));
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                int nTargetIndex = resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(nSrcIndex);
                targetFields.add(nTargetIndex);
            }
        }
        if ((indexField = sourceFieldInfos.indexOf(outField)) != -1 && source.getFieldInfos().get(indexField).getType() != FieldType.TEXT && source.getFieldInfos().get(indexField).getType() != FieldType.WTEXT) {
            indexField = -1;
        }
        if (indexField == -1) {
            if (outField == null) {
                outField = "Text";
            }
            String fieldName = source.getAvailableFieldName(outField);
            indexField = resultDataset.getFieldInfos().add(new FieldInfo(fieldName, FieldType.WTEXT));
        }
        if ((recordset = source.getRecordset(false, CursorType.STATIC)) == null) {
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query source recordset");
        }
        Recordset resultRecordset = resultDataset.getRecordset(true, CursorType.DYNAMIC);
        if (resultRecordset == null) {
            recordset.dispose();
            outDatasource.getDatasets().delete(resultName);
            throw new RuntimeException("Failed to query result recordset");
        }
        resultRecordset.getBatch().begin();
        HashMap targetValues = new HashMap();
        while (!recordset.isEOF()) {
            try {
                GeoText geoText = (GeoText)recordset.getGeometry();
                ArrayList<GeoPoint> geoPoints = Converts.convertGeoTextToPoint(geoText);
                targetValues.clear();
                for (int i2 = 0; i2 < sourceFields.size(); ++i2) {
                    targetValues.put(targetFields.get(i2), recordset.getFieldValue(((Integer)sourceFields.get(i2)).intValue()));
                }
                for (GeoPoint geo : geoPoints) {
                    resultRecordset.addNew((Geometry)geo);
                    for (Integer key : targetValues.keySet()) {
                        resultRecordset.setFieldValue(key.intValue(), targetValues.get(key));
                    }
                    geo.dispose();
                }
                if (indexField != -1) {
                    resultRecordset.setFieldValue(indexField, (Object)geoText.getText());
                }
                geoText.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            recordset.moveNext();
        }
        resultRecordset.getBatch().update();
        resultRecordset.dispose();
        recordset.dispose();
        return resultDataset;
    }

    public static DatasetVector convertDatasetNetworkToLine(DatasetVector source, List<String> savedFields, Datasource outDatasource, String resultName) {
        String nodeIDField;
        int i;
        FieldInfos sourceFieldInfos;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType != DatasetType.NETWORK) {
            throw new IllegalArgumentException("DatasetVector source required NetWork, but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, DatasetType.LINE));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<String> sourceFields = new ArrayList<String>();
        ArrayList<String> targetFields = new ArrayList<String>();
        if (savedFields == null) {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add("SmUserID");
                    targetFields.add("SmUserID");
                    continue;
                }
                resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(sourceFieldInfos.get(i).getName());
                targetFields.add(sourceFieldInfos.get(i).getName());
            }
        } else {
            sourceFieldInfos = source.getFieldInfos();
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(savedFields.get(i));
                    targetFields.add("SmUserID");
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(savedFields.get(i));
                targetFields.add(savedFields.get(i));
            }
        }
        if (source.getFieldNameBySign(FieldSign.EDGEID).compareToIgnoreCase("SmEdgeID") == 0) {
            nodeIDField = resultDataset.getAvailableFieldName("EdgeID");
            FieldInfo nodeIDFieldInfo = new FieldInfo(nodeIDField, FieldType.INT32);
            nodeIDFieldInfo.setCaption(nodeIDField);
            resultDataset.getFieldInfos().add(nodeIDFieldInfo);
            sourceFields.add("SmEdgeID");
            targetFields.add(nodeIDField);
        }
        if (source.getFieldNameBySign(FieldSign.FNODE).compareToIgnoreCase("SmFNode") == 0) {
            nodeIDField = resultDataset.getAvailableFieldName("FNodeID");
            FieldInfo nodeIDFieldInfo = new FieldInfo(nodeIDField, FieldType.INT32);
            nodeIDFieldInfo.setCaption(nodeIDField);
            resultDataset.getFieldInfos().add(nodeIDFieldInfo);
            sourceFields.add("SmFNode");
            targetFields.add(nodeIDField);
        }
        if (source.getFieldNameBySign(FieldSign.TNODE).compareToIgnoreCase("SmTNode") == 0) {
            nodeIDField = resultDataset.getAvailableFieldName("TNodeID");
            FieldInfo nodeIDFieldInfo = new FieldInfo(nodeIDField, FieldType.INT32);
            nodeIDFieldInfo.setCaption(nodeIDField);
            resultDataset.getFieldInfos().add(nodeIDFieldInfo);
            sourceFields.add("SmTNode");
            targetFields.add(nodeIDField);
        }
        String[] fields1 = new String[sourceFields.size()];
        sourceFields.toArray(fields1);
        String[] fields2 = new String[targetFields.size()];
        targetFields.toArray(fields2);
        Recordset recordset = source.getRecordset(false, CursorType.STATIC);
        resultDataset.append(recordset, fields1, fields2);
        recordset.dispose();
        return resultDataset;
    }

    public static DatasetVector convertDatasetNetworkToPoint(DatasetVector source, List<String> savedFields, Datasource outDatasource, String resultName) {
        int i;
        FieldInfos sourceFieldInfos;
        if (source == null) {
            throw new IllegalArgumentException("DatasetVector source is null");
        }
        DatasetType sourceType = source.getType();
        if (sourceType != DatasetType.NETWORK) {
            throw new IllegalArgumentException("DatasetVector source required NetWork, but is " + sourceType.name());
        }
        if (outDatasource == null) {
            throw new IllegalArgumentException("Output Datasource is null");
        }
        if (resultName == null || !outDatasource.getDatasets().isAvailableDatasetName(resultName)) {
            throw new IllegalArgumentException("Result dataset name is invalid ");
        }
        DatasetVector resultDataset = outDatasource.getDatasets().create(new DatasetVectorInfo(resultName, DatasetType.POINT));
        if (resultDataset == null) {
            throw new RuntimeException("Failed to create result dataset");
        }
        source.open();
        resultDataset.setPrjCoordSys(source.getPrjCoordSys());
        ArrayList<String> sourceFields = new ArrayList<String>();
        ArrayList<String> targetFields = new ArrayList<String>();
        DatasetVector pointDataset = source.getChildDataset();
        if (savedFields == null) {
            sourceFieldInfos = pointDataset.getFieldInfos();
            for (i = 0; i < sourceFieldInfos.getCount(); ++i) {
                if (sourceFieldInfos.get(i).isSystemField()) continue;
                if (sourceFieldInfos.get(i).getName().compareToIgnoreCase("SmUserID") == 0) {
                    sourceFields.add("SmUserID");
                    targetFields.add("SmUserID");
                    continue;
                }
                resultDataset.getFieldInfos().add(sourceFieldInfos.get(i));
                sourceFields.add(sourceFieldInfos.get(i).getName());
                targetFields.add(sourceFieldInfos.get(i).getName());
            }
        } else {
            sourceFieldInfos = pointDataset.getFieldInfos();
            for (i = 0; i < savedFields.size(); ++i) {
                if (savedFields.get(i).toLowerCase().startsWith("sm")) {
                    if (savedFields.get(i).compareToIgnoreCase("SmUserID") != 0) continue;
                    sourceFields.add(savedFields.get(i));
                    targetFields.add("SmUserID");
                    continue;
                }
                int nSrcIndex = sourceFieldInfos.indexOf(savedFields.get(i));
                if (nSrcIndex == -1) continue;
                resultDataset.getFieldInfos().add(sourceFieldInfos.get(savedFields.get(i)));
                sourceFields.add(savedFields.get(i));
                targetFields.add(savedFields.get(i));
            }
        }
        if (pointDataset.getFieldNameBySign(FieldSign.NODEID).compareToIgnoreCase("SmNodeID") == 0) {
            String nodeIDField = resultDataset.getAvailableFieldName("NodeID");
            FieldInfo nodeIDFieldInfo = new FieldInfo(nodeIDField, FieldType.INT32);
            nodeIDFieldInfo.setCaption(nodeIDField);
            resultDataset.getFieldInfos().add(nodeIDFieldInfo);
            sourceFields.add("SmNodeID");
            targetFields.add(nodeIDField);
        }
        String[] fields1 = new String[sourceFields.size()];
        sourceFields.toArray(fields1);
        String[] fields2 = new String[targetFields.size()];
        targetFields.toArray(fields2);
        Recordset recordset = pointDataset.getRecordset(false, CursorType.STATIC);
        resultDataset.append(recordset, fields1, fields2);
        recordset.dispose();
        return resultDataset;
    }

    static {
        DataSerializers.registerEnum(RegionToPointMode.class);
        DataSerializers.registerEnum(LineToPointMode.class);
    }
}

