/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.plot;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.plot.AnimationAttribute;
import com.supermap.plot.AnimationBlink;
import com.supermap.plot.AnimationDefine;
import com.supermap.plot.AnimationGO;
import com.supermap.plot.AnimationGroup;
import com.supermap.plot.AnimationGrow;
import com.supermap.plot.AnimationManagerNative;
import com.supermap.plot.AnimationPlayBeginEvent;
import com.supermap.plot.AnimationPlayBeginListener;
import com.supermap.plot.AnimationPlayFinishEvent;
import com.supermap.plot.AnimationPlayFinishListener;
import com.supermap.plot.AnimationRotate;
import com.supermap.plot.AnimationScale;
import com.supermap.plot.AnimationShow;
import com.supermap.plot.AnimationWay;
import com.supermap.plot.InternalToolkitPlot;
import com.supermap.ui.MapControl;
import com.supermap.ui.SceneControl;
import java.util.ArrayList;
import java.util.Vector;

public class AnimationManager
extends InternalHandleDisposable {
    private static License m_license;
    transient Vector<AnimationPlayBeginListener> m_playBeginListeners;
    transient Vector<AnimationPlayFinishListener> m_playFinishListeners;
    private static AnimationManager instance;

    public static AnimationManager getInstance() {
        AnimationManager.verifyLicense();
        if (instance == null) {
            instance = new AnimationManager();
        }
        return instance;
    }

    private AnimationManager() {
    }

    public AnimationGO createAnimation(AnimationDefine.AnimationType type) {
        AnimationGO animationGO = null;
        long l = AnimationManagerNative.jni_CreateAnimation(type.value());
        animationGO = this.CreateInterfaceAnimation(type, l);
        return animationGO;
    }

    public void play() {
        AnimationManagerNative.jni_Play();
    }

    public void stop() {
        AnimationManagerNative.jni_Stop();
    }

    public void pause() {
        AnimationManagerNative.jni_Pause();
    }

    public void reset() {
        AnimationManagerNative.jni_Reset();
    }

    public void excute() {
        AnimationManagerNative.jni_Excute();
    }

    public AnimationGroup addAnimationGroup(String strgroupname) {
        long l = AnimationManagerNative.jni_AddAnimationGroup(strgroupname);
        AnimationGroup animationGroup = new AnimationGroup(l);
        return animationGroup;
    }

    public void addSceneControl(SceneControl pSceneControl) {
        AnimationManagerNative.jni_AddSceneControl(pSceneControl.get_mHandle());
    }

    public void removeSceneControl(String pSceneName) {
        AnimationManagerNative.jni_RemoveSceneControl(pSceneName);
    }

    public void removeAllSceneControl() {
        AnimationManagerNative.jni_RemoveAllSceneControl();
    }

    public void addMapControl(MapControl pMapControl) {
        AnimationManagerNative.jni_AddMapControl(pMapControl.get_mHandle());
    }

    public void removeMapControl(MapControl pMapControl) {
    }

    public void removeAllMapControl() {
        AnimationManagerNative.jni_RemoveAllMapControl();
    }

    public AnimationGroup getGroupByName(String groupName) {
        long l = AnimationManagerNative.jni_GetGroupByName(groupName);
        if (l == 0L) {
            return null;
        }
        AnimationGroup animationGroup = new AnimationGroup(l);
        animationGroup.m_arrAnimation.clear();
        for (int i = 0; i < animationGroup.getAnimationCount(); ++i) {
            animationGroup.m_arrAnimation.add(animationGroup.getAnimationByIndex(i));
        }
        return animationGroup;
    }

    public AnimationGroup getGroupByIndex(int ipos) {
        long l = AnimationManagerNative.jni_GetGroupByIndex(ipos);
        if (l == 0L) {
            return null;
        }
        AnimationGroup animationGroup = new AnimationGroup(l);
        animationGroup.m_arrAnimation.clear();
        for (int i = 0; i < animationGroup.getAnimationCount(); ++i) {
            animationGroup.m_arrAnimation.add(animationGroup.getAnimationByIndex(i));
        }
        return animationGroup;
    }

    public int getGroupCount() {
        return AnimationManagerNative.jni_GetGroupCount();
    }

    public boolean deleteGroupByName(String groupName) {
        boolean bl = AnimationManagerNative.jni_DeleteGroupByName(groupName);
        return bl;
    }

    public void deleteAll() {
        AnimationManagerNative.jni_DeleteAll();
    }

    public boolean merge(String groupName1, String groupName2) {
        AnimationGroup animationGroup = this.getGroupByName(groupName1);
        AnimationGroup animationGroup2 = this.getGroupByName(groupName2);
        if (animationGroup == null || animationGroup2 == null) {
            return false;
        }
        boolean bl = AnimationManagerNative.jni_Merge(groupName1, groupName2);
        return bl;
    }

    public boolean split(String oldGroupName, int index, String newGroupName) {
        int n;
        if (oldGroupName.equals(newGroupName)) {
            return false;
        }
        AnimationGroup animationGroup = this.getGroupByName(newGroupName);
        if (null != animationGroup) {
            return false;
        }
        AnimationGroup animationGroup2 = this.getGroupByName(oldGroupName);
        if (null == animationGroup2 || index >= animationGroup2.getAnimationCount()) {
            return false;
        }
        if (0 == animationGroup2.getAnimationCount()) {
            return false;
        }
        for (n = animationGroup2.getAnimationCount() - 1; n >= index; n -= 1) {
            animationGroup2.m_arrAnimation.remove(n);
        }
        n = AnimationManagerNative.jni_split(oldGroupName, index, newGroupName) ? 1 : 0;
        return n != 0;
    }

    public boolean movePrev(int iGroupIndex) {
        return AnimationManagerNative.jni_MovePrev(iGroupIndex);
    }

    public boolean moveNext(int iGroupIndex) {
        return AnimationManagerNative.jni_MoveNext(iGroupIndex);
    }

    public boolean setPlayRang(int iStartGroup, int iCount) {
        return AnimationManagerNative.jni_SetPlayRange(iStartGroup, iCount);
    }

    public int getStartGroupOfPlayRang() {
        int[] nArray = new int[2];
        AnimationManagerNative.jni_GetPlayRange(nArray);
        return nArray[0];
    }

    public int getEndGroupOfPlayRang() {
        int[] nArray = new int[2];
        AnimationManagerNative.jni_GetPlayRange(nArray);
        return nArray[1];
    }

    public int getCountOfPlayRange() {
        int[] nArray = new int[2];
        AnimationManagerNative.jni_GetPlayRange(nArray);
        return nArray[1] - nArray[0] + 1;
    }

    public String getCurrentGroup() {
        String string = AnimationManagerNative.jni_GetCurrentGroup();
        return string;
    }

    public boolean getAnimationFromXML(String filePath) {
        boolean bl = AnimationManagerNative.jni_GetAnimationFromXML(filePath);
        return bl;
    }

    public boolean saveAnimationToXML(String filePath) {
        return AnimationManagerNative.jni_SaveAnimationToXML(filePath);
    }

    public boolean getAnimationFromJSON(String filePath) {
        boolean bl = AnimationManagerNative.jni_GetAnimationFromJSON(filePath);
        return bl;
    }

    public boolean saveAnimationToJSON(String filePath) {
        return AnimationManagerNative.jni_SaveAnimationToJSON(filePath);
    }

    public String[] getDeletedGeoAnimations() {
        String[] stringArray = null;
        String string = AnimationManagerNative.jni_GetDeletedGeoAnimations();
        if (string == null || string.length() <= 0) {
            return null;
        }
        stringArray = string.split("\\|");
        return stringArray;
    }

    private AnimationGO CreateInterfaceAnimation(AnimationDefine.AnimationType type, long handle) {
        AnimationGO animationGO = null;
        switch (type.value()) {
            case 0: {
                animationGO = new AnimationWay(handle);
                break;
            }
            case 1: {
                animationGO = new AnimationBlink(handle);
                break;
            }
            case 2: {
                animationGO = new AnimationAttribute(handle);
                break;
            }
            case 3: {
                animationGO = new AnimationShow(handle);
                break;
            }
            case 4: {
                animationGO = new AnimationRotate(handle);
                break;
            }
            case 5: {
                animationGO = new AnimationScale(handle);
                break;
            }
            case 6: {
                animationGO = new AnimationGrow(handle);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            default: {
                animationGO = null;
            }
        }
        return animationGO;
    }

    public synchronized void addAnimationPlayBeginListener(AnimationPlayBeginListener l) {
        if (this.m_playBeginListeners == null) {
            this.m_playBeginListeners = new Vector();
        }
        if (!this.m_playBeginListeners.contains(l)) {
            this.m_playBeginListeners.add(l);
        }
    }

    public synchronized void removeAnimationPlayBeginListener(AnimationPlayBeginListener l) {
        if (this.m_playBeginListeners != null && this.m_playBeginListeners.contains(l)) {
            this.m_playBeginListeners.remove(l);
        }
    }

    protected void fireAnimationPlayBegin(AnimationPlayBeginEvent event) {
        if (this.m_playBeginListeners != null) {
            Vector<AnimationPlayBeginListener> vector = this.m_playBeginListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).playBegin(event);
            }
        }
    }

    public synchronized void addAnimationPlayFinishListener(AnimationPlayFinishListener l) {
        if (this.m_playFinishListeners == null) {
            this.m_playFinishListeners = new Vector();
        }
        if (!this.m_playFinishListeners.contains(l)) {
            this.m_playFinishListeners.add(l);
        }
    }

    public synchronized void removeAnimationPlayFinishListener(AnimationPlayFinishListener l) {
        if (this.m_playFinishListeners != null && this.m_playFinishListeners.contains(l)) {
            this.m_playFinishListeners.remove(l);
        }
    }

    protected void fireAnimationPlayFinish(AnimationPlayFinishEvent event) {
        if (this.m_playFinishListeners != null) {
            Vector<AnimationPlayFinishListener> vector = this.m_playFinishListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).playFinish(event);
            }
        }
    }

    public void deleteAnimationManager() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
        AnimationManagerNative.jni_Reset();
        AnimationManagerNative.jni_DeleteAnimationManager();
    }

    public String animationToGeoJson() {
        return AnimationManagerNative.jni_AnimationToGeoJson();
    }

    public boolean geoJsonToAnimation(String geoJson) {
        boolean bl = AnimationManagerNative.jni_GeoJsonToAnimation(geoJson);
        return bl;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitPlot.managerProducts(InternalToolkitPlot.getPlot3DProducts());
        m_license = InternalToolkitPlot.verifyLicense(arrayList);
        instance = null;
    }
}

