/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.InternalHandle;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.SamplingFunctionParameter;
import com.supermap.analyst.spatialstatistics.SamplingParameterNative;
import com.supermap.data.InternalHandleDisposable;

public abstract class SamplingParameter
extends InternalHandleDisposable {
    protected boolean m_bProportion;
    protected double m_dResolution;
    protected double m_dExpandRatio;
    protected boolean m_SetFunction;
    protected double m_dSpatialRelation;
    SamplingFunctionParameter m_SamplingFunctionParameter;

    protected SamplingParameter() {
        long l = SamplingParameterNative.jni_New();
        this.setHandle(l, true);
        this.m_bProportion = false;
        this.m_dResolution = 0.0;
        this.m_dExpandRatio = 0.1;
        this.m_SamplingFunctionParameter = null;
        this.m_SetFunction = false;
        this.m_dSpatialRelation = -1.0;
    }

    void reset() {
        long l = super.getHandle();
        if (l != 0L) {
            SamplingParameterNative.jni_Reset(l);
        }
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            SamplingParameterNative.jni_setProportion2(l, this.m_bProportion);
            SamplingParameterNative.jni_setResolution(l, this.m_dResolution);
            SamplingParameterNative.jni_setExpandRatio(l, this.m_dExpandRatio);
            SamplingParameterNative.jni_setSpatialRelation(l, this.m_dSpatialRelation);
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            SamplingParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public boolean isProportion() {
        return this.m_bProportion;
    }

    public void setProportion(boolean value) {
        this.m_bProportion = value;
    }

    public double getResolution() {
        return this.m_dResolution;
    }

    public void setResolution(double value) {
        if (value <= 0.0) {
            String string = InternalResource.loadString("Resolution", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dResolution = value;
    }

    public double getExpandRatio() {
        return this.m_dExpandRatio;
    }

    public void setExpandRatio(double value) {
        if (value > 1.0 || value < 0.0) {
            String string = InternalResource.loadString("ExpandRatio", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dExpandRatio = value;
    }

    public SamplingFunctionParameter getSamplingFunctionParameter() {
        return this.m_SamplingFunctionParameter;
    }

    public void setSamplingFunctionParameter(SamplingFunctionParameter value) {
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("SamplingFunctionParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        this.m_SamplingFunctionParameter = value;
        this.reset();
        SamplingParameterNative.jni_setSamplingParameter(super.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
        this.m_SetFunction = true;
    }
}

