/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.SamplingFunctionParameter;
import com.supermap.analyst.spatialstatistics.SamplingFunctionType;
import com.supermap.analyst.spatialstatistics.SamplingParameterNative;

public class SamplingFunctionScaleFParameter
extends SamplingFunctionParameter {
    private double m_dCoefficientOfVariation = 0.0;
    private double m_dRelativeError = 0.0;
    private double m_dSignificanceLevel = 0.0;
    private int m_nInitialIteratedSize = 0;

    private SamplingFunctionScaleFParameter() {
    }

    public SamplingFunctionScaleFParameter(double dCoefficientOfVariation, double dRelativeError, Double dSignificanceLevel, int nInitialIteratedSize) {
        this.m_FunctionType = SamplingFunctionType.FUNCTIONSCALEF;
        this.setCoefficientOfVariation(dCoefficientOfVariation);
        this.setRelativeError(dRelativeError);
        this.setSignificanceLevel(dSignificanceLevel);
        this.setInitialIteratedSize(nInitialIteratedSize);
    }

    public double getCoefficientOfVariation() {
        return this.m_dCoefficientOfVariation;
    }

    public void setCoefficientOfVariation(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("CoefficientOfVariation", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dCoefficientOfVariation = value;
    }

    public double getRelativeError() {
        return this.m_dRelativeError;
    }

    public void setRelativeError(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("RelativeError", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dRelativeError = value;
    }

    public double getSignificanceLevel() {
        return this.m_dSignificanceLevel;
    }

    public void setSignificanceLevel(double value) {
        if (value > 1.0 || value < 0.0) {
            String string = InternalResource.loadString("SignificanceLevel", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dSignificanceLevel = value;
    }

    public int getInitialIteratedSize() {
        return this.m_nInitialIteratedSize;
    }

    public void setInitialIteratedSize(int value) {
        if (value < 0) {
            String string = InternalResource.loadString("InitialIteratedSize", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nInitialIteratedSize = value;
    }

    @Override
    protected void SetSampleParameter(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("SamplingFunctionScaleCParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        SamplingParameterNative.jni_setCoefficientOfVariation(handle, this.m_dCoefficientOfVariation);
        SamplingParameterNative.jni_setSignificanceLevel(handle, this.m_dSignificanceLevel);
        SamplingParameterNative.jni_setRelativeError(handle, this.m_dRelativeError);
        SamplingParameterNative.jni_setInitialIteratedSize(handle, this.m_nInitialIteratedSize);
    }
}

