/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.SamplingFunctionParameter;
import com.supermap.analyst.spatialstatistics.SamplingFunctionType;
import com.supermap.analyst.spatialstatistics.SamplingParameterNative;

public class SamplingFunctionProportionEParameter
extends SamplingFunctionParameter {
    private double m_dPresamplingProportion = 0.0;
    private double m_dCoefficientOfVariation = 0.0;
    private int m_nPresamplingSize = 0;

    private SamplingFunctionProportionEParameter() {
    }

    public SamplingFunctionProportionEParameter(double dPresamplingProportion, double dCoefficientOfVariation, int nPresamplingSize) {
        this.m_FunctionType = SamplingFunctionType.FUNCTIONPROPORTIONE;
        this.setPresamplingProportion(dPresamplingProportion);
        this.setCoefficientOfVariation(dCoefficientOfVariation);
        this.setPresamplingSize(nPresamplingSize);
    }

    public double getPresamplingProportion() {
        return this.m_dPresamplingProportion;
    }

    public void setPresamplingProportion(double value) {
        if (value > 1.0 || value < 0.0) {
            String string = InternalResource.loadString("PresamplingProportion", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dPresamplingProportion = value;
    }

    public double getCoefficientOfVariation() {
        return this.m_dCoefficientOfVariation;
    }

    public void setCoefficientOfVariation(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("CoefficientOfVariation", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dCoefficientOfVariation = value;
    }

    public int getPresamplingSize() {
        return this.m_nPresamplingSize;
    }

    public void setPresamplingSize(int value) {
        if (value < 0) {
            String string = InternalResource.loadString("PresamplingSize", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nPresamplingSize = value;
    }

    @Override
    protected void SetSampleParameter(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("SamplingFunctionScaleCParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        SamplingParameterNative.jni_setPresamplingProportion(handle, this.m_dPresamplingProportion);
        SamplingParameterNative.jni_setCoefficientOfVariation(handle, this.m_dCoefficientOfVariation);
        SamplingParameterNative.jni_setPresamplingSize(handle, this.m_nPresamplingSize);
    }
}

