/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.ConceptualizationModel;
import com.supermap.analyst.spatialstatistics.DistanceMethod;
import com.supermap.analyst.spatialstatistics.InternalEnum;
import com.supermap.analyst.spatialstatistics.InternalHandleDisposable;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.PatternsParameterNative;

public class PatternsParameter
extends InternalHandleDisposable {
    private String m_sAssessmentFieldName;
    private ConceptualizationModel m_ConceptModel = ConceptualizationModel.INVERSEDISTANCE;
    private double m_dDistTolerance = -1.0;
    private double m_dExponent = 1.0;
    private int m_nKNeighbors = 1;
    private boolean m_bStandardization = false;
    private String m_sSelfWeightFieldName;
    private boolean m_bFDRAdjusted = false;
    private String m_sFilePath;
    private DistanceMethod m_distanceMethod = DistanceMethod.EUCLIDEAN;

    public PatternsParameter() {
        long l = PatternsParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    void reset() {
        long l = super.getHandle();
        if (l != 0L) {
            PatternsParameterNative.jni_Reset(l);
        }
    }

    public PatternsParameter(PatternsParameter patternsParameter) {
        if (patternsParameter == null) {
            String string = InternalResource.loadString("patternsParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        long l = PatternsParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.m_sAssessmentFieldName = patternsParameter.m_sAssessmentFieldName;
        this.m_ConceptModel = patternsParameter.m_ConceptModel;
        this.m_dDistTolerance = patternsParameter.m_dDistTolerance;
        this.m_dExponent = patternsParameter.m_dExponent;
        this.m_nKNeighbors = patternsParameter.m_nKNeighbors;
        this.m_bStandardization = patternsParameter.m_bStandardization;
        this.m_sSelfWeightFieldName = patternsParameter.m_sSelfWeightFieldName;
        this.m_bFDRAdjusted = patternsParameter.m_bFDRAdjusted;
        this.m_sFilePath = patternsParameter.m_sFilePath;
        this.m_distanceMethod = patternsParameter.m_distanceMethod;
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            PatternsParameterNative.jni_SetAssessmentField(l, this.m_sAssessmentFieldName);
            int n = InternalEnum.getUGCValue(this.m_ConceptModel);
            PatternsParameterNative.jni_SetConceptModel(l, n);
            PatternsParameterNative.jni_SetDistTolerance(l, this.m_dDistTolerance);
            PatternsParameterNative.jni_SetExponent(l, this.m_dExponent);
            PatternsParameterNative.jni_SetKNeighbos(l, this.m_nKNeighbors);
            PatternsParameterNative.jni_SetStandardization(l, this.m_bStandardization);
            PatternsParameterNative.jni_SetSelfWeightField(l, this.m_sSelfWeightFieldName);
            PatternsParameterNative.jni_SetFDRAdjusted(l, this.m_bFDRAdjusted);
            PatternsParameterNative.jni_SetFilePath(l, this.m_sFilePath);
            int n2 = InternalEnum.getUGCValue(this.m_distanceMethod);
            PatternsParameterNative.jni_SetDistanceMethod(l, n2);
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            PatternsParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public String getAssessmentFieldName() {
        return this.m_sAssessmentFieldName;
    }

    public void setAssessmentFieldName(String value) {
        if (value == null || value.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("AssessmentFieldName", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_sAssessmentFieldName = value;
    }

    public ConceptualizationModel getConceptModel() {
        return this.m_ConceptModel;
    }

    public void setConceptModel(ConceptualizationModel value) {
        this.m_ConceptModel = value;
    }

    public double getDistanceTolerance() {
        return this.m_dDistTolerance;
    }

    public void setDistanceTolerance(double value) {
        if (value != -1.0 && value < 0.0) {
            String string = InternalResource.loadString("DistanceTolerance", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dDistTolerance = value;
    }

    public double getExponent() {
        return this.m_dExponent;
    }

    public void setExponent(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("Exponent", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dExponent = value;
    }

    public int getKNeighbors() {
        return this.m_nKNeighbors;
    }

    public void setKNeighbors(int value) {
        if (value <= 0) {
            String string = InternalResource.loadString("KNeighbors", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nKNeighbors = value;
    }

    public boolean isStandardization() {
        return this.m_bStandardization;
    }

    public void setStandardization(boolean value) {
        this.m_bStandardization = value;
    }

    public String getSelfWeightFieldName() {
        return this.m_sSelfWeightFieldName;
    }

    public void setSelfWeightFieldName(String value) {
        this.m_sSelfWeightFieldName = value;
    }

    public boolean isFDRAdjusted() {
        return this.m_bFDRAdjusted;
    }

    public void setFDRAdjusted(boolean value) {
        this.m_bFDRAdjusted = value;
    }

    public String getFilePath() {
        return this.m_sFilePath;
    }

    public void setFilePath(String value) {
        this.m_sFilePath = value;
    }

    public DistanceMethod getDistanceMethod() {
        return this.m_distanceMethod;
    }

    public void setDistanceMethod(DistanceMethod value) {
        this.m_distanceMethod = value;
    }
}

