/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point3D;
import com.supermap.realspace.threeddesigner.InternalResource;
import com.supermap.realspace.threeddesigner.ShadowVolumeSettingNative;
import com.supermap.realspace.threeddesigner.ShadowVolumeType;
import com.supermap.realspace.threeddesigner.SunDataTimeInfo;

public class ShadowVolumeSetting
extends InternalHandleDisposable {
    private SunDataTimeInfo sunTime;

    public ShadowVolumeSetting() {
        long l = ShadowVolumeSettingNative.jni_New();
        this.setHandle(l, true);
    }

    public void setShadowLightType(ShadowVolumeType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowVolumeSetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        ShadowVolumeSettingNative.jni_SetShadowLightType(this.getHandle(), value.value());
    }

    public ShadowVolumeType getShadowLightType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowVolumeSetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        int n = ShadowVolumeSettingNative.jni_GetShadowLightType(this.getHandle());
        return ShadowVolumeType.parseUGCValue(n);
    }

    public void setViewerPosition(Point3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowVolumeSetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        ShadowVolumeSettingNative.jni_SetViewerPosition(this.getHandle(), value.getX(), value.getY(), value.getZ());
    }

    public Point3D getViewerPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowVolumeSetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[3];
        ShadowVolumeSettingNative.jni_GetViewerPosition(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        dArray = null;
        return point3D;
    }

    public void setSunTime(SunDataTimeInfo value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowVolumeSetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.sunTime == null) {
            this.sunTime = new SunDataTimeInfo(value.getSunDateTime(), value.getBaseUtcOffset());
        } else if (this.sunTime != value) {
            this.sunTime.setSunDateTime(value.getSunDateTime());
            this.sunTime.setBaseUtcOffset(value.getBaseUtcOffset());
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", value.getSunDateTime());
        int n = -((int)((double)value.getBaseUtcOffset().getRawOffset() / 60000.0));
        ShadowVolumeSettingNative.jni_SetSunTime(this.getHandle(), string, n);
    }

    public SunDataTimeInfo getSunTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowVolumeSetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return this.sunTime;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "ThreeDDesigner_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ShadowVolumeSettingNative.jni_Delete(this.getHandle());
            this.clearHandle();
            if (this.sunTime != null) {
                this.sunTime.dispose();
                this.sunTime = null;
            }
        }
    }
}

