/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Environment;
import com.supermap.data.GeoModel3D;
import com.supermap.data.GeoSphere;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.threeddesigner.BatchOperator;
import com.supermap.realspace.threeddesigner.CacheProcessor3DNative;
import com.supermap.realspace.threeddesigner.ClipParameter;
import com.supermap.realspace.threeddesigner.ClippingType;
import com.supermap.realspace.threeddesigner.ConstraintType;
import com.supermap.realspace.threeddesigner.InternalGeometry;
import com.supermap.realspace.threeddesigner.InternalHandle;
import com.supermap.realspace.threeddesigner.InternalResource;
import com.supermap.realspace.threeddesigner.InternalToolkitThreeDDesigner;
import com.supermap.realspace.threeddesigner.MatchParameter;
import com.supermap.realspace.threeddesigner.ModelFileType;
import com.supermap.realspace.threeddesigner.S3mInfo;
import com.supermap.realspace.threeddesigner.TextureCompressType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;

public abstract class CacheProcessor3D {
    private static transient Vector m_steppedListeners;
    private static License m_license;
    private static BatchOperator batchOperator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static boolean buildPagedLODInfo(String configFile) {
        return CacheProcessor3DNative.jni_BuildPagedLODInfo(configFile);
    }

    public static boolean clip(String scpFile, ArrayList<Geometry> clipRegionList, ClippingType clippingType, ConstraintType constraintType) {
        CacheProcessor3D.verifyLicense();
        if (clipRegionList == null || clipRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[clipRegionList.size()];
        for (int i = 0; i < clipRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_Clip(scpFile, lArray, clippingType.value(), constraintType.value());
    }

    public static boolean clip(String scpFile, ArrayList<Geometry> clipRegionList, String OutputFolder, String CacheName, ClippingType clippingType, ConstraintType constraintType) {
        CacheProcessor3D.verifyLicense();
        if (clipRegionList == null || clipRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[clipRegionList.size()];
        for (int i = 0; i < clipRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_Clip(scpFile, lArray, OutputFolder, CacheName, clippingType.value(), constraintType.value());
    }

    public static boolean clipTIN(String sctFile, ArrayList<Geometry> clipRegionList, String OutputFolder, String CacheName, ClippingType clippingType, ConstraintType constraintType) {
        CacheProcessor3D.verifyLicense();
        if (clipRegionList == null || clipRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[clipRegionList.size()];
        for (int i = 0; i < clipRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_ClipTIN(sctFile, lArray, OutputFolder, CacheName, clippingType.value(), constraintType.value());
    }

    public static boolean clipTIN(String sctFile, ArrayList<Geometry> clipRegionList, ClippingType clippingType, ConstraintType constraintType) {
        CacheProcessor3D.verifyLicense();
        if (clipRegionList == null || clipRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[clipRegionList.size()];
        for (int i = 0; i < clipRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_ClipTIN(sctFile, lArray, clippingType.value(), constraintType.value());
    }

    public static boolean cull(String scpFile, ArrayList<GeoSphere> boundingSphereList) {
        CacheProcessor3D.verifyLicense();
        if (scpFile == null || boundingSphereList == null || boundingSphereList.size() == 0) {
            return false;
        }
        long[] lArray = new long[boundingSphereList.size()];
        for (int i = 0; i < boundingSphereList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)boundingSphereList.get(i));
        }
        return CacheProcessor3DNative.jni_Cull(scpFile, lArray);
    }

    public static boolean discretExtremum(String scpFileName, DatasetVector pDatasetVector, String bottomName, String extrudeName) {
        if (scpFileName == null || pDatasetVector == null) {
            return false;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)pDatasetVector);
        return CacheProcessor3DNative.jni_DiscretExtremum(scpFileName, l, bottomName, extrudeName);
    }

    public static boolean eraseTIN(String sctFile, ArrayList<Geometry3D> geometryList) {
        CacheProcessor3D.verifyLicense();
        if (geometryList == null || geometryList.size() == 0) {
            return false;
        }
        long[] lArray = new long[geometryList.size()];
        for (int i = 0; i < geometryList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometryList.get(i));
        }
        return CacheProcessor3DNative.jni_EraseTIN(sctFile, lArray);
    }

    public static GeoModel3D extractTINSurface(String sctFile, int nLevel) {
        GeoModel3D geoModel3D = null;
        if (sctFile == null) {
            return geoModel3D;
        }
        long l = CacheProcessor3DNative.jni_ExtractTINSurface(sctFile, nLevel);
        if (0L != l) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    public static void getHistory(String configFile, ArrayList<Calendar> times) {
        String[] stringArray = CacheProcessor3DNative.jni_GetHistory(configFile);
        times.clear();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].trim().split(" ");
            String[] stringArray3 = stringArray2[0].trim().split("-");
            String[] stringArray4 = stringArray2[1].trim().split(":");
            int n = Integer.parseInt(stringArray3[0]);
            int n2 = Integer.parseInt(stringArray3[1]);
            int n3 = Integer.parseInt(stringArray3[2]);
            int n4 = Integer.parseInt(stringArray4[0]);
            int n5 = Integer.parseInt(stringArray4[1]);
            int n6 = Integer.parseInt(stringArray4[2]);
            times.add(new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6));
        }
    }

    public static boolean hasPagedLODInfo(String configFile) {
        if (configFile == null) {
            return false;
        }
        return CacheProcessor3DNative.jni_HasPagedLODInfo(configFile);
    }

    public static boolean hollowTIN(String sctFile, ArrayList<Geometry> clipRegionList, ClippingType clippingType, ConstraintType constraintType) {
        CacheProcessor3D.verifyLicense();
        if (clipRegionList == null || clipRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[clipRegionList.size()];
        for (int i = 0; i < clipRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_HollowTIN(sctFile, lArray, clippingType.value(), constraintType.value());
    }

    public static boolean hollowTIN(String sctFile, ArrayList<Geometry> clipRegionList, String OutputFolder, String CacheName, ClippingType clippingType, ConstraintType constraintType) {
        CacheProcessor3D.verifyLicense();
        if (clipRegionList == null || clipRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[clipRegionList.size()];
        for (int i = 0; i < clipRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_HollowTIN(sctFile, lArray, OutputFolder, CacheName, clippingType.value(), constraintType.value());
    }

    public static boolean mosaic(String scpFile, ArrayList<Geometry> mosaicRegionList) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_Mosaic(scpFile, lArray);
    }

    public static boolean mosaic(String scpFile, ArrayList<Geometry> mosaicRegionList, Color replaceColor) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_Mosaic(scpFile, lArray, replaceColor.getRGB());
    }

    public static boolean mosaic(String scpFile, ArrayList<Geometry> mosaicRegionList, Color replaceColor, String OutputFolder, String CacheName) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_Mosaic(scpFile, lArray, replaceColor.getRGB(), OutputFolder, CacheName);
    }

    public static boolean mosaic(String scpFile, ArrayList<Geometry> mosaicRegionList, String OutputFolder, String CacheName) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_Mosaic(scpFile, lArray, OutputFolder, CacheName);
    }

    public static boolean mosaicTIN(String sctFile, ArrayList<Geometry> mosaicRegion3DList) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegion3DList == null || mosaicRegion3DList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegion3DList.size()];
        for (int i = 0; i < mosaicRegion3DList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegion3DList.get(i));
        }
        return CacheProcessor3DNative.jni_MosaicTIN(sctFile, lArray);
    }

    public static boolean mosaicTIN(String sctFile, ArrayList<Geometry> mosaicRegion3DList, String OutputFolder, String CacheName) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegion3DList == null || mosaicRegion3DList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegion3DList.size()];
        for (int i = 0; i < mosaicRegion3DList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegion3DList.get(i));
        }
        return CacheProcessor3DNative.jni_MosaicTIN(sctFile, lArray, OutputFolder, CacheName);
    }

    public static boolean removePagedLODInfo(String configFile) {
        if (configFile == null) {
            return false;
        }
        return CacheProcessor3DNative.jni_RemovePagedLODInfo(configFile);
    }

    public static boolean replaceTextureByColor(String scpFile, ArrayList<Geometry> regionList, Color color) {
        if (regionList == null || regionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[regionList.size()];
        for (int i = 0; i < regionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)regionList.get(i));
        }
        return CacheProcessor3DNative.jni_ReplaceTextureByColor(scpFile, lArray, color.getRGB());
    }

    public static void rollBack(String scFile, Calendar time) {
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", time);
        CacheProcessor3DNative.jni_RollBack(scFile, string);
    }

    public static boolean unionTIN(String sctFile, ArrayList<Geometry3D> geometryList) {
        CacheProcessor3D.verifyLicense();
        if (geometryList == null || geometryList.size() == 0) {
            return false;
        }
        long[] lArray = new long[geometryList.size()];
        for (int i = 0; i < geometryList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometryList.get(i));
        }
        return CacheProcessor3DNative.jni_UnionTIN(sctFile, lArray);
    }

    public static ArrayList<Geometry3D> geometryMatch(String scpFile, ArrayList<Geometry> geometryList) {
        return CacheProcessor3D.geometryMatch(scpFile, geometryList, 0.0);
    }

    public static ArrayList<Geometry3D> geometryMatch(String scpFile, ArrayList<Geometry> geometryList, double sampleDistance) {
        MatchParameter matchParameter = new MatchParameter();
        matchParameter.setSampleDistance(sampleDistance);
        return CacheProcessor3D.geometryMatch(scpFile, geometryList, matchParameter);
    }

    public static ArrayList<Geometry3D> geometryMatch(String scpFile, ArrayList<Geometry> geometryList, MatchParameter matchParam) {
        CacheProcessor3D.verifyLicense();
        if (geometryList == null || geometryList.size() == 0) {
            String string = InternalResource.loadString("geometryList", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (matchParam == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)matchParam) == 0L) {
            String string = InternalResource.loadString("matchParam", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[geometryList.size()];
        for (int i = 0; i < geometryList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometryList.get(i));
        }
        ArrayList<Geometry3D> arrayList = new ArrayList<Geometry3D>();
        long[] lArray2 = CacheProcessor3DNative.jni_GeometryMatch(scpFile, lArray, InternalHandle.getHandle((com.supermap.data.InternalHandle)matchParam));
        for (int i = 0; i < lArray2.length; ++i) {
            arrayList.add((Geometry3D)InternalGeometry.createInstance(lArray2[i]));
        }
        return arrayList;
    }

    public static ArrayList<Geometry3D> geometryMatchTIN(String sctFile, ArrayList<Geometry> geometryList) {
        return CacheProcessor3D.geometryMatchTIN(sctFile, geometryList, 0.0);
    }

    public static ArrayList<Geometry3D> geometryMatchTIN(String sctFile, ArrayList<Geometry> geometryList, double sampleDistance) {
        MatchParameter matchParameter = new MatchParameter();
        matchParameter.setSampleDistance(sampleDistance);
        return CacheProcessor3D.geometryMatchTIN(sctFile, geometryList, matchParameter);
    }

    public static ArrayList<Geometry3D> geometryMatchTIN(String sctFile, ArrayList<Geometry> geometryList, MatchParameter matchParam) {
        CacheProcessor3D.verifyLicense();
        if (geometryList == null || geometryList.size() == 0) {
            String string = InternalResource.loadString("geometryList", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (matchParam == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)matchParam) == 0L) {
            String string = InternalResource.loadString("matchParam", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (batchOperator == null || !batchOperator.isBatchStart()) {
            batchOperator = new BatchOperator();
        }
        long[] lArray = new long[geometryList.size()];
        for (int i = 0; i < geometryList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometryList.get(i));
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)batchOperator);
        long[] lArray2 = CacheProcessor3DNative.jni_GeometryMatchTIN(l, sctFile, lArray, InternalHandle.getHandle((com.supermap.data.InternalHandle)matchParam), batchOperator.isBatchStart());
        if (lArray2 == null) {
            return null;
        }
        ArrayList<Geometry3D> arrayList = new ArrayList<Geometry3D>();
        for (int i = 0; i < lArray2.length; ++i) {
            arrayList.add((Geometry3D)InternalGeometry.createInstance(lArray2[i]));
        }
        return arrayList;
    }

    public static boolean mosaic(String scpFile, ArrayList<Geometry> mosaicRegionList, double slopeWidth) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_MosaicSlope(scpFile, lArray, slopeWidth);
    }

    public static boolean mosaic(String scpFile, ArrayList<Geometry> mosaicRegionList, String outputFolder, String cacheName, double slopeWidth) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_MosaicSlope2(scpFile, lArray, outputFolder, cacheName, slopeWidth);
    }

    public static boolean mosaic(String scpFile, ArrayList<Geometry> mosaicRegionList, ArrayList<Geometry> refOffsettingRegionList) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        long[] lArray2 = new long[refOffsettingRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)refOffsettingRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_MosaicSlope3(scpFile, lArray, lArray2);
    }

    public static boolean mosaic(String scpFile, ArrayList<Geometry> mosaicRegionList, ArrayList<Geometry> refOffsettingRegionList, String outputFolder, String cacheName) {
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        long[] lArray2 = new long[refOffsettingRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)refOffsettingRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_MosaicSlope4(scpFile, lArray, lArray2, outputFolder, cacheName);
    }

    public static boolean mosaicTIN(String sctFile, ArrayList<Geometry> mosaicRegionList, double slopeWidth) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_MosaicTINSlope(sctFile, lArray, slopeWidth);
    }

    public static boolean mosaicTIN(String sctFile, ArrayList<Geometry> mosaicRegionList, String outputFolder, String cacheName, double slopeWidth) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_MosaicTINSlope2(sctFile, lArray, outputFolder, cacheName, slopeWidth);
    }

    public static boolean mosaicTIN(String sctFile, ArrayList<Geometry> mosaicRegionList, ArrayList<Geometry> refOffsettingRegionList) {
        CacheProcessor3D.verifyLicense();
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        long[] lArray2 = new long[refOffsettingRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)refOffsettingRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_MosaicTINSlope3(sctFile, lArray, lArray2);
    }

    public static boolean mosaicTIN(String sctFile, ArrayList<Geometry> mosaicRegionList, ArrayList<Geometry> refOffsettingRegionList, String outputFolder, String cacheName) {
        if (mosaicRegionList == null || mosaicRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        long[] lArray2 = new long[refOffsettingRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)refOffsettingRegionList.get(i));
        }
        return CacheProcessor3DNative.jni_MosaicTINSlope4(sctFile, lArray, lArray2, outputFolder, cacheName);
    }

    public static boolean compTextureAndDiscret(String scpFileName, String outputFolder, TextureCompressType type, DatasetVector pDatasetVector, String strFieldName, ModelFileType outputFileType) {
        long l = 0L;
        if (pDatasetVector != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)pDatasetVector);
        }
        return CacheProcessor3DNative.jni_CompTextureAndDiscret(scpFileName, outputFolder, type.value(), l, strFieldName, outputFileType.value());
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "CacheProcessor3D";
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        CacheProcessor3D.fireStepped(steppedEvent);
        InternalToolkitThreeDDesigner.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    public static boolean clipConfigFile(String outpath, String configPath, ArrayList<Geometry> clipRegionList, ClipParameter clipParameter) {
        CacheProcessor3D.verifyLicense();
        if (outpath == null) {
            String string = InternalResource.loadString("ClipConfigFile", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (configPath == null) {
            String string = InternalResource.loadString("ClipConfigFile", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipRegionList == null || clipRegionList.size() == 0) {
            String string = InternalResource.loadString("ClipConfigFile", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[clipRegionList.size()];
        for (int i = 0; i < clipRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegionList.get(i));
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipParameter);
        boolean bl = CacheProcessor3DNative.jni_ClipConfigFile(outpath, configPath, lArray, l);
        return bl;
    }

    public static boolean clip(S3mInfo toInfo, S3mInfo fromInfo, String strFileName, ArrayList<Geometry> clipRegionList, ClipParameter clipParam) {
        if (toInfo == null) {
            String string = InternalResource.loadString("Clip", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (fromInfo == null) {
            String string = InternalResource.loadString("Clip", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (strFileName == null) {
            String string = InternalResource.loadString("Clip", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[clipRegionList.size()];
        for (int i = 0; i < clipRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegionList.get(i));
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)fromInfo);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)toInfo);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipParam);
        boolean bl = CacheProcessor3DNative.jni_Clip2(l2, l, strFileName, lArray, l3);
        return bl;
    }

    public static BatchOperator getBatchOperator() {
        return batchOperator;
    }

    public static void setBatchOperator(BatchOperator batchOperatorImport) {
        batchOperator = batchOperatorImport;
    }

    static {
        batchOperator = new BatchOperator();
        Environment.LoadWrapJ();
        ArrayList<ProductType> arrayList = InternalToolkitThreeDDesigner.managerProducts(InternalToolkitThreeDDesigner.getThreeDDesignerProducts());
        m_license = InternalToolkitThreeDDesigner.verifyLicense(arrayList);
    }
}

