/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.chart.conversion;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.chart.conversion.DataImportChartNative;
import com.supermap.chart.conversion.ImportChartSteppedEvent;
import com.supermap.chart.conversion.ImportChartSteppedListener;
import com.supermap.chart.conversion.ImportResultChart;
import com.supermap.chart.conversion.ImportSettingChart;
import com.supermap.chart.conversion.ImportSettingChartS57;
import com.supermap.chart.conversion.ImportSettingCharts;
import com.supermap.chart.conversion.InternalDatasource;
import com.supermap.chart.conversion.InternalHandle;
import com.supermap.chart.conversion.InternalHandleDisposable;
import com.supermap.chart.conversion.InternalResource;
import com.supermap.chart.conversion.InternalToolkiConversion;
import com.supermap.data.DatasetGroup;
import java.util.ArrayList;
import java.util.Vector;

public class DataImportChart
extends InternalHandleDisposable {
    private static License m_license;
    private ImportSettingCharts m_importSettings = new ImportSettingCharts();
    transient Vector m_steppedListeners;
    private int m_completed = 0;
    private long m_selfEventHandle;

    public DataImportChart() {
        this.setHandle(DataImportChartNative.jni_New(), true);
    }

    public ImportResultChart run() {
        Object object;
        DataImportChart.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("importData()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_selfEventHandle = DataImportChartNative.jni_NewSelfEventHandle(this.getHandle(), this);
        this.m_completed = 0;
        int n = this.m_importSettings.getCount();
        ArrayList<ImportSettingChart> arrayList = new ArrayList<ImportSettingChart>();
        ArrayList<ImportSettingChart> arrayList2 = new ArrayList<ImportSettingChart>();
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                int n2;
                object = this.m_importSettings.get(i).getStates();
                if (object == null) {
                    object = new ArrayList();
                }
                int[] nArray = new int[((ArrayList)object).size()];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = (Boolean)((ArrayList)object).get(n2) != false ? 1 : 0;
                }
                n2 = 0;
                if (this.m_importSettings.get(i).getTargetDatasource() != null) {
                    n2 = DataImportChartNative.jni_ImportData1(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_importSettings.get(i)), nArray, InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_importSettings.get(i).getTargetDatasource())) ? 1 : 0;
                    InternalDatasource.refresh(this.m_importSettings.get(i).getTargetDatasource());
                } else if (this.m_importSettings.get(i).getTargetDatasourceConnectionInfo() != null) {
                    n2 = DataImportChartNative.jni_ImportData(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_importSettings.get(i)), nArray, InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_importSettings.get(i).getTargetDatasourceConnectionInfo())) ? 1 : 0;
                } else if (this.m_importSettings.get(i).getTargetDatasetGroup() != null) {
                    DatasetGroup datasetGroup = this.m_importSettings.get(i).getTargetDatasetGroup();
                    n2 = DataImportChartNative.jni_ImportData2(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_importSettings.get(i)), nArray, InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGroup)) ? 1 : 0;
                    InternalDatasource.refresh(datasetGroup.getDatasource());
                }
                ++this.m_completed;
                int n3 = this.m_completed * 100 / n;
                ImportSettingChart importSettingChart = this.getImportSettingCharts().get(this.m_completed - 1);
                ImportChartSteppedEvent importChartSteppedEvent = new ImportChartSteppedEvent((Object)this, null, null, n3, 100, importSettingChart, n, false);
                this.fireStepped(importChartSteppedEvent);
                if (importChartSteppedEvent.getCancel()) break;
                if (n2 != 0) {
                    arrayList.add(this.m_importSettings.get(i));
                    continue;
                }
                arrayList2.add(this.m_importSettings.get(i));
            }
        }
        this.clearSelfEventHandle();
        ImportSettingChart[] importSettingChartArray = new ImportSettingChart[arrayList.size()];
        object = new ImportSettingChart[arrayList2.size()];
        arrayList.toArray(importSettingChartArray);
        arrayList2.toArray((T[])object);
        return new ImportResultChart(importSettingChartArray, (ImportSettingChart[])object);
    }

    public ImportSettingCharts getImportSettingCharts() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportSettingCharts()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_importSettings;
    }

    public void setImportSettingCharts(ImportSettingCharts importSettings) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportSettings(ImportSettingCharts settings)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (importSettings == null) {
            String string = InternalResource.loadString("setImportSettings(ImportSettingCharts settings)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_importSettings.clear();
        for (int i = 0; i < importSettings.getCount(); ++i) {
            String string = ((Object)((Object)importSettings.get(i))).getClass().getName();
            if (string.compareTo("com.supermap.chart.conversion.ImportSettingChartS57") != 0) continue;
            this.m_importSettings.add(new ImportSettingChartS57((ImportSettingChartS57)importSettings.get(i)));
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            DataImportChartNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
        this.clearSelfEventHandle();
    }

    public synchronized void addImportSteppedListener(ImportChartSteppedListener importChartSteppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(importChartSteppedListener)) {
            this.m_steppedListeners.add(importChartSteppedListener);
        }
    }

    public synchronized void removeImportSteppedListener(ImportChartSteppedListener importChartSteppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(importChartSteppedListener)) {
            this.m_steppedListeners.remove(importChartSteppedListener);
        }
    }

    protected void fireStepped(ImportChartSteppedEvent importChartSteppedEvent) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ImportChartSteppedListener)vector.elementAt(i)).stepped(importChartSteppedEvent);
            }
        }
    }

    static void importSteppedCallBack(DataImportChart dataImport, int nPercent, long cancelHandle, String title, String message) {
        int n = nPercent;
        int n2 = dataImport.getImportSettingCharts().getCount();
        int n3 = dataImport.m_completed;
        ImportSettingChart importSettingChart = dataImport.getImportSettingCharts().get(n3);
        int n4 = n3 * 100 / n2;
        Boolean bl = InternalToolkiConversion.getHandleBooleanValue(cancelHandle);
        ImportChartSteppedEvent importChartSteppedEvent = new ImportChartSteppedEvent((Object)dataImport, title, message, n4, n, importSettingChart, n2, bl);
        dataImport.fireStepped(importChartSteppedEvent);
        InternalToolkiConversion.setHandleBooleanValue(cancelHandle, importChartSteppedEvent.getCancel());
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DataImportChartNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkiConversion.managerProducts(InternalToolkiConversion.getChartProducts());
        m_license = InternalToolkiConversion.verifyLicense(arrayList);
    }
}

