/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Point2D;
import com.supermap.data.Point3D;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.ProjectionImageNative;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ProjectionImage
extends InternalHandleDisposable {
    private static License m_license;
    private Scene m_scene;
    private Point3D m_position = new Point3D(0.0, 0.0, 0.0);
    private double m_horizontalFov = 90.0;
    private double m_verticalFov = 60.0;
    private boolean m_hintLineVisible = false;
    private HashMap<Point2D, Point3D> sm_dicData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public ProjectionImage(Scene scene) {
        ProjectionImage.verifyLicense();
        this.m_scene = scene;
        long l = ProjectionImageNative.jni_New("");
        this.setHandle(l, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            ProjectionImageNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }

    public Point3D getPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_position;
    }

    public void setPosition(Point3D position) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewerPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetPosition(this.getHandle(), position.getX(), position.getY(), position.getZ());
        this.m_position = position;
    }

    public double getHeading() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeading()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionImageNative.jni_GetHeading(this.getHandle());
    }

    public void setHeading(double heading) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeading()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetHeading(this.getHandle(), heading);
    }

    public double getPitch() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPitch()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionImageNative.jni_GetPitch(this.getHandle());
    }

    public void setPitch(double pitch) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPitch()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetPitch(this.getHandle(), pitch);
    }

    public double getHorizontalFov() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHorizontalFov()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_horizontalFov;
    }

    public void setHorizontalFov(double horizontalFov) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHorizontalFov()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetHorizontalFov(this.getHandle(), horizontalFov);
        this.m_horizontalFov = horizontalFov;
    }

    public double getVerticalFov() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalFov()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_verticalFov;
    }

    public void setVerticalFov(double verticalFov) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalFov()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetVerticalFov(this.getHandle(), verticalFov);
        this.m_verticalFov = verticalFov;
    }

    public boolean getHintLineVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHintLineVisible()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_hintLineVisible;
    }

    public void setHintLineVisible(boolean visible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHintLineColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetHintLineVisible(this.getHandle(), visible);
        this.m_hintLineVisible = visible;
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionImageNative.jni_Build(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void locateToShootingPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("locateToShootingPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_LocateToShootingPosition(this.getHandle());
    }

    public void setImage(BufferedImage image) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImage()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = image.getWidth();
        int n2 = image.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = image.getRGB(j, i);
            }
        }
        ProjectionImageNative.jni_SetImage(this.getHandle(), nArray, n, n2);
    }

    public double getHintLineLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ProjectionImage", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionImageNative.jni_GetHintLineLength(this.getHandle());
    }

    public void setHintLineLength(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ProjectionImage", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetHintLineLength(this.getHandle(), value);
    }

    public boolean isHomonymyPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ProjectionImage", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionImageNative.jni_IsHomonymyPoints(this.getHandle());
    }

    public void setHomonymyPoints(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ProjectionImage", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetHomonymyPoints(this.getHandle(), value);
    }

    public boolean isVideo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ProjectionImage", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionImageNative.jni_IsVideo(this.getHandle());
    }

    public void setVideo(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ProjectionImage", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetVideo(this.getHandle(), value);
    }

    public boolean getRenderToGlobe() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ProjectionImage", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionImageNative.jni_GetRenderToGlobe(this.getHandle());
    }

    public void setRenderToGlobe(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ProjectionImage", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetRenderToGlobe(this.getHandle(), value);
    }

    public void setDirectionByPoint(Point3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ProjectionImage", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProjectionImageNative.jni_SetDirectionByPoint(this.getHandle(), value.getX(), value.getY(), value.getZ());
    }

    public void setHomonymyPoints(HashMap<Point2D, Point3D> value) {
        if (this.getHandle() == 0L || this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L) {
            String string = InternalResource.loadString("ProjectionImage", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.size() < 3) {
            String string = InternalResource.loadString("value", "ArgumentInvalid", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        this.sm_dicData = value;
        ProjectionImageNative.jni_SetHomonymyPoints2(this.getHandle());
        this.onAffineMatrixChanged();
    }

    private void onAffineMatrixChanged() {
        if (this.getHandle() == 0L || this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L) {
            String string = InternalResource.loadString("onAffineMatrixChanged", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.sm_dicData == null || this.sm_dicData.size() == 0) {
            String string = InternalResource.loadString("value", "ArgumentInvalid", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[this.sm_dicData.size() * 2];
        double[] dArray2 = new double[this.sm_dicData.size() * 3];
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        ArrayList<Point3D> arrayList2 = new ArrayList<Point3D>();
        Set<Point2D> set = this.sm_dicData.keySet();
        for (Point2D point2D : set) {
            arrayList.add(point2D);
            arrayList2.add(this.sm_dicData.get(point2D));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            dArray[2 * i] = ((Point2D)arrayList.get(i)).getX();
            dArray[2 * i + 1] = ((Point2D)arrayList.get(i)).getY();
            dArray2[3 * i] = ((Point3D)arrayList2.get(i)).getX();
            dArray2[3 * i + 1] = ((Point3D)arrayList2.get(i)).getY();
            dArray2[3 * i + 2] = ((Point3D)arrayList2.get(i)).getZ();
        }
        ProjectionImageNative.jni_OnAffineMatrixChanged(this.getHandle(), dArray, dArray2);
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

